/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.content.Context;
import android.text.TextUtils;
import com.verizon.ads.Logger;
import java.io.File;
import java.security.InvalidParameterException;

public class StorageCache {
    private static final Logger logger = Logger.getInstance(StorageCache.class);
    private File cacheDirectory;

    public StorageCache(File cacheDirectory) {
        if (cacheDirectory == null) {
            throw new InvalidParameterException("cache directory cannot be null");
        }
        this.cacheDirectory = cacheDirectory;
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Storage cache created: %s", cacheDirectory));
        }
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public synchronized void deleteCacheDirectory() {
        if (this.cacheDirectory == null) {
            logger.e("Cache directory is null");
            return;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Deleting file cache directory: %s", this.cacheDirectory));
        }
        StorageCache.deleteDirectory(this.cacheDirectory);
    }

    public synchronized File createFile(String filename) {
        if (TextUtils.isEmpty((CharSequence)filename)) {
            logger.e("filename cannot be null or empty");
            return null;
        }
        if (!this.createCacheDirectory()) {
            return null;
        }
        return new File(this.cacheDirectory, filename);
    }

    public synchronized boolean createCacheDirectory() {
        if (this.cacheDirectory == null) {
            logger.e("Cache directory is null");
            return false;
        }
        try {
            if (this.cacheDirectory.exists()) {
                return true;
            }
            if (this.cacheDirectory.mkdirs()) {
                if (Logger.isLogLevelEnabled((int)3)) {
                    logger.d(String.format("File cache directory created: %s", this.cacheDirectory.getAbsolutePath()));
                }
                return true;
            }
            logger.e(String.format("Failed to create cache directory: %s", this.cacheDirectory.getAbsolutePath()));
        }
        catch (Exception e) {
            logger.e("Error creating cache directory", (Throwable)e);
        }
        return false;
    }

    public static File getApplicationCache(Context applicationContext, String cachePath) {
        if (applicationContext == null) {
            logger.e("Unable to create cache directory. Application context is null");
            return null;
        }
        try {
            File fileRoot = applicationContext.getExternalFilesDir(null);
            if (fileRoot == null) {
                logger.e("Unable to create cache directory. External storage is not available");
                return null;
            }
            return new File(fileRoot, cachePath);
        }
        catch (Exception e) {
            logger.e("Error getting root cache directory", (Throwable)e);
            return null;
        }
    }

    public synchronized void deleteExpiredCacheEntries(int expirationTime) {
        if (this.cacheDirectory == null) {
            return;
        }
        try {
            File[] fileList = this.cacheDirectory.listFiles();
            if (fileList != null) {
                for (File file : fileList) {
                    if (!StorageCache.hasFileExpired(file, expirationTime)) continue;
                    if (file.isDirectory()) {
                        if (Logger.isLogLevelEnabled((int)3)) {
                            logger.d(String.format("Cache directory has expired -- deleting: %s", file));
                        }
                        StorageCache.deleteDirectory(file);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    if (Logger.isLogLevelEnabled((int)3)) {
                        logger.d(String.format("Cache file has expired -- deleting: %s", file));
                    }
                    StorageCache.deleteFile(file);
                }
            }
        }
        catch (Exception e) {
            logger.e(String.format("Error deleting expired cache instance directories: %s", this.cacheDirectory), (Throwable)e);
        }
    }

    private static boolean hasFileExpired(File file, int expirationTime) {
        if (file == null) {
            return false;
        }
        try {
            long lastModified = file.lastModified();
            return System.currentTimeMillis() - lastModified > (long)expirationTime;
        }
        catch (Exception e) {
            logger.e("Error checking if file expired", (Throwable)e);
            return false;
        }
    }

    private static void deleteDirectory(File dir) {
        if (dir == null) {
            return;
        }
        try {
            boolean deleted;
            if (!dir.exists()) {
                logger.d(String.format("Directory already deleted: %s", dir));
                return;
            }
            File[] fileList = dir.listFiles();
            if (fileList != null) {
                for (File file : fileList) {
                    if (file.isFile()) {
                        StorageCache.deleteFile(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    StorageCache.deleteDirectory(file);
                }
            }
            if (!(deleted = dir.delete())) {
                logger.w(String.format("Failed to delete directory: %s", dir));
            } else if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Deleted directory: %s", dir));
            }
        }
        catch (Exception e) {
            logger.e(String.format("Error occurred deleting directory: %s", dir), (Throwable)e);
        }
    }

    public static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        try {
            boolean deleted = file.delete();
            if (!deleted) {
                logger.w(String.format("Failed to delete file: %s", file));
            } else if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Deleted file: %s", file));
            }
        }
        catch (Exception e) {
            logger.e("Error deleting file", (Throwable)e);
        }
    }
}

