/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.sideloadingwaterfallprovider;

import android.content.Context;
import com.verizon.ads.AdContent;
import com.verizon.ads.Bid;
import com.verizon.ads.BidRequestListener;
import com.verizon.ads.Component;
import com.verizon.ads.ComponentFactory;
import com.verizon.ads.Configuration;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.RequestMetadata;
import com.verizon.ads.Waterfall;
import com.verizon.ads.WaterfallProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class SideloadingWaterfallProvider
extends WaterfallProvider
implements Component {
    private static final Logger logger = Logger.getInstance(SideloadingWaterfallProvider.class);
    private static final String METADATA_KEY_AD_CONTENT = "adContent";
    private static final String METADATA_KEY_REPORTING_ENABLED = "reportingEnabled";

    private SideloadingWaterfallProvider(Context context) {
        super(context);
    }

    public void load(RequestMetadata requestMetadata, int numberOfWaterfalls, int timeout, WaterfallProvider.WaterfallListener waterfallListener) {
        boolean isEnabled = Configuration.getBoolean((String)"com.verizon.ads.core", (String)"sdkEnabled", (boolean)true);
        if (!isEnabled) {
            ErrorInfo errorInfo = new ErrorInfo(SideloadingWaterfallProvider.class.getName(), "VASAds SDK is disabled.", -3);
            logger.e(errorInfo.toString());
            waterfallListener.onWaterfallReceived(null, errorInfo, true);
            return;
        }
        if (requestMetadata == null || requestMetadata.getPlacementData() == null) {
            ErrorInfo errorInfo = new ErrorInfo(SideloadingWaterfallProvider.class.getName(), "No RequestMetadata present.", -3);
            logger.e(errorInfo.toString());
            waterfallListener.onWaterfallReceived(null, errorInfo, true);
            return;
        }
        Map placementData = requestMetadata.getPlacementData();
        Object adContent = placementData.get(METADATA_KEY_AD_CONTENT);
        if (adContent == null) {
            ErrorInfo errorInfo = new ErrorInfo(SideloadingWaterfallProvider.class.getName(), "No content present in the RequestMetadata.", -3);
            logger.e(errorInfo.toString());
            waterfallListener.onWaterfallReceived(null, errorInfo, true);
            return;
        }
        SideloadingWaterfall waterfall = new SideloadingWaterfall();
        waterfall.addItem(new SideloadingWaterfallItem((String)adContent, requestMetadata.getPlacementData()));
        waterfallListener.onWaterfallReceived((Waterfall[])new SideloadingWaterfall[]{waterfall}, null, true);
    }

    public boolean isSuperAuctionSupported() {
        return false;
    }

    public void requestBid(RequestMetadata requestMetadata, int i, BidRequestListener bidRequestListener) {
        logger.e("Super Auction not supported.");
    }

    public void load(Bid bid, int i, WaterfallProvider.WaterfallListener waterfallListener) {
        logger.e("Super Auction not supported.");
    }

    public void release() {
    }

    static class SideloadingWaterfallItem
    implements Waterfall.WaterfallItem {
        final String value;
        final Map<String, Object> requestMetadata;

        SideloadingWaterfallItem(String value, Map<String, Object> requestMetadata) {
            this.value = value;
            this.requestMetadata = requestMetadata;
        }

        public Waterfall.WaterfallItem.FetchResult fetch() {
            Object size;
            HashMap adSize = new HashMap();
            Object adSizes = this.requestMetadata.get("adSizes");
            if (adSizes instanceof ArrayList && !((ArrayList)adSizes).isEmpty() && (size = ((ArrayList)adSizes).get(0)) instanceof Map) {
                Map sizeMap = (Map)size;
                adSize.put("w", sizeMap.get("w"));
                adSize.put("h", sizeMap.get("h"));
            }
            HashMap adMetadata = new HashMap();
            adMetadata.put("ad_size", adSize);
            return new Waterfall.WaterfallItem.FetchResult(new AdContent(this.value, adMetadata));
        }

        public Map<String, Object> getMetadata() {
            return null;
        }
    }

    static class SideloadingWaterfall
    implements Waterfall {
        List<Waterfall.WaterfallItem> waterfallItems = new ArrayList<Waterfall.WaterfallItem>();

        SideloadingWaterfall() {
        }

        void addItem(Waterfall.WaterfallItem waterfallItem) {
            if (waterfallItem == null) {
                return;
            }
            this.waterfallItems.add(waterfallItem);
        }

        public Waterfall.WaterfallItem[] getWaterfallItems() {
            return this.waterfallItems.toArray(new Waterfall.WaterfallItem[0]);
        }

        public Map<String, Object> getMetadata() {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put(SideloadingWaterfallProvider.METADATA_KEY_REPORTING_ENABLED, false);
            return metadata;
        }
    }

    public static class Factory
    implements ComponentFactory {
        public Component newInstance(Context context, JSONObject jsonObject, Object ... objects) {
            return new SideloadingWaterfallProvider(context);
        }
    }
}

