/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.nativeverizonnativeadapter;

import android.content.Context;
import android.view.ViewGroup;
import com.verizon.ads.AdContent;
import com.verizon.ads.AdSession;
import com.verizon.ads.Component;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.nativeplacement.NativeAdAdapter;
import com.verizon.ads.nativeplacement.NativeComponentBundle;
import com.verizon.ads.utils.TextUtils;
import com.verizon.ads.verizonnativecontroller.VerizonNativeAd;
import com.verizon.ads.verizonnativecontroller.VerizonNativeComponentBundle;
import com.verizon.ads.verizonnativecontroller.VerizonNativeController;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class NativeVerizonNativeAdapter
implements NativeAdAdapter {
    private static final Logger logger = Logger.getInstance(NativeVerizonNativeAdapter.class);
    private static final String NATIVE_COMPONENT_BUNDLE_TYPE_ERROR = "NativeComponentBundle does not contain a VerizonNativeComponentBundle";
    private static final String VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG = "Verizon Native Ad not loaded.";
    private NativeAdAdapter.NativeAdAdapterListener nativeAdAdapterListener;
    private VerizonNativeAd verizonNativeAd;
    private AdContent adContent;

    public void setListener(NativeAdAdapter.NativeAdAdapterListener nativeAdAdapterListener) {
        this.nativeAdAdapterListener = nativeAdAdapterListener;
    }

    public String getAdType() {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return null;
        }
        return this.verizonNativeAd.getAdType();
    }

    public void release() {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return;
        }
        this.verizonNativeAd.release();
    }

    public AdContent getAdContent() {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return null;
        }
        return this.adContent;
    }

    public void loadComponents(boolean skipAssets, int timeout, final NativeAdAdapter.LoadComponentsListener loadComponentsListener) {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return;
        }
        if (loadComponentsListener == null) {
            logger.e("loadComponentsListener must not be null.");
            return;
        }
        this.verizonNativeAd.loadResources(skipAssets, timeout, new VerizonNativeAd.LoadResourcesListener(){

            public void onComplete(ErrorInfo errorInfo) {
                loadComponentsListener.onComplete(errorInfo);
            }
        });
    }

    public void abortLoadComponents() {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return;
        }
        this.verizonNativeAd.abortLoadAssets();
    }

    public void invokeDefaultAction(Context context) {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return;
        }
        this.verizonNativeAd.invokeDefaultAction(context);
    }

    public void fireImpression() {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return;
        }
        this.verizonNativeAd.fireImpression();
    }

    public Component getComponent(NativeComponentBundle nativeComponentBundle, String componentId) {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return null;
        }
        VerizonNativeComponentBundle verizonNativeComponentBundle = this.getVerizonNativeComponentBundle(nativeComponentBundle);
        if (verizonNativeComponentBundle == null) {
            logger.e(NATIVE_COMPONENT_BUNDLE_TYPE_ERROR);
            return null;
        }
        Component component = this.getComponentFromController(verizonNativeComponentBundle, componentId);
        if (component == null) {
            logger.e("Error obtaining native component from controller.");
        }
        return component;
    }

    public JSONObject getJSON(NativeComponentBundle nativeComponentBundle) {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return null;
        }
        VerizonNativeComponentBundle verizonNativeComponentBundle = this.getVerizonNativeComponentBundle(nativeComponentBundle);
        if (verizonNativeComponentBundle == null) {
            logger.e(NATIVE_COMPONENT_BUNDLE_TYPE_ERROR);
            return null;
        }
        return verizonNativeComponentBundle.getComponentInfo();
    }

    public JSONObject getJSON(NativeComponentBundle nativeComponentBundle, String componentId) {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return null;
        }
        VerizonNativeComponentBundle verizonNativeComponentBundle = this.getVerizonNativeComponentBundle(nativeComponentBundle);
        if (verizonNativeComponentBundle == null) {
            logger.e(NATIVE_COMPONENT_BUNDLE_TYPE_ERROR);
            return null;
        }
        return verizonNativeComponentBundle.getComponentJSON(componentId);
    }

    public Set<String> getComponentIds(NativeComponentBundle nativeComponentBundle) {
        VerizonNativeComponentBundle verizonNativeComponentBundle = this.getVerizonNativeComponentBundle(nativeComponentBundle);
        if (verizonNativeComponentBundle == null) {
            logger.e(NATIVE_COMPONENT_BUNDLE_TYPE_ERROR);
            return null;
        }
        return verizonNativeComponentBundle.getComponentIds();
    }

    public Set<String> getRequiredComponentIds() {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return null;
        }
        return this.verizonNativeAd.getRequiredComponentIds();
    }

    public ErrorInfo prepare(AdSession adSession, AdContent adContent) {
        this.adContent = adContent;
        VerizonNativeController verizonNativeController = new VerizonNativeController();
        ErrorInfo errorInfo = verizonNativeController.prepare(adSession, adContent);
        if (errorInfo != null) {
            return errorInfo;
        }
        this.verizonNativeAd = verizonNativeController.getVerizonNativeAd();
        this.verizonNativeAd.setInteractionListener(new VerizonNativeAd.InteractionListener(){

            public void onClicked(Component component) {
                if (NativeVerizonNativeAdapter.this.nativeAdAdapterListener != null) {
                    NativeVerizonNativeAdapter.this.nativeAdAdapterListener.onClicked(component);
                }
            }

            public void onAdLeftApplication(Component component) {
                if (NativeVerizonNativeAdapter.this.nativeAdAdapterListener != null) {
                    NativeVerizonNativeAdapter.this.nativeAdAdapterListener.onAdLeftApplication();
                }
            }

            public void onEvent(String source, String eventId, Map<String, Object> arguments) {
                if (NativeVerizonNativeAdapter.this.nativeAdAdapterListener != null) {
                    NativeVerizonNativeAdapter.this.nativeAdAdapterListener.onEvent(source, eventId, arguments);
                }
            }
        });
        return null;
    }

    public NativeComponentBundle getRootBundle() {
        return new NativeComponentBundle(null, (Component)this.verizonNativeAd);
    }

    private JSONObject getComponentJSON(VerizonNativeComponentBundle verizonNativeComponentBundle, String componentId) {
        if (TextUtils.isEmpty((String)componentId)) {
            logger.e("componentId cannot be null or empty string.");
            return null;
        }
        return this.getComponentJSONFromController(verizonNativeComponentBundle, componentId);
    }

    private JSONObject getComponentJSONFromController(VerizonNativeComponentBundle verizonNativeComponentBundle, String componentId) {
        return verizonNativeComponentBundle.getComponentJSON(componentId);
    }

    private Component getComponentFromController(VerizonNativeComponentBundle verizonNativeComponentBundle, String componentId) {
        return verizonNativeComponentBundle.getComponent(componentId);
    }

    private VerizonNativeComponentBundle getVerizonNativeComponentBundle(NativeComponentBundle nativeComponentBundle) {
        Component bundleComponent = nativeComponentBundle.getBundleComponent();
        if (!(bundleComponent instanceof VerizonNativeComponentBundle)) {
            logger.e(NATIVE_COMPONENT_BUNDLE_TYPE_ERROR);
            return null;
        }
        return (VerizonNativeComponentBundle)bundleComponent;
    }

    public boolean registerContainerView(ViewGroup containerView) {
        if (this.verizonNativeAd == null) {
            logger.w(VERIZON_NATIVE_AD_NOT_LOADED_WARNING_MSG);
            return false;
        }
        return this.verizonNativeAd.registerContainerView(containerView);
    }
}

