/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.nativeverizonnativeadapter;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.ToggleButton;
import com.iab.omid.library.oath.adsession.video.Position;
import com.iab.omid.library.oath.adsession.video.VastProperties;
import com.iab.omid.library.oath.adsession.video.VideoEvents;
import com.verizon.ads.Configuration;
import com.verizon.ads.Logger;
import com.verizon.ads.nativeplacement.VASDisplayMediaView;
import com.verizon.ads.nativeverizonnativeadapter.R;
import com.verizon.ads.support.utils.ViewabilityWatcher;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.videoplayer.VideoView;
import java.io.File;

public class VerizonVideoView
extends VASDisplayMediaView
implements VideoView.VideoViewListener,
ViewabilityWatcher.ViewabilityListener {
    private static final Logger logger = Logger.getInstance(VerizonVideoView.class);
    private static final String DOMAIN = "com.verizon.ads.nativeverizonnativeadapter";
    private static final String NATIVE_VIDEO_PLAYBACK_THRESHOLD_PERCENTAGE_KEY = "nativeVideoAutoplayThresholdPercentage";
    private static final int DEFAULT_THRESHOLD = 10;
    final VideoView videoView;
    final ViewabilityWatcher playbackControlWatcher;
    final Button replayButton;
    final VideoEvents videoEvents;
    final boolean autoPlay;
    volatile boolean playbackInitiated = false;
    volatile boolean paused = false;
    volatile int lastQuartileFired = 0;
    int duration;
    Button playButton;

    public VerizonVideoView(Context context, int width, int height, boolean autoPlay, VideoEvents videoEvents) {
        super(context);
        this.autoPlay = autoPlay;
        this.videoEvents = videoEvents;
        this.videoView = new VideoView(context);
        this.videoView.registerListener((VideoView.VideoViewListener)this);
        this.videoView.setVolume(0.0f);
        this.addView((View)this.videoView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
        this.playbackControlWatcher = new ViewabilityWatcher((View)this, (ViewabilityWatcher.ViewabilityListener)this);
        this.playbackControlWatcher.setMinViewabilityPercent(Configuration.getInt((String)DOMAIN, (String)NATIVE_VIDEO_PLAYBACK_THRESHOLD_PERCENTAGE_KEY, (int)10));
        this.playbackControlWatcher.startWatching();
        ToggleButton toggleButton = new ToggleButton(context);
        toggleButton.setText((CharSequence)"");
        toggleButton.setTextOff((CharSequence)"");
        toggleButton.setTextOn((CharSequence)"");
        toggleButton.setTag((Object)"MUTE_UNMUTE_TOGGLE");
        toggleButton.setBackgroundResource(R.drawable.verizon_ads_sdk_mute_toggle);
        toggleButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                VerizonVideoView.this.videoView.setVolume(isChecked ? 1.0f : 0.0f);
            }
        });
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.verizon_ads_sdk_mute_width), (int)this.getResources().getDimension(R.dimen.verizon_ads_sdk_mute_width));
        layoutParams.addRule(12);
        layoutParams.addRule(11);
        this.videoView.addView((View)toggleButton, (ViewGroup.LayoutParams)layoutParams);
        this.replayButton = new Button(context);
        this.replayButton.setTag((Object)"REPLAY_BUTTON");
        this.replayButton.setVisibility(8);
        this.replayButton.setBackgroundResource(R.drawable.verizon_ads_sdk_replay);
        this.replayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerizonVideoView.this.lastQuartileFired = 0;
                VerizonVideoView.this.videoView.replay();
            }
        });
        layoutParams = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width), (int)this.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width));
        layoutParams.addRule(13);
        this.videoView.addView((View)this.replayButton, (ViewGroup.LayoutParams)layoutParams);
        if (!autoPlay) {
            this.playButton = new Button(context);
            this.playButton.setTag((Object)"PLAY_BUTTON");
            this.playButton.setBackgroundResource(R.drawable.verizon_ads_sdk_replay);
            this.playButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    VerizonVideoView.this.play();
                }
            });
            layoutParams = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width), (int)this.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width));
            layoutParams.addRule(13);
            this.videoView.addView((View)this.playButton, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void loadAsset(File asset) {
        this.videoView.load(Uri.fromFile((File)asset));
    }

    public void onLoaded(final VideoView videoView) {
        logger.d("video asset loaded.");
        this.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                VerizonVideoView.this.duration = videoView.getDuration();
                if (VerizonVideoView.this.videoEvents != null) {
                    try {
                        VastProperties vastProperties = VastProperties.createVastPropertiesForSkippableVideo((float)0.0f, (boolean)false, (Position)Position.STANDALONE);
                        VerizonVideoView.this.videoEvents.loaded(vastProperties);
                        logger.d("Fired OMSDK loaded event.");
                    }
                    catch (Throwable t) {
                        logger.e("Error recording load event with OMSDK.", t);
                    }
                }
            }
        });
    }

    public void onUnloaded(VideoView videoView) {
        logger.d("video asset unloaded.");
    }

    public void onReady(VideoView videoView) {
        logger.d("video is ready for playback.");
    }

    public void onPlay(final VideoView videoView) {
        logger.d("video is playing.");
        this.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                VerizonVideoView.this.playbackInitiated = true;
                if (VerizonVideoView.this.videoEvents != null) {
                    if (!VerizonVideoView.this.paused) {
                        try {
                            VerizonVideoView.this.videoEvents.start((float)videoView.getDuration(), videoView.getVolume());
                            logger.d("Fired OMSDK start event.");
                        }
                        catch (Throwable t) {
                            logger.e("Error occurred firing OMSDK start event.", t);
                        }
                    } else {
                        try {
                            VerizonVideoView.this.videoEvents.resume();
                            logger.d("Fired OMSDK resume event.");
                        }
                        catch (Throwable t) {
                            logger.e("Error occurred firing OMSDK resume event.", t);
                        }
                    }
                }
                VerizonVideoView.this.paused = false;
                VerizonVideoView.this.replayButton.setVisibility(8);
                if (VerizonVideoView.this.playButton != null) {
                    videoView.removeView((View)VerizonVideoView.this.playButton);
                }
            }
        });
    }

    public void onPaused(VideoView videoView) {
        logger.d("video is paused.");
        this.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                VerizonVideoView.this.paused = true;
                if (VerizonVideoView.this.videoEvents != null) {
                    try {
                        VerizonVideoView.this.videoEvents.pause();
                        logger.d("Fired OMSDK pause event.");
                    }
                    catch (Throwable t) {
                        logger.e("Error occurred firing OMSDK pause event.", t);
                    }
                }
            }
        });
    }

    public void onComplete(VideoView videoView) {
        logger.d("video playback completed.");
        this.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VerizonVideoView.this.videoEvents != null) {
                    try {
                        VerizonVideoView.this.videoEvents.complete();
                        logger.d("Fired OMSDK complete event.");
                    }
                    catch (Throwable t) {
                        logger.e("Error occurred firing OMSDK complete event.", t);
                    }
                }
                VerizonVideoView.this.replayButton.setVisibility(0);
            }
        });
    }

    public void onProgress(VideoView videoView, int progress) {
        this.reportQuartile(this.duration, progress);
    }

    void reportQuartile(int duration, int progress) {
        float quartileLength = (float)duration / 4.0f;
        final int quartile = (int)((float)progress / quartileLength);
        if (quartile > this.lastQuartileFired) {
            this.lastQuartileFired = quartile;
            this.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    switch (quartile) {
                        case 1: {
                            VerizonVideoView.this.firstQuartile();
                            break;
                        }
                        case 2: {
                            VerizonVideoView.this.midpoint();
                            break;
                        }
                        case 3: {
                            VerizonVideoView.this.thirdQuartile();
                        }
                    }
                }
            });
        }
    }

    void postOnUiThread(Runnable runnable) {
        ThreadUtils.postOnUiThread((Runnable)runnable);
    }

    void firstQuartile() {
        if (this.videoEvents != null) {
            try {
                this.videoEvents.firstQuartile();
                logger.d("Fired OMSDK firstQuartile event.");
            }
            catch (Throwable t) {
                logger.e("Error occurred firing OMSDK firstQuartile event.", t);
            }
        }
    }

    void midpoint() {
        if (this.videoEvents != null) {
            try {
                this.videoEvents.midpoint();
                logger.d("Fired OMSDK midpoint event.");
            }
            catch (Throwable t) {
                logger.e("Error occurred firing OMSDK midpoint event.", t);
            }
        }
    }

    void thirdQuartile() {
        if (this.videoEvents != null) {
            try {
                this.videoEvents.thirdQuartile();
                logger.d("Fired OMSDK thirdQuartile event.");
            }
            catch (Throwable t) {
                logger.e("Error occurred firing OMSDK thirdQuartile event.", t);
            }
        }
    }

    public void onSeekCompleted(VideoView videoView) {
    }

    public void onError(VideoView videoView) {
        logger.e("video playback error.");
    }

    public void onVolumeChanged(VideoView videoView, final float volume) {
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("video player volume changed to <%f>", Float.valueOf(volume)));
        }
        this.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VerizonVideoView.this.videoEvents != null) {
                    try {
                        VerizonVideoView.this.videoEvents.volumeChange(volume);
                        logger.d("Fired OMSDK volume change event.");
                    }
                    catch (Throwable t) {
                        logger.e("Error occurred firing OMSDK volume change event.", t);
                    }
                }
            }
        });
    }

    public void onViewableChanged(boolean viewable) {
        if (this.isPlaybackComplete()) {
            return;
        }
        if (viewable && (this.autoPlay || this.playbackInitiated)) {
            this.play();
        } else {
            this.pause();
        }
    }

    void pause() {
        this.videoView.pause();
    }

    void play() {
        this.videoView.play();
    }

    boolean isPlaybackComplete() {
        return this.replayButton.getVisibility() == 0;
    }

    public float getVolume() {
        return this.videoView.getVolume();
    }

    public void release() {
        if (this.playbackControlWatcher != null) {
            this.playbackControlWatcher.stopWatching();
        }
        if (this.videoView != null) {
            this.pause();
            this.videoView.unload();
        }
    }
}

