/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.nativeverizonnativeadapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.view.View;
import com.iab.omid.library.oath.adsession.video.VideoEvents;
import com.verizon.ads.AdContent;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.PEXHandler;
import com.verizon.ads.nativeplacement.NativeAd;
import com.verizon.ads.nativeplacement.NativeAdAdapter;
import com.verizon.ads.nativeplacement.NativeComponentBundle;
import com.verizon.ads.nativeplacement.VASDisplayMediaView;
import com.verizon.ads.nativeplacement.VASTextView;
import com.verizon.ads.nativeverizonnativeadapter.VerizonImageView;
import com.verizon.ads.nativeverizonnativeadapter.VerizonNativeComponentBundle;
import com.verizon.ads.nativeverizonnativeadapter.VerizonVideoView;
import com.verizon.ads.utils.HttpUtils;
import com.verizon.ads.utils.TextUtils;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.verizonnativecontroller.VerizonNativeController;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeVerizonNativeAdapter
implements NativeAdAdapter {
    private static final Logger logger = Logger.getInstance(NativeVerizonNativeAdapter.class);
    private static final String BUNDLE_CONTENT_TYPE = "bundle";
    private static final String TEXT_PREFIX = "text/";
    private static final String IMAGE_PREFIX = "image/";
    private static final String VIDEO_PREFIX = "video/";
    private static final String KEY_POST_EVENT_EXPERIENCES = "postEventExperiences";
    private static final String KEY_SECRET = "secret";
    private static final String PEX_PREFIX = "PEX_";
    private static final String DEFAULT_EVENTS = "defaultEvents";
    private NativeAdAdapter.NativeAdAdapterListener nativeAdAdapterListener;
    private VerizonNativeController verizonNativeController = new VerizonNativeController();
    private AdContent adContent;

    public void setListener(NativeAdAdapter.NativeAdAdapterListener nativeAdAdapterListener) {
        this.nativeAdAdapterListener = nativeAdAdapterListener;
    }

    public String getOMSessionType() {
        return this.verizonNativeController.getOMSessionType();
    }

    public String getAdType() {
        return this.verizonNativeController.getAdType();
    }

    public void release() {
        this.verizonNativeController.release();
    }

    public AdContent getAdContent() {
        return this.adContent;
    }

    public void loadComponents(boolean skipAssets, int timeout, final NativeAdAdapter.LoadComponentsListener loadComponentsListener) {
        if (loadComponentsListener == null) {
            logger.e("loadComponentsListener must not be null.");
            return;
        }
        this.verizonNativeController.loadResources(skipAssets, timeout, new VerizonNativeController.LoadResourcesListener(){

            public void onComplete(ErrorInfo errorInfo) {
                loadComponentsListener.onComplete(errorInfo);
            }
        });
    }

    public void abortLoadComponents() {
        this.verizonNativeController.abortLoadAssets();
    }

    public void invokeDefaultAction(Context context) {
        try {
            JSONObject nativeJSON = this.verizonNativeController.getNativeJSON();
            JSONArray actions = this.getActionsForEvent(null, nativeJSON, "tap");
            if (actions == null) {
                logger.d("No default actions specified for event tap.");
                return;
            }
            for (int i = 0; i < actions.length(); ++i) {
                this.performAction(context, actions.getJSONObject(i));
            }
        }
        catch (Exception e) {
            logger.e("Could not determine the default action due to an exception.", (Throwable)e);
        }
    }

    public void fireImpression() {
    }

    public VASTextView getText(NativeComponentBundle nativeComponentBundle, Context context, String componentId) {
        if (context == null) {
            logger.e("context cannot be null.");
            return null;
        }
        JSONObject componentInfo = this.getComponentJSON(nativeComponentBundle, componentId);
        if (componentInfo == null) {
            logger.e(String.format("Could not find component info for id <%s>", componentId));
            return null;
        }
        try {
            String contentType = componentInfo.getString("contentType");
            if (!contentType.startsWith(TEXT_PREFIX)) {
                logger.e(String.format("Invalid content type <%s> for text component with id <%s>", contentType, componentId));
                return null;
            }
            VASTextView vasTextView = this.getVasTextView(context, componentInfo.getString("data"));
            this.registerTapListener(context, (View)vasTextView, nativeComponentBundle, componentInfo);
            return vasTextView;
        }
        catch (JSONException e) {
            logger.e(String.format("Invalid structure for text component with id <%s>", componentId), (Throwable)e);
            return null;
        }
    }

    public VASDisplayMediaView getDisplayMedia(NativeComponentBundle nativeComponentBundle, Context context, String componentId) {
        if (context == null) {
            logger.e("context cannot be null.");
            return null;
        }
        JSONObject componentInfo = this.getComponentJSON(nativeComponentBundle, componentId);
        if (componentInfo == null) {
            logger.e(String.format("Could not find component info for id <%s>", componentId));
            return null;
        }
        try {
            File asset = this.createFileFromAsset(componentInfo.getString("asset"));
            if (!asset.exists()) {
                logger.e(String.format("Media asset for component <%s> does not exist.", componentId));
                return null;
            }
            String contentType = componentInfo.getString("contentType");
            int width = componentInfo.getInt("width");
            int height = componentInfo.getInt("height");
            boolean autoplay = componentInfo.optBoolean("autoplay", true);
            VASDisplayMediaView displayMediaView = null;
            if (contentType.startsWith(IMAGE_PREFIX)) {
                displayMediaView = this.getVerizonImageView(context, componentId, asset, width, height);
            } else if (contentType.startsWith(VIDEO_PREFIX)) {
                NativeAd nativeAd = nativeComponentBundle.getAd();
                displayMediaView = this.getVerizonVideoView(context, asset, width, height, autoplay, nativeAd != null ? nativeAd.getVideoEvents() : null);
            } else {
                logger.e(String.format("Unexpected content type <%s> display media component with Id <%s>", contentType, componentId));
            }
            this.registerTapListener(context, (View)displayMediaView, nativeComponentBundle, componentInfo);
            return displayMediaView;
        }
        catch (JSONException e) {
            logger.e(String.format("Invalid structure for display media component with id <%s>", componentId), (Throwable)e);
            return null;
        }
    }

    public NativeComponentBundle getBundle(NativeComponentBundle nativeComponentBundle, String componentId) {
        JSONObject componentInfo = this.getComponentJSON(nativeComponentBundle, componentId);
        if (componentInfo == null) {
            logger.e(String.format("Could not find component info for id <%s>", componentId));
            return null;
        }
        try {
            String contentType = componentInfo.getString("contentType");
            if (!BUNDLE_CONTENT_TYPE.equalsIgnoreCase(contentType)) {
                logger.e(String.format("Invalid content type <%s> for bundle component with id <%s>", contentType, componentId));
                return null;
            }
            return this.createChildBundle(nativeComponentBundle, componentInfo);
        }
        catch (JSONException e) {
            logger.e(String.format("Invalid structure for bundle component with id <%s>", componentId), (Throwable)e);
            return null;
        }
    }

    public JSONObject getJSON(NativeComponentBundle nativeComponentBundle) {
        JSONObject sanitizedJSON;
        JSONObject json = this.getJsonObject(nativeComponentBundle);
        if (json == null) {
            return null;
        }
        try {
            sanitizedJSON = new JSONObject(json.toString());
        }
        catch (Exception e) {
            logger.e("Error creating copy of JSON for bundle", (Throwable)e);
            return null;
        }
        if (sanitizedJSON.has(KEY_POST_EVENT_EXPERIENCES)) {
            try {
                sanitizedJSON.put(KEY_POST_EVENT_EXPERIENCES, (Object)NativeVerizonNativeAdapter.sanitizeExperiences(sanitizedJSON.getJSONArray(KEY_POST_EVENT_EXPERIENCES)));
            }
            catch (Exception e) {
                logger.e("Invalid format for postEventExperiences", (Throwable)e);
                sanitizedJSON.remove(KEY_POST_EVENT_EXPERIENCES);
            }
        }
        return sanitizedJSON;
    }

    public JSONObject getJSON(NativeComponentBundle nativeComponentBundle, String componentId) {
        JSONObject sanitizedJSON;
        JSONObject json = this.getComponentJSON(nativeComponentBundle, componentId);
        if (json == null) {
            return null;
        }
        try {
            sanitizedJSON = new JSONObject(json.toString());
        }
        catch (Exception e) {
            logger.e(String.format("Error creating copy of JSON for component Id <%s>", componentId), (Throwable)e);
            return null;
        }
        return sanitizedJSON;
    }

    public Set<String> getComponentIds(NativeComponentBundle nativeComponentBundle) {
        return this.verizonNativeController.getComponentIds(this.getJsonObject(nativeComponentBundle));
    }

    public Set<String> getRequiredComponentIds() {
        return this.verizonNativeController.getRequiredComponentIds();
    }

    public JSONArray getOMVendors() {
        return this.verizonNativeController.getOMVendors();
    }

    public ErrorInfo prepare(AdContent adContent) {
        this.adContent = adContent;
        return this.verizonNativeController.prepare(adContent);
    }

    @NonNull
    VASTextView getVasTextView(Context context, String data) {
        VASTextView textView = new VASTextView(context);
        textView.setText((CharSequence)data);
        return textView;
    }

    VerizonImageView getVerizonImageView(Context context, String componentId, File asset, int width, int height) {
        Bitmap bitmap = this.getBitmap(asset);
        if (bitmap == null) {
            logger.e(String.format("Bitmap could not be decoded for component Id <%s>", componentId));
            return null;
        }
        return this.createVerizonImageView(context, bitmap, width, height);
    }

    @NonNull
    VerizonImageView createVerizonImageView(Context context, Bitmap bitmap, int width, int height) {
        VerizonImageView verizonImageView = new VerizonImageView(context);
        verizonImageView.setImageBitmap(bitmap, width, height);
        return verizonImageView;
    }

    Bitmap getBitmap(File asset) {
        return BitmapFactory.decodeFile((String)asset.getAbsolutePath());
    }

    @NonNull
    VerizonVideoView getVerizonVideoView(Context context, File asset, int width, int height, boolean autoPlay, VideoEvents videoEvents) {
        VerizonVideoView verizonVideoView = new VerizonVideoView(context, width, height, autoPlay, videoEvents);
        verizonVideoView.loadAsset(asset);
        return verizonVideoView;
    }

    @SuppressLint(value={"DefaultLocale"})
    static JSONArray sanitizeExperiences(JSONArray experiences) {
        JSONArray sanitizedExperiences = new JSONArray();
        for (int i = 0; i < experiences.length(); ++i) {
            try {
                JSONObject experience = experiences.getJSONObject(i);
                if (experience.getBoolean(KEY_SECRET)) {
                    if (!Logger.isLogLevelEnabled((int)3)) continue;
                    logger.d(String.format("Sanitized secret postEventExperience: %s", experience.optString("name")));
                    continue;
                }
                sanitizedExperiences.put((Object)experience);
                continue;
            }
            catch (Exception e) {
                logger.e(String.format("Invalid format for postEventExperience entry %d", i));
            }
        }
        return sanitizedExperiences;
    }

    JSONObject getComponentJSON(NativeComponentBundle nativeComponentBundle, String componentId) {
        if (nativeComponentBundle == null) {
            logger.e("nativeComponentBundle cannot be null.");
            return null;
        }
        if (TextUtils.isEmpty((String)componentId)) {
            logger.e("componentId cannot be null or empty string.");
            return null;
        }
        return this.getComponentJSONFromController(nativeComponentBundle, componentId);
    }

    JSONObject getComponentJSONFromController(NativeComponentBundle nativeComponentBundle, String componentId) {
        return this.verizonNativeController.getComponentJSON(this.getJsonObject(nativeComponentBundle), componentId, null);
    }

    @NonNull
    File createFileFromAsset(String pathToMediaAsset) {
        return new File(pathToMediaAsset);
    }

    @NonNull
    VerizonNativeComponentBundle createChildBundle(NativeComponentBundle nativeComponentBundle, JSONObject childBundle) {
        return new VerizonNativeComponentBundle(nativeComponentBundle, childBundle);
    }

    JSONObject getJsonObject(NativeComponentBundle nativeComponentBundle) {
        return nativeComponentBundle instanceof VerizonNativeComponentBundle ? ((VerizonNativeComponentBundle)nativeComponentBundle).jsonObject : this.verizonNativeController.getNativeJSON();
    }

    void registerTapListener(final Context context, View view, final NativeComponentBundle parentBundle, JSONObject componentInfo) {
        if (view == null) {
            logger.e("Cannot register tap listeners for null view.");
            return;
        }
        final JSONArray tapActions = this.getActionsForEvent(parentBundle, componentInfo, "tap");
        if (tapActions == null || tapActions.length() == 0) {
            return;
        }
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NativeVerizonNativeAdapter.this.nativeAdAdapterListener != null) {
                    NativeVerizonNativeAdapter.this.nativeAdAdapterListener.onClicked(parentBundle);
                }
                for (int i = 0; i < tapActions.length(); ++i) {
                    try {
                        NativeVerizonNativeAdapter.this.performAction(context, (JSONObject)tapActions.get(i));
                        continue;
                    }
                    catch (JSONException e) {
                        logger.e("An error occurred performing an action for tap event.", (Throwable)e);
                    }
                }
            }
        });
    }

    void performAction(final Context context, final JSONObject action) {
        this.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONArray urls;
                    String type = action.getString("type");
                    if ("pex".equalsIgnoreCase(type)) {
                        final String id = action.getString("id");
                        VerizonNativeController.LoadedPostEventExperience loadedExperience = NativeVerizonNativeAdapter.this.getLoadedExperienceFromController(id);
                        if (loadedExperience != null) {
                            try {
                                loadedExperience.execute(context, new PEXHandler.PEXHandlerListener(){

                                    public void onEvent(String eventType, Map<String, Object> arguments) {
                                        if (NativeVerizonNativeAdapter.this.nativeAdAdapterListener != null) {
                                            if ("adLeftApplication".equals(eventType)) {
                                                NativeVerizonNativeAdapter.this.nativeAdAdapterListener.onAdLeftApplication();
                                            } else {
                                                NativeVerizonNativeAdapter.this.nativeAdAdapterListener.onEvent(id, NativeVerizonNativeAdapter.PEX_PREFIX + eventType, arguments);
                                            }
                                        }
                                    }
                                }, action.optJSONObject("args"));
                            }
                            catch (Throwable t) {
                                logger.e(String.format("An error occurred executing pex with id = <%s>", id));
                            }
                        } else {
                            logger.e(String.format("No loaded experience exists with id <%s>.", id));
                        }
                    } else if ("trackers".equalsIgnoreCase(type) && (urls = action.getJSONArray("urls")) != null && urls.length() > 0) {
                        NativeVerizonNativeAdapter.this.runOnWorkerThread(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = 0; i < urls.length(); ++i) {
                                    try {
                                        NativeVerizonNativeAdapter.this.pingUrl(urls.getString(i));
                                        continue;
                                    }
                                    catch (JSONException e) {
                                        logger.e("Exception while retrieving tracker url.", (Throwable)e);
                                    }
                                }
                            }
                        });
                    }
                }
                catch (JSONException e) {
                    logger.e("An exception occurred processing event action json.", (Throwable)e);
                }
            }
        });
    }

    void pingUrl(String url) {
        HttpUtils.getContentFromGetRequest((String)url);
    }

    VerizonNativeController.LoadedPostEventExperience getLoadedExperienceFromController(String id) {
        return this.verizonNativeController.getLoadedPostEventExperience(id);
    }

    JSONArray getActionsForEvent(NativeComponentBundle parentBundle, JSONObject componentInfo, String eventName) {
        JSONObject event;
        JSONObject events;
        JSONObject jSONObject = componentInfo != null ? componentInfo.optJSONObject(parentBundle != null ? "events" : DEFAULT_EVENTS) : (events = null);
        if (events != null && (event = events.optJSONObject(eventName)) != null) {
            try {
                JSONArray actions = event.getJSONArray("actions");
                if (actions.length() > 0) {
                    return actions;
                }
            }
            catch (JSONException e) {
                logger.e(String.format("No actions specified for event <%s>", eventName), (Throwable)e);
            }
        }
        if (parentBundle != null) {
            return this.getActionsForEvent(parentBundle.getParentBundle(), this.getJsonObject(parentBundle), eventName);
        }
        return null;
    }

    void runOnWorkerThread(Runnable runnable) {
        ThreadUtils.runOnWorkerThread((Runnable)runnable);
    }

    void postOnUiThread(Runnable runnable) {
        ThreadUtils.postOnUiThread((Runnable)runnable);
    }
}

