/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.interstitialvastadapter;

import android.content.Context;
import com.verizon.ads.AdContent;
import com.verizon.ads.ContentFilter;
import com.verizon.ads.Logger;
import com.verizon.ads.Plugin;
import com.verizon.ads.interstitialplacement.InterstitialAd;
import com.verizon.ads.interstitialvastadapter.InterstitialVASTAdapter;
import com.verizon.ads.utils.TextUtils;
import java.net.URI;
import java.net.URL;

public class InterstitialVASTAdapterPlugin
extends Plugin {
    private static final Logger logger = Logger.getInstance(InterstitialVASTAdapterPlugin.class);
    private static final String PLUGIN_ID = "com.verizon.ads.interstitialvastadapter";
    private static final String PLUGIN_NAME = "Interstitial VAST Adapter";
    private static final String PLUGIN_VERSION = "1.2.0-a5c4364";
    private static final String PLUGIN_AUTHOR = "Verizon";
    private static final URI PLUGIN_EMAIL = null;
    private static final URL PLUGIN_WEBSITE = null;
    private static final int PLUGIN_MIN_API_LEVEL = 1;

    public InterstitialVASTAdapterPlugin(Context applicationContext) {
        super(applicationContext, PLUGIN_ID, PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR, PLUGIN_EMAIL, PLUGIN_WEBSITE, 1);
    }

    protected boolean prepare() {
        logger.d("Preparing InterstitialVASTAdapterPlugin");
        this.registerAdAdapter(InterstitialAd.class, InterstitialVASTAdapter.class, new InterstitialVASTContentFilter());
        return true;
    }

    protected void onPluginEnabled() {
    }

    protected void onPluginDisabled() {
    }

    static class InterstitialVASTContentFilter
    implements ContentFilter {
        InterstitialVASTContentFilter() {
        }

        public boolean accepts(AdContent adContent) {
            if (adContent == null) {
                return false;
            }
            String content = adContent.getContent();
            if (TextUtils.isEmpty((String)content)) {
                return false;
            }
            content = content.toUpperCase();
            int vastOpenIndex = content.indexOf("<VAST");
            int adOpenIndex = content.indexOf("<AD");
            int vastCloseIndex = content.indexOf("</VAST>");
            return vastOpenIndex >= 0 && vastOpenIndex < adOpenIndex && adOpenIndex < vastCloseIndex;
        }
    }
}

