/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.interstitialvastadapter;

import android.content.Context;
import com.verizon.ads.AdContent;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.interstitialplacement.InterstitialAdAdapter;
import com.verizon.ads.interstitialvastadapter.VASTActivity;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.vastcontroller.VASTController;
import java.lang.ref.WeakReference;

public class InterstitialVASTAdapter
implements InterstitialAdAdapter,
VASTController.VASTControllerListener {
    private static final Logger logger = Logger.getInstance(InterstitialVASTAdapter.class);
    private static final String WHO = InterstitialVASTAdapter.class.getSimpleName();
    private static final int ERROR_NULL_ACTIVITY = -1;
    private static final int ERROR_INCORRECT_STATE = -2;
    private WeakReference<VASTActivity> activityRef;
    private VASTController vastController;
    private InterstitialAdAdapter.InterstitialAdAdapterListener interstitialAdAdapterListener;
    private boolean immersive;
    private int enterAnimationId = 0;
    private int exitAnimationId = 0;
    private AdContent adContent;
    private volatile AdapterState state = AdapterState.DEFAULT;

    public InterstitialVASTAdapter() {
        this.vastController = new VASTController();
        this.vastController.setListener((VASTController.VASTControllerListener)this);
    }

    public synchronized ErrorInfo prepare(AdContent adContent) {
        if (this.state != AdapterState.DEFAULT) {
            logger.d("prepare failed; adapter is not in the default state.");
            return new ErrorInfo(WHO, "Adapter not in the default state.", -2);
        }
        ErrorInfo errorInfo = this.vastController.prepare(adContent.getContent());
        this.state = errorInfo == null ? AdapterState.PREPARED : AdapterState.ERROR;
        this.adContent = adContent;
        return errorInfo;
    }

    public AdContent getAdContent() {
        return this.adContent;
    }

    public synchronized void load(Context context, int timeout, final InterstitialAdAdapter.LoadViewListener listener) {
        if (listener == null) {
            logger.e("LoadViewListener cannot be null.");
            return;
        }
        if (this.state != AdapterState.PREPARED) {
            logger.d("Adapter must be in prepared state to load.");
            listener.onComplete(new ErrorInfo(WHO, "Adapter not in prepared state.", -2));
            return;
        }
        this.state = AdapterState.LOADING;
        this.vastController.load(context, timeout, new VASTController.LoadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(ErrorInfo errorInfo) {
                InterstitialVASTAdapter interstitialVASTAdapter = InterstitialVASTAdapter.this;
                synchronized (interstitialVASTAdapter) {
                    if (InterstitialVASTAdapter.this.state == AdapterState.LOADING) {
                        if (errorInfo == null) {
                            InterstitialVASTAdapter.this.state = AdapterState.LOADED;
                        } else {
                            InterstitialVASTAdapter.this.state = AdapterState.ERROR;
                        }
                        listener.onComplete(errorInfo);
                    } else {
                        listener.onComplete(new ErrorInfo(WHO, "Adapter not in the loading state.", -2));
                    }
                }
            }
        });
    }

    public synchronized void abortLoad() {
        logger.d("Attempting to abort load.");
        if (this.state == AdapterState.PREPARED || this.state == AdapterState.LOADING) {
            this.state = AdapterState.ABORTED;
        }
    }

    public synchronized void show(Context context) {
        if (this.state != AdapterState.LOADED) {
            logger.d("Show failed; Adapter not loaded.");
            if (this.interstitialAdAdapterListener != null) {
                this.interstitialAdAdapterListener.onError(new ErrorInfo(WHO, "Show failed; Adapter not loaded.", -2));
            }
            return;
        }
        this.state = AdapterState.SHOWING;
        VASTActivity.VASTActivityConfig config = new VASTActivity.VASTActivityConfig(this);
        config.setImmersive(this.isImmersiveEnabled()).setTransitionAnimation(this.getEnterAnimationId(), this.getExitAnimationId());
        VASTActivity.launch(context, config);
    }

    public synchronized void setListener(InterstitialAdAdapter.InterstitialAdAdapterListener interstitialAdAdapterListener) {
        if (this.state != AdapterState.PREPARED && this.state != AdapterState.DEFAULT && this.state != AdapterState.LOADING && this.state != AdapterState.LOADED) {
            logger.e("InterstitialAdAdapterListener can only be set in default or prepared state.");
            return;
        }
        this.interstitialAdAdapterListener = interstitialAdAdapterListener;
    }

    public void setImmersiveEnabled(boolean immersive) {
        this.immersive = immersive;
    }

    public boolean isImmersiveEnabled() {
        return this.immersive;
    }

    public void setEnterAnimation(int enterAnimationId) {
        this.enterAnimationId = enterAnimationId;
    }

    public int getEnterAnimationId() {
        return this.enterAnimationId;
    }

    public void setExitAnimation(int exitAnimationId) {
        this.exitAnimationId = exitAnimationId;
    }

    public int getExitAnimationId() {
        return this.exitAnimationId;
    }

    public void fireImpression() {
    }

    void attach(final VASTActivity activity) {
        final InterstitialAdAdapter.InterstitialAdAdapterListener adAdapterListener = this.interstitialAdAdapterListener;
        if (activity == null) {
            this.state = AdapterState.ERROR;
            if (adAdapterListener != null) {
                adAdapterListener.onError(new ErrorInfo(WHO, "Could not attach VAST player. Parent activity was null.", -1));
            }
            return;
        }
        this.activityRef = new WeakReference<VASTActivity>(activity);
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (InterstitialVASTAdapter.this.state != AdapterState.SHOWING && InterstitialVASTAdapter.this.state != AdapterState.SHOWN) {
                    logger.d("adapter not in shown or showing state; aborting show.");
                    InterstitialVASTAdapter.this.finishActivity();
                    return;
                }
                InterstitialVASTAdapter.this.vastController.attach(activity.getRootView(), new VASTController.AttachListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onComplete(ErrorInfo errorInfo) {
                        InterstitialVASTAdapter interstitialVASTAdapter = InterstitialVASTAdapter.this;
                        synchronized (interstitialVASTAdapter) {
                            if (errorInfo != null) {
                                InterstitialVASTAdapter.this.state = AdapterState.ERROR;
                                if (adAdapterListener != null) {
                                    adAdapterListener.onError(errorInfo);
                                }
                            } else {
                                InterstitialVASTAdapter.this.state = AdapterState.SHOWN;
                                if (adAdapterListener != null) {
                                    adAdapterListener.onShown();
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    public synchronized void release() {
        this.state = AdapterState.RELEASED;
        if (this.vastController != null) {
            this.vastController.close();
            this.vastController.release();
            this.vastController = null;
        }
        ThreadUtils.postOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                InterstitialVASTAdapter.this.finishActivity();
            }
        });
    }

    synchronized boolean isReleased() {
        return this.state == AdapterState.RELEASED;
    }

    VASTActivity getActivity() {
        if (this.activityRef == null) {
            return null;
        }
        return (VASTActivity)((Object)this.activityRef.get());
    }

    void finishActivity() {
        VASTActivity activity = this.getActivity();
        if (activity != null && !activity.isFinishing()) {
            activity.finish();
        }
    }

    void onClosed() {
        if (this.interstitialAdAdapterListener != null) {
            this.interstitialAdAdapterListener.onClosed();
        }
    }

    synchronized boolean onBackPressed() {
        return this.vastController != null && this.vastController.onBackPressed();
    }

    public void onClicked() {
        if (this.interstitialAdAdapterListener != null) {
            this.interstitialAdAdapterListener.onClicked();
        }
    }

    public void onAdLeftApplication() {
        if (this.interstitialAdAdapterListener != null) {
            this.interstitialAdAdapterListener.onAdLeftApplication();
        }
    }

    public void onVideoComplete() {
        if (this.interstitialAdAdapterListener != null) {
            this.interstitialAdAdapterListener.onEvent(WHO, "onVideoComplete", null);
        }
    }

    public void close() {
        this.finishActivity();
    }

    static enum AdapterState {
        DEFAULT,
        PREPARED,
        LOADING,
        LOADED,
        SHOWING,
        SHOWN,
        ERROR,
        ABORTED,
        RELEASED;

    }
}

