/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.utils;

import com.verizon.ads.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class VASAdsSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger logger = Logger.getInstance(VASAdsSSLSocketFactory.class);
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"TLSv1.1", "TLSv1.2"};
    private static final String[] SUPPORTED_CIPHER_SUITES = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"};
    private static String sslContextFactoryClass = null;
    private SSLSocketFactory socketFactory;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private static volatile VASAdsSSLSocketFactory instance = new VASAdsSSLSocketFactory().init();

    static void setSSLContextFactoryClass(String sslContextFactoryClass) {
        VASAdsSSLSocketFactory.sslContextFactoryClass = sslContextFactoryClass;
        instance.init();
    }

    private VASAdsSSLSocketFactory() {
    }

    private VASAdsSSLSocketFactory init() {
        block5: {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Initializing SSLSocketFactory");
            }
            try {
                SSLContext sslContext = this.getSSLContext();
                if (sslContext != null) {
                    this.socketFactory = sslContext.getSocketFactory();
                    SSLSocket socket = (SSLSocket)this.socketFactory.createSocket();
                    this.enabledProtocols = VASAdsSSLSocketFactory.getEnabledEntries(socket.getSupportedProtocols(), SUPPORTED_PROTOCOLS);
                    this.enabledCipherSuites = VASAdsSSLSocketFactory.getEnabledEntries(socket.getSupportedCipherSuites(), SUPPORTED_CIPHER_SUITES);
                    socket.close();
                    if (Logger.isLogLevelEnabled(3)) {
                        logger.d("Protocols enabled: " + Arrays.toString(this.enabledProtocols));
                        logger.d("Cipher suites enabled: " + Arrays.toString(this.enabledCipherSuites));
                    }
                    break block5;
                }
                logger.e("Failed to instantiate a valid SSLContext.");
                return null;
            }
            catch (Exception e) {
                logger.e("Failed to initialize SSLSocketFactory", e);
                return null;
            }
        }
        return this;
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContextFactory sslContextFactory = null;
        if (sslContextFactoryClass != null) {
            try {
                sslContextFactory = (SSLContextFactory)Class.forName(sslContextFactoryClass).newInstance();
            }
            catch (Exception e) {
                logger.e("Could not instantiate custom SSLContextFactory using class = " + sslContextFactoryClass + ", reverting to default.");
            }
        }
        if (sslContextFactory == null) {
            sslContextFactory = new DefaultSSLContextFactory();
        }
        return sslContextFactory.getInstance("TLS");
    }

    public static VASAdsSSLSocketFactory getInstance() {
        return instance;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.socketFactory.createSocket(s, host, port, autoClose);
        return this.secureSocket(socket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.socketFactory.createSocket(host, port);
        return this.secureSocket(socket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = this.socketFactory.createSocket(host, port, localHost, localPort);
        return this.secureSocket(socket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.socketFactory.createSocket(host, port);
        return this.secureSocket(socket);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.socketFactory.createSocket(address, port, localAddress, localPort);
        return this.secureSocket(socket);
    }

    private Socket secureSocket(Socket socket) {
        if (socket instanceof SSLSocket) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Setting enabled protocols and cipher suites on secure socket");
            }
            try {
                ((SSLSocket)socket).setEnabledProtocols(this.enabledProtocols);
                ((SSLSocket)socket).setEnabledCipherSuites(this.enabledCipherSuites);
            }
            catch (Exception e) {
                logger.e("Failed to set secure socket properties - " + e.getMessage());
            }
        }
        return socket;
    }

    private static String[] getEnabledEntries(String[] available, String[] requested) {
        HashSet<String> availableEntries = new HashSet<String>(Arrays.asList(available));
        HashSet<String> enabledEntries = new HashSet<String>(Arrays.asList(requested));
        enabledEntries.retainAll(availableEntries);
        return enabledEntries.toArray(new String[0]);
    }

    private class DefaultSSLContextFactory
    implements SSLContextFactory {
        private DefaultSSLContextFactory() {
        }

        @Override
        public SSLContext getInstance(String protocol) throws NoSuchAlgorithmException, KeyManagementException {
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, null, null);
            return sslContext;
        }
    }

    public static interface SSLContextFactory {
        public SSLContext getInstance(String var1) throws NoSuchAlgorithmException, KeyManagementException;
    }
}

