/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import com.verizon.ads.Bid;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Waterfall;
import com.verizon.ads.events.Events;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class WaterfallResult {
    public static final String EVENT_WATERFALL_RESULT = "com.verizon.ads.waterfall.result";
    private final long startTime = System.currentTimeMillis();
    private final String eventId = UUID.randomUUID().toString();
    private final Map<String, Object> waterfallMetadata;
    private final List<WaterfallItemResult> waterfallItemResults;
    private final Bid bid;
    private long elapsedTime;
    private ErrorInfo errorInfo;

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Map<String, Object> getMetadata() {
        if (this.waterfallMetadata == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.waterfallMetadata);
    }

    public List<WaterfallItemResult> getWaterfallItemResults() {
        return Collections.unmodifiableList(this.waterfallItemResults);
    }

    public Bid getBid() {
        return this.bid;
    }

    public WaterfallResult(Waterfall waterfall, Bid bid) {
        this.waterfallMetadata = waterfall.getMetadata();
        this.waterfallItemResults = new ArrayList<WaterfallItemResult>();
        this.bid = bid;
    }

    public synchronized void setResult(ErrorInfo errorInfo) {
        if (this.elapsedTime > 0L || this.errorInfo != null) {
            return;
        }
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        this.errorInfo = errorInfo;
        if (this.waterfallItemResults.size() > 0) {
            WaterfallItemResult waterfallItemResult = this.waterfallItemResults.get(this.waterfallItemResults.size() - 1);
            waterfallItemResult.setResult(errorInfo);
        }
        Events.sendEvent(EVENT_WATERFALL_RESULT, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized WaterfallItemResult startWaterfallItem(Waterfall.WaterfallItem waterfallItem) {
        WaterfallItemResult waterfallItemResult;
        List<WaterfallItemResult> list = this.waterfallItemResults;
        synchronized (list) {
            waterfallItemResult = new WaterfallItemResult(waterfallItem);
            this.waterfallItemResults.add(waterfallItemResult);
        }
        return waterfallItemResult;
    }

    public synchronized String toString() {
        return "WaterfallResult{eventId=" + this.eventId + ", startTime=" + this.startTime + ", elapsedTime=" + this.elapsedTime + ", waterfallMetadata=" + (this.waterfallMetadata == null ? "" : this.waterfallMetadata.toString()) + ", waterfallItemResults=" + this.waterfallItemResults.toString() + '}';
    }

    public static final class WaterfallItemResult {
        private final long startTime = System.currentTimeMillis();
        private Waterfall.WaterfallItem waterfallItem;
        private Map<String, Object> waterfallItemMetadata;
        private long elapsedTime;
        private ErrorInfo errorInfo;

        public long getStartTime() {
            return this.startTime;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public ErrorInfo getErrorInfo() {
            return this.errorInfo;
        }

        public Map<String, Object> getMetadata() {
            if (this.waterfallItemMetadata == null) {
                return null;
            }
            return Collections.unmodifiableMap(this.waterfallItemMetadata);
        }

        private WaterfallItemResult(Waterfall.WaterfallItem waterfallItem) {
            this.waterfallItem = waterfallItem;
        }

        synchronized boolean setResult(ErrorInfo errorInfo) {
            if (this.elapsedTime > 0L || this.errorInfo != null) {
                return false;
            }
            if (this.waterfallItem != null) {
                this.waterfallItemMetadata = this.waterfallItem.getMetadata();
                this.waterfallItem = null;
            }
            this.elapsedTime = System.currentTimeMillis() - this.startTime;
            this.errorInfo = errorInfo;
            return true;
        }

        public synchronized String toString() {
            return "WaterfallItemResult{startTime=" + this.startTime + ", elapsedTime=" + this.elapsedTime + ", errorInfo=" + (this.errorInfo == null ? "" : this.errorInfo.toString()) + ", waterfallItem=" + (this.waterfallItem == null ? "" : this.waterfallItem.toString()) + ", waterfallItemMetadata= " + (this.waterfallItemMetadata == null ? "" : this.waterfallItemMetadata.toString()) + '}';
        }
    }
}

