/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.util.Log;

public final class Logger {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    private static final String TAG_PREFIX = "VAS-";
    private static volatile int logLevel = 4;
    private final String tag;

    private Logger(String tag) {
        this.tag = tag;
    }

    public static Logger getInstance(Class clazz) {
        return new Logger(clazz.getSimpleName());
    }

    static void setLogLevel(int level) {
        logLevel = level;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static boolean isLogLevelEnabled(int level) {
        return logLevel <= level;
    }

    public void v(String logMessage) {
        if (logLevel <= 2) {
            Log.v((String)this.getFullTag(), (String)logMessage);
        }
    }

    public void v(String logMessage, Throwable throwable) {
        if (logLevel <= 2) {
            Log.v((String)this.getFullTag(), (String)logMessage, (Throwable)throwable);
        }
    }

    public void d(String logMessage) {
        if (logLevel <= 3) {
            Log.d((String)this.getFullTag(), (String)logMessage);
        }
    }

    public void d(String logMessage, Throwable throwable) {
        if (logLevel <= 3) {
            Log.d((String)this.getFullTag(), (String)logMessage, (Throwable)throwable);
        }
    }

    public void i(String logMessage) {
        if (logLevel <= 4) {
            Log.i((String)this.getFullTag(), (String)logMessage);
        }
    }

    public void i(String logMessage, Throwable throwable) {
        if (logLevel <= 4) {
            Log.i((String)this.getFullTag(), (String)logMessage, (Throwable)throwable);
        }
    }

    public void w(String logMessage) {
        if (logLevel <= 5) {
            Log.w((String)this.getFullTag(), (String)logMessage);
        }
    }

    public void w(String logMessage, Throwable throwable) {
        if (logLevel <= 5) {
            Log.w((String)this.getFullTag(), (String)logMessage, (Throwable)throwable);
        }
    }

    public void e(String logMessage) {
        if (logLevel <= 6) {
            Log.e((String)this.getFullTag(), (String)logMessage);
        }
    }

    public void e(String logMessage, Throwable throwable) {
        if (logLevel <= 6) {
            Log.e((String)this.getFullTag(), (String)logMessage, (Throwable)throwable);
        }
    }

    private String getFullTag() {
        return TAG_PREFIX + this.tag + " <" + Thread.currentThread().getId() + ":" + System.currentTimeMillis() + ">";
    }

    static String stringFromLogLevel(int logLevel) {
        switch (logLevel) {
            case 2: {
                return "VERBOSE";
            }
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
        }
        return "UNKNOWN";
    }
}

