/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.content.Context;
import android.content.res.AssetManager;
import com.flurry.android.Consent;
import com.flurry.android.FlurryAgent;
import com.flurry.android.FlurryConsent;
import com.verizon.ads.Configuration;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.ErrorInfoException;
import com.verizon.ads.Logger;
import com.verizon.ads.Plugin;
import com.verizon.ads.PrivacyDataHelper;
import com.verizon.ads.VASAds;
import com.verizon.ads.utils.IOUtils;
import com.verizon.ads.utils.TextUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020-H\u0007J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00100\u001a\u00020-H\u0002J\u0018\u00103\u001a\u00020+2\u0006\u00100\u001a\u00020-2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020+2\u0006\u00107\u001a\u000202H\u0002J\u0010\u00108\u001a\u00020+2\u0006\u00109\u001a\u000202H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR!\u0010\u001f\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010 8F\u00a2\u0006\f\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001bR\u0016\u0010%\u001a\u0004\u0018\u00010\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\n )*\u0004\u0018\u00010(0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/verizon/ads/Bootstrap;", "", "()V", "BOOTSTRAP_FILE_NAME", "", "CLASS_KEY", "CONFIGURATION_SETTINGS_KEY", "EDITION_NAME_KEY", "EDITION_VERSION_KEY", "ENABLED_KEY", "ERROR_INITIALIZING_FLURRY", "", "ERROR_LOADING_MANIFEST", "ERROR_REGISTERING_PLUGINS", "ERROR_SETTING_CONFIGURATION", "FLURRY_APIKEY_KEY", "FLURRY_DATA_SALE_OPT_OUT_CCPA_KEY", "FLURRY_DOMAIN", "FLURRY_IS_GDPR_SCOPE_KEY", "MANIFEST_VERSION", "PLUGINS_KEY", "VERIZON_ADS_CORE_DOMAIN", "VERIZON_ADS_DOMAIN", "WHO", "dataSaleOptOutCCPA", "", "getDataSaleOptOutCCPA", "()Z", "flurryApiKey", "getFlurryApiKey", "()Ljava/lang/String;", "gdprConsentMap", "", "gdprConsentMap$annotations", "getGdprConsentMap", "()Ljava/util/Map;", "isFlurryAnalyticsAvailable", "isGdprScope", "()Ljava/lang/Boolean;", "logger", "Lcom/verizon/ads/Logger;", "kotlin.jvm.PlatformType", "initializeFlurryAnalytics", "", "applicationContext", "Landroid/content/Context;", "load", "Lcom/verizon/ads/ErrorInfo;", "context", "loadManifest", "Lorg/json/JSONObject;", "registerPlugins", "plugins", "Lorg/json/JSONArray;", "setupConfiguration", "configurationSettings", "verifyManifestVersion", "manifest", "lib_release"})
public final class Bootstrap {
    private static final Logger logger;
    private static final String WHO;
    private static final String VERIZON_ADS_DOMAIN = "com.verizon.ads";
    private static final String VERIZON_ADS_CORE_DOMAIN = "com.verizon.ads.core";
    private static final String FLURRY_DOMAIN = "com.verizon.ads.flurry";
    private static final String BOOTSTRAP_FILE_NAME = "verizon_ads_sdk_bootstrap.json";
    private static final int MANIFEST_VERSION = 1;
    private static final String PLUGINS_KEY = "plugins";
    private static final String CONFIGURATION_SETTINGS_KEY = "configurationSettings";
    private static final String CLASS_KEY = "id";
    private static final String ENABLED_KEY = "enabled";
    private static final String EDITION_NAME_KEY = "editionName";
    private static final String EDITION_VERSION_KEY = "editionVersion";
    private static final String FLURRY_APIKEY_KEY = "api-key";
    private static final String FLURRY_IS_GDPR_SCOPE_KEY = "isGdprScope";
    private static final String FLURRY_DATA_SALE_OPT_OUT_CCPA_KEY = "dataSaleOptOutCCPA";
    private static final int ERROR_LOADING_MANIFEST = -1;
    private static final int ERROR_REGISTERING_PLUGINS = -2;
    private static final int ERROR_SETTING_CONFIGURATION = -3;
    private static final int ERROR_INITIALIZING_FLURRY = -4;
    public static final Bootstrap INSTANCE;

    @JvmStatic
    @Nullable
    public static final ErrorInfo load(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        logger.d("Loading bootstrap");
        try {
            JSONObject manifest;
            JSONObject jSONObject = manifest = INSTANCE.loadManifest(context);
            if (jSONObject != null) {
                boolean bl;
                boolean bl2;
                JSONArray jSONArray;
                JSONObject jSONObject2 = jSONObject;
                boolean bl3 = false;
                boolean bl4 = false;
                JSONObject it = jSONObject2;
                boolean bl5 = false;
                JSONArray jSONArray2 = manifest.optJSONArray(PLUGINS_KEY);
                if (jSONArray2 != null) {
                    jSONArray = jSONArray2;
                    bl2 = false;
                    bl = false;
                    JSONArray plugins = jSONArray;
                    boolean bl6 = false;
                    INSTANCE.registerPlugins(context, plugins);
                } else {
                    logger.d("No plugin definitions found");
                }
                JSONObject jSONObject3 = manifest.optJSONObject(CONFIGURATION_SETTINGS_KEY);
                if (jSONObject3 != null) {
                    jSONArray = jSONObject3;
                    bl2 = false;
                    bl = false;
                    JSONArray configurationSettings = jSONArray;
                    boolean bl7 = false;
                    INSTANCE.setupConfiguration((JSONObject)configurationSettings);
                } else {
                    logger.d("No configuration settings found");
                }
                INSTANCE.initializeFlurryAnalytics(context);
                logger.d("Bootstrap loaded successfully -- continuing with VAS initialization");
            } else {
                logger.d("Bootstrap file was not found -- continuing with VAS initialization");
            }
        }
        catch (ErrorInfoException e) {
            logger.e("Bootstrap loading error.", e);
            return e.toErrorInfo();
        }
        return null;
    }

    private final JSONObject loadManifest(Context context) throws ErrorInfoException {
        JSONObject jSONObject;
        String string;
        logger.d("Loading manifest");
        try {
            AssetManager assetManager = context.getAssets();
            string = IOUtils.convertStreamToString(assetManager != null ? assetManager.open(BOOTSTRAP_FILE_NAME) : null);
        }
        catch (IOException e) {
            string = null;
        }
        String content = string;
        if (content == null) {
            logger.w("verizon_ads_sdk_bootstrap.json file not found. Make sure it is defined in the application assets directory.");
            return null;
        }
        try {
            jSONObject = new JSONObject(content);
        }
        catch (Exception e) {
            throw (Throwable)new ErrorInfoException(WHO, "Invalid JSON in Bootstrap manifest file", -1);
        }
        JSONObject manifest = jSONObject;
        logger.d("Manifest successfully loaded");
        this.verifyManifestVersion(manifest);
        return manifest;
    }

    private final void verifyManifestVersion(JSONObject manifest) throws ErrorInfoException {
        logger.d("Verifying manifest version");
        String version = "";
        try {
            String string = manifest.getString("ver");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"manifest.getString(\"ver\")");
            String string2 = version = string;
            boolean bl = false;
            int majorVersion = Integer.parseInt(string2);
            if (majorVersion > 1) {
                throw (Throwable)new ErrorInfoException(WHO, "Manifest did not contain a compatible version. Received version " + majorVersion + " and expected max version of 1", -1);
            }
        }
        catch (JSONException e) {
            throw (Throwable)new ErrorInfoException(WHO, "Manifest does not contain a version string", -1);
        }
        catch (NumberFormatException e) {
            throw (Throwable)new ErrorInfoException(WHO, "Manifest version is not a valid integer, " + version, -1);
        }
        logger.d("Manifest version verified");
    }

    /*
     * WARNING - void declaration
     */
    private final void registerPlugins(Context context, JSONArray plugins) throws ErrorInfoException {
        logger.d("Registering plugins");
        int n = 0;
        int n2 = plugins.length();
        while (n < n2) {
            void i;
            try {
                Constructor<?> pluginConstructor;
                Class<?> pluginClass;
                JSONObject plugin = plugins.getJSONObject((int)i);
                String className = plugin.getString(CLASS_KEY);
                boolean enabled = plugin.optBoolean(ENABLED_KEY, true);
                logger.d("Registering plugin: " + className);
                Intrinsics.checkExpressionValueIsNotNull(Class.forName(className), (String)"Class.forName(className)");
                Intrinsics.checkExpressionValueIsNotNull(pluginClass.getConstructor(Context.class), (String)"pluginClass.getConstructor(Context::class.java)");
                Object obj = pluginConstructor.newInstance(context);
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.verizon.ads.Plugin");
                }
                VASAds.registerPlugin((Plugin)obj, enabled);
            }
            catch (Exception e) {
                throw (Throwable)new ErrorInfoException(WHO, "Error registering plugins", -2, e);
            }
            ++i;
        }
        logger.d("Plugins successfully registered");
    }

    private final void setupConfiguration(JSONObject configurationSettings) throws ErrorInfoException {
        logger.d("Setting configuration values");
        try {
            Iterator domains = configurationSettings.keys();
            while (domains.hasNext()) {
                String domain = (String)domains.next();
                JSONObject keyValues = configurationSettings.getJSONObject(domain);
                Iterator keys = keyValues.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = keyValues.get(key);
                    logger.d("Setting configuration - domain: " + domain + ", key: " + key + ", value: " + value);
                    Configuration.set(value, domain, key, Configuration.getSecurityKey(domain));
                }
            }
        }
        catch (Exception e) {
            throw (Throwable)new ErrorInfoException(WHO, "Error setting configuration settings", -3);
        }
        logger.d("Configuration values successfully set");
    }

    private final void initializeFlurryAnalytics(Context applicationContext) throws ErrorInfoException {
        logger.d("Initializing Flurry Analytics");
        String flurryApiKey = this.getFlurryApiKey();
        if (flurryApiKey == null) {
            logger.i("No Flurry Analytics api-key provided.");
            return;
        }
        if (TextUtils.isEmpty(flurryApiKey)) {
            logger.e("Unable to initialize Flurry Analytics. The flurry.api-key is empty.");
            return;
        }
        if (!this.isFlurryAnalyticsAvailable()) {
            throw (Throwable)new ErrorInfoException(WHO, "Unable to initialize Flurry Analytics. The flurry.api-key has been set but no Flurry Analytics library can be found.", -4);
        }
        try {
            Boolean gdprScope;
            if (FlurryAgent.isSessionActive()) {
                logger.v("Flurry Analytics session already initialized.");
                return;
            }
            FlurryAgent.Builder builder = new FlurryAgent.Builder();
            if (Logger.isLogLevelEnabled(3)) {
                int logLevel = Logger.getLogLevel();
                builder.withLogEnabled(true);
                builder.withLogLevel(logLevel);
                logger.d("Flurry Analytics logLevel is set to " + Logger.stringFromLogLevel(logLevel));
            }
            Boolean bl = gdprScope = this.isGdprScope();
            if (bl == null) {
                throw (Throwable)new ErrorInfoException(WHO, "Unable to initialize Flurry Analytics. The flurry.isGdprScope key must be set.", -4);
            }
            bl.booleanValue();
            Map<?, ?> gdprConsentMap = this.getGdprConsentMap();
            builder.withConsent((Consent)new FlurryConsent(gdprScope.booleanValue(), gdprConsentMap));
            boolean dataSaleOptOutCCPA = this.getDataSaleOptOutCCPA();
            builder.withDataSaleOptOut(dataSaleOptOutCCPA);
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Flurry Analytics api-key is set to " + flurryApiKey);
                logger.d("Flurry Analytics isGdprScope is set to " + gdprScope);
                logger.d("Flurry Analytics consentStrings is set to " + gdprConsentMap);
                logger.d("Flurry Analytics dataSaleOptOut is set to " + dataSaleOptOutCCPA);
            }
            builder.build(applicationContext, flurryApiKey);
            String editionName = Configuration.getString(VERIZON_ADS_DOMAIN, EDITION_NAME_KEY, "unknown");
            String editionVersion = Configuration.getString(VERIZON_ADS_DOMAIN, EDITION_VERSION_KEY, "unknown");
            String editionInfo = editionName + '-' + editionVersion;
            FlurryAgent.addOrigin((String)"vas", (String)editionInfo);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new ErrorInfoException(WHO, "Unable to initialize Flurry Analytics. Invalid flurry.api-key.", -4);
        }
        catch (Throwable t) {
            throw (Throwable)new ErrorInfoException(WHO, "Unable to initialize Flurry Analytics. Make sure Flurry Analytics library has been added to build dependencies", -4);
        }
        logger.d("Flurry Analytics successfully initialized");
    }

    private final String getFlurryApiKey() {
        String apiKey;
        String string = Configuration.getString(FLURRY_DOMAIN, FLURRY_APIKEY_KEY, null);
        if (string == null) {
            return null;
        }
        String $this$trim$iv = apiKey = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    private final Boolean isGdprScope() {
        Object value = Configuration.getObject(FLURRY_DOMAIN, FLURRY_IS_GDPR_SCOPE_KEY, null);
        return !(value instanceof Boolean) ? null : (Boolean)value;
    }

    private final boolean getDataSaleOptOutCCPA() {
        return Configuration.getBoolean(FLURRY_DOMAIN, FLURRY_DATA_SALE_OPT_OUT_CCPA_KEY, false);
    }

    public static /* synthetic */ void gdprConsentMap$annotations() {
    }

    @Nullable
    public final Map<?, ?> getGdprConsentMap() {
        Map<?, ?> gdprConsentMap = null;
        try {
            Map privacyData = Configuration.getMap(VERIZON_ADS_CORE_DOMAIN, "userPrivacyData", null);
            if (privacyData != null) {
                PrivacyDataHelper privacyDataHelper = new PrivacyDataHelper(privacyData);
                gdprConsentMap = privacyDataHelper.getGDPRConsentMap();
            }
        }
        catch (Throwable t) {
            logger.e("Error retrieving user privacy data", t);
        }
        return gdprConsentMap;
    }

    private final boolean isFlurryAnalyticsAvailable() {
        try {
            Class.forName("com.flurry.android.FlurryAgent");
        }
        catch (ClassNotFoundException e) {
            logger.e("Flurry Analytics library not found", e);
            return false;
        }
        return true;
    }

    private Bootstrap() {
    }

    static {
        Bootstrap bootstrap;
        INSTANCE = bootstrap = new Bootstrap();
        logger = Logger.getInstance(Bootstrap.class);
        String string = Bootstrap.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Bootstrap::class.java.name");
        WHO = string;
    }
}

