/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.verizonsspwaterfallprovider;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.net.NetworkInfo;
import android.os.Build;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import com.verizon.ads.AdContent;
import com.verizon.ads.AdSession;
import com.verizon.ads.Bid;
import com.verizon.ads.BidRequestListener;
import com.verizon.ads.Component;
import com.verizon.ads.ComponentFactory;
import com.verizon.ads.Configuration;
import com.verizon.ads.CreativeInfo;
import com.verizon.ads.EnvironmentInfo;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.Plugin;
import com.verizon.ads.PrivacyDataHelper;
import com.verizon.ads.RequestMetadata;
import com.verizon.ads.VASAds;
import com.verizon.ads.Waterfall;
import com.verizon.ads.WaterfallProvider;
import com.verizon.ads.WaterfallResult;
import com.verizon.ads.utils.HttpUtils;
import com.verizon.ads.utils.TextUtils;
import com.verizon.ads.utils.ThreadUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VerizonSSPWaterfallProvider
extends WaterfallProvider
implements Component {
    private static final Logger logger = Logger.getInstance(VerizonSSPWaterfallProvider.class);
    private static final String DEFAULT_BASE_URL = "https://ads.nexage.com";
    private static final String PLAYLIST_VERSION = "3";
    private static final String PLAYLIST_REQUEST_PATH = "/admax/sdk/playlist/3";
    private static final String REQ_KEY = "req";
    private static final String DO_NOT_REPORT = "DoNotReport";
    private static final String SERVER_MEDIATION = "server_mediation";
    private static final String AD_CONTENT = "ad_content";
    private static final String EXCHANGE = "exchange";
    private static final String SUPER_AUCTION = "super_auction";
    private static final String SERVER_DEMAND = "server_demand";
    private static final String AD_CONTENT_DEMAND = "ad_content";
    private static final String TYPE = "type";
    private static final String WHO = VerizonSSPWaterfallProvider.class.getSimpleName();
    private static final int NOT_A_VALID_BID_ERROR_CODE = 1;
    private static final int PLAYLIST_SERVER_HTTP_ERROR_CODE = 2;
    private static final int NO_VALID_WATERFALLS_ERROR_CODE = 3;
    private static final int NO_CONTENT_RETURNED_ERROR_CODE = 4;
    private static final int BUILD_PLAYLIST_REQ_ERROR_CODE = 5;
    private static final int NO_DEMAND_SOURCES_ERROR_CODE = 6;
    private static final int NO_BIDS_ERROR_CODE = 7;
    private static final int BID_EXPIRED_ERROR_CODE = 8;
    private static final int NO_REDIRECT_URL_ERROR_CODE = 9;
    private static final String VERIZON_ADS_DOMAIN = "com.verizon.ads";
    private static final String VERIZON_SSP_DOMAIN = "com.verizon.ads.verizonssp";
    private static final String EDITION_NAME_KEY = "editionName";
    private static final String EDITION_VERSION_KEY = "editionVersion";
    private static final String S2S_TIMEOUT_KEY = "serverMediationRequestTimeout";
    private static final String EXCHANGE_TIMEOUT_KEY = "exchangeRequestTimeout";
    private static final String BID_EXPIRATION_KEY = "bidExpirationTimeout";
    private static final String WATERFALL_PROVIDER_BASE_URL_KEY = "waterfallProviderBaseUrl";
    private static final int BID_EXPIRATION_DEFAULT = 600000;
    private static final int S2S_TIMEOUT_DEFAULT = 10000;
    private static final int EXCHANGE_TIMEOUT_DEFAULT = 10000;
    private static final String CREATIVE_ID_HEADER = "CREATIVE_ID_HEADER";
    private static final String RESPONSE_HEADERS_KEY = "response_headers";
    private static final String AD_SIZE_KEY = "ad_size";
    private static final String CREATIVE_INFO_KEY = "creative_info";
    private final Context context;
    private final EnvironmentInfo environmentInfo;
    public static final int ERROR_WATERFALL_ITEM_NO_AD_CONTENT = -1;
    public static final int ERROR_WATERFALL_ITEM_TIMEOUT = -2;
    public static final int ERROR_WATERFALL_ITEM_ERROR = -3;
    public static final int ERROR_WATERFALL_ITEM_SUPER_AUCTION_INVALID_BID = 110;
    public static final int ERROR_WATERFALL_ITEM_SUPER_AUCTION_BID_EXPIRED = 113;
    public static final String METADATA_KEY_RESPONSE_ID = "responseId";
    public static final String METADATA_KEY_PLACEMENT_NAME = "placementName";
    public static final String METADATA_KEY_IMPRESSION_GROUP = "impressionGroup";
    public static final String METADATA_KEY_REPORTING_ENABLED = "reportingEnabled";
    public static final String METADATA_KEY_ITEM_ID = "itemId";
    public static final String METADATA_KEY_BUYER = "buyer";
    public static final String METADATA_KEY_PRU = "pru";
    public static final String USER_DATA_AGE_KEY = "age";
    public static final String USER_DATA_CHILDREN_KEY = "children";
    public static final String USER_DATA_INCOME_KEY = "income";
    public static final String USER_DATA_EDUCATION_KEY = "education";
    public static final String USER_DATA_ETHNICITY_KEY = "ethnicity";
    public static final String USER_DATA_GENDER_KEY = "gender";
    public static final String USER_DATA_KEYWORDS_KEY = "keywords";
    public static final String USER_DATA_MARITAL_STATUS_KEY = "marital";
    public static final String USER_DATA_POLITICS_KEY = "politics";
    public static final String USER_DATA_DOB_KEY = "dob";
    public static final String USER_DATA_STATE_KEY = "state";
    public static final String USER_DATA_COUNTRY_KEY = "country";
    public static final String USER_DATA_POSTAL_CODE_KEY = "postalCode";
    public static final String USER_DATA_DMA_KEY = "dma";
    public static final String APP_DATA_COPPA_KEY = "coppa";
    public static final String APP_DATA_MEDIATOR_KEY = "mediator";
    public static final String PLACEMENT_DATA_TYPE_KEY = "type";
    public static final String PLACEMENT_DATA_IMP_GROUP_KEY = "impressionGroup";
    public static final String PLACEMENT_DATA_ID_KEY = "id";
    public static final String PLACEMENT_DATA_WIDTH_KEY = "width";
    public static final String PLACEMENT_DATA_HEIGHT_KEY = "height";
    public static final String PLACEMENT_DATA_AD_SIZES_KEY = "adSizes";
    public static final String PLACEMENT_DATA_NATIVE_TYPES_KEY = "nativeTypes";
    public static final String PLACEMENT_DATA_REFRESH_RATE_KEY = "refreshRate";
    public static final String EXTRAS_TEST_CREATIVE_ID_KEY = "testCreativeID";
    public static final String EXTRAS_TEST_BIDDER_ID_KEY = "testBidderID";

    private VerizonSSPWaterfallProvider(Context context) {
        super(context);
        this.context = context;
        this.environmentInfo = new EnvironmentInfo(context);
    }

    @Override
    public void load(RequestMetadata requestMetadata, int timeout, WaterfallProvider.WaterfallListener waterfallListener) {
        this.requestPlayLists(requestMetadata, new PlayListRequestListener(waterfallListener, requestMetadata), timeout);
    }

    @Override
    public boolean isSuperAuctionSupported() {
        return true;
    }

    @Override
    public void requestBid(RequestMetadata requestMetadata, int timeout, BidRequestListener bidRequestListener) {
        this.requestPlayLists(requestMetadata, new PlayListRequestListener(bidRequestListener, requestMetadata), timeout);
    }

    @Override
    public void load(Bid bid, int timeout, WaterfallProvider.WaterfallListener waterfallListener) {
        if (!(bid instanceof VerizonSSPBid)) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "Bid is not valid", 1);
            logger.e(errorInfo.toString());
            waterfallListener.onAdSessionsReceived(null, errorInfo);
            return;
        }
        VerizonSSPBid verizonSSPBid = (VerizonSSPBid)bid;
        int bidExpiration = Configuration.getInt(VERIZON_SSP_DOMAIN, BID_EXPIRATION_KEY, 600000);
        long currentTime = System.currentTimeMillis();
        if (currentTime - (long)bidExpiration > verizonSSPBid.bidCreationTime) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "Bid has expired", 8);
            logger.e(errorInfo.toString());
            waterfallListener.onAdSessionsReceived(null, errorInfo);
            WaterfallResult waterfallResult = new WaterfallResult(verizonSSPBid.waterfall, bid);
            waterfallResult.startWaterfallItem(verizonSSPBid.waterfall.waterfallItems.get(0));
            waterfallResult.setResult(new ErrorInfo(WHO, "Provided bid has expired.", 113));
            return;
        }
        if (!TextUtils.isEmpty(verizonSSPBid.winUrl)) {
            String winUrl = verizonSSPBid.winUrl;
            this.pingWinUrl(winUrl);
        }
        VerizonSSPWaterfall waterfall = new VerizonSSPWaterfall();
        waterfall.handshakeId = verizonSSPBid.waterfall.handshakeId;
        waterfall.responseId = verizonSSPBid.waterfall.responseId;
        waterfall.placementId = verizonSSPBid.waterfall.placementId;
        waterfall.placementName = verizonSSPBid.waterfall.placementName;
        waterfall.siteId = verizonSSPBid.waterfall.siteId;
        if (!DO_NOT_REPORT.equals(waterfall.siteId)) {
            waterfall.enableReporting();
        } else if (Logger.isLogLevelEnabled(3)) {
            logger.d("Playlist dcn is <DoNotReport> -- reporting disabled");
        }
        JSONArray demandSources = verizonSSPBid.demandSources;
        if (demandSources != null) {
            for (int i = 0; i < demandSources.length(); ++i) {
                try {
                    JSONObject demandObject = demandSources.getJSONObject(i);
                    String type = demandObject.getString("type");
                    demandObject.put("ad_bidder_id", (Object)demandObject.getString(METADATA_KEY_BUYER));
                    Waterfall.WaterfallItem waterfallItem = VerizonSSPWaterfallProvider.createFromSuperAuctionDemandSource(type, waterfall.placementId, demandObject);
                    if (waterfallItem == null) continue;
                    if (waterfallItem instanceof VerizonSSPWaterfallItem) {
                        ((VerizonSSPWaterfallItem)waterfallItem).adSize = verizonSSPBid.adSize;
                    }
                    waterfall.addItem(waterfallItem);
                    continue;
                }
                catch (Exception e) {
                    logger.e("Error processing super auction demand source.", e);
                }
            }
        } else if (waterfallListener != null) {
            waterfallListener.onAdSessionsReceived(null, new ErrorInfo(WHO, "No Demand Sources in Super Auction item.", 6));
        }
        bid.adSession.put("response.waterfall", (Object)waterfall);
        if (waterfallListener != null) {
            waterfallListener.onAdSessionsReceived(Collections.singletonList(bid.adSession), null);
        }
    }

    @Override
    public String getBiddingToken(RequestMetadata requestMetadata) {
        String requestUrl = Configuration.get(VERIZON_ADS_DOMAIN, WATERFALL_PROVIDER_BASE_URL_KEY, String.class, DEFAULT_BASE_URL).concat(PLAYLIST_REQUEST_PATH);
        boolean secureContent = URLUtil.isHttpsUrl((String)requestUrl);
        JSONObject requestJSON = this.buildAdRequestJSON(requestMetadata, secureContent);
        if (requestJSON == null) {
            return null;
        }
        try {
            JSONObject biddingToken = new JSONObject();
            biddingToken.put("waterfallRequest", (Object)requestJSON);
            return biddingToken.toString();
        }
        catch (Exception e) {
            logger.e("Error creating JSON bidding token", e);
            return null;
        }
    }

    private void requestPlayLists(final RequestMetadata requestMetadata, final PlayListRequestListener playListRequestListener, final int timeout) {
        boolean isEnabled = Configuration.getBoolean("com.verizon.ads.core", "sdkEnabled", true);
        ErrorInfo errorInfo = null;
        if (!isEnabled) {
            errorInfo = new ErrorInfo(VerizonSSPWaterfallProvider.class.getName(), "Verizon Ads SDK is disabled.", -3);
        } else if (requestMetadata == null) {
            errorInfo = new ErrorInfo(VerizonSSPWaterfallProvider.class.getName(), "No request metadata provided for request", -3);
        }
        if (errorInfo != null) {
            logger.e(errorInfo.toString());
            playListRequestListener.onRequestFailed(errorInfo);
            return;
        }
        ThreadUtils.runOnWorkerThread(new Runnable(){

            @Override
            public void run() {
                List waterfalls;
                HttpUtils.Response adResponse;
                if (requestMetadata == null) {
                    playListRequestListener.onRequestFailed(new ErrorInfo(WHO, "Ad session cannot be null", 5));
                    return;
                }
                String requestUrl = VerizonSSPWaterfallProvider.getWaterfallBaseUrl().concat(VerizonSSPWaterfallProvider.PLAYLIST_REQUEST_PATH);
                boolean secureContent = URLUtil.isHttpsUrl((String)requestUrl);
                String postData = VerizonSSPWaterfallProvider.this.buildAdRequest(requestMetadata, secureContent);
                if (postData == null) {
                    ErrorInfo errorInfo = new ErrorInfo(WHO, "Failed to build a playlist request object.", 5);
                    playListRequestListener.onRequestFailed(errorInfo);
                    return;
                }
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d(String.format("Request\n\turl: %s\n\tpost data: %s", requestUrl, postData));
                }
                if ((adResponse = VerizonSSPWaterfallProvider.this.requestPlaylist(requestUrl, postData, "application/json", null, timeout, playListRequestListener)) == null) {
                    return;
                }
                if (VerizonSSPWaterfallProvider.isRedirect(adResponse.content)) {
                    JSONObject playListItem = VerizonSSPWaterfallProvider.getRedirectPlayListItem(adResponse.content);
                    String contentType = "application/json";
                    try {
                        JSONObject req = playListItem.getJSONObject(VerizonSSPWaterfallProvider.REQ_KEY);
                        requestUrl = req.getString("url");
                        postData = req.getString("postBody");
                        contentType = req.getString("postType");
                    }
                    catch (Exception e) {
                        ErrorInfo errorInfo = new ErrorInfo(WHO, "Malformed playlist item for adnet: redirect.", 9);
                        logger.d(errorInfo.toString(), e);
                        playListRequestListener.onRequestFailed(errorInfo);
                        return;
                    }
                    if (TextUtils.isEmpty(requestUrl)) {
                        ErrorInfo errorInfo = new ErrorInfo(WHO, "PlayList redirect response did not contain a redirect URL", 9);
                        playListRequestListener.onRequestFailed(errorInfo);
                        return;
                    }
                    if (Logger.isLogLevelEnabled(3)) {
                        logger.d(String.format("Playlist redirect url provided = %s", requestUrl));
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("X-VAS-RESPONSE-FORMAT", "waterfall");
                    adResponse = VerizonSSPWaterfallProvider.this.requestPlaylist(requestUrl, postData, contentType, headers, timeout, playListRequestListener);
                    if (adResponse == null) {
                        return;
                    }
                }
                if ((waterfalls = VerizonSSPWaterfallProvider.this.parsePlaylists(adResponse.content, requestMetadata)).isEmpty()) {
                    ErrorInfo errorInfo = new ErrorInfo(WHO, "Playlist response did not return a valid waterfall.", 3);
                    playListRequestListener.onRequestFailed(errorInfo);
                } else {
                    playListRequestListener.onRequestSucceeded(waterfalls);
                }
            }
        });
    }

    private List<Waterfall> parsePlaylists(String content, RequestMetadata requestMetadata) {
        ArrayList<Waterfall> waterfalls = new ArrayList<Waterfall>();
        if ("[".equals(String.valueOf(content.charAt(0)))) {
            try {
                logger.d("Parsing playlist array resopnse");
                JSONArray jsonArray = new JSONArray(content);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Waterfall waterfall = VerizonSSPWaterfallProvider.parsePlayListResponse(jsonArray.getJSONObject(i), (String)requestMetadata.getPlacementData().get("impressionGroup"));
                    if (waterfall == null) continue;
                    waterfalls.add(waterfall);
                }
            }
            catch (Exception e) {
                logger.e("Unable to parse playlist array response", e);
            }
        } else {
            logger.d("Parsing single playlist resopnse");
            try {
                Waterfall waterfall = VerizonSSPWaterfallProvider.parsePlayListResponse(new JSONObject(content), (String)requestMetadata.getPlacementData().get("impressionGroup"));
                if (waterfall != null) {
                    waterfalls.add(waterfall);
                }
            }
            catch (Exception e) {
                logger.e("Unable to parse single playlist response", e);
            }
        }
        return waterfalls;
    }

    private HttpUtils.Response requestPlaylist(String requestUrl, String postData, String contentType, Map<String, String> headers, int timeout, PlayListRequestListener playListRequestListener) {
        HttpUtils.Response adResponse = HttpUtils.getContentFromPostRequest(requestUrl, postData, contentType, headers, timeout);
        if (adResponse.code != 200) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, String.format("PlayList request failed with HTTP Status: %d", adResponse.code), 2);
            playListRequestListener.onRequestFailed(errorInfo);
            return null;
        }
        if (TextUtils.isEmpty(adResponse.content)) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "PlayList request returned no content", 4);
            playListRequestListener.onRequestFailed(errorInfo);
            return null;
        }
        if (Logger.isLogLevelEnabled(3)) {
            logger.d("Response content:\n" + adResponse.content);
        }
        return adResponse;
    }

    static String getWaterfallBaseUrl() {
        return Configuration.getString(VERIZON_ADS_DOMAIN, WATERFALL_PROVIDER_BASE_URL_KEY, DEFAULT_BASE_URL);
    }

    static JSONObject getRedirectPlayListItem(String content) {
        try {
            JSONObject playListJSON = new JSONObject(content);
            JSONArray playListItemsJSON = playListJSON.getJSONArray("playlist");
            for (int i = 0; i < playListItemsJSON.length(); ++i) {
                try {
                    JSONObject playListItemJSON = playListItemsJSON.getJSONObject(i);
                    String adnet = playListItemJSON.getString("adnet");
                    if (!"redirect".equalsIgnoreCase(adnet)) continue;
                    return playListItemJSON;
                }
                catch (Exception e) {
                    logger.e("Unable to parse play list item<" + i + ">", e);
                }
            }
        }
        catch (JSONException e) {
            logger.e("Unable to parse redirect play list", e);
        }
        return null;
    }

    static boolean isRedirect(String content) {
        if (TextUtils.isEmpty(content)) {
            return false;
        }
        content = content.replaceAll("\\s+", "");
        return content.contains("\"adnet\":\"redirect\"");
    }

    JSONObject buildAppInfoJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("appId", (Object)this.getAppId());
        json.put("name", (Object)this.getApplicationName());
        json.put("ver", (Object)this.getApplicationVersion());
        return json;
    }

    JSONObject buildEnvironmentInfoJSON(boolean secureContent) throws JSONException {
        EnvironmentInfo.CameraType[] cameraTypes;
        String aaid;
        EnvironmentInfo.AdvertisingIdInfo adInfo;
        Set<Plugin> registeredPlugins;
        JSONObject json = new JSONObject();
        json.put("os", (Object)"android");
        json.put("osv", (Object)Build.VERSION.RELEASE);
        EnvironmentInfo.DeviceInfo deviceInfo = this.environmentInfo.getDeviceInfo();
        EnvironmentInfo.NetworkOperatorInfo networkOperatorInfo = this.environmentInfo.getNetworkOperatorInfo();
        VerizonSSPWaterfallProvider.putIfNotNull(json, "model", deviceInfo.getModel());
        VerizonSSPWaterfallProvider.putIfNotNull(json, "manufacturer", deviceInfo.getManufacturer());
        VerizonSSPWaterfallProvider.putIfNotNull(json, "name", deviceInfo.getName());
        VerizonSSPWaterfallProvider.putIfNotNull(json, "build", deviceInfo.getOSBuildNumber());
        JSONObject sdkInfo = new JSONObject();
        sdkInfo.put("coreVer", (Object)VASAds.getSDKInfo().version);
        String editionName = Configuration.getString(VERIZON_ADS_DOMAIN, EDITION_NAME_KEY, null);
        String editionVersion = Configuration.getString(VERIZON_ADS_DOMAIN, EDITION_VERSION_KEY, null);
        if (editionName != null && editionVersion != null) {
            sdkInfo.put("editionId", (Object)String.format("%s-%s", editionName, editionVersion));
        }
        if (!(registeredPlugins = VASAds.getRegisteredPlugins()).isEmpty()) {
            JSONObject sdkPlugins = new JSONObject();
            for (Plugin registeredPlugin : registeredPlugins) {
                JSONObject jsonRegisteredPlugin = new JSONObject();
                jsonRegisteredPlugin.put("name", (Object)registeredPlugin.getName());
                jsonRegisteredPlugin.put("version", (Object)registeredPlugin.getVersion());
                jsonRegisteredPlugin.put("author", (Object)registeredPlugin.getAuthor());
                jsonRegisteredPlugin.put("email", (Object)registeredPlugin.getEmail());
                jsonRegisteredPlugin.put("website", (Object)registeredPlugin.getWebsite());
                jsonRegisteredPlugin.put("minApiLevel", registeredPlugin.getMinApiLevel());
                jsonRegisteredPlugin.put("enabled", VASAds.isPluginEnabled(registeredPlugin.getId()));
                sdkPlugins.put(registeredPlugin.getId(), (Object)jsonRegisteredPlugin);
            }
            sdkInfo.put("sdkPlugins", (Object)sdkPlugins);
        }
        json.put("sdkInfo", (Object)sdkInfo);
        if (networkOperatorInfo != null) {
            VerizonSSPWaterfallProvider.putIfNotNull(json, "mcc", networkOperatorInfo.getMCC());
            VerizonSSPWaterfallProvider.putIfNotNull(json, "mnc", networkOperatorInfo.getMNC());
            VerizonSSPWaterfallProvider.putIfNotNull(json, "cellSignalDbm", networkOperatorInfo.getCellSignalDbm());
            VerizonSSPWaterfallProvider.putIfNotNull(json, "carrier", networkOperatorInfo.getNetworkOperatorName());
        }
        json.put("lang", (Object)deviceInfo.getLanguage());
        json.put(USER_DATA_COUNTRY_KEY, (Object)deviceInfo.getCountryCode());
        json.put("ua", (Object)deviceInfo.getUserAgent());
        if (secureContent) {
            json.put("secureContent", true);
        }
        if ((adInfo = this.environmentInfo.getAdvertisingIdInfo()) != null && (aaid = adInfo.getId()) != null) {
            json.put("ifa", (Object)aaid);
            json.put("lmt", adInfo.isLimitAdTrackingEnabled());
        }
        EnvironmentInfo.ScreenInfo screenInfo = this.environmentInfo.getDeviceInfo().getScreenInfo();
        json.put("w", screenInfo.getWidth());
        json.put("h", screenInfo.getHeight());
        json.put("screenScale", (double)screenInfo.getDensity());
        json.put("ppi", screenInfo.getDensityDpi());
        json.put("natOrient", (Object)deviceInfo.getNaturalOrientation());
        VerizonSSPWaterfallProvider.putIfNotNull(json, "storage", deviceInfo.getAvailableStorage());
        VerizonSSPWaterfallProvider.putIfNotNull(json, "vol", deviceInfo.getVolume(3));
        VerizonSSPWaterfallProvider.putIfNotNull(json, "headphones", deviceInfo.hasHeadphonesPluggedIn());
        VerizonSSPWaterfallProvider.putIfNotNull(json, "charging", deviceInfo.isCharging());
        VerizonSSPWaterfallProvider.putIfNotNull(json, "charge", deviceInfo.getBatteryLevel());
        VerizonSSPWaterfallProvider.putIfNotNull(json, "connectionType", this.getNetworkConnectionType(deviceInfo.getNetworkInfo()));
        VerizonSSPWaterfallProvider.putIfNotNull(json, "ip", deviceInfo.getIP());
        Location location = this.environmentInfo.getLocation();
        if (location != null && VASAds.isLocationEnabled()) {
            JSONObject locationJson = new JSONObject();
            locationJson.put("lat", location.getLatitude());
            locationJson.put("lon", location.getLongitude());
            locationJson.put("src", (Object)location.getProvider());
            locationJson.put("ts", location.getTime() / 1000L);
            if (location.hasAccuracy()) {
                locationJson.put("horizAcc", (double)location.getAccuracy());
            }
            if (location.hasSpeed()) {
                locationJson.put("speed", (double)location.getSpeed());
            }
            if (location.hasBearing()) {
                locationJson.put("bearing", (double)location.getBearing());
            }
            if (location.hasAltitude()) {
                locationJson.put("alt", location.getAltitude());
            }
            json.put("loc", (Object)locationJson);
        }
        JSONObject deviceFeatures = new JSONObject();
        for (EnvironmentInfo.CameraType cameraType : cameraTypes = deviceInfo.getCameras()) {
            if (cameraType == EnvironmentInfo.CameraType.FRONT) {
                deviceFeatures.put("cameraFront", (Object)"true");
                continue;
            }
            if (cameraType != EnvironmentInfo.CameraType.BACK) continue;
            deviceFeatures.put("cameraRear", (Object)"true");
        }
        VerizonSSPWaterfallProvider.putAsStringIfNotNull(deviceFeatures, "nfc", deviceInfo.hasNFC());
        VerizonSSPWaterfallProvider.putAsStringIfNotNull(deviceFeatures, "bt", deviceInfo.hasBluetooth());
        VerizonSSPWaterfallProvider.putAsStringIfNotNull(deviceFeatures, "mic", deviceInfo.hasMicrophone());
        VerizonSSPWaterfallProvider.putAsStringIfNotNull(deviceFeatures, "gps", deviceInfo.hasGPS());
        VerizonSSPWaterfallProvider.putIfTrue(json, "deviceFeatures", deviceFeatures, !VASAds.isAnonymous());
        return json;
    }

    JSONObject buildRequestInfoJSON(RequestMetadata requestMetadata) throws JSONException {
        Map<String, Object> extras;
        Map<String, Object> placementData;
        JSONObject privacyDataJSON;
        JSONObject json = new JSONObject();
        VerizonSSPWaterfallProvider.putIfNotNull(json, "gdpr", VASAds.isAnonymous());
        if (requestMetadata == null) {
            return json;
        }
        json.put(APP_DATA_COPPA_KEY, (Object)VASAds.getCoppa());
        json.put("dcn", (Object)VASAds.getSiteId());
        Map privacyData = Configuration.get("com.verizon.ads.core", "userPrivacyData", Map.class, null);
        PrivacyDataHelper privacyDataHelper = new PrivacyDataHelper(privacyData);
        JSONObject consentMapJSON = VerizonSSPWaterfallProvider.toJSONObject(privacyDataHelper.getConsentStringsMap());
        if (consentMapJSON != null && consentMapJSON.length() > 0) {
            json.put("consentstrings", (Object)consentMapJSON);
        }
        if ((privacyDataJSON = VerizonSSPWaterfallProvider.toJSONObject(privacyData)) != null && privacyDataJSON.length() > 0) {
            json.put("privacymap", (Object)privacyDataJSON);
        }
        json.put("orients", (Object)VerizonSSPWaterfallProvider.toJSONArray(requestMetadata.getSupportedOrientations()));
        Map<String, Object> appInfo = requestMetadata.getAppData();
        if (appInfo != null) {
            json.put(APP_DATA_MEDIATOR_KEY, appInfo.get(APP_DATA_MEDIATOR_KEY));
        }
        if ((placementData = requestMetadata.getPlacementData()) != null) {
            Object impressionGroup = placementData.get("impressionGroup");
            if (!TextUtils.isEmpty((String)impressionGroup)) {
                json.put("grp", impressionGroup);
            }
            json.put(PLACEMENT_DATA_REFRESH_RATE_KEY, placementData.get(PLACEMENT_DATA_REFRESH_RATE_KEY));
        }
        if ((extras = requestMetadata.getExtras()) != null) {
            Object keywords;
            JSONObject customTargetingJSON;
            Object customTargeting = extras.get("customTargeting");
            if (customTargeting instanceof Map && !((Map)customTargeting).isEmpty() && (customTargetingJSON = VerizonSSPWaterfallProvider.toJSONObject((Map)customTargeting)) != null && customTargetingJSON.length() > 0) {
                json.put("targeting", (Object)customTargetingJSON);
            }
            if ((keywords = extras.get(USER_DATA_KEYWORDS_KEY)) instanceof List && !((List)keywords).isEmpty()) {
                json.put(USER_DATA_KEYWORDS_KEY, (Object)VerizonSSPWaterfallProvider.toJSONArray((List)keywords));
            }
        }
        json.put("curOrient", (Object)this.environmentInfo.getDeviceInfo().getConfigurationOrientation());
        return json;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static JSONObject buildUserInfoJSON(RequestMetadata requestMetadata) throws JSONException {
        if (VASAds.isAnonymous() || requestMetadata == null) {
            return null;
        }
        Map<String, Object> userData = requestMetadata.getUserData();
        if (userData != null) {
            JSONObject json = new JSONObject();
            json.put(USER_DATA_AGE_KEY, userData.get(USER_DATA_AGE_KEY));
            json.put("kids", userData.get(USER_DATA_CHILDREN_KEY));
            json.put("hhi", userData.get(USER_DATA_INCOME_KEY));
            json.put("edu", userData.get(USER_DATA_EDUCATION_KEY));
            json.put("eth", userData.get(USER_DATA_ETHNICITY_KEY));
            json.put(USER_DATA_GENDER_KEY, userData.get(USER_DATA_GENDER_KEY));
            Object keywords = userData.get(USER_DATA_KEYWORDS_KEY);
            if (keywords instanceof List && !((List)keywords).isEmpty()) {
                json.put(USER_DATA_KEYWORDS_KEY, (Object)VerizonSSPWaterfallProvider.toJSONArray((List)keywords));
            }
            json.put(USER_DATA_MARITAL_STATUS_KEY, userData.get(USER_DATA_MARITAL_STATUS_KEY));
            json.put(USER_DATA_POLITICS_KEY, userData.get(USER_DATA_POLITICS_KEY));
            json.put("zip", userData.get(USER_DATA_POSTAL_CODE_KEY));
            Object dob = userData.get(USER_DATA_DOB_KEY);
            if (dob instanceof Date) {
                json.put(USER_DATA_DOB_KEY, (Object)new SimpleDateFormat("yyyyMMdd").format(dob));
            }
            json.put(USER_DATA_STATE_KEY, userData.get(USER_DATA_STATE_KEY));
            json.put(USER_DATA_COUNTRY_KEY, userData.get(USER_DATA_COUNTRY_KEY));
            json.put(USER_DATA_DMA_KEY, userData.get(USER_DATA_DMA_KEY));
            return json;
        }
        return null;
    }

    private static JSONObject buildTestingJSON(RequestMetadata requestMetadata) {
        if (requestMetadata == null) {
            return null;
        }
        Map<String, Object> extras = requestMetadata.getExtras();
        if (extras != null) {
            Object bidder = extras.get(EXTRAS_TEST_BIDDER_ID_KEY);
            Object creativeId = extras.get(EXTRAS_TEST_CREATIVE_ID_KEY);
            if (bidder != null || creativeId != null) {
                JSONObject json = new JSONObject();
                VerizonSSPWaterfallProvider.putIfNotNull(json, "bidder", bidder);
                VerizonSSPWaterfallProvider.putIfNotNull(json, "creativeId", creativeId);
                return json;
            }
        }
        return null;
    }

    String buildAdRequest(RequestMetadata requestMetadata, boolean secureContent) {
        JSONObject json = this.buildAdRequestJSON(requestMetadata, secureContent);
        if (json == null) {
            return null;
        }
        if (requestMetadata == null) {
            return json.toString();
        }
        try {
            JSONObject req = json.getJSONObject(REQ_KEY);
            Map<String, Object> placementData = requestMetadata.getPlacementData();
            if (placementData != null) {
                req.put("posType", placementData.get("type"));
                req.put("posId", placementData.get(PLACEMENT_DATA_ID_KEY));
                Object placementAdSizes = placementData.get(PLACEMENT_DATA_AD_SIZES_KEY);
                if (placementAdSizes instanceof List && !((List)placementAdSizes).isEmpty()) {
                    JSONObject adSizes = new JSONObject();
                    adSizes.put(PLACEMENT_DATA_AD_SIZES_KEY, (Object)VerizonSSPWaterfallProvider.toJSONArray((List)placementAdSizes));
                    req.put("posTypeAttrs", (Object)adSizes);
                }
                if (placementData.containsKey(PLACEMENT_DATA_NATIVE_TYPES_KEY)) {
                    JSONObject attributes = new JSONObject();
                    attributes.put("nativeType", (Object)VerizonSSPWaterfallProvider.toJSONArray((List)placementData.get(PLACEMENT_DATA_NATIVE_TYPES_KEY)));
                    req.put("posTypeAttrs", (Object)attributes);
                }
            }
            return json.toString();
        }
        catch (Exception e) {
            logger.e("Error building JSON request", e);
            return null;
        }
    }

    JSONObject buildAdRequestJSON(RequestMetadata requestMetadata, boolean secureContent) {
        try {
            JSONObject json = new JSONObject();
            json.put("ver", (Object)PLAYLIST_VERSION);
            json.put("app", (Object)this.buildAppInfoJSON());
            json.put("env", (Object)this.buildEnvironmentInfoJSON(secureContent));
            json.put(REQ_KEY, (Object)this.buildRequestInfoJSON(requestMetadata));
            json.put("user", (Object)VerizonSSPWaterfallProvider.buildUserInfoJSON(requestMetadata));
            VerizonSSPWaterfallProvider.putIfNotNull(json, "testing", VerizonSSPWaterfallProvider.buildTestingJSON(requestMetadata));
            return json;
        }
        catch (Exception e) {
            logger.e("Error creating JSON request", e);
            return null;
        }
    }

    void pingWinUrl(final String winUrl) {
        ThreadUtils.runOnWorkerThread(new Runnable(){

            @Override
            public void run() {
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d(String.format("Firing super auction win url = %s", winUrl));
                }
                HttpUtils.getContentFromGetRequest(winUrl);
            }
        });
    }

    static Waterfall parsePlayListResponse(JSONObject playListJSON, String impressionGroup) {
        try {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("playlist = \n" + playListJSON.toString(2));
            }
            VerizonSSPWaterfall playList = new VerizonSSPWaterfall();
            playList.version = playListJSON.getString("ver");
            if (!PLAYLIST_VERSION.equals(playList.version)) {
                logger.e("Playlist response does not match requested version");
                return null;
            }
            playList.handshakeId = playListJSON.optString("config", null);
            playList.responseId = VerizonSSPWaterfallProvider.getRequiredPropertyAsString(playListJSON, PLACEMENT_DATA_ID_KEY);
            playList.placementId = VerizonSSPWaterfallProvider.getRequiredPropertyAsString(playListJSON, "posId");
            playList.placementName = VerizonSSPWaterfallProvider.getRequiredPropertyAsString(playListJSON, "pos");
            playList.siteId = VerizonSSPWaterfallProvider.getRequiredPropertyAsString(playListJSON, "dcn");
            playList.impressionGroup = impressionGroup;
            if (!DO_NOT_REPORT.equals(playList.siteId)) {
                playList.enableReporting();
            } else if (Logger.isLogLevelEnabled(3)) {
                logger.d("Playlist dcn is <DoNotReport> -- reporting disabled");
            }
            JSONArray playListItemsJSON = playListJSON.getJSONArray("playlist");
            for (int i = 0; i < playListItemsJSON.length(); ++i) {
                try {
                    JSONObject playListItemJSON = playListItemsJSON.getJSONObject(i);
                    String type = playListItemJSON.getString("type");
                    Waterfall.WaterfallItem waterfallItem = VerizonSSPWaterfallProvider.create(type, playList, playListItemJSON);
                    if (waterfallItem == null) continue;
                    playList.addItem(waterfallItem);
                    continue;
                }
                catch (Exception e) {
                    logger.e("Unable to parse play list item<" + i + ">", e);
                }
            }
            return playList;
        }
        catch (JSONException e) {
            logger.e("Unable to parse play list", e);
            return null;
        }
    }

    private static Waterfall.WaterfallItem create(String type, VerizonSSPWaterfall waterfall, JSONObject jsonObject) throws JSONException {
        if (type == null || jsonObject == null) {
            logger.e("playlist item type or json was null.");
            return null;
        }
        VerizonSSPWaterfallItem waterfallItem = null;
        if (SERVER_MEDIATION.equalsIgnoreCase(type)) {
            waterfallItem = new ServerMediationWaterfallItem(waterfall.placementId, jsonObject);
        } else if ("ad_content".equalsIgnoreCase(type)) {
            waterfallItem = new AdContentWaterfallItem(waterfall.placementId, jsonObject);
        } else if (EXCHANGE.equalsIgnoreCase(type)) {
            waterfallItem = new ExchangeWaterfallItem(waterfall.placementId, jsonObject);
        } else if (SUPER_AUCTION.equalsIgnoreCase(type)) {
            waterfallItem = new SuperAuctionWaterfallItem(waterfall, jsonObject);
        }
        return waterfallItem;
    }

    private static Waterfall.WaterfallItem createFromSuperAuctionDemandSource(String demandSourceType, String placementId, JSONObject jsonObject) throws JSONException {
        if (demandSourceType == null || jsonObject == null) {
            logger.e("demand source type or json was null.");
            return null;
        }
        VerizonSSPWaterfallItem waterfallItem = null;
        if (SERVER_DEMAND.equalsIgnoreCase(demandSourceType)) {
            waterfallItem = new ServerMediationWaterfallItem(placementId, jsonObject);
        } else if ("ad_content".equalsIgnoreCase(demandSourceType)) {
            waterfallItem = new AdContentWaterfallItem(placementId, "adContent", jsonObject);
        }
        return waterfallItem;
    }

    private String getApplicationName() {
        try {
            PackageManager packageManager = this.context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(this.context.getPackageName(), 0);
            return packageManager.getApplicationLabel(appInfo).toString();
        }
        catch (Throwable e) {
            logger.e("Unable to determine package name", e);
            return null;
        }
    }

    private String getApplicationVersion() {
        try {
            PackageManager packageManager = this.context.getPackageManager();
            PackageInfo info = packageManager.getPackageInfo(this.context.getPackageName(), 0);
            if (info != null && info.versionName != null) {
                return info.versionName;
            }
        }
        catch (Throwable e) {
            logger.e("Unable to determine application version", e);
        }
        return "unknown";
    }

    private String getAppId() {
        return this.context.getPackageName();
    }

    private static void putIfNotNull(JSONObject jsonObject, String key, Object value) {
        if (key == null) {
            logger.e("Unable to put value, specified key is null");
            return;
        }
        if (value == null) {
            return;
        }
        try {
            jsonObject.put(key, value);
        }
        catch (Exception e) {
            logger.e("Error adding " + key + ":" + value + " to JSON", e);
        }
    }

    public static JSONArray toJSONArray(Collection objects) {
        if (objects == null) {
            return null;
        }
        JSONArray json = new JSONArray();
        for (Object entry : objects) {
            json.put(VerizonSSPWaterfallProvider.buildFromObject(entry));
        }
        return json;
    }

    public static JSONObject toJSONObject(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                json.put(entry.getKey().toString(), VerizonSSPWaterfallProvider.buildFromObject(entry.getValue()));
            }
        }
        catch (Exception e) {
            logger.e("Error building JSON from Map", e);
        }
        return json;
    }

    public static Object buildFromObject(Object value) {
        if (value instanceof Map) {
            return VerizonSSPWaterfallProvider.toJSONObject((Map)value);
        }
        if (value instanceof List) {
            return VerizonSSPWaterfallProvider.toJSONArray((List)value);
        }
        return value;
    }

    public static String getRequiredPropertyAsString(JSONObject jsonObject, String name) throws JSONException {
        if (jsonObject == null) {
            throw new JSONException("The passed jsonObject is null.");
        }
        String value = jsonObject.getString(name);
        if (TextUtils.isEmpty(value)) {
            throw new JSONException("The value for key '" + name + "' is null or empty.");
        }
        return value;
    }

    public static void putIfTrue(JSONObject jsonObject, String key, Object value, Boolean inject) {
        if (Boolean.TRUE.equals(inject)) {
            VerizonSSPWaterfallProvider.putIfNotNull(jsonObject, key, value);
        }
    }

    public static void putAsStringIfNotNull(JSONObject jsonObject, String key, Object value) {
        if (value == null) {
            return;
        }
        VerizonSSPWaterfallProvider.putIfNotNull(jsonObject, key, String.valueOf(value));
    }

    private String getNetworkConnectionType(NetworkInfo networkInfo) {
        String connectionType;
        if (networkInfo == null) {
            connectionType = null;
        } else if (networkInfo.isConnected()) {
            int type = networkInfo.getType();
            if (type == 1) {
                connectionType = "wifi";
            } else if (type == 0) {
                switch (networkInfo.getSubtype()) {
                    case 7: {
                        connectionType = "1xrtt";
                        break;
                    }
                    case 4: {
                        connectionType = "cdma";
                        break;
                    }
                    case 2: {
                        connectionType = "edge";
                        break;
                    }
                    case 14: {
                        connectionType = "ehrpd";
                        break;
                    }
                    case 5: {
                        connectionType = "evdo_0";
                        break;
                    }
                    case 6: {
                        connectionType = "evdo_a";
                        break;
                    }
                    case 12: {
                        connectionType = "evdo_b";
                        break;
                    }
                    case 1: {
                        connectionType = "gprs";
                        break;
                    }
                    case 8: {
                        connectionType = "hsdpa";
                        break;
                    }
                    case 10: {
                        connectionType = "hspa";
                        break;
                    }
                    case 15: {
                        connectionType = "hspap";
                        break;
                    }
                    case 9: {
                        connectionType = "hsupa";
                        break;
                    }
                    case 11: {
                        connectionType = "iden";
                        break;
                    }
                    case 13: {
                        connectionType = "lte";
                        break;
                    }
                    case 3: {
                        connectionType = "umts";
                        break;
                    }
                    default: {
                        connectionType = "unknown";
                        break;
                    }
                }
            } else {
                connectionType = "unknown";
            }
        } else {
            connectionType = "offline";
        }
        return connectionType;
    }

    private static ErrorInfo createErrorInfoFromResponseCode(HttpUtils.Response response) {
        switch (response.code) {
            case 408: 
            case 504: {
                return new ErrorInfo(WHO, "Timeout occurred retrieving ad content", -2);
            }
            case 200: {
                return new ErrorInfo(WHO, "Empty content returned when retrieving ad content", -3);
            }
        }
        return new ErrorInfo(WHO, String.format("HTTP error code %d retrieving ad content", response.code), -3);
    }

    @Override
    public void release() {
    }

    public static class VerizonSSPBid
    extends Bid {
        public final VerizonSSPWaterfall waterfall;
        public final JSONArray demandSources;
        public final JSONObject bidderItem;
        public final String winUrl;
        public final long bidCreationTime;
        public final String itemId;
        public Map<String, Integer> adSize;

        VerizonSSPBid(AdSession adSession, VerizonSSPWaterfall waterfall, JSONArray demandSources, JSONObject bidderItem, String bidPrice, String winUrl, long bidCreationTime, String itemId, Map<String, Integer> adSize) {
            super(adSession, bidPrice);
            this.waterfall = waterfall;
            this.demandSources = demandSources;
            this.bidderItem = bidderItem;
            this.winUrl = winUrl;
            this.bidCreationTime = bidCreationTime;
            this.itemId = itemId;
            this.adSize = adSize;
        }

        @NonNull
        public String toString() {
            return String.format("VerizonSSPBid{waterfall: %s, demandSources: %s, bidderItem: %s, winUrl: %s, bidCreationTime: %d, itemId: %s, adSize: %s}", this.waterfall, this.demandSources, this.bidderItem, this.winUrl, this.bidCreationTime, this.itemId, this.adSize);
        }
    }

    static class SuperAuctionWaterfallItem
    extends VerizonSSPWaterfallItem {
        final VerizonSSPWaterfall waterfall;
        final JSONArray demandSources;
        final JSONArray bidderItems;
        JSONObject bidderItem;
        String bidPrice;
        String winUrl;

        SuperAuctionWaterfallItem(VerizonSSPWaterfall waterfall, JSONObject jsonObject) throws JSONException {
            super(waterfall.placementId, jsonObject);
            this.waterfall = waterfall;
            this.demandSources = jsonObject.getJSONArray("demandSources");
            this.bidderItems = jsonObject.getJSONArray("bidders");
            for (int i = 0; i < this.bidderItems.length(); ++i) {
                JSONObject bidderObject = this.bidderItems.getJSONObject(i);
                if (!bidderObject.getString("type").equals("server_bid") || this.demandSources == null || this.demandSources.length() <= 0) continue;
                this.bidderItem = bidderObject;
                break;
            }
            if (this.bidderItem != null) {
                this.bidPrice = this.bidderItem.optString("bidPrice");
                this.winUrl = this.bidderItem.optString("winUrl");
            }
        }

        @Override
        @NonNull
        public String toString() {
            return String.format("SuperAuctionWaterfallItem{bidPrice: %s, winUrl: %s, demandSources: %s, bidderItems: %s, bidderItem: %s, %s}", this.bidPrice, this.winUrl, this.demandSources, this.bidderItems, this.bidderItem, super.toString());
        }

        @Override
        public Waterfall.WaterfallItem.FetchResult fetch(AdSession adSession) {
            return null;
        }

        Bid getBid(AdSession adSession) {
            if (adSession == null) {
                logger.e("Ad session cannot be null");
                return null;
            }
            if (this.demandSources == null || this.demandSources.length() == 0) {
                logger.e("Bid response is missing demand sources");
                return null;
            }
            if (this.bidderItem == null) {
                logger.e("Bid response is missing bidder item");
                return null;
            }
            if (TextUtils.isEmpty(this.bidPrice)) {
                logger.e("Bid response is missing a bid price");
                return null;
            }
            return new VerizonSSPBid(adSession, this.waterfall, this.demandSources, this.bidderItem, this.bidPrice, this.winUrl, System.currentTimeMillis(), this.itemId, this.adSize);
        }
    }

    static class ExchangeWaterfallItem
    extends VerizonSSPWaterfallItem {
        final String url;
        final String postBody;
        final String postContentType;

        ExchangeWaterfallItem(String placementId, JSONObject jsonObject) throws JSONException, IllegalArgumentException {
            super(placementId, jsonObject);
            JSONObject requestInfo = jsonObject.getJSONObject(VerizonSSPWaterfallProvider.REQ_KEY);
            this.url = requestInfo.getString("url");
            this.postBody = requestInfo.optString("postBody", null);
            this.postContentType = requestInfo.optString("postType", null);
        }

        @Override
        @NonNull
        public String toString() {
            return String.format("ExchangeWaterfallItem{url: %s, postContentType: %s, %s}", this.url, this.postContentType, super.toString());
        }

        @Override
        public Waterfall.WaterfallItem.FetchResult fetch(AdSession adSession) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Processing exchange mediation playlist item ID: " + this.itemId);
            }
            if (adSession == null) {
                logger.e("Ad session cannot be null");
                return new Waterfall.WaterfallItem.FetchResult(new ErrorInfo(WHO, "Ad Session cannot be null", -3));
            }
            int exchangeTimeout = Configuration.getInt(VerizonSSPWaterfallProvider.VERIZON_SSP_DOMAIN, VerizonSSPWaterfallProvider.EXCHANGE_TIMEOUT_KEY, 10000);
            HttpUtils.Response response = !TextUtils.isEmpty(this.postBody) ? HttpUtils.getContentFromPostRequest(this.url, this.postBody, this.postContentType, exchangeTimeout) : HttpUtils.getContentFromPostRequest(this.url, exchangeTimeout);
            if (response.code != 200) {
                logger.e("Unable to retrieve content for exchange mediation playlist item, placement ID <" + this.placementId + ">");
                return new Waterfall.WaterfallItem.FetchResult(VerizonSSPWaterfallProvider.createErrorInfoFromResponseCode(response));
            }
            if (TextUtils.isEmpty(response.content)) {
                logger.e("Ad content is empty for exchange mediation playlist item, placement ID <" + this.placementId + ">");
                return new Waterfall.WaterfallItem.FetchResult(new ErrorInfo(WHO, "No ad response", -1));
            }
            try {
                JSONObject exchangeResponseJSON = new JSONObject(response.content);
                String ad = exchangeResponseJSON.getString("ad");
                this.buyer = exchangeResponseJSON.optString("ad_buyer", null);
                this.pru = exchangeResponseJSON.optString("ad_pru", null);
                String creativeId = exchangeResponseJSON.optString("ad_crid", null);
                String demandSource = exchangeResponseJSON.optString("ad_bidder_id", null);
                CreativeInfo creativeInfo = new CreativeInfo(creativeId, demandSource);
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d("Exchange waterfall item creative info: " + creativeInfo);
                }
                HashMap<String, Object> metadata = new HashMap<String, Object>();
                if (response.adMetadata != null) {
                    metadata.put(VerizonSSPWaterfallProvider.RESPONSE_HEADERS_KEY, response.adMetadata);
                }
                metadata.put(VerizonSSPWaterfallProvider.CREATIVE_INFO_KEY, creativeInfo);
                if (this.adSize != null) {
                    metadata.put(VerizonSSPWaterfallProvider.AD_SIZE_KEY, this.adSize);
                }
                AdContent adContent = new AdContent(ad, metadata);
                return new Waterfall.WaterfallItem.FetchResult(adContent);
            }
            catch (JSONException e) {
                logger.e("Error occurred when trying to parse ad content from exchange response", e);
                return new Waterfall.WaterfallItem.FetchResult(new ErrorInfo(WHO, "Error parsing ad content", -3));
            }
        }
    }

    static class AdContentWaterfallItem
    extends VerizonSSPWaterfallItem {
        final String value;
        final String creativeId;
        final String adnet;

        AdContentWaterfallItem(String placementId, JSONObject jsonObject) throws JSONException, IllegalArgumentException {
            this(placementId, "value", jsonObject);
        }

        AdContentWaterfallItem(String placementId, String valuePropertyName, JSONObject jsonObject) throws JSONException, IllegalArgumentException {
            super(placementId, jsonObject);
            this.value = jsonObject.getString(valuePropertyName);
            this.creativeId = jsonObject.optString("creativeid", null);
            this.adnet = jsonObject.optString("adnet", null);
        }

        @Override
        @NonNull
        public String toString() {
            return String.format("AdContentWaterfallItem{creativeId: %s, adnet: %s, %s}", this.creativeId, this.adnet, super.toString());
        }

        @Override
        public Waterfall.WaterfallItem.FetchResult fetch(AdSession adSession) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Processing ad content playlist item ID: " + this.itemId);
            }
            if (adSession == null) {
                logger.e("Ad session cannot be null");
                return new Waterfall.WaterfallItem.FetchResult(new ErrorInfo(WHO, "Ad Session cannot be null", -3));
            }
            if (TextUtils.isEmpty(this.value)) {
                return new Waterfall.WaterfallItem.FetchResult(new ErrorInfo(WHO, "Ad content is empty", -3));
            }
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("creativeid", this.creativeId);
            metadata.put("adnet", this.adnet);
            if (this.adSize != null) {
                metadata.put(VerizonSSPWaterfallProvider.AD_SIZE_KEY, this.adSize);
            }
            if (this.creativeInfo != null) {
                metadata.put(VerizonSSPWaterfallProvider.CREATIVE_INFO_KEY, this.creativeInfo);
            }
            return new Waterfall.WaterfallItem.FetchResult(new AdContent(this.value, metadata));
        }
    }

    static class ServerMediationWaterfallItem
    extends VerizonSSPWaterfallItem {
        final String url;
        final String validateRegex;
        final String postBody;
        final String postContentType;
        final String cridHeaderField;
        final String adnet;

        ServerMediationWaterfallItem(String placementId, JSONObject jsonObject) throws JSONException, IllegalArgumentException {
            super(placementId, jsonObject);
            JSONObject requestInfo = jsonObject.getJSONObject(VerizonSSPWaterfallProvider.REQ_KEY);
            this.url = requestInfo.getString("url");
            this.validateRegex = requestInfo.optString("validRegex", null);
            this.postBody = requestInfo.optString("postBody", null);
            this.postContentType = requestInfo.optString("postType", null);
            this.cridHeaderField = jsonObject.optString("cridHeaderField", null);
            this.adnet = jsonObject.optString("adnet", null);
        }

        @Override
        @NonNull
        public String toString() {
            return String.format("ServerMediationWaterfallItem{url: %s, validateRegEx: %s, postContentType: %s, cridHeaderField: %s, adNet: %s, %s}", this.url, this.validateRegex, this.postContentType, this.cridHeaderField, this.adnet, super.toString());
        }

        @Override
        public Waterfall.WaterfallItem.FetchResult fetch(AdSession adSession) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Processing server mediation playlist item ID: " + this.itemId);
            }
            if (adSession == null) {
                logger.e("Ad session cannot be null");
                return new Waterfall.WaterfallItem.FetchResult(new ErrorInfo(WHO, "Ad Session cannot be null", -3));
            }
            int serverToServerTimeout = Configuration.getInt(VerizonSSPWaterfallProvider.VERIZON_SSP_DOMAIN, VerizonSSPWaterfallProvider.S2S_TIMEOUT_KEY, 10000);
            HttpUtils.Response response = !TextUtils.isEmpty(this.postBody) ? HttpUtils.getContentFromPostRequest(this.url, this.postBody, this.postContentType, serverToServerTimeout) : HttpUtils.getContentFromPostRequest(this.url, serverToServerTimeout);
            if (response.code != 200) {
                logger.e("Unable to retrieve content for server mediation playlist item, placement ID <" + this.placementId + ">");
                return new Waterfall.WaterfallItem.FetchResult(VerizonSSPWaterfallProvider.createErrorInfoFromResponseCode(response));
            }
            if (TextUtils.isEmpty(response.content)) {
                logger.e("Ad content is empty for server mediation playlist item, placement ID <" + this.placementId + ">");
                return new Waterfall.WaterfallItem.FetchResult(new ErrorInfo(WHO, "Ad content is empty", -1));
            }
            if (!TextUtils.isEmpty(this.validateRegex) && response.content.matches("(?s)" + this.validateRegex)) {
                logger.e("Unable to validate content for server mediation playlist item due to \"no ad\" response for placement ID <" + this.placementId + "> and content <" + response.content + ">");
                return new Waterfall.WaterfallItem.FetchResult(new ErrorInfo(WHO, "No ad response", -1));
            }
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            if (response.adMetadata != null) {
                metadata.put(VerizonSSPWaterfallProvider.RESPONSE_HEADERS_KEY, response.adMetadata);
            }
            if (!TextUtils.isEmpty(this.cridHeaderField)) {
                metadata.put(VerizonSSPWaterfallProvider.CREATIVE_ID_HEADER, this.cridHeaderField);
            }
            if (this.adSize != null) {
                metadata.put(VerizonSSPWaterfallProvider.AD_SIZE_KEY, this.adSize);
            }
            if (this.creativeInfo != null) {
                metadata.put(VerizonSSPWaterfallProvider.CREATIVE_INFO_KEY, this.creativeInfo);
            }
            if (metadata.isEmpty()) {
                metadata = null;
            }
            return new Waterfall.WaterfallItem.FetchResult(new AdContent(response.content, metadata));
        }
    }

    static abstract class VerizonSSPWaterfallItem
    implements Waterfall.WaterfallItem {
        static final String ITEM_KEY = "item";
        static final String ENHANCED_AD_CONTROL_KEY = "enableEnhancedAdControl";
        final String itemId;
        final String placementId;
        final boolean enhancedAdControlEnabled;
        String buyer;
        String pru;
        Map<String, Integer> adSize;
        CreativeInfo creativeInfo;

        VerizonSSPWaterfallItem(String placementId, JSONObject jsonObject) throws JSONException, IllegalArgumentException {
            JSONObject adSizeJSONObject;
            JSONObject adMetaDataJSONObject;
            this.placementId = placementId;
            if (jsonObject == null) {
                throw new IllegalArgumentException("jsonObject cannot be null.");
            }
            this.itemId = jsonObject.getString(ITEM_KEY);
            this.enhancedAdControlEnabled = jsonObject.optBoolean(ENHANCED_AD_CONTROL_KEY, false);
            this.buyer = jsonObject.optString(VerizonSSPWaterfallProvider.METADATA_KEY_BUYER, null);
            this.pru = jsonObject.optString("price", null);
            String creativeId = jsonObject.optString("ad_crid", null);
            String demandSource = jsonObject.optString("ad_bidder_id", null);
            if (!TextUtils.isEmpty(creativeId) || !TextUtils.isEmpty(demandSource)) {
                this.creativeInfo = new CreativeInfo(creativeId, demandSource);
            }
            if ((adMetaDataJSONObject = jsonObject.optJSONObject("adMetaData")) != null && (adSizeJSONObject = adMetaDataJSONObject.optJSONObject("adSize")) != null) {
                this.adSize = new HashMap<String, Integer>();
                try {
                    this.adSize.put("w", adSizeJSONObject.getInt("w"));
                    this.adSize.put("h", adSizeJSONObject.getInt("h"));
                }
                catch (JSONException e) {
                    logger.w("Error occurred when trying to parse ad size from response", e);
                    this.adSize = null;
                }
            }
        }

        VerizonSSPWaterfallItem(String placementId, String itemId) {
            this.placementId = placementId;
            this.itemId = itemId;
            this.enhancedAdControlEnabled = false;
        }

        @NonNull
        public String toString() {
            return String.format("placementId: %s, itemId: %s, enhancedAdControlEnabled: %s, buyer: %s, pru: %s, creativeInfo: %s", this.placementId, this.itemId, this.enhancedAdControlEnabled, this.buyer, this.pru, this.creativeInfo);
        }

        @Override
        public Map<String, Object> getMetadata() {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put(VerizonSSPWaterfallProvider.METADATA_KEY_ITEM_ID, this.itemId);
            if (this.buyer != null) {
                metadata.put(VerizonSSPWaterfallProvider.METADATA_KEY_BUYER, this.buyer);
            }
            if (this.pru != null) {
                metadata.put(VerizonSSPWaterfallProvider.METADATA_KEY_PRU, this.pru);
            }
            return metadata;
        }
    }

    static class VerizonSSPWaterfall
    implements Waterfall {
        private static final Logger logger = Logger.getInstance(VerizonSSPWaterfall.class);
        String version;
        String handshakeId;
        String responseId;
        String placementId;
        String placementName;
        String impressionGroup;
        String siteId;
        boolean reportingEnabled = false;
        List<Waterfall.WaterfallItem> waterfallItems = new ArrayList<Waterfall.WaterfallItem>();

        VerizonSSPWaterfall() {
        }

        @NonNull
        public String toString() {
            return String.format("VerizonSSPWaterfall{version: %s, handshakeId: %s, responseId: %s, placementId: %s, placementName: %s, impressionGroup: %s, siteId: %s, reportingEnabled: %s, waterfallItems: %s}", this.version, this.handshakeId, this.responseId, this.placementId, this.placementName, this.impressionGroup, this.siteId, this.reportingEnabled, this.waterfallItems);
        }

        void addItem(Waterfall.WaterfallItem waterfallItem) {
            if (waterfallItem == null) {
                return;
            }
            this.waterfallItems.add(waterfallItem);
        }

        public void enableReporting() {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Enabling reporting for placement id <%s> and playlist <%s>.", this.placementId, this));
            }
            this.reportingEnabled = true;
        }

        @Override
        public Waterfall.WaterfallItem[] getWaterfallItems() {
            return this.waterfallItems.toArray(new Waterfall.WaterfallItem[0]);
        }

        @Override
        public Map<String, Object> getMetadata() {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put(VerizonSSPWaterfallProvider.METADATA_KEY_RESPONSE_ID, this.responseId);
            metadata.put(VerizonSSPWaterfallProvider.METADATA_KEY_PLACEMENT_NAME, this.placementName);
            metadata.put(VerizonSSPWaterfallProvider.METADATA_KEY_REPORTING_ENABLED, this.reportingEnabled);
            if (this.impressionGroup != null) {
                metadata.put("impressionGroup", this.impressionGroup);
            }
            return metadata;
        }
    }

    private static class PlayListRequestListener {
        final BidRequestListener bidRequestListener;
        final WaterfallProvider.WaterfallListener waterfallListener;
        final RequestMetadata requestMetadata;

        PlayListRequestListener(WaterfallProvider.WaterfallListener waterfallListener, RequestMetadata requestMetadata) {
            this(null, waterfallListener, requestMetadata);
        }

        PlayListRequestListener(BidRequestListener bidRequestListener, RequestMetadata requestMetadata) {
            this(bidRequestListener, null, requestMetadata);
        }

        PlayListRequestListener(BidRequestListener bidRequestListener, WaterfallProvider.WaterfallListener waterfallListener, RequestMetadata requestMetadata) {
            this.bidRequestListener = bidRequestListener;
            this.waterfallListener = waterfallListener;
            this.requestMetadata = requestMetadata;
        }

        void onRequestFailed(ErrorInfo errorInfo) {
            if (this.waterfallListener != null) {
                this.waterfallListener.onAdSessionsReceived(null, errorInfo);
            } else if (this.bidRequestListener != null) {
                this.bidRequestListener.onComplete(null, errorInfo);
            }
        }

        void onRequestSucceeded(List<Waterfall> waterfalls) {
            if (this.waterfallListener != null) {
                ArrayList<AdSession> adSessions = new ArrayList<AdSession>();
                for (Waterfall waterfall : waterfalls) {
                    AdSession multiWaterfallAdSession = new AdSession();
                    multiWaterfallAdSession.put("request.requestMetadata", (Object)this.requestMetadata);
                    multiWaterfallAdSession.put("response.waterfall", (Object)waterfall);
                    adSessions.add(multiWaterfallAdSession);
                }
                this.waterfallListener.onAdSessionsReceived(adSessions, null);
            } else if (this.bidRequestListener != null) {
                Waterfall waterfall = waterfalls.get(0);
                for (Waterfall.WaterfallItem waterfallItem : waterfall.getWaterfallItems()) {
                    if (!(waterfallItem instanceof SuperAuctionWaterfallItem)) continue;
                    SuperAuctionWaterfallItem superAuctionWaterfallItem = (SuperAuctionWaterfallItem)waterfallItem;
                    AdSession adSession = new AdSession();
                    adSession.put("request.requestMetadata", (Object)this.requestMetadata);
                    Bid bid = superAuctionWaterfallItem.getBid(adSession);
                    if (bid == null) {
                        WaterfallResult waterfallResult = new WaterfallResult(waterfall, null);
                        waterfallResult.startWaterfallItem(waterfallItem);
                        waterfallResult.setResult(new ErrorInfo(WHO, "Server response contained no bids.", 110));
                        this.bidRequestListener.onComplete(null, new ErrorInfo(WHO, "Server response contained no bids.", 7));
                    } else {
                        this.bidRequestListener.onComplete(bid, null);
                    }
                    return;
                }
                this.bidRequestListener.onComplete(null, new ErrorInfo(WHO, "Server response contained no bids.", 7));
            }
        }
    }

    public static class Factory
    implements ComponentFactory {
        @Override
        public Component newInstance(Context context, JSONObject jsonObject, Object ... objects) {
            return new VerizonSSPWaterfallProvider(context);
        }
    }
}

