/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.content.Context;
import android.content.MutableContextWrapper;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.AbsSavedState;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.ToggleButton;
import com.verizon.ads.Logger;
import com.verizon.ads.R;
import com.verizon.ads.VideoPlayer;
import com.verizon.ads.utils.ThreadUtils;

public class VideoPlayerView
extends FrameLayout {
    private static final Logger logger = Logger.getInstance(VideoPlayerView.class);
    private static final String NAMESPACE = "http://verizon.com/ads";
    private RelativeLayout relativeLayout;
    private Button replayButton;
    private Button playButton;
    private ToggleButton muteToggleButton;
    private boolean isReplayButtonEnabled = false;
    private boolean isPlayButtonEnabled = false;
    private boolean isMuteToggleEnabled = false;
    private VideoPlayer videoPlayer;
    private SurfaceView surfaceView;

    public VideoPlayerView(Context context) {
        this(context, null, 0);
    }

    public VideoPlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super((Context)new MutableContextWrapper(context), attrs, defStyleAttr);
        if (attrs != null) {
            this.isMuteToggleEnabled = attrs.getAttributeBooleanValue(NAMESPACE, "muteToggleEnabled", false);
            this.isPlayButtonEnabled = attrs.getAttributeBooleanValue(NAMESPACE, "playButtonEnabled", false);
            this.isReplayButtonEnabled = attrs.getAttributeBooleanValue(NAMESPACE, "replayButtonEnabled", false);
        }
        this.setBackgroundColor(this.getResources().getColor(17170444));
        MutableContextWrapper mutableContext = (MutableContextWrapper)this.getContext();
        this.relativeLayout = new RelativeLayout((Context)mutableContext);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.addView((View)this.relativeLayout, (ViewGroup.LayoutParams)layoutParams);
        this.surfaceView = new VideoSurfaceView((Context)mutableContext);
        this.surfaceView.getHolder().setType(3);
        RelativeLayout.LayoutParams surfaceLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        surfaceLayoutParams.addRule(13);
        this.relativeLayout.addView((View)this.surfaceView, (ViewGroup.LayoutParams)surfaceLayoutParams);
    }

    public void bindPlayer(VideoPlayer videoPlayer) {
        this.videoPlayer = videoPlayer;
        this.videoPlayer.setSurfaceView(this.surfaceView);
        this.setupVideoControls();
        videoPlayer.registerListener(new VideoPlayer.VideoPlayerListener(){

            @Override
            public void onLoaded(VideoPlayer videoPlayer) {
            }

            @Override
            public void onUnloaded(VideoPlayer videoPlayer) {
            }

            @Override
            public void onReady(VideoPlayer videoPlayer) {
            }

            @Override
            public void onPlay(VideoPlayer videoPlayer) {
                ThreadUtils.postOnUiThread(() -> VideoPlayerView.this.updateMuteToggleVisibility());
                ThreadUtils.postOnUiThread(() -> VideoPlayerView.this.updateReplayVisibility());
                ThreadUtils.postOnUiThread(() -> VideoPlayerView.this.updatePlayVisibility());
            }

            @Override
            public void onPaused(VideoPlayer videoPlayer) {
            }

            @Override
            public void onComplete(VideoPlayer videoPlayer) {
                ThreadUtils.postOnUiThread(() -> VideoPlayerView.this.updateReplayVisibility());
            }

            @Override
            public void onProgress(VideoPlayer videoPlayer, int i) {
            }

            @Override
            public void onSeekCompleted(VideoPlayer videoPlayer) {
            }

            @Override
            public void onError(VideoPlayer videoPlayer) {
            }

            @Override
            public void onVolumeChanged(VideoPlayer videoPlayer, float volume) {
                ThreadUtils.postOnUiThread(() -> {
                    if (VideoPlayerView.this.muteToggleButton != null) {
                        VideoPlayerView.this.muteToggleButton.setChecked(volume > 0.0f);
                    }
                });
            }

            @Override
            public void onClick(VideoPlayer videoPlayer) {
            }

            @Override
            public void onVideoSizeChanged(int width, int height) {
                ThreadUtils.postOnUiThread(() -> VideoPlayerView.this.requestLayout());
            }
        });
    }

    public VideoPlayer getVideoPlayer() {
        return this.videoPlayer;
    }

    void setupVideoControls() {
        Context context = this.getContext();
        this.muteToggleButton = new ToggleButton(context);
        this.muteToggleButton.setText((CharSequence)"");
        this.muteToggleButton.setTextOff((CharSequence)"");
        this.muteToggleButton.setTextOn((CharSequence)"");
        this.muteToggleButton.setTag((Object)"MUTE_UNMUTE_TOGGLE");
        this.muteToggleButton.setBackgroundResource(R.drawable.verizon_ads_sdk_mute_toggle);
        this.muteToggleButton.setOnCheckedChangeListener((buttonView, isChecked) -> this.videoPlayer.setVolume(isChecked ? 1.0f : 0.0f));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_mute_width), (int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_mute_width));
        layoutParams.addRule(12);
        layoutParams.addRule(11);
        this.relativeLayout.addView((View)this.muteToggleButton, (ViewGroup.LayoutParams)layoutParams);
        this.replayButton = new Button(context);
        this.replayButton.setTag((Object)"REPLAY_BUTTON");
        this.replayButton.setBackgroundResource(R.drawable.verizon_ads_sdk_replay);
        this.replayButton.setOnClickListener(v -> this.videoPlayer.replay());
        layoutParams = new RelativeLayout.LayoutParams((int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width), (int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width));
        layoutParams.addRule(13);
        this.relativeLayout.addView((View)this.replayButton, (ViewGroup.LayoutParams)layoutParams);
        this.playButton = new Button(context);
        this.playButton.setTag((Object)"PLAY_BUTTON");
        this.playButton.setBackgroundResource(R.drawable.verizon_ads_sdk_play);
        this.playButton.setOnClickListener(v -> this.videoPlayer.play());
        layoutParams = new RelativeLayout.LayoutParams((int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width), (int)context.getResources().getDimension(R.dimen.verizon_ads_sdk_replay_width));
        layoutParams.addRule(13);
        this.relativeLayout.addView((View)this.playButton, (ViewGroup.LayoutParams)layoutParams);
        this.updateReplayVisibility();
        this.updateMuteToggleVisibility();
        this.updatePlayVisibility();
    }

    protected Parcelable onSaveInstanceState() {
        if (this.videoPlayer == null) {
            logger.d("A VideoPlayer instance has not been bound.");
            return null;
        }
        return this.videoPlayer.saveInstanceState(super.onSaveInstanceState());
    }

    protected void onRestoreInstanceState(Parcelable state) {
        AbsSavedState absSavedState = (AbsSavedState)state;
        super.onRestoreInstanceState(absSavedState.getSuperState());
        if (this.videoPlayer == null) {
            logger.d("A VideoPlayer instance has not been bound.");
            return;
        }
        this.videoPlayer.restoreInstanceState(absSavedState);
    }

    public void setMuteToggleEnabled(boolean isMuteToggleEnabled) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setMuteToggleEnabled must be called from UI thread.");
            return;
        }
        this.isMuteToggleEnabled = isMuteToggleEnabled;
        this.updateMuteToggleVisibility();
    }

    private void updateMuteToggleVisibility() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("updateMuteToggleVisibility must be called from UI thread.");
            return;
        }
        if (this.muteToggleButton != null) {
            if (this.isMuteToggleEnabled) {
                this.muteToggleButton.setVisibility(0);
            } else {
                this.muteToggleButton.setVisibility(8);
            }
        }
    }

    public void setReplayButtonEnabled(boolean isReplayButtonEnabled) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setReplayButtonEnabled must be called from UI thread.");
            return;
        }
        this.isReplayButtonEnabled = isReplayButtonEnabled;
        this.updateReplayVisibility();
    }

    private void updateReplayVisibility() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("updateReplayVisibility must be called from UI thread.");
            return;
        }
        if (this.videoPlayer == null) {
            logger.d("A VideoPlayer instance has not been bound.");
            return;
        }
        if (this.replayButton != null) {
            int currentState = this.videoPlayer.getState();
            if (this.isReplayButtonEnabled && currentState == 6) {
                this.replayButton.setVisibility(0);
            } else {
                this.replayButton.setVisibility(8);
            }
        }
    }

    public void setPlayButtonEnabled(boolean isPlayButtonEnabled) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("setPlayButtonEnabled must be called from UI thread.");
            return;
        }
        this.isPlayButtonEnabled = isPlayButtonEnabled;
        this.updatePlayVisibility();
    }

    private void updatePlayVisibility() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            logger.e("updatePlayVisibility must be called from UI thread.");
            return;
        }
        if (this.videoPlayer == null) {
            logger.d("A VideoPlayer instance has not been bound.");
            return;
        }
        if (this.playButton != null) {
            int currentState = this.videoPlayer.getState();
            if (this.isPlayButtonEnabled && currentState != 4 && currentState != 6) {
                this.playButton.setVisibility(0);
            } else {
                this.playButton.setVisibility(8);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.videoPlayer == null) {
            logger.d("A VideoPlayer instance has not been bound.");
            return;
        }
        this.videoPlayer.setAudioFocus();
    }

    protected void onDetachedFromWindow() {
        if (this.videoPlayer != null) {
            this.videoPlayer.releaseAudioFocus();
        } else {
            logger.d("A VideoPlayer instance has not been bound.");
        }
        super.onDetachedFromWindow();
    }

    private class VideoSurfaceView
    extends SurfaceView {
        VideoSurfaceView(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int videoHeight = VideoPlayerView.this.videoPlayer.getVideoHeight();
            int videoWidth = VideoPlayerView.this.videoPlayer.getVideoWidth();
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            logger.d("widthSize = " + widthSize + ", heightSize = " + heightSize);
            int width = VideoSurfaceView.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
            int height = VideoSurfaceView.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
            if (videoWidth > 0 && videoHeight > 0) {
                int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                    height = heightSpecSize;
                    width = widthSpecSize;
                    if (videoWidth * height < width * videoHeight) {
                        width = height * videoWidth / videoHeight;
                    } else if (videoWidth * height > width * videoHeight) {
                        height = width * videoHeight / videoWidth;
                    }
                } else if (widthSpecMode == 0x40000000) {
                    width = widthSpecSize;
                    height = width * videoHeight / videoWidth;
                    if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                        height = heightSpecSize;
                    }
                } else if (heightSpecMode == 0x40000000) {
                    height = heightSpecSize;
                    width = height * videoWidth / videoHeight;
                    if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                        width = widthSpecSize;
                    }
                } else {
                    int scaledHeight;
                    int scaledWidth;
                    width = videoWidth;
                    height = videoHeight;
                    if (heightSpecMode == Integer.MIN_VALUE && height < heightSpecSize && (scaledWidth = heightSpecSize * videoWidth / videoHeight) <= widthSpecSize) {
                        height = heightSpecSize;
                        width = scaledWidth;
                    }
                    if (widthSpecMode == Integer.MIN_VALUE && width < widthSpecSize && (scaledHeight = widthSpecSize * videoHeight / videoWidth) <= heightSpecSize) {
                        width = widthSpecSize;
                        height = scaledHeight;
                    }
                    if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                        height = heightSpecSize;
                        width = height * videoWidth / videoHeight;
                    }
                    if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                        width = widthSpecSize;
                        height = width * videoHeight / videoWidth;
                    }
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }
}

