/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.verizon.ads.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadUtils {
    private static final Logger logger = Logger.getInstance(ThreadUtils.class);
    private static final Handler uiHandler;
    private static final ExecutorService workerExecutor;
    private static final Handler workerHandler;

    public static void postOnUiThread(Runnable runnable) {
        uiHandler.post(runnable);
    }

    public static void runOnUiThread(Runnable runnable) {
        ThreadUtils.postOnUiThread(runnable);
    }

    public static void runOffUiThread(Runnable runnable) {
        if (ThreadUtils.isUiThread()) {
            try {
                workerExecutor.execute(runnable);
            }
            catch (Throwable t) {
                logger.d("Error executing runnable", t);
            }
        } else {
            runnable.run();
        }
    }

    public static void runOnWorkerThread(Runnable runnable) {
        try {
            workerExecutor.execute(runnable);
        }
        catch (Throwable t) {
            logger.d("Error executing runnable", t);
        }
    }

    public static ScheduledRunnable runOnUiThreadDelayed(final Runnable runnable, long delay) {
        ScheduledRunnable runnableWrapper = new ScheduledRunnable(){

            @Override
            public void run() {
                runnable.run();
            }

            @Override
            public void cancel() {
                uiHandler.removeCallbacks((Runnable)this);
            }
        };
        uiHandler.postDelayed((Runnable)runnableWrapper, delay);
        return runnableWrapper;
    }

    public static ScheduledRunnable runOnWorkerThreadDelayed(final Runnable runnable, long delay) {
        ScheduledRunnable runnableWrapper = new ScheduledRunnable(){

            @Override
            public void run() {
                try {
                    workerExecutor.execute(runnable);
                }
                catch (Throwable t) {
                    logger.d("Error executing runnable", t);
                }
            }

            @Override
            public void cancel() {
                workerHandler.removeCallbacks((Runnable)this);
            }
        };
        workerHandler.postDelayed((Runnable)runnableWrapper, delay);
        return runnableWrapper;
    }

    public static boolean isUiThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static int getActiveWorkerThreadCount() {
        return ((ThreadPoolExecutor)workerExecutor).getActiveCount();
    }

    static {
        logger.d("Initializing ThreadUtils");
        uiHandler = new Handler(Looper.getMainLooper());
        HandlerThread handlerThread = new HandlerThread(ThreadUtils.class.getName());
        handlerThread.start();
        workerHandler = new Handler(handlerThread.getLooper());
        workerExecutor = Executors.newCachedThreadPool();
    }

    public static interface ScheduledRunnable
    extends Runnable {
        public void cancel();
    }
}

