/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.os.Handler;
import com.verizon.ads.AdAdapter;
import com.verizon.ads.AdRequest;
import com.verizon.ads.AdSession;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.VASAds;
import com.verizon.ads.Waterfall;
import com.verizon.ads.WaterfallResult;

final class WaterfallProcessingRunnable
implements Runnable {
    private static final Logger logger = Logger.getInstance(WaterfallProcessingRunnable.class);
    private static final String WHO = WaterfallProcessingRunnable.class.getSimpleName();
    private final AdRequest adRequest;
    private final AdSession adSession;
    private final Waterfall waterfall;
    private final Handler handler;
    private final WaterfallResult waterfallResult;

    WaterfallProcessingRunnable(AdRequest adRequest, AdSession adSession, Handler handler) {
        this.adRequest = adRequest;
        this.adSession = adSession;
        this.waterfall = adSession.get("response.waterfall", Waterfall.class, null);
        this.handler = handler;
        this.waterfallResult = new WaterfallResult(this.waterfall, adRequest.bid);
    }

    void setResult(ErrorInfo errorInfo) {
        this.waterfallResult.setResult(errorInfo);
    }

    @Override
    public void run() {
        Waterfall.WaterfallItem[] waterfallItems;
        if (this.waterfall != null && (waterfallItems = this.waterfall.getWaterfallItems()) != null) {
            for (Waterfall.WaterfallItem waterfallItem : waterfallItems) {
                WaterfallResult.WaterfallItemResult waterfallItemResult = this.waterfallResult.startWaterfallItem(waterfallItem);
                ErrorInfo errorInfo = null;
                Waterfall.WaterfallItem.FetchResult fetchResult = null;
                try {
                    fetchResult = waterfallItem.fetch(this.adSession);
                    if (fetchResult == null) {
                        errorInfo = new ErrorInfo(WHO, "No fill", -1);
                    } else if (fetchResult.adContent == null) {
                        errorInfo = fetchResult.errorInfo != null ? fetchResult.errorInfo : new ErrorInfo(WHO, "No fill", -1);
                    }
                }
                catch (Throwable t) {
                    logger.e("Unexpected Throwable from WaterfallItem.fetch().", t);
                    errorInfo = new ErrorInfo(WHO, "Error fetching data", -3);
                }
                if (errorInfo == null) {
                    Class adRequestClass = this.adRequest.adRequesterClass;
                    AdAdapter adAdapter = VASAds.getAdAdapter(adRequestClass, fetchResult.adContent);
                    if (adAdapter != null) {
                        errorInfo = adAdapter.prepare(this.adSession, fetchResult.adContent);
                        if (errorInfo != null) {
                            logger.e(String.format("Error occurred while preparing ad adapter: %s", errorInfo));
                            errorInfo = new ErrorInfo(WHO, "Error preparing adapter", -3);
                        } else {
                            this.adSession.put("response.waterfallItem", (Object)waterfallItem);
                            this.adSession.setAdAdapter(adAdapter);
                        }
                    } else {
                        if (Logger.isLogLevelEnabled(3)) {
                            logger.d(String.format("Could not find an ad adapter for class [%s] and content:\n%s", adRequestClass, fetchResult.adContent));
                        }
                        errorInfo = new ErrorInfo(WHO, "Could not find an ad adapter", -3);
                    }
                }
                if (!waterfallItemResult.setResult(errorInfo) || this.adSession.getAdAdapter() != null) break;
            }
        }
        this.handler.sendMessage(this.handler.obtainMessage(3, (Object)new WaterfallProcessingResult(this.adRequest, this.adSession, this)));
    }

    static final class WaterfallProcessingResult {
        final AdRequest adRequest;
        final AdSession adSession;
        final WaterfallProcessingRunnable waterfallProcessingRunnable;

        WaterfallProcessingResult(AdRequest adRequest, AdSession adSession, WaterfallProcessingRunnable waterfallProcessingRunnable) {
            this.adRequest = adRequest;
            this.adSession = adSession;
            this.waterfallProcessingRunnable = waterfallProcessingRunnable;
        }
    }
}

