/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.content.Context;
import com.verizon.ads.AdAdapter;
import com.verizon.ads.ConfigurationProvider;
import com.verizon.ads.ContentFilter;
import com.verizon.ads.Logger;
import com.verizon.ads.PEXFactory;
import com.verizon.ads.PEXRegistry;
import com.verizon.ads.VASAds;
import com.verizon.ads.utils.TextUtils;
import java.net.URI;
import java.net.URL;

public abstract class Plugin {
    private static final Logger logger = Logger.getInstance(Plugin.class);
    final String id;
    final String name;
    final String version;
    final String author;
    final URI email;
    final URL website;
    final int minApiLevel;
    final Context applicationContext;

    protected Plugin(Context applicationContext, String id, String name, String version, String author, URI email, URL website, int minApiLevel) {
        this.applicationContext = applicationContext;
        this.id = id;
        this.name = name;
        this.version = version;
        this.author = author;
        this.email = email;
        this.website = website;
        this.minApiLevel = minApiLevel;
    }

    public String toString() {
        return "Plugin{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", author='" + this.author + '\'' + ", email='" + this.email + '\'' + ", website='" + this.website + '\'' + ", minApiLevel=" + this.minApiLevel + ", applicationContext ='" + this.applicationContext + '\'' + '}';
    }

    final boolean validate() {
        if (this.applicationContext == null) {
            logger.e("applicationContext cannot be null.");
            return false;
        }
        if (TextUtils.isEmpty(this.id)) {
            logger.e("id cannot be null or empty.");
            return false;
        }
        if (TextUtils.isEmpty(this.name)) {
            logger.e("name cannot be null or empty.");
            return false;
        }
        if (TextUtils.isEmpty(this.version)) {
            logger.e("version cannot be null or empty.");
            return false;
        }
        if (TextUtils.isEmpty(this.author)) {
            logger.e("author cannot be null or empty.");
            return false;
        }
        if (this.minApiLevel <= 0) {
            logger.e("minApiLevel must be greater than zero.");
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public URI getEmail() {
        return this.email;
    }

    public URL getWebsite() {
        return this.website;
    }

    public int getMinApiLevel() {
        return this.minApiLevel;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plugin)) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return this.id.equals(plugin.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected void registerAdAdapter(Class adRequestorClass, Class<? extends AdAdapter> adAdapterClass, ContentFilter contentFilter) {
        VASAds.registerAdAdapter(this.id, adRequestorClass, adAdapterClass, contentFilter);
    }

    protected void registerConfigurationProvider(ConfigurationProvider configurationProvider) {
        VASAds.registerConfigurationProvider(this.id, configurationProvider);
    }

    protected boolean registerPEX(String contentType, PEXFactory factory) {
        return PEXRegistry.registerPEX(contentType, factory);
    }

    protected abstract boolean prepare();

    protected abstract void onPluginEnabled();

    protected abstract void onPluginDisabled();
}

