/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import com.verizon.ads.DataStore;
import com.verizon.ads.Logger;
import com.verizon.ads.events.Events;
import com.verizon.ads.utils.TextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Configuration {
    private static final Logger logger = Logger.getInstance(Configuration.class);
    private static final String DOMAIN_REQUIRED_MESSAGE = "Domain cannot be null";
    private static final String DOMAIN_AND_KEY_REQUIRED_MESSAGE = "Domain and key cannot be null or empty";
    private static final String SECURITY_KEY_REQUIRED_MESSAGE = "Security key cannot be null";
    private static final DataStore domainDataStore = new DataStore();
    private static final Map<String, String> protectedDomains = new ConcurrentHashMap<String, String>();
    public static final String CONFIGURATION_CHANGE_EVENT_ID = "com.verizon.ads.configuration.change";

    private Configuration() {
    }

    public static boolean protectDomain(String domain, String securityKey) throws Exception {
        if (TextUtils.isEmpty(domain)) {
            logger.e(DOMAIN_REQUIRED_MESSAGE);
            return false;
        }
        if (TextUtils.isEmpty(securityKey)) {
            logger.e(SECURITY_KEY_REQUIRED_MESSAGE);
            return false;
        }
        if (protectedDomains.containsKey(domain) && !securityKey.equals(protectedDomains.get(domain))) {
            throw new Exception("Domain has already been protected");
        }
        protectedDomains.put(domain, securityKey);
        return true;
    }

    public static boolean isDomainProtected(String domain) {
        if (TextUtils.isEmpty(domain)) {
            logger.e(DOMAIN_REQUIRED_MESSAGE);
            return false;
        }
        return protectedDomains.containsKey(domain);
    }

    public static boolean exists(String domain, String key) {
        if (TextUtils.isEmpty(domain) || TextUtils.isEmpty(key)) {
            logger.e(DOMAIN_AND_KEY_REQUIRED_MESSAGE);
            return false;
        }
        return domainDataStore.containsKey(Configuration.makeDataStoreKey(domain, key));
    }

    public static Object getObject(String domain, String key, Object defaultValue) {
        return Configuration.get(domain, key, Object.class, defaultValue);
    }

    public static int getInt(String domain, String key, int defaultValue) {
        return Configuration.get(domain, key, Integer.class, defaultValue);
    }

    public static double getDouble(String domain, String key, double defaultValue) {
        return Configuration.get(domain, key, Double.class, defaultValue);
    }

    public static boolean getBoolean(String domain, String key, boolean defaultValue) {
        return Configuration.get(domain, key, Boolean.class, defaultValue);
    }

    public static String getString(String domain, String key, String defaultValue) {
        return Configuration.get(domain, key, String.class, defaultValue);
    }

    public static Map getMap(String domain, String key, Map defaultValue) {
        return Configuration.get(domain, key, Map.class, defaultValue);
    }

    public static List getList(String domain, String key, List defaultValue) {
        return Configuration.get(domain, key, List.class, defaultValue);
    }

    public static void set(Object value, String domain, String key, String securityKey) {
        if (value == null) {
            Configuration.removeDomainValue(domain, key, securityKey);
        } else {
            Configuration.setDomainValue(value, domain, key, securityKey);
        }
    }

    public static void setObject(Object value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setInt(int value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setDouble(double value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setBoolean(boolean value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setString(String value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setMap(Map value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setList(List value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static <T> T get(String domain, String key, Class<T> clazz, T defaultValue) {
        if (TextUtils.isEmpty(domain) || TextUtils.isEmpty(key)) {
            logger.e(DOMAIN_AND_KEY_REQUIRED_MESSAGE);
            return Configuration.getImmutableValue(defaultValue);
        }
        T value = domainDataStore.get(Configuration.makeDataStoreKey(domain, key), clazz, defaultValue);
        if (value != null) {
            return value;
        }
        return Configuration.getImmutableValue(defaultValue);
    }

    private static <T> T getImmutableValue(T value) {
        if (value instanceof Map) {
            return (T)Collections.unmodifiableMap((Map)value);
        }
        if (value instanceof List) {
            return (T)Collections.unmodifiableList((List)value);
        }
        return value;
    }

    private static boolean isAllowedToUpdateDomain(String domain, String securityKey) {
        if (TextUtils.isEmpty(domain)) {
            return false;
        }
        String requiredSecurityKey = protectedDomains.get(domain);
        if (requiredSecurityKey == null || requiredSecurityKey.equals(securityKey)) {
            return true;
        }
        logger.e("Not authorized to set value for a protected domain: " + domain);
        return false;
    }

    private static void setDomainValue(Object value, String domain, String key, String securityKey) {
        if (TextUtils.isEmpty(domain) || TextUtils.isEmpty(key)) {
            logger.e(DOMAIN_AND_KEY_REQUIRED_MESSAGE);
            return;
        }
        if (!Configuration.isAllowedToUpdateDomain(domain, securityKey)) {
            return;
        }
        Object immutableValue = Configuration.getImmutableValue(value);
        Object result = domainDataStore.put(Configuration.makeDataStoreKey(domain, key), immutableValue);
        if (!value.equals(result)) {
            Events.sendEvent(CONFIGURATION_CHANGE_EVENT_ID, new ConfigurationChangeEvent(domain, key, immutableValue));
        }
    }

    private static void removeDomainValue(String domain, String key, String securityKey) {
        if (TextUtils.isEmpty(domain) || TextUtils.isEmpty(key)) {
            logger.e(DOMAIN_AND_KEY_REQUIRED_MESSAGE);
            return;
        }
        if (!Configuration.isAllowedToUpdateDomain(domain, securityKey)) {
            return;
        }
        if (domainDataStore.remove(Configuration.makeDataStoreKey(domain, key)) != null) {
            Events.sendEvent(CONFIGURATION_CHANGE_EVENT_ID, new ConfigurationChangeEvent(domain, key, null));
        }
    }

    private static String makeDataStoreKey(String domain, String key) {
        return domain + '.' + key;
    }

    public static String asString() {
        return String.format("Configuration:\n%s", domainDataStore.toString());
    }

    public static final class ConfigurationChangeEvent {
        public final String domain;
        public final String key;
        public final Object value;

        ConfigurationChangeEvent(String domain, String key, Object value) {
            this.domain = domain;
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "ConfigurationChangeEvent{domain: " + this.domain + ", key: " + this.key + ", value: " + this.value + '}';
        }
    }
}

