/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import com.verizon.ads.AdAdapter;
import com.verizon.ads.AdSessionEvent;
import com.verizon.ads.DataStore;
import com.verizon.ads.Logger;
import com.verizon.ads.events.Events;
import com.verizon.ads.utils.TextUtils;

public class AdSession
extends DataStore {
    private static final Logger logger = Logger.getInstance(AdSession.class);
    private final long creationTime = System.currentTimeMillis();
    private final String sessionId = Integer.toString(this.hashCode());
    private AdAdapter adAdapter;
    public static final String AD_SESSION_CHANGE_EVENT_ID = "com.verizon.ads.adsession.change";

    public AdSession() {
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Ad session created: %s", this.getSessionId()));
        }
    }

    @Override
    public Object put(String key, Object value) {
        Object previousValue = super.put(key, value);
        if (!TextUtils.isEmpty(key) && value != null && !value.equals(previousValue)) {
            Events.sendEvent(AD_SESSION_CHANGE_EVENT_ID, new AdSessionChangeEvent(this, key, value, previousValue));
        }
        return previousValue;
    }

    @Override
    public Object remove(String key) {
        Object previousValue = super.remove(key);
        if (previousValue != null) {
            Events.sendEvent(AD_SESSION_CHANGE_EVENT_ID, new AdSessionChangeEvent(this, key, null, previousValue));
        }
        return previousValue;
    }

    public void setAdAdapter(AdAdapter adAdapter) {
        this.adAdapter = adAdapter;
    }

    public AdAdapter getAdAdapter() {
        return this.adAdapter;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void release() {
        this.clear();
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Ad session released: %s", this.getSessionId()));
        }
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    @NonNull
    public String toString() {
        return String.format("AdSession{id: %s, creation time: %d, adAdapter: %s}", this.getSessionId(), this.getCreationTime(), this.adAdapter);
    }

    @SuppressLint(value={"DefaultLocale"})
    @NonNull
    public String toStringLongDescription() {
        return String.format("%s, contents\n%s", this, super.toString());
    }

    public static final class AdSessionChangeEvent
    extends AdSessionEvent {
        public final String key;
        public final Object value;
        public final Object previousValue;

        AdSessionChangeEvent(AdSession adSession, String key, Object value, Object previousValue) {
            super(adSession);
            this.key = key;
            this.value = value;
            this.previousValue = previousValue;
        }

        @Override
        public String toString() {
            return "AdSessionChangeEvent{key: " + this.key + ", value: " + this.value + ", previous value: " + this.previousValue + '}';
        }
    }
}

