/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.verizonsspreporter;

import android.content.Context;
import com.verizon.ads.Bid;
import com.verizon.ads.Configuration;
import com.verizon.ads.EnvironmentInfo;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Job;
import com.verizon.ads.JobScheduler;
import com.verizon.ads.Logger;
import com.verizon.ads.VASAds;
import com.verizon.ads.Waterfall;
import com.verizon.ads.WaterfallResult;
import com.verizon.ads.events.EventReceiver;
import com.verizon.ads.events.Events;
import com.verizon.ads.support.ClickEvent;
import com.verizon.ads.support.ImpressionEvent;
import com.verizon.ads.utils.HttpUtils;
import com.verizon.ads.utils.IOUtils;
import com.verizon.ads.utils.JSONWriter;
import com.verizon.ads.utils.TextUtils;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.verizonsspwaterfallprovider.VerizonSSPWaterfallProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VerizonSSPReporter {
    static final String REPORTING_DIR = "/.reporting/";
    static final String SSP_REPORTING_PATH = "/admax/sdk/report/4";
    static final String SSP_SITE_ID_PARAMETER = "?dcn=";
    private static final Logger logger = Logger.getInstance(VerizonSSPReporter.class);
    private static final int BID_SUBMITTED_STATUS = 1;
    private static final int WATERFALL_ITEM_STATUS_UNKNOWN = 0;
    private static final int WATERFALL_ITEM_STATUS_SUCCEEDED = 1;
    private static final int WATERFALL_ITEM_SUPER_AUCTION_SUCCEEDED = 111;
    private static final int ERROR_WATERFALL_ITEM_SUPER_AUCTION_FAILED = 112;
    private static final int REPORTING_JOB_ID = 17;
    private static final String META_DATA_IMP_GROUP_KEY = "impressionGroup";
    private static final String META_DATA_RESPONSE_ID = "responseId";
    private static final String META_DATA_ITEM_ID = "itemId";
    private static final String META_DATA_PLACEMENT_NAME = "placementName";
    private static final String META_DATA_REPORTING_ENABLED = "reportingEnabled";
    private static final String REPORTING_BATCH_FREQUENCY_KEY = "reportingBatchFrequency";
    private static final String REPORTING_BATCH_SIZE_KEY = "reportingBatchSize";
    private static final String REPORTING_BASE_URL_KEY = "reportingBaseUrl";
    private static final String VERIZON_SSP_DOMAIN = "com.verizon.ads.verizonssp";
    private static final int DEFAULT_REPORTING_BATCH_FREQUENCY = 120000;
    private static final int DEFAULT_REPORTING_BATCH_SIZE = 5;
    private static final String DEFAULT_REPORTING_BASE_URL = "https://ads.nexage.com";
    private static final String REPORT_KEY_RESPONSE_ID = "a";
    private static final String REPORT_KEY_TIMESTAMP = "ts";
    private static final String REPORT_KEY_PLACEMENT_NAME = "zone";
    private static final String REPORT_KEY_RESPONSE_TIME = "resp";
    private static final String REPORT_KEY_BUYER = "buyer";
    private static final String REPORT_KEY_PRU = "pru";
    private static final String REPORT_KEY_ADNET = "adnet";
    private static final String REPORT_KEY_ITEM_ID = "tag";
    private static final String REPORT_KEY_STATUS = "status";
    private static final String REPORT_KEY_REQUEST = "req";
    private static final String REPORT_KEY_DISPLAY = "display";
    private static final String REPORT_KEY_CLICK = "click";
    private static final String REPORT_KEY_IMPRESSION_GROUP = "grp";
    private static final String REPORT_KEY_SUPER_AUCTION = "superAuction";
    private static final String REPORT_KEY_SUPER_AUCTION_BIDDERS = "bidders";
    private static final String REPORT_KEY_SUPER_AUCTION_DEMAND_SOURCES = "demandSources";
    private static final String REPORT_KEY_TYPE = "type";
    private static final String REPORT_KEY_PRICE = "price";
    private static final String EVENT_REQUEST = "request_";
    private static final String EVENT_CLICK = "click_";
    private static final String EVENT_DISPLAY = "display_";
    private static final String EXTENSION_JSON = ".json";
    private static final Object stateLock = new Object();
    private static final int STARTUP_DELAY_IN_SECONDS = 5;
    private static volatile File reportingDir;
    private static volatile UploadState uploadState;
    private static volatile AtomicInteger numberCachedEvents;

    public VerizonSSPReporter(Context context) {
        logger.d("Initializing VerizonSSPReporter");
        Events.subscribe(new EventReceiver(){

            @Override
            protected void onEvent(String topic, Object data) {
                if (data instanceof ClickEvent) {
                    ClickEvent clickEvent = (ClickEvent)data;
                    VerizonSSPReporter.this.addClickEvent(clickEvent);
                } else {
                    logger.w("Unable to process unknown click event type");
                }
            }
        }, "com.verizon.ads.click");
        Events.subscribe(new EventReceiver(){

            @Override
            protected void onEvent(String topic, Object data) {
                if (data instanceof ImpressionEvent) {
                    ImpressionEvent impressionEvent = (ImpressionEvent)data;
                    VerizonSSPReporter.this.addImpressionEvent(impressionEvent);
                } else {
                    logger.w("Unable to process unknown impression event type");
                }
            }
        }, "com.verizon.ads.impression");
        Events.subscribe(new EventReceiver(){

            @Override
            protected void onEvent(String topic, Object data) {
                if (data instanceof WaterfallResult) {
                    WaterfallResult waterfallResult = (WaterfallResult)data;
                    VerizonSSPReporter.this.addWaterfallResultEvent(waterfallResult);
                } else {
                    logger.w("Unable to process unknown waterfall event result type");
                }
            }
        }, "com.verizon.ads.waterfall.result");
        Uploader.start(context);
    }

    public static void clear() {
        if (uploadState != UploadState.UPLOADING) {
            Uploader.setUploadState(UploadState.CLEARING);
        }
    }

    private void addWaterfallResultEvent(WaterfallResult waterfallResult) {
        if (!Boolean.TRUE.equals(waterfallResult.getMetadata().get(META_DATA_REPORTING_ENABLED))) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Reporting disabled. Ignoring waterfall result event for responseId: " + waterfallResult.getMetadata().get(META_DATA_RESPONSE_ID));
            }
            return;
        }
        if (Logger.isLogLevelEnabled(3)) {
            logger.d("Adding waterfall result event for responseId: " + waterfallResult.getMetadata().get(META_DATA_RESPONSE_ID));
        }
        try {
            JSONObject playlistReportJson = new JSONObject();
            playlistReportJson.put(REPORT_KEY_TIMESTAMP, System.currentTimeMillis());
            playlistReportJson.put(REPORT_KEY_RESPONSE_ID, waterfallResult.getMetadata().get(META_DATA_RESPONSE_ID));
            playlistReportJson.put(REPORT_KEY_PLACEMENT_NAME, waterfallResult.getMetadata().get(META_DATA_PLACEMENT_NAME));
            playlistReportJson.put(REPORT_KEY_IMPRESSION_GROUP, waterfallResult.getMetadata().get(META_DATA_IMP_GROUP_KEY));
            playlistReportJson.put(REPORT_KEY_RESPONSE_TIME, waterfallResult.getElapsedTime());
            playlistReportJson.put(REPORT_KEY_ADNET, (Object)this.getWaterfallItemResultList(waterfallResult));
            if (waterfallResult.getBid() == null) {
                playlistReportJson.put(REPORT_KEY_BUYER, (Object)this.getWaterfallItemResultMetadataValue(waterfallResult, REPORT_KEY_BUYER));
                playlistReportJson.put(REPORT_KEY_PRU, (Object)this.getWaterfallItemResultMetadataValue(waterfallResult, REPORT_KEY_PRU));
            }
            Uploader.storeEvent(EVENT_REQUEST, playlistReportJson);
        }
        catch (JSONException e) {
            logger.e("Unable to process waterfall result event");
        }
    }

    private String getWaterfallItemResultMetadataValue(WaterfallResult waterfallResult, String key) {
        for (WaterfallResult.WaterfallItemResult waterfallItemResult : waterfallResult.getWaterfallItemResults()) {
            if (waterfallItemResult.getErrorInfo() != null) continue;
            return (String)waterfallItemResult.getMetadata().get(key);
        }
        return null;
    }

    private JSONArray getWaterfallItemResultList(WaterfallResult waterfallResult) {
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Reporting waterfall item results for responseId: %s", waterfallResult.getMetadata().get(META_DATA_RESPONSE_ID)));
        }
        JSONArray waterfallItemResultArray = new JSONArray();
        Bid bid = waterfallResult.getBid();
        VerizonSSPWaterfallProvider.VerizonSSPBid verizonSSPBid = null;
        if (bid instanceof VerizonSSPWaterfallProvider.VerizonSSPBid) {
            verizonSSPBid = (VerizonSSPWaterfallProvider.VerizonSSPBid)bid;
        } else if (bid != null) {
            logger.w("Unable to process unknown bid type");
        }
        try {
            if (verizonSSPBid == null) {
                for (WaterfallResult.WaterfallItemResult waterfallItemResult : waterfallResult.getWaterfallItemResults()) {
                    JSONObject json = new JSONObject();
                    json.put(REPORT_KEY_ITEM_ID, waterfallItemResult.getMetadata().get(META_DATA_ITEM_ID));
                    json.put(REPORT_KEY_STATUS, this.getWaterfallItemStatus(waterfallItemResult));
                    json.put(REPORT_KEY_RESPONSE_TIME, waterfallItemResult.getElapsedTime());
                    waterfallItemResultArray.put((Object)json);
                }
            } else {
                JSONObject json = new JSONObject();
                json.put(REPORT_KEY_ITEM_ID, (Object)verizonSSPBid.itemId);
                json.put(REPORT_KEY_STATUS, this.getSuperAuctionStatus(waterfallResult.getWaterfallItemResults()));
                json.put(REPORT_KEY_RESPONSE_TIME, this.getSuperAuctionResponseTime(waterfallResult.getWaterfallItemResults()));
                json.put(REPORT_KEY_SUPER_AUCTION, (Object)this.addSuperAuctionItems(verizonSSPBid, waterfallResult.getWaterfallItemResults()));
                waterfallItemResultArray.put((Object)json);
            }
        }
        catch (Exception e) {
            logger.e("Error adding waterfall item");
        }
        return waterfallItemResultArray;
    }

    private long getSuperAuctionResponseTime(List<WaterfallResult.WaterfallItemResult> waterfallItemResults) {
        long totalProcessingTime = 0L;
        for (WaterfallResult.WaterfallItemResult waterfallItemResult : waterfallItemResults) {
            totalProcessingTime += waterfallItemResult.getElapsedTime();
        }
        return totalProcessingTime;
    }

    private int getSuperAuctionStatus(List<WaterfallResult.WaterfallItemResult> waterfallItemResults) {
        for (WaterfallResult.WaterfallItemResult waterfallItemResult : waterfallItemResults) {
            if (waterfallItemResult.getErrorInfo() != null && waterfallItemResult.getErrorInfo().getErrorCode() == 113) {
                return 113;
            }
            if (this.getWaterfallItemStatus(waterfallItemResult) != 1) continue;
            return 111;
        }
        return 112;
    }

    private int getWaterfallItemStatus(WaterfallResult.WaterfallItemResult waterfallItemResult) {
        if (waterfallItemResult == null) {
            logger.w("WaterfallItemResult cannot be null");
            return 0;
        }
        ErrorInfo errorInfo = waterfallItemResult.getErrorInfo();
        if (errorInfo == null) {
            return 1;
        }
        return errorInfo.getErrorCode();
    }

    private JSONObject addSuperAuctionItems(VerizonSSPWaterfallProvider.VerizonSSPBid verizonSSPBid, List<WaterfallResult.WaterfallItemResult> waterfallItemResults) throws JSONException {
        if (verizonSSPBid == null) {
            logger.w("Bid object cannot be null");
            return null;
        }
        JSONObject superAuctionObject = new JSONObject();
        if (verizonSSPBid.bidderItem != null) {
            JSONArray biddersArray = new JSONArray();
            JSONObject bidderJSON = new JSONObject();
            bidderJSON.put(REPORT_KEY_TYPE, (Object)verizonSSPBid.bidderItem.getString(REPORT_KEY_TYPE));
            bidderJSON.put(REPORT_KEY_PRICE, (Object)verizonSSPBid.bidderItem.getString("bidPrice"));
            bidderJSON.put(REPORT_KEY_STATUS, 1);
            biddersArray.put((Object)bidderJSON);
            superAuctionObject.put(REPORT_KEY_SUPER_AUCTION_BIDDERS, (Object)biddersArray);
        }
        JSONArray demandSourcesArray = new JSONArray();
        for (WaterfallResult.WaterfallItemResult waterfallItemResult : waterfallItemResults) {
            if (waterfallItemResult.getErrorInfo() != null && waterfallItemResult.getErrorInfo().getErrorCode() == 113) {
                return superAuctionObject;
            }
            JSONObject demandJSON = new JSONObject();
            demandJSON.put(REPORT_KEY_STATUS, this.getWaterfallItemStatus(waterfallItemResult));
            demandJSON.put(REPORT_KEY_TIMESTAMP, waterfallItemResult.getStartTime());
            demandJSON.put(REPORT_KEY_ITEM_ID, waterfallItemResult.getMetadata().get(META_DATA_ITEM_ID));
            demandJSON.put(REPORT_KEY_RESPONSE_TIME, waterfallItemResult.getElapsedTime());
            demandSourcesArray.put((Object)demandJSON);
        }
        superAuctionObject.put(REPORT_KEY_SUPER_AUCTION_DEMAND_SOURCES, (Object)demandSourcesArray);
        return superAuctionObject;
    }

    private void addImpressionEvent(ImpressionEvent impressionEvent) {
        try {
            Waterfall waterfall = impressionEvent.adSession.get("response.waterfall", Waterfall.class, null);
            Map<String, Object> waterfallMetadata = waterfall.getMetadata();
            if (!Boolean.TRUE.equals(waterfallMetadata.get(META_DATA_REPORTING_ENABLED))) {
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d("Reporting disabled. Ignoring impression event for responseId: " + waterfallMetadata.get(META_DATA_RESPONSE_ID));
                }
                return;
            }
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Reporting impression event for responseId: %s", waterfallMetadata.get(META_DATA_RESPONSE_ID)));
            }
            Waterfall.WaterfallItem waterfallItem = impressionEvent.adSession.get("response.waterfallItem", Waterfall.WaterfallItem.class, null);
            Map<String, Object> waterfallItemMetadata = waterfallItem.getMetadata();
            JSONObject displayJson = new JSONObject();
            displayJson.put(REPORT_KEY_RESPONSE_ID, waterfallMetadata.get(META_DATA_RESPONSE_ID));
            displayJson.put(REPORT_KEY_TIMESTAMP, impressionEvent.impressionTime);
            displayJson.put(REPORT_KEY_PLACEMENT_NAME, waterfallMetadata.get(META_DATA_PLACEMENT_NAME));
            displayJson.put(REPORT_KEY_ITEM_ID, waterfallItemMetadata.get(META_DATA_ITEM_ID));
            displayJson.put(REPORT_KEY_BUYER, waterfallItemMetadata.get(REPORT_KEY_BUYER));
            displayJson.put(REPORT_KEY_PRU, waterfallItemMetadata.get(REPORT_KEY_PRU));
            displayJson.put(REPORT_KEY_IMPRESSION_GROUP, waterfallMetadata.get(META_DATA_IMP_GROUP_KEY));
            Uploader.storeEvent(EVENT_DISPLAY, displayJson);
        }
        catch (Exception e) {
            logger.e("Error recording impression event");
        }
    }

    private void addClickEvent(ClickEvent clickEvent) {
        try {
            Waterfall waterfall = clickEvent.adSession.get("response.waterfall", Waterfall.class, null);
            Map<String, Object> waterfallMetadata = waterfall.getMetadata();
            if (!Boolean.TRUE.equals(waterfallMetadata.get(META_DATA_REPORTING_ENABLED))) {
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d("Reporting disabled. Ignoring click event for responseId: " + waterfallMetadata.get(META_DATA_RESPONSE_ID));
                }
                return;
            }
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Reporting click event for responseId: " + waterfallMetadata.get(META_DATA_RESPONSE_ID));
            }
            Waterfall.WaterfallItem waterfallItem = clickEvent.adSession.get("response.waterfallItem", Waterfall.WaterfallItem.class, null);
            Map<String, Object> waterfallItemMetadata = waterfallItem.getMetadata();
            JSONObject clickJson = new JSONObject();
            clickJson.put(REPORT_KEY_RESPONSE_ID, waterfallMetadata.get(META_DATA_RESPONSE_ID));
            clickJson.put(REPORT_KEY_TIMESTAMP, clickEvent.clickTime);
            clickJson.put(REPORT_KEY_PLACEMENT_NAME, waterfallMetadata.get(META_DATA_PLACEMENT_NAME));
            clickJson.put(REPORT_KEY_ITEM_ID, waterfallItemMetadata.get(META_DATA_ITEM_ID));
            clickJson.put(REPORT_KEY_IMPRESSION_GROUP, waterfallMetadata.get(META_DATA_IMP_GROUP_KEY));
            Uploader.storeEvent(EVENT_CLICK, clickJson);
        }
        catch (Exception e) {
            logger.e("Error recording click event");
        }
    }

    static {
        uploadState = UploadState.IDLE;
        numberCachedEvents = new AtomicInteger(0);
    }

    static class Uploader {
        private static volatile ThreadUtils.ScheduledRunnable scheduledRunnable = null;
        private static File fileRoot;
        private static Job reportingUploadJob;

        Uploader() {
        }

        private static File[] getEventsToUpload() {
            File[] eventsToUpload = reportingDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(VerizonSSPReporter.EXTENSION_JSON);
                }
            });
            if (eventsToUpload == null) {
                eventsToUpload = new File[]{};
            }
            return eventsToUpload;
        }

        private static void deleteUploadedEvents(File[] uploadEvents) {
            int count = 0;
            for (File file : uploadEvents) {
                if (!file.delete()) {
                    logger.e("Failed to delete reporting file <" + file.getName() + ">");
                    continue;
                }
                --count;
            }
            numberCachedEvents.addAndGet(count);
        }

        /*
         * Loose catch block
         * Enabled aggressive exception aggregation
         */
        private static File buildReport(File[] eventsToUpload) {
            Object object;
            Throwable throwable;
            JSONWriter jsonWriter;
            block35: {
                block36: {
                    File reportFile;
                    block32: {
                        block33: {
                            block34: {
                                JSONObject reportJson;
                                Set<File> clickEvents;
                                Set<File> displayEvents;
                                Set<File> requestEvents;
                                block29: {
                                    File file;
                                    block30: {
                                        block31: {
                                            reportFile = File.createTempFile("VerizonSSPReport", null);
                                            jsonWriter = new JSONWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8"));
                                            throwable = null;
                                            requestEvents = Uploader.getEventsForType(VerizonSSPReporter.EVENT_REQUEST, eventsToUpload);
                                            displayEvents = Uploader.getEventsForType(VerizonSSPReporter.EVENT_DISPLAY, eventsToUpload);
                                            clickEvents = Uploader.getEventsForType(VerizonSSPReporter.EVENT_CLICK, eventsToUpload);
                                            if (!requestEvents.isEmpty() || !displayEvents.isEmpty() || !clickEvents.isEmpty()) break block29;
                                            file = null;
                                            if (jsonWriter == null) break block30;
                                            if (throwable == null) break block31;
                                            try {
                                                jsonWriter.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            break block30;
                                        }
                                        jsonWriter.close();
                                    }
                                    return file;
                                }
                                jsonWriter.beginObject();
                                if (!requestEvents.isEmpty()) {
                                    jsonWriter.name(VerizonSSPReporter.REPORT_KEY_REQUEST);
                                    jsonWriter.beginArray();
                                    for (File requestEvent : requestEvents) {
                                        reportJson = Uploader.retrieveEvent(requestEvent);
                                        jsonWriter.write(reportJson);
                                    }
                                    jsonWriter.endArray();
                                }
                                if (!displayEvents.isEmpty()) {
                                    jsonWriter.name(VerizonSSPReporter.REPORT_KEY_DISPLAY);
                                    jsonWriter.beginArray();
                                    for (File displayEvent : displayEvents) {
                                        reportJson = Uploader.retrieveEvent(displayEvent);
                                        jsonWriter.write(reportJson);
                                    }
                                    jsonWriter.endArray();
                                }
                                if (!clickEvents.isEmpty()) {
                                    jsonWriter.name(VerizonSSPReporter.REPORT_KEY_CLICK);
                                    jsonWriter.beginArray();
                                    for (File clickEvent : clickEvents) {
                                        reportJson = Uploader.retrieveEvent(clickEvent);
                                        jsonWriter.write(reportJson);
                                    }
                                    jsonWriter.endArray();
                                }
                                jsonWriter.endObject();
                                jsonWriter.close();
                                if (requestEvents.size() + clickEvents.size() + displayEvents.size() != 0) break block32;
                                logger.d("No reporting events added to the request");
                                object = null;
                                if (jsonWriter == null) break block33;
                                if (throwable == null) break block34;
                                try {
                                    jsonWriter.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block33;
                            }
                            jsonWriter.close();
                        }
                        return object;
                    }
                    object = reportFile;
                    if (jsonWriter == null) break block35;
                    if (throwable == null) break block36;
                    try {
                        jsonWriter.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block35;
                }
                jsonWriter.close();
            }
            return object;
            catch (Throwable throwable5) {
                try {
                    try {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (jsonWriter != null) {
                            if (throwable != null) {
                                try {
                                    jsonWriter.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                jsonWriter.close();
                            }
                        }
                        throw throwable6;
                    }
                }
                catch (Exception e) {
                    try {
                        logger.e("Error creating SSP reporting request", e);
                        return null;
                    }
                    catch (Exception e2) {
                        logger.e("Could not create the SSP report file.", e2);
                        return null;
                    }
                }
            }
        }

        private static Set<File> getEventsForType(String typePrefix, File[] eventFiles) {
            HashSet<File> eventsForType = new HashSet<File>();
            for (File eventFile : eventFiles) {
                if (!eventFile.getName().startsWith(typePrefix)) continue;
                eventsForType.add(eventFile);
            }
            return eventsForType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean saveToFile(File file, String contents) {
            boolean fileWritten;
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file);
                IOUtils.write(outputStream, contents);
            }
            catch (Exception e) {
                try {
                    logger.e("Error writing to file <" + file.getName() + ">", e);
                }
                catch (Throwable throwable) {
                    boolean fileWritten2 = IOUtils.closeStream(outputStream);
                    throw throwable;
                }
                fileWritten = IOUtils.closeStream(outputStream);
            }
            fileWritten = IOUtils.closeStream(outputStream);
            return fileWritten;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String readFromFile(File file) {
            FileInputStream inputStream = null;
            String contents = null;
            if (file.exists()) {
                try {
                    inputStream = new FileInputStream(file);
                    contents = IOUtils.read((InputStream)inputStream, "UTF-8");
                }
                catch (IOException e) {
                    try {
                        logger.e("Error opening file <" + file.getName() + ">", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(inputStream);
                        throw throwable;
                    }
                    IOUtils.closeStream(inputStream);
                }
                IOUtils.closeStream(inputStream);
            }
            return contents;
        }

        static void storeEvent(String prefix, JSONObject json) {
            String eventId = UUID.randomUUID().toString();
            String filename = prefix + eventId + VerizonSSPReporter.EXTENSION_JSON;
            File file = new File(reportingDir, filename);
            if (Uploader.saveToFile(file, json.toString())) {
                Uploader.incrementCachedEventsCount();
            }
        }

        private static JSONObject retrieveEvent(File file) {
            JSONObject json = null;
            if (file.exists()) {
                String contents = Uploader.readFromFile(file);
                try {
                    json = new JSONObject(contents);
                }
                catch (JSONException e) {
                    logger.e("Error parsing reporting file <" + file.getName() + ">", e);
                }
            }
            return json;
        }

        private static void countCachedEvents() {
            File[] tmpFiles = reportingDir.listFiles();
            int count = 0;
            if (tmpFiles != null) {
                for (File tmpFile : tmpFiles) {
                    if (!tmpFile.getName().endsWith(VerizonSSPReporter.EXTENSION_JSON)) continue;
                    ++count;
                }
            }
            numberCachedEvents.set(count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void incrementCachedEventsCount() {
            Object object = stateLock;
            synchronized (object) {
                int count = numberCachedEvents.incrementAndGet();
                if (uploadState == UploadState.IDLE && count >= Uploader.getReportingBatchSize()) {
                    logger.d("Reporting batch size limit detected -- requesting upload");
                    Uploader.setUploadState(UploadState.UPLOADING);
                }
            }
        }

        private static int getReportingBatchSize() {
            return Configuration.getInt(VerizonSSPReporter.VERIZON_SSP_DOMAIN, VerizonSSPReporter.REPORTING_BATCH_SIZE_KEY, 5);
        }

        private static void start(Context context) {
            fileRoot = context.getFilesDir();
            String path = Uploader.getReportingDir() + VerizonSSPReporter.REPORTING_DIR;
            reportingDir = new File(path);
            reportingDir.mkdirs();
            if (!reportingDir.isDirectory()) {
                logger.e("Unable to creating reporting directory");
                return;
            }
            Uploader.countCachedEvents();
            scheduledRunnable = ThreadUtils.runOnWorkerThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    logger.d("Reporting startup -- requesting upload");
                    Uploader.setUploadState(UploadState.UPLOADING);
                }
            }, 5000L);
        }

        private static File getReportingDir() {
            String path = fileRoot + "/.com.verizon.ads/";
            File file = new File(path);
            file.mkdirs();
            return file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void setUploadState(UploadState newState) {
            Object object = stateLock;
            synchronized (object) {
                if (newState == uploadState) {
                    return;
                }
                uploadState = newState;
            }
            switch (uploadState) {
                case IDLE: {
                    logger.d("Reporting upload state set to IDLE");
                    scheduledRunnable = ThreadUtils.runOnWorkerThreadDelayed(new Runnable(){

                        @Override
                        public void run() {
                            logger.d("Reporting batch frequency detected -- requesting upload");
                            Uploader.setUploadState(UploadState.UPLOADING);
                        }
                    }, Uploader.getReportingBatchFrequency());
                    break;
                }
                case UPLOADING: {
                    logger.d("Reporting upload state set to UPLOADING");
                    if (scheduledRunnable != null) {
                        scheduledRunnable.cancel();
                    }
                    JobScheduler.schedule(reportingUploadJob);
                    break;
                }
                case ERROR_SENDING_TO_SERVER: {
                    logger.d("Reporting upload state set to ERROR_SENDING_TO_SERVER");
                    scheduledRunnable = ThreadUtils.runOnWorkerThreadDelayed(new Runnable(){

                        @Override
                        public void run() {
                            logger.d("Reporting batch frequency detected -- requesting upload");
                            Uploader.setUploadState(UploadState.UPLOADING);
                        }
                    }, Uploader.getReportingBatchFrequency());
                    break;
                }
                case CLEARING: {
                    logger.d("Reporting upload state set to CLEARING");
                    if (scheduledRunnable != null) {
                        scheduledRunnable.cancel();
                    }
                    Uploader.clearNow();
                }
            }
        }

        private static long getReportingBatchFrequency() {
            return Configuration.getInt(VerizonSSPReporter.VERIZON_SSP_DOMAIN, VerizonSSPReporter.REPORTING_BATCH_FREQUENCY_KEY, 120000);
        }

        private static void uploadNow() {
            logger.d("Reporting is starting upload");
            File[] eventsToUpload = Uploader.getEventsToUpload();
            if (eventsToUpload.length == 0) {
                logger.d("Reporting found no events to upload");
                Uploader.setUploadState(UploadState.IDLE);
                return;
            }
            if (!EnvironmentInfo.isNetworkAvailable()) {
                logger.w("Cannot upload report because network is not available");
                Uploader.setUploadState(UploadState.IDLE);
                return;
            }
            String reportingUrl = Uploader.getReportingBaseUrl();
            if (reportingUrl == null) {
                logger.e("Unable to determine base url for request");
                Uploader.setUploadState(UploadState.ERROR_SENDING_TO_SERVER);
                return;
            }
            reportingUrl = reportingUrl.concat(VerizonSSPReporter.SSP_REPORTING_PATH);
            String siteId = VASAds.getSiteId();
            if (TextUtils.isEmpty(siteId)) {
                logger.e("Unable to upload report -- siteId has not been set");
                Uploader.setUploadState(UploadState.ERROR_SENDING_TO_SERVER);
                return;
            }
            File reportFile = Uploader.buildReport(eventsToUpload);
            if (reportFile != null) {
                HttpUtils.Response response = HttpUtils.getContentFromPostRequest(reportingUrl + VerizonSSPReporter.SSP_SITE_ID_PARAMETER + siteId, reportFile, "application/json");
                if (response.code != 200) {
                    logger.e("Reporting failed to upload with response code <" + response.code + ">");
                    Uploader.setUploadState(UploadState.ERROR_SENDING_TO_SERVER);
                    return;
                }
                logger.d("Report successfully uploaded");
                if (!reportFile.delete()) {
                    logger.d("Failed to delete report file + " + reportFile.getAbsolutePath());
                }
            }
            Uploader.deleteUploadedEvents(eventsToUpload);
            if (numberCachedEvents.get() >= Uploader.getReportingBatchSize()) {
                JobScheduler.schedule(reportingUploadJob);
                return;
            }
            Uploader.setUploadState(UploadState.IDLE);
        }

        private static void clearNow() {
            logger.d("Reporting is clearing events");
            File[] eventsToUpload = Uploader.getEventsToUpload();
            if (eventsToUpload.length > 0) {
                Uploader.deleteUploadedEvents(eventsToUpload);
            }
            Uploader.setUploadState(UploadState.IDLE);
        }

        private static String getReportingBaseUrl() {
            return Configuration.getString(VerizonSSPReporter.VERIZON_SSP_DOMAIN, VerizonSSPReporter.REPORTING_BASE_URL_KEY, VerizonSSPReporter.DEFAULT_REPORTING_BASE_URL);
        }

        static {
            reportingUploadJob = new Job(){

                @Override
                public int getId() {
                    return 17;
                }

                @Override
                public long getDelay() {
                    return 0L;
                }

                @Override
                public void run() {
                    Uploader.uploadNow();
                }
            };
        }
    }

    static enum UploadState {
        IDLE,
        UPLOADING,
        ERROR_SENDING_TO_SERVER,
        CLEARING;

    }
}

