/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.verizonsspconfigprovider;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import com.verizon.ads.Configuration;
import com.verizon.ads.ConfigurationProvider;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.Plugin;
import com.verizon.ads.VASAds;
import com.verizon.ads.utils.HttpUtils;
import com.verizon.ads.utils.IOUtils;
import com.verizon.ads.verizonsspconfigprovider.JSONUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"DefaultLocale"})
public class VerizonSSPConfigProvider
implements ConfigurationProvider {
    private static final Logger logger = Logger.getInstance(VerizonSSPConfigProvider.class);
    private static final String WHO = VerizonSSPConfigProvider.class.getSimpleName();
    private static final int ERROR_PARSING = -1;
    private static final int ERROR_INVALID_VERSION = -2;
    private static final int ERROR_INCOMPATIBLE_VERSION = -3;
    private static final int ERROR_HTTP_REQUEST = -4;
    private static final int ERROR_BUSY = -5;
    private static final String VERIZON_ADS_DIRECTORY = "/.com.verizon.ads/";
    private static final String HANDSHAKE_VERSION = "1";
    private static final String HANDSHAKE_JSON = "handshake.json";
    private static final String HANDSHAKE_PATH = "/admax/sdk/handshake/1";
    private static final int MAX_HANDSHAKE_ATTEMPTS = 10;
    private static final int HANDSHAKE_REQUEST_TIMEOUT = 15000;
    private static final DomainInfo DOMAIN_VERIZON_ADS = new DomainInfo("com.verizon.ads", null);
    private static final DomainInfo DOMAIN_VERIZON_ADS_OMSDK = new DomainInfo("com.verizon.ads.omsdk", null);
    private static final DomainInfo DOMAIN_VERIZON_ADS_VERIZONSSP = new DomainInfo("com.verizon.ads.verizonssp", "verizon-ssp-config-key");
    private static final DomainInfo DOMAIN_VERIZON_ADS_CORE = new DomainInfo("com.verizon.ads.core", "vas-core-key");
    private static final DomainInfo DOMAIN_VERIZON_ADS_NATIVEPLACEMENT = new DomainInfo("com.verizon.ads.nativeplacement", null);
    private static final DomainInfo DOMAIN_VERIZON_ADS_INLINEPLACEMENT = new DomainInfo("com.verizon.ads.inlineplacement", null);
    private static final DomainInfo DOMAIN_VERIZON_ADS_INTERSTITIALPLACEMENT = new DomainInfo("com.verizon.ads.interstitialplacement", null);
    private static final DomainInfo DOMAIN_VERIZON_ADS_VAST = new DomainInfo("com.verizon.ads.vast", null);
    private static final DomainInfo DOMAIN_VERIZON_ADS_VPAID = new DomainInfo("com.verizon.ads.vpaid", null);
    private static final String KEY_HANDSHAKE_BASE_URL = "handshakeBaseUrl";
    private static final String KEY_EDITION_NAME = "editionName";
    private static final String KEY_EDITION_VERSION = "editionVersion";
    private static final String DEFAULT_HANDSHAKE_BASE_URL = "https://ads.nexage.com";
    private final File vasAdsDirectory;
    private final String appId;
    private int handshakeAttempts = 0;
    private AtomicBoolean requestInProgress = new AtomicBoolean(false);

    public VerizonSSPConfigProvider(Context context) {
        Context applicationContext = context.getApplicationContext();
        this.vasAdsDirectory = new File(applicationContext.getFilesDir() + VERIZON_ADS_DIRECTORY);
        this.appId = applicationContext.getPackageName();
    }

    static ErrorInfo processHandshake(String handshakeContent) {
        if (handshakeContent == null) {
            return new ErrorInfo(WHO, "Handshake content is null -- nothing to parse", -1);
        }
        if (Logger.isLogLevelEnabled(3)) {
            logger.d("Parsing handshake:\n" + handshakeContent);
        }
        try {
            int handshakeVersion;
            JSONObject handshakeJson = new JSONObject(handshakeContent);
            String version = handshakeJson.getString("ver");
            try {
                handshakeVersion = Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return new ErrorInfo(WHO, String.format("Handshake version is not a valid integer, %s", version), -2);
            }
            if (handshakeVersion > Integer.parseInt(HANDSHAKE_VERSION)) {
                return new ErrorInfo(WHO, String.format("Handshake response did not contain a compatible version. Received version, %d and expected max version of %s", handshakeVersion, HANDSHAKE_VERSION), -3);
            }
            JSONObject activePlaylistServerJson = handshakeJson.optJSONObject("playlistServer");
            String waterfallProviderClass = JSONUtils.optString(activePlaylistServerJson, "name");
            if ("orange".equalsIgnoreCase(waterfallProviderClass) || "green".equalsIgnoreCase(waterfallProviderClass)) {
                waterfallProviderClass = "com.verizon.ads.verizonsspwaterfallprovider.VerizonSSPWaterfallProvider";
            }
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS, "waterfallProviderClass", waterfallProviderClass);
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS, "waterfallProviderBaseUrl", JSONUtils.optString(activePlaylistServerJson, "baseUrl"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, KEY_HANDSHAKE_BASE_URL, JSONUtils.optString(handshakeJson, KEY_HANDSHAKE_BASE_URL));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "reportingBaseUrl", JSONUtils.optString(handshakeJson, "rptBaseUrl"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_CORE, "geoIpCheckUrl", JSONUtils.optString(handshakeJson, "geoIpCheckUrl"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_CORE, "locationRequiresConsentTtl", JSONUtils.optInteger(handshakeJson, "geoIpCheckTtl"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_CORE, "sdkEnabled", JSONUtils.optBoolean(handshakeJson, "sdkEnabled"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_CORE, "configurationProviderRefreshInterval", JSONUtils.optInteger(handshakeJson, "ttl"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "version", version);
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_INTERSTITIALPLACEMENT, "interstitialAdExpirationTimeout", JSONUtils.optInteger(handshakeJson, "instlExpDur"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_NATIVEPLACEMENT, "nativeAdExpirationTimeout", JSONUtils.optInteger(handshakeJson, "nativeExpDur"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_INLINEPLACEMENT, "inlineAdExpirationTimeout", JSONUtils.optInteger(handshakeJson, "inlineExpDur"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_INLINEPLACEMENT, "minInlineRefreshInterval", JSONUtils.optInteger(handshakeJson, "minInlineRefresh"));
            Integer minImpressionViewabilityPercent = JSONUtils.optInteger(handshakeJson, "minImpressionViewabilityPercent");
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_INLINEPLACEMENT, "minImpressionViewabilityPercent", minImpressionViewabilityPercent);
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_NATIVEPLACEMENT, "minImpressionViewabilityPercent", minImpressionViewabilityPercent);
            Integer minImpressionDuration = JSONUtils.optInteger(handshakeJson, "minImpressionDuration");
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_INLINEPLACEMENT, "minImpressionDuration", minImpressionDuration);
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_NATIVEPLACEMENT, "minImpressionDuration", minImpressionDuration);
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "reportingBatchFrequency", JSONUtils.optInteger(handshakeJson, "rptFreq"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "reportingBatchSize", JSONUtils.optInteger(handshakeJson, "rptBatchSize"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_INLINEPLACEMENT, "inlineAdRequestTimeout", JSONUtils.optInteger(handshakeJson, "inlineTmax"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_INTERSTITIALPLACEMENT, "interstitialAdRequestTimeout", JSONUtils.optInteger(handshakeJson, "instlTmax"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_NATIVEPLACEMENT, "nativeAdRequestTimeout", JSONUtils.optInteger(handshakeJson, "nativeTmax"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "clientMediationRequestTimeout", JSONUtils.optInteger(handshakeJson, "clientAdTmax"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "serverMediationRequestTimeout", JSONUtils.optInteger(handshakeJson, "serverAdTmax"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "exchangeRequestTimeout", JSONUtils.optInteger(handshakeJson, "exTmax"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "bidExpirationTimeout", JSONUtils.optInteger(handshakeJson, "saCacheTimeout"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VAST, "vastSkipRule", JSONUtils.optString(handshakeJson, "vastSkipRule"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VAST, "vastSkipOffsetMax", JSONUtils.optInteger(handshakeJson, "vastSkipOffsetMax"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VAST, "vastSkipOffsetMin", JSONUtils.optInteger(handshakeJson, "vastSkipOffsetMin"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VERIZONSSP, "config", JSONUtils.optString(handshakeJson, "config"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_OMSDK, "omsdkEnabled", JSONUtils.optBoolean(handshakeJson, "moatEnabled"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS, "autoPlayAudioEnabled", JSONUtils.optBoolean(handshakeJson, "autoPlayAudioEnabled"));
            JSONObject vpaid = handshakeJson.optJSONObject("vpaid");
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VPAID, "vpaidStartAdTimeout", JSONUtils.optInteger(vpaid, "startAdTimeout"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VPAID, "vpaidSkipAdTimeout", JSONUtils.optInteger(vpaid, "skipAdTimeout"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VPAID, "vpaidAdUnitTimeout", JSONUtils.optInteger(vpaid, "adUnitTimeout"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VPAID, "vpaidHtmlEndCardTimeout", JSONUtils.optInteger(vpaid, "htmlEndCardTimeout"));
            VerizonSSPConfigProvider.setConfigValue(DOMAIN_VERIZON_ADS_VPAID, "vpaidMaxBackButtonDelay", JSONUtils.optInteger(vpaid, "maxBackButtonDelay"));
            logger.d("Handshake successfully parsed");
        }
        catch (JSONException e) {
            logger.d("An error occurred parsing the handshake", e);
            return new ErrorInfo(WHO, "An error occurred parsing the handshake response", -1);
        }
        return null;
    }

    private static void setConfigValue(DomainInfo domainInfo, String key, Object value) {
        Configuration.set(value, domainInfo.domain, key, domainInfo.securityKey);
    }

    public static boolean isConfigProviderEnabled() {
        return Configuration.getBoolean(VerizonSSPConfigProvider.DOMAIN_VERIZON_ADS_VERIZONSSP.domain, "configProviderEnabled", true);
    }

    public boolean prepare() {
        try {
            if (Configuration.protectDomain(VerizonSSPConfigProvider.DOMAIN_VERIZON_ADS_VERIZONSSP.domain, VerizonSSPConfigProvider.DOMAIN_VERIZON_ADS_VERIZONSSP.securityKey)) {
                return true;
            }
            logger.e(String.format("An error occurred while attempting to protect the domain '%s'.", VerizonSSPConfigProvider.DOMAIN_VERIZON_ADS_VERIZONSSP.domain));
            return false;
        }
        catch (Exception e) {
            logger.e(String.format("An exception occurred while attempting to protect the domain '%s'.", VerizonSSPConfigProvider.DOMAIN_VERIZON_ADS_VERIZONSSP.domain), e);
            return false;
        }
    }

    @Override
    public String getId() {
        return VerizonSSPConfigProvider.class.getSimpleName();
    }

    @Override
    public void update(final ConfigurationProvider.UpdateListener updateListener) {
        logger.d("Processing configuration update request");
        boolean setSuccessful = this.requestInProgress.compareAndSet(false, true);
        if (!setSuccessful) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "Handshake request already in progress", -5);
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(errorInfo.toString());
            }
            if (updateListener != null) {
                updateListener.onComplete(this, errorInfo);
            }
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                HttpUtils.Response response;
                ErrorInfo errorInfo;
                String handshakeUrl = null;
                if (VerizonSSPConfigProvider.this.handshakeAttempts < 10) {
                    handshakeUrl = Configuration.getString(DOMAIN_VERIZON_ADS_VERIZONSSP.domain, VerizonSSPConfigProvider.KEY_HANDSHAKE_BASE_URL, VerizonSSPConfigProvider.DEFAULT_HANDSHAKE_BASE_URL);
                }
                if (handshakeUrl == null) {
                    handshakeUrl = VerizonSSPConfigProvider.DEFAULT_HANDSHAKE_BASE_URL;
                }
                handshakeUrl = handshakeUrl.concat(VerizonSSPConfigProvider.HANDSHAKE_PATH);
                VerizonSSPConfigProvider.this.handshakeAttempts++;
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d(String.format("Requesting handshake from '%s' - attempt %d", handshakeUrl, VerizonSSPConfigProvider.this.handshakeAttempts));
                }
                if ((errorInfo = (response = VerizonSSPConfigProvider.this.requestHandshake(handshakeUrl)) == null ? new ErrorInfo(WHO, "No response from handshake HTTP request", -4) : (response.code != 200 ? new ErrorInfo(WHO, String.format("Handshake request failed with HTTP response code: %d", response.code), -4) : VerizonSSPConfigProvider.processHandshake(response.content))) == null) {
                    VerizonSSPConfigProvider.this.saveHandshakeToFile(response.content);
                    VerizonSSPConfigProvider.this.handshakeAttempts = 0;
                } else if (Logger.isLogLevelEnabled(3)) {
                    logger.d(errorInfo.toString());
                }
                VerizonSSPConfigProvider.this.requestInProgress.set(false);
                if (updateListener != null) {
                    updateListener.onComplete(VerizonSSPConfigProvider.this, errorInfo);
                }
            }
        };
        thread.start();
    }

    public void restoreHandshakeValues() {
        String handshake = this.loadHandshakeFromFile();
        if (handshake != null) {
            logger.d("Restoring from saved handshake file");
            VerizonSSPConfigProvider.processHandshake(handshake);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    String loadHandshakeFromFile() {
        logger.d("Loading handshake file");
        String handshake = null;
        FileInputStream inputStream = null;
        try {
            File file = new File(this.vasAdsDirectory, HANDSHAKE_JSON);
            inputStream = new FileInputStream(file);
            handshake = IOUtils.read((InputStream)inputStream, "UTF-8");
        }
        catch (FileNotFoundException e) {
            logger.i(String.format("Saved handshake '%s' does not exists", HANDSHAKE_JSON));
            IOUtils.closeStream(inputStream);
        }
        catch (IOException e2) {
            logger.e(String.format("Could not read handshake '%s", HANDSHAKE_JSON), e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeStream(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeStream(inputStream);
        }
        IOUtils.closeStream(inputStream);
        return handshake;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHandshakeToFile(String handshakeContent) {
        logger.d("Saving handshake file");
        FileOutputStream outputStream = null;
        try {
            this.vasAdsDirectory.mkdirs();
            File file = new File(this.vasAdsDirectory, HANDSHAKE_JSON);
            outputStream = new FileOutputStream(file);
            IOUtils.write(outputStream, handshakeContent);
            IOUtils.closeStream(outputStream);
        }
        catch (IOException e) {
            logger.e("Could not write handshake handshake.json", e);
        }
        finally {
            IOUtils.closeStream(outputStream);
        }
    }

    HttpUtils.Response requestHandshake(String handshakeUrl) {
        try {
            JSONObject requestParams = this.getHandshakeJSON();
            String requestParamsString = requestParams.toString();
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Requesting handshake.\n\tattempt: %d\n\turl: %s\n\tpost data: %s", this.handshakeAttempts, handshakeUrl, requestParamsString));
            }
            return HttpUtils.getContentFromPostRequest(handshakeUrl, requestParamsString, "application/json", 15000);
        }
        catch (JSONException e) {
            logger.e("Cannot build the handshake request data", e);
            return null;
        }
    }

    JSONObject getHandshakeJSON() throws JSONException {
        JSONObject requestParams = new JSONObject();
        JSONObject sdkInfo = new JSONObject();
        String editionName = Configuration.getString(VerizonSSPConfigProvider.DOMAIN_VERIZON_ADS.domain, KEY_EDITION_NAME, null);
        String editionVersion = Configuration.getString(VerizonSSPConfigProvider.DOMAIN_VERIZON_ADS.domain, KEY_EDITION_VERSION, null);
        if (editionName != null && editionVersion != null) {
            String editionInfo = String.format("%s-%s", editionName, editionVersion);
            requestParams.put("sdkVer", (Object)editionInfo);
            sdkInfo.put("editionId", (Object)editionInfo);
        } else {
            requestParams.put("sdkVer", (Object)String.format("core-%s", VASAds.getSDKInfo().version));
        }
        requestParams.put("ver", (Object)HANDSHAKE_VERSION);
        requestParams.put("os", (Object)"android");
        requestParams.put("osv", (Object)Build.VERSION.RELEASE);
        requestParams.put("appId", (Object)this.appId);
        sdkInfo.put("coreVer", (Object)VASAds.getSDKInfo().version);
        Set<Plugin> registeredPlugins = VASAds.getRegisteredPlugins();
        if (!registeredPlugins.isEmpty()) {
            JSONObject sdkPlugins = new JSONObject();
            for (Plugin registeredPlugin : registeredPlugins) {
                JSONObject jsonRegisteredPlugin = new JSONObject();
                jsonRegisteredPlugin.put("name", (Object)registeredPlugin.getName());
                jsonRegisteredPlugin.put("version", (Object)registeredPlugin.getVersion());
                jsonRegisteredPlugin.put("author", (Object)registeredPlugin.getAuthor());
                if (registeredPlugin.getEmail() != null) {
                    jsonRegisteredPlugin.put("email", (Object)registeredPlugin.getEmail().toString());
                }
                if (registeredPlugin.getWebsite() != null) {
                    jsonRegisteredPlugin.put("website", (Object)registeredPlugin.getWebsite().toString());
                }
                jsonRegisteredPlugin.put("minApiLevel", registeredPlugin.getMinApiLevel());
                jsonRegisteredPlugin.put("enabled", VASAds.isPluginEnabled(registeredPlugin.getId()));
                sdkPlugins.put(registeredPlugin.getId(), (Object)jsonRegisteredPlugin);
            }
            sdkInfo.put("sdkPlugins", (Object)sdkPlugins);
        }
        requestParams.put("sdkInfo", (Object)sdkInfo);
        return requestParams;
    }

    static class DomainInfo {
        final String domain;
        final String securityKey;

        DomainInfo(String domain, String securityKey) {
            this.domain = domain;
            this.securityKey = securityKey;
        }
    }
}

