/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.verizon.ads.ActivityStateManager;
import com.verizon.ads.AdAdapter;
import com.verizon.ads.AdAdapterRegistration;
import com.verizon.ads.AdContent;
import com.verizon.ads.AdRequest;
import com.verizon.ads.AdRequestHandler;
import com.verizon.ads.AdSession;
import com.verizon.ads.Bid;
import com.verizon.ads.BidRequestListener;
import com.verizon.ads.Component;
import com.verizon.ads.ComponentRegistry;
import com.verizon.ads.Configuration;
import com.verizon.ads.ConfigurationProvider;
import com.verizon.ads.ConfigurationProviderRegistration;
import com.verizon.ads.ContentFilter;
import com.verizon.ads.EnvironmentInfo;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.Plugin;
import com.verizon.ads.PrivacyDataHelper;
import com.verizon.ads.RequestMetadata;
import com.verizon.ads.SDKInfo;
import com.verizon.ads.WaterfallProvider;
import com.verizon.ads.events.EventReceiver;
import com.verizon.ads.events.Events;
import com.verizon.ads.sideloadingwaterfallprovider.SideloadingWaterfallProvider;
import com.verizon.ads.utils.IOUtils;
import com.verizon.ads.utils.TextUtils;
import com.verizon.ads.utils.VASAdsSSLSocketFactory;
import com.verizon.ads.verizonsspconfigprovider.VerizonSSPConfigProvider;
import com.verizon.ads.verizonsspconfigprovider.VerizonSSPConfigProviderPlugin;
import com.verizon.ads.verizonsspreporter.VerizonSSPReporter;
import com.verizon.ads.verizonsspwaterfallprovider.VerizonSSPWaterfallProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public final class VASAds {
    public static final String COLLECTION_MODE = "collectionMode";
    public static final String COLLECT = "Collect";
    public static final String DO_NOT_COLLECT = "DoNotCollect";
    public static final int API_LEVEL = 1;
    public static final int ERROR_NO_FILL = -1;
    public static final int ERROR_AD_REQUEST_TIMED_OUT = -2;
    public static final int ERROR_AD_REQUEST_FAILED = -3;
    public static final String DOMAIN = "com.verizon.ads.core";
    public static final String LOCATION_ENABLED_KEY = "locationEnabled";
    public static final String USER_PRIVACY_DATA_KEY = "userPrivacyData";
    public static final String LOCATION_REQUIRES_CONSENT_KEY = "locationRequiresConsent";
    public static final String IAB_CONSENT_KEY = "iab";
    public static final String ANONYMOUS_USER_KEY = "anonymousUser";
    public static final String SDK_ENABLED_KEY = "sdkEnabled";
    static final String DEFAULT_GEO_IP_CHECK_URL = "https://service.cmp.oath.com/cmp/v0/location/eu";
    static final String GEO_IP_CHECK_URL_KEY = "geoIpCheckUrl";
    static final String LOCATION_REQUIRES_CONSENT_TTL_KEY = "locationRequiresConsentTtl";
    static final int DEFAULT_LOCATION_REQUIRES_CONSENT_TTL = 86400000;
    static final int DEFAULT_CONFIGURATION_PROVIDER_REFRESH_INTERVAL = 86400000;
    private static final Logger logger = Logger.getInstance(VASAds.class);
    private static final ConfigurationProvider.UpdateListener configProviderUpdateListener = new ConfigurationProvider.UpdateListener(){

        @Override
        public void onComplete(ConfigurationProvider configurationProvider, ErrorInfo errorInfo) {
            if (errorInfo != null) {
                logger.e(String.format("An error occurred while updating configuration provider <%s>. Error Info: %s", configurationProvider.getId(), errorInfo));
            } else if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Successfully updated configuration provider <%s>", configurationProvider.getId()));
            }
        }
    };
    private static final List<ConfigurationProviderRegistration> registeredConfigurationProviders;
    private static final Map<String, RegisteredPlugin> registeredPlugins;
    private static final List<AdAdapterRegistration> adAdapterRegistrations;
    private static final SDKInfo sdkInfo;
    private static final HandlerThread handlerThread;
    private static final AdRequestHandler adRequestHandler;
    private static final Handler coreHandler;
    private static final Handler locationHandler;
    private static final String SECURITY_KEY = "vas-core-key";
    private static final String COPPA_KEY = "coppa";
    private static final String SHARE_APPLICATION_ID_KEY = "shareApplicationId";
    private static final String SHARE_ADVERTISER_ID_KEY = "shareAdvertiserId";
    private static final int HTTP_CONNECT_TIMEOUT = 10000;
    private static final int HTTP_READ_TIMEOUT = 10000;
    private static final String CONFIGURATION_PROVIDER_REFRESH_INTERVAL_KEY = "configurationProviderRefreshInterval";
    private static final String WHO;
    private static VerizonSSPReporter verizonSSPReporter;
    public static final String REQUEST_FACTORY_REF = "request.factoryRef";
    public static final String REQUEST_PLACEMENT_REF = "request.placementRef";
    public static final String REQUEST_REQUEST_METADATA = "request.requestMetadata";
    public static final String REQUEST_REQUESTER_CLASS = "request.requesterClass";
    public static final String RESPONSE_WATERFALL = "response.waterfall";
    public static final String RESPONSE_WATERFALL_ITEM = "response.waterfallItem";
    private static final AtomicBoolean locationRequestInProgress;
    private static final int CONFIGURATION_CHANGE_LOCATION_UPDATE_DELAY = 5000;
    static WeakReference<Application> applicationWeakReference;
    private static volatile RequestMetadata requestMetadata;
    private static boolean initialized;
    private static String siteId;
    private static ExecutorService executorService;
    private static ActivityStateManager activityStateManager;
    private static WeakReference<Context> applicationContextRef;

    public static void requestAds(Context context, Class adRequesterClass, RequestMetadata requestMetadata, int numberOfAds, int timeout, AdRequestListener adRequestListener) {
        if (context == null) {
            logger.e("context cannot be null.");
            return;
        }
        if (adRequestListener == null) {
            logger.e("adRequestListener cannot be null.");
            return;
        }
        if (!VASAds.isInitialized()) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "VASAds SDK must be initialized before requesting ads.", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        boolean isEnabled = Configuration.getBoolean(DOMAIN, SDK_ENABLED_KEY, true);
        if (!isEnabled) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "VASAds SDK is disabled.", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        if (numberOfAds < 1) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "numberOfAds must be greater than zero", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        WaterfallProvider waterfallProvider = VASAds.getWaterfallProvider(context, requestMetadata);
        if (waterfallProvider != null) {
            VASAds.requestAds(adRequesterClass, waterfallProvider, null, requestMetadata, numberOfAds, timeout, adRequestListener);
        } else {
            adRequestListener.onAdReceived(null, new ErrorInfo(WHO, "The default waterfall provider factory is either not registered or did not provide a valid waterfall provider instance.", -1), true);
        }
    }

    public static void requestBid(Context context, RequestMetadata requestMetadata, int timeout, final BidRequestListener bidRequestListener) {
        Map<String, Object> placementData;
        Object overrideWaterfallProviderId;
        if (context == null) {
            logger.e("context cannot be null.");
            return;
        }
        if (bidRequestListener == null) {
            logger.e("bidRequestListener cannot be null.");
            return;
        }
        if (!VASAds.isInitialized()) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "VASAds SDK must be initialized before requesting bids.", -3);
            logger.e(errorInfo.toString());
            bidRequestListener.onComplete(null, errorInfo);
            return;
        }
        boolean isEnabled = Configuration.getBoolean(DOMAIN, SDK_ENABLED_KEY, true);
        if (!isEnabled) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "VASAds SDK is disabled.", -3);
            logger.e(errorInfo.toString());
            bidRequestListener.onComplete(null, errorInfo);
            return;
        }
        Component waterfallProvider = null;
        String waterfallProviderId = null;
        if (requestMetadata != null && requestMetadata.getPlacementData() != null && (overrideWaterfallProviderId = (placementData = requestMetadata.getPlacementData()).get("overrideWaterfallProvider")) != null) {
            waterfallProviderId = overrideWaterfallProviderId.toString();
            waterfallProvider = ComponentRegistry.getComponent(waterfallProviderId, context, null, null);
        }
        if (!(waterfallProvider instanceof WaterfallProvider)) {
            waterfallProviderId = Configuration.getString(DOMAIN, "defaultWaterfallProvider", null);
            if (waterfallProviderId != null) {
                waterfallProvider = ComponentRegistry.getComponent(waterfallProviderId, context, null, null);
            } else {
                logger.e("No default waterfall provider registered in Configuration.");
                waterfallProviderId = null;
            }
        }
        if (waterfallProvider instanceof WaterfallProvider) {
            final String resolvedWaterfallProviderId = waterfallProviderId;
            AdSession adSession = new AdSession();
            adSession.put(REQUEST_REQUEST_METADATA, (Object)requestMetadata);
            ((WaterfallProvider)waterfallProvider).requestBid(adSession, timeout, new BidRequestListener(){

                @Override
                public void onComplete(Bid bid, ErrorInfo errorInfo) {
                    if (bid != null) {
                        bid.waterfallProviderId = resolvedWaterfallProviderId;
                    }
                    bidRequestListener.onComplete(bid, errorInfo);
                }
            });
        } else {
            bidRequestListener.onComplete(null, new ErrorInfo(WHO, "The default waterfall provider factory is either not registered or did not provide a valid waterfall provider instance.", -1));
        }
    }

    public static void requestAd(Context context, Bid bid, Class adRequesterClass, int timeout, AdRequestListener adRequestListener) {
        if (context == null) {
            logger.e("context cannot be null.");
            return;
        }
        if (adRequestListener == null) {
            logger.e("adRequestListener cannot be null.");
            return;
        }
        if (!VASAds.isInitialized()) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "VASAds SDK must be initialized before requesting ads.", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        boolean isEnabled = Configuration.getBoolean(DOMAIN, SDK_ENABLED_KEY, true);
        if (!isEnabled) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "VASAds SDK is disabled.", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        if (bid == null) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "bid cannot be null", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        Component waterfallProvider = ComponentRegistry.getComponent(bid.waterfallProviderId, context, null, null);
        if (waterfallProvider instanceof WaterfallProvider) {
            VASAds.requestAds(adRequesterClass, (WaterfallProvider)waterfallProvider, bid, null, 0, timeout, adRequestListener);
        } else {
            adRequestListener.onAdReceived(null, new ErrorInfo(WHO, "The waterfall provider factory is either not registered or did not provide a valid waterfall provider instance.", -1), true);
        }
    }

    static void registerConfigurationProvider(String pluginId, ConfigurationProvider configurationProvider) {
        if (TextUtils.isEmpty(pluginId)) {
            logger.e("The pluginId parameter cannot be null or empty.");
            return;
        }
        if (configurationProvider == null) {
            logger.e("The configurationProvider parameter cannot be null");
            return;
        }
        ConfigurationProviderRegistration configurationProviderRegistration = new ConfigurationProviderRegistration(pluginId, configurationProvider);
        registeredConfigurationProviders.add(configurationProviderRegistration);
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Registered configuration provider <%s>", configurationProvider.getId()));
        }
        if (VASAds.isInitialized()) {
            configurationProviderRegistration.update(configProviderUpdateListener);
        }
    }

    static void registerAdAdapter(String pluginId, Class adRequesterClass, Class<? extends AdAdapter> adAdapterClass, ContentFilter contentFilter) {
        if (TextUtils.isEmpty(pluginId)) {
            logger.e("The pluginId parameter cannot be null or empty.");
            return;
        }
        if (adRequesterClass == null) {
            logger.e("The adRequesterClass parameter cannot be null.");
            return;
        }
        if (adAdapterClass == null) {
            logger.e("The adAdapter parameter cannot be null.");
            return;
        }
        if (contentFilter == null) {
            logger.e("The contentFilter parameter cannot be null.");
            return;
        }
        adAdapterRegistrations.add(0, new AdAdapterRegistration(pluginId, adRequesterClass, adAdapterClass, contentFilter));
    }

    public static ActivityStateManager getActivityStateManager() {
        return activityStateManager;
    }

    public static boolean registerPlugin(Plugin plugin, boolean enabled) {
        if (plugin == null) {
            logger.e("plugin cannot be null.");
            return false;
        }
        if (!plugin.validate()) {
            logger.e(String.format("Plugin %s is invalid. Additional details can be found in the log.", plugin));
            return false;
        }
        if (1 < plugin.minApiLevel) {
            logger.e(String.format("Plugin[%s] requires core min api level = %d, actual core api level = %d", plugin.name, plugin.minApiLevel, 1));
            return false;
        }
        if (registeredPlugins.containsKey(plugin.id)) {
            logger.e(String.format("A plugin with id = %s is already registered.", plugin.id));
            return false;
        }
        boolean success = false;
        try {
            success = plugin.prepare();
        }
        catch (Throwable t) {
            logger.e(String.format("An error occurred preparing plugin %s", plugin), t);
        }
        if (success) {
            registeredPlugins.put(plugin.id, new RegisteredPlugin(plugin));
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Registered %s", plugin));
            }
            if (enabled) {
                VASAds.enablePlugin(plugin.id);
            }
        } else {
            logger.e(String.format("Prepare plugin %s failed", plugin));
        }
        return success;
    }

    public static Set<Plugin> getRegisteredPlugins() {
        Collection<RegisteredPlugin> registeredPluginsValues = registeredPlugins.values();
        HashSet<Plugin> plugins = new HashSet<Plugin>(registeredPluginsValues.size());
        for (RegisteredPlugin registeredPlugin : registeredPluginsValues) {
            plugins.add(registeredPlugin.plugin);
        }
        return Collections.unmodifiableSet(plugins);
    }

    public static void enablePlugin(String id) {
        if (TextUtils.isEmpty(id)) {
            logger.e("id cannot be null or empty.");
            return;
        }
        RegisteredPlugin registeredPlugin = registeredPlugins.get(id);
        if (registeredPlugin == null) {
            logger.e(String.format("No registered plugin exists with id = %s", id));
            return;
        }
        if (registeredPlugin.enabled) {
            logger.i(String.format("Plugin with id = %s is already enabled", id));
            return;
        }
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Enabling plugin %s", registeredPlugin.plugin));
        }
        registeredPlugin.enabled = true;
        registeredPlugin.plugin.onPluginEnabled();
    }

    public static void disablePlugin(String id) {
        if (TextUtils.isEmpty(id)) {
            logger.e("id cannot be null or empty.");
            return;
        }
        RegisteredPlugin registeredPlugin = registeredPlugins.get(id);
        if (registeredPlugin == null) {
            logger.e(String.format("No registered plugin exists with id = %s", id));
            return;
        }
        if (!registeredPlugin.enabled) {
            logger.i(String.format("Plugin with id = %s is already disabled", id));
            return;
        }
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Disabling plugin %s", registeredPlugin.plugin));
        }
        registeredPlugin.enabled = false;
        registeredPlugin.plugin.onPluginDisabled();
    }

    public static boolean isPluginEnabled(String id) {
        if (TextUtils.isEmpty(id)) {
            logger.e("id cannot be null or empty.");
            return false;
        }
        RegisteredPlugin registeredPlugin = registeredPlugins.get(id);
        if (registeredPlugin == null) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("No registered plugin with id = %s", id));
            }
            return false;
        }
        return registeredPlugin.enabled;
    }

    public static synchronized boolean initialize(final Application application, String siteId) {
        if (initialized) {
            if (VASAds.siteId.equals(siteId)) {
                logger.w("Verizon Ads SDK already initialized");
                return true;
            }
            logger.e("Attempt to reinitialize the Verizon Ads SDK with a new site ID.");
            return false;
        }
        if (siteId == null) {
            logger.e("The site ID cannot be null");
            return false;
        }
        logger.d("Initializing Verizon Ads SDK");
        try {
            if (Configuration.protectDomain(DOMAIN, SECURITY_KEY)) {
                initialized = true;
                VASAds.siteId = siteId;
                applicationContextRef = new WeakReference<Context>(application.getApplicationContext());
                VASAds.registerCoreComponents();
                VASAds.registerCoreConfigProvider(application);
                VASAds.initializeCoreReporter(application);
                VASAds.subscribeForConfigChanges();
                VASAds.scheduleNextLocationUpdate(0, true);
                activityStateManager = new ActivityStateManager(application);
                applicationWeakReference = new WeakReference<Application>(application);
                coreHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        EnvironmentInfo.loadAdvertisingInfo(application.getApplicationContext());
                    }
                });
                coreHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        VASAds.updateConfigurationProviders();
                        VASAds.scheduleNextConfigurationUpdate(this);
                    }
                });
                return true;
            }
            logger.e("An error occurred while attempting to protect the core domain.");
            return false;
        }
        catch (Exception e) {
            logger.e("An exception occurred while attempting to protect the core domain.", e);
            return false;
        }
    }

    static void scheduleNextConfigurationUpdate(Runnable runnable) {
        coreHandler.postDelayed(runnable, (long)Configuration.getInt(DOMAIN, CONFIGURATION_PROVIDER_REFRESH_INTERVAL_KEY, 86400000));
    }

    static void scheduleNextLocationUpdate(int delay, boolean async) {
        locationHandler.removeCallbacks(null);
        if (async) {
            locationHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VASAds.fetchUserLocationRequiresConsentStatus(true);
                }
            }, (long)delay);
        } else {
            VASAds.fetchUserLocationRequiresConsentStatus(false);
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    static int getLocationRequiresConsentTtl() {
        int locationRequiresConsentTtl = Configuration.getInt(DOMAIN, LOCATION_REQUIRES_CONSENT_TTL_KEY, 86400000);
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Configuration location requires consent ttl: %d", locationRequiresConsentTtl));
        }
        return locationRequiresConsentTtl;
    }

    static Context getApplicationContext() {
        return applicationContextRef != null ? (Context)applicationContextRef.get() : null;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static SDKInfo getSDKInfo() {
        return sdkInfo;
    }

    public static String getSiteId() {
        return siteId;
    }

    public static void setLocationEnabled(boolean locationEnabled) {
        Configuration.setBoolean(locationEnabled, DOMAIN, LOCATION_ENABLED_KEY, SECURITY_KEY);
    }

    public static boolean isLocationEnabled() {
        return Configuration.getBoolean(DOMAIN, LOCATION_ENABLED_KEY, true);
    }

    public static void setLogLevel(int logLevel) {
        Logger.setLogLevel(logLevel);
    }

    public static int getLogLevel() {
        return Logger.getLogLevel();
    }

    public static void setRequestMetadata(RequestMetadata requestMetadata) {
        VASAds.requestMetadata = requestMetadata;
    }

    public static RequestMetadata getRequestMetadata() {
        return requestMetadata;
    }

    public static void setPrivacyData(Map<String, Object> privacyData) {
        Configuration.set(privacyData, DOMAIN, USER_PRIVACY_DATA_KEY, SECURITY_KEY);
        VASAds.setUserAnonymousConfigValue();
    }

    public static boolean isAnonymous() {
        return Configuration.getBoolean(DOMAIN, ANONYMOUS_USER_KEY, true);
    }

    public static void setCoppa(boolean compliance) {
        Configuration.setBoolean(compliance, DOMAIN, COPPA_KEY, SECURITY_KEY);
    }

    public static Boolean getCoppa() {
        return Configuration.get(DOMAIN, COPPA_KEY, Boolean.class, null);
    }

    public static boolean isShareAdvertiserIdEnabled() {
        return Configuration.getBoolean(DOMAIN, SHARE_ADVERTISER_ID_KEY, false);
    }

    public static void setShareAdvertiserIdEnabled(boolean shareAdvertiserIdEnabled) {
        Configuration.setBoolean(shareAdvertiserIdEnabled, DOMAIN, SHARE_ADVERTISER_ID_KEY, SECURITY_KEY);
    }

    public static boolean isShareApplicationIdEnabled() {
        return Configuration.getBoolean(DOMAIN, SHARE_APPLICATION_ID_KEY, false);
    }

    public static void setShareApplicationIdEnabled(boolean shareApplicationIdEnabled) {
        Configuration.setBoolean(shareApplicationIdEnabled, DOMAIN, SHARE_APPLICATION_ID_KEY, SECURITY_KEY);
    }

    public static String getBiddingToken(Context context, RequestMetadata requestMetadata) {
        WaterfallProvider waterfallProvider = VASAds.getWaterfallProvider(context, requestMetadata);
        if (waterfallProvider == null) {
            return null;
        }
        return waterfallProvider.getBiddingToken(requestMetadata);
    }

    static AdAdapter getAdAdapter(Class adRequesterClass, AdContent adContent) {
        Class<? extends AdAdapter> adAdapterClass = null;
        for (AdAdapterRegistration registration : adAdapterRegistrations) {
            if (!registration.matches(adRequesterClass, adContent)) continue;
            adAdapterClass = registration.adAdapterClass;
            break;
        }
        if (adAdapterClass != null) {
            try {
                return (AdAdapter)adAdapterClass.newInstance();
            }
            catch (Throwable t) {
                logger.e(String.format("Unable to instantiate AdAdapter class: %s", adAdapterClass.getName()), t);
            }
        }
        return null;
    }

    private static void requestAds(Class adRequesterClass, WaterfallProvider waterfallProvider, Bid bid, RequestMetadata requestMetadata, int numberOfAds, int timeout, AdRequestListener adRequestListener) {
        AdSession[] adSessions;
        RequestMetadata actualRequestMetadata;
        if (adRequestListener == null) {
            logger.e("adRequestListener cannot be null.");
            return;
        }
        if (adRequesterClass == null) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "adRequesterClass cannot be null", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        if (waterfallProvider == null) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "waterfallProvider cannot be null", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        if (timeout < 1) {
            ErrorInfo errorInfo = new ErrorInfo(WHO, "timeout must be greater than zero", -3);
            logger.e(errorInfo.toString());
            adRequestListener.onAdReceived(null, errorInfo, true);
            return;
        }
        RequestMetadata requestMetadata2 = actualRequestMetadata = requestMetadata != null ? requestMetadata : VASAds.getRequestMetadata();
        if (bid == null) {
            adSessions = new AdSession[numberOfAds];
            for (int i = 0; i < numberOfAds; ++i) {
                adSessions[i] = new AdSession();
            }
        } else {
            adSessions = new AdSession[]{bid.adSession};
        }
        for (AdSession adSession : adSessions) {
            adSession.put(REQUEST_REQUEST_METADATA, (Object)actualRequestMetadata);
            adSession.put(REQUEST_REQUESTER_CLASS, (Object)adRequesterClass);
            adRequestListener.prepare(adSession);
        }
        AdRequest adRequest = new AdRequest(waterfallProvider, bid, adSessions, timeout, adRequestListener);
        adRequestHandler.requestAds(adRequest);
    }

    static void fetchUserLocationRequiresConsentStatus(final boolean async) {
        Runnable fetchRunnable = new Runnable(){

            @Override
            public void run() {
                boolean setSuccessful = locationRequestInProgress.compareAndSet(false, true);
                if (!setSuccessful) {
                    logger.d("Location request already in progress");
                    return;
                }
                String response = VASAds.getGeoIpCheckURLResponse();
                if (response != null) {
                    try {
                        JSONObject jsonObject = new JSONObject(response);
                        boolean result = jsonObject.getBoolean("result");
                        if (Logger.isLogLevelEnabled(3)) {
                            logger.d(String.format("Location requires consent = %b", result));
                        }
                        Configuration.set(result, VASAds.DOMAIN, VASAds.LOCATION_REQUIRES_CONSENT_KEY, VASAds.SECURITY_KEY);
                        VASAds.setUserAnonymousConfigValue();
                    }
                    catch (JSONException e) {
                        logger.e("An exception occurred parsing response from privacy server", e);
                    }
                }
                locationRequestInProgress.set(false);
                VASAds.scheduleNextLocationUpdate(VASAds.getLocationRequiresConsentTtl(), async);
            }
        };
        if (async) {
            executorService.execute(fetchRunnable);
        } else {
            fetchRunnable.run();
        }
    }

    static void subscribeForConfigChanges() {
        Events.subscribe(new EventReceiver(){

            @Override
            protected void onEvent(String topic, Object data) {
                VASAds.handleConfigurationChangeEvent((Configuration.ConfigurationChangeEvent)data, true);
            }
        }, "com.verizon.ads.configuration.change");
    }

    private static void registerCoreComponents() {
        ComponentRegistry.registerComponent("waterfallprovider/sideloading", new SideloadingWaterfallProvider.Factory());
        ComponentRegistry.registerComponent("waterfallprovider/verizonssp", new VerizonSSPWaterfallProvider.Factory());
    }

    private static void registerCoreConfigProvider(Application application) {
        VASAds.registerPlugin(new VerizonSSPConfigProviderPlugin((Context)application), VerizonSSPConfigProvider.isConfigProviderEnabled());
    }

    private static void initializeCoreReporter(Application application) {
        verizonSSPReporter = new VerizonSSPReporter((Context)application);
    }

    static void handleConfigurationChangeEvent(Configuration.ConfigurationChangeEvent event, boolean async) {
        if (DOMAIN.equals(event.domain) && (GEO_IP_CHECK_URL_KEY.equals(event.key) || LOCATION_REQUIRES_CONSENT_TTL_KEY.equals(event.key))) {
            VASAds.scheduleNextLocationUpdate(5000, async);
        }
    }

    static void setUserAnonymousConfigValue() {
        Map privacyData = Configuration.getMap(DOMAIN, USER_PRIVACY_DATA_KEY, null);
        PrivacyDataHelper privacyDataHelper = new PrivacyDataHelper(privacyData);
        String collectionMode = privacyDataHelper.getCollectionMode();
        if (COLLECT.equalsIgnoreCase(collectionMode)) {
            Configuration.set(false, DOMAIN, ANONYMOUS_USER_KEY, SECURITY_KEY);
            return;
        }
        if (DO_NOT_COLLECT.equalsIgnoreCase(collectionMode)) {
            Configuration.set(true, DOMAIN, ANONYMOUS_USER_KEY, SECURITY_KEY);
            return;
        }
        boolean locationRequiresConsent = Configuration.getBoolean(DOMAIN, LOCATION_REQUIRES_CONSENT_KEY, true);
        if (!locationRequiresConsent) {
            Configuration.set(false, DOMAIN, ANONYMOUS_USER_KEY, SECURITY_KEY);
            return;
        }
        Map<?, ?> consentMap = privacyDataHelper.getGDPRConsentMap();
        boolean gdprConsent = consentMap != null && !consentMap.isEmpty();
        Configuration.set(!gdprConsent, DOMAIN, ANONYMOUS_USER_KEY, SECURITY_KEY);
    }

    static void updateConfigurationProviders() {
        for (ConfigurationProviderRegistration configurationProviderRegistration : registeredConfigurationProviders) {
            configurationProviderRegistration.update(configProviderUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getGeoIpCheckURLResponse() {
        InputStream inputStream;
        HttpURLConnection httpURLConnection;
        block11: {
            String string;
            block10: {
                String geoIpCheckURL = Configuration.getString(DOMAIN, GEO_IP_CHECK_URL_KEY, DEFAULT_GEO_IP_CHECK_URL);
                if (geoIpCheckURL == null) return null;
                httpURLConnection = null;
                inputStream = null;
                try {
                    URL url = new URL(geoIpCheckURL);
                    httpURLConnection = (HttpURLConnection)url.openConnection();
                    if (httpURLConnection instanceof HttpsURLConnection) {
                        logger.d("HttpsURLConnection created. Setting custom SSLSocketFactory.");
                        VASAdsSSLSocketFactory socketFactory = VASAdsSSLSocketFactory.getInstance();
                        if (socketFactory != null) {
                            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(socketFactory);
                        }
                    }
                    httpURLConnection.setConnectTimeout(10000);
                    httpURLConnection.setReadTimeout(10000);
                    int responseCode = httpURLConnection.getResponseCode();
                    if (responseCode == 200) {
                        inputStream = httpURLConnection.getInputStream();
                        string = IOUtils.read(inputStream, (String)null);
                        IOUtils.closeStream(inputStream);
                        break block10;
                    }
                    logger.e(String.format("An HTTP error occurred with status code = %d when attempting to determine if the user is in a privacy restricted zone.", responseCode));
                    IOUtils.closeStream(inputStream);
                    break block11;
                }
                catch (IOException e) {
                    logger.e("An exception occurred connecting to privacy server.", e);
                    return null;
                }
            }
            if (httpURLConnection == null) return string;
            httpURLConnection.disconnect();
            return string;
        }
        if (httpURLConnection == null) return null;
        httpURLConnection.disconnect();
        return null;
        finally {
            IOUtils.closeStream(inputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    static WaterfallProvider getWaterfallProvider(Context context, RequestMetadata requestMetadata) {
        Map<String, Object> placementData;
        Object overrideWaterfallProviderId;
        if (context == null) {
            logger.e("context cannot be null.");
            return null;
        }
        Component waterfallProvider = null;
        if (requestMetadata != null && requestMetadata.getPlacementData() != null && (overrideWaterfallProviderId = (placementData = requestMetadata.getPlacementData()).get("overrideWaterfallProvider")) != null) {
            waterfallProvider = ComponentRegistry.getComponent(overrideWaterfallProviderId.toString(), context, null, null);
        }
        if (!(waterfallProvider instanceof WaterfallProvider)) {
            String defaultWaterfallProviderId = Configuration.getString(DOMAIN, "defaultWaterfallProvider", null);
            if (defaultWaterfallProviderId != null) {
                waterfallProvider = ComponentRegistry.getComponent(defaultWaterfallProviderId, context, null, null);
            } else {
                logger.e("No default waterfall provider registered in Configuration.");
            }
        }
        return waterfallProvider instanceof WaterfallProvider ? (WaterfallProvider)waterfallProvider : null;
    }

    static {
        WHO = VASAds.class.getName();
        locationRequestInProgress = new AtomicBoolean(false);
        executorService = Executors.newSingleThreadExecutor();
        registeredConfigurationProviders = new CopyOnWriteArrayList<ConfigurationProviderRegistration>();
        adAdapterRegistrations = new CopyOnWriteArrayList<AdAdapterRegistration>();
        registeredPlugins = new ConcurrentHashMap<String, RegisteredPlugin>();
        handlerThread = new HandlerThread("VASAdsCoreHandlerThread");
        handlerThread.start();
        adRequestHandler = new AdRequestHandler(handlerThread.getLooper());
        coreHandler = new Handler(handlerThread.getLooper());
        locationHandler = new Handler(handlerThread.getLooper());
        sdkInfo = new SDKInfo("2.1.0", "36697f5", "release", "1", "2020-05-15T16:01:00Z");
    }

    static final class RegisteredPlugin {
        final Plugin plugin;
        volatile boolean enabled;

        private RegisteredPlugin(Plugin plugin) {
            this.plugin = plugin;
        }
    }

    public static interface AdRequestListener {
        default public void prepare(AdSession adSession) {
        }

        public void onAdReceived(AdSession var1, ErrorInfo var2, boolean var3);
    }
}

