/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Point;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.location.Location;
import android.location.LocationManager;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import androidx.core.content.ContextCompat;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.verizon.ads.AmazonAdvertisingIdInfo;
import com.verizon.ads.GoogleAdvertisingIdInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.VASAds;
import com.verizon.ads.utils.ThreadUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class EnvironmentInfo {
    private static final Logger logger = Logger.getInstance(EnvironmentInfo.class);
    private static volatile AdvertisingIdInfo advertisingIdInfo;
    private final Context context;
    private final NetworkOperatorInfo networkOperatorInfo;
    private final DeviceInfo deviceInfo;

    public EnvironmentInfo(final Context context) {
        this.context = context;
        this.networkOperatorInfo = new NetworkOperatorInfo(context);
        this.deviceInfo = new DeviceInfo(context);
        ThreadUtils.runOnWorkerThread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfo.loadAdvertisingInfo(context);
            }
        });
    }

    public synchronized boolean isCustomTabsSupported() {
        try {
            PackageManager pm = this.context.getPackageManager();
            Intent activityIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.yahoo.com"));
            List resolvedActivityList = pm.queryIntentActivities(activityIntent, 0);
            for (ResolveInfo info : resolvedActivityList) {
                Intent serviceIntent = new Intent();
                serviceIntent.setAction("android.support.customtabs.action.CustomTabsService");
                serviceIntent.setPackage(info.activityInfo.packageName);
                if (pm.resolveService(serviceIntent, 0) == null) continue;
                logger.d("Custom tabs is supported by at least one installed browser.");
                return true;
            }
        }
        catch (Throwable t) {
            logger.i("Verification of custom tabs support requires the custom tabs support lib.", t);
        }
        logger.d("Custom tabs is not supported.");
        return false;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public NetworkOperatorInfo getNetworkOperatorInfo() {
        if (VASAds.isAnonymous()) {
            return null;
        }
        return this.networkOperatorInfo;
    }

    public AdvertisingIdInfo getAdvertisingIdInfo() {
        if (VASAds.isAnonymous()) {
            return null;
        }
        return advertisingIdInfo;
    }

    @SuppressLint(value={"MissingPermission"})
    public Location getLocation() {
        LocationManager locationManager;
        if (VASAds.isAnonymous() || !VASAds.isLocationEnabled()) {
            return null;
        }
        if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 && (locationManager = (LocationManager)this.context.getSystemService("location")) != null) {
            return locationManager.getLastKnownLocation("passive");
        }
        return null;
    }

    public String getSDKVersion() {
        return VASAds.getSDKInfo().version;
    }

    @SuppressLint(value={"DefaultLocal"})
    public String getHashedDeviceId(String hashType) {
        if (VASAds.isAnonymous()) {
            return null;
        }
        String androidId = this.getSecureAndroidId();
        if (androidId == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(hashType);
            byte[] hashBytes = messageDigest.digest(androidId.getBytes("UTF-8"));
            return EnvironmentInfo.byteArrayToHex(hashBytes);
        }
        catch (Exception e) {
            logger.e(String.format("Exception calculating <%s> hashed device id with ANDROID_ID <%s>", hashType, androidId), e);
            return null;
        }
    }

    @SuppressLint(value={"HardwareIds"})
    String getSecureAndroidId() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
    }

    static synchronized void loadAdvertisingInfo(Context context) {
        if (VASAds.isAnonymous()) {
            return;
        }
        if (advertisingIdInfo == null) {
            String errorMessagePrefix = "Unable to get google play services advertising info, ";
            try {
                AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                advertisingIdInfo = new GoogleAdvertisingIdInfo(info);
            }
            catch (IOException e) {
                logger.e("Unable to get google play services advertising info, google play services (e.g., the old version of the service doesn't support getting advertising ID)", e);
            }
            catch (GooglePlayServicesNotAvailableException e) {
                logger.e("Unable to get google play services advertising info, google play services is not available", e);
            }
            catch (IllegalStateException e) {
                logger.e("Unable to get google play services advertising info, illegal state", e);
            }
            catch (GooglePlayServicesRepairableException e) {
                logger.e("Unable to get google play services advertising info, google play services is not installed, up-to-date, or enabled", e);
            }
            catch (Throwable e) {
                logger.e("Unable to get google play services advertising info, error obtaining advertising info from google play services", e);
            }
            if (advertisingIdInfo == null) {
                try {
                    ContentResolver cr = context.getContentResolver();
                    int limitAdTracking = Settings.Secure.getInt((ContentResolver)cr, (String)"limit_ad_tracking");
                    String advertisingId = Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id");
                    advertisingIdInfo = new AmazonAdvertisingIdInfo(advertisingId, limitAdTracking);
                }
                catch (Settings.SettingNotFoundException e) {
                    logger.e("Amazon advertiser info not available.", e);
                }
            }
            if (advertisingIdInfo == null && !"Amazon".equalsIgnoreCase(Build.MANUFACTURER)) {
                logger.w("No advertiser ID could be found. Please include Google Play Services Ads in your application if available.");
            }
            if (advertisingIdInfo != null && Logger.isLogLevelEnabled(3)) {
                logger.d(advertisingIdInfo.toString());
            }
        }
    }

    static String byteArrayToHex(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(byteArray.length * 2);
        for (byte byteArrayItem : byteArray) {
            hexString.append(String.format("%02X", byteArrayItem));
        }
        return hexString.toString();
    }

    public static boolean isNetworkAvailable() {
        Context applicationContext = (Context)VASAds.applicationWeakReference.get();
        NetworkInfo networkInfo = EnvironmentInfo.getNetworkInfo(applicationContext);
        return networkInfo != null && networkInfo.isConnected();
    }

    @SuppressLint(value={"MissingPermission"})
    private static NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager connectivityManager;
        if (context == null) {
            logger.e("Context is null.  Unable to get networkInfo.");
            return null;
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0 && (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")) != null) {
            return connectivityManager.getActiveNetworkInfo();
        }
        return null;
    }

    static final class PhoneStateListenerThread
    extends HandlerThread {
        private final WeakReference<Context> applicationContextRef;
        private PhoneStateListener phoneStateListener;

        private PhoneStateListenerThread(Context applicationContext) {
            super("vas-phone-state-listener");
            this.applicationContextRef = new WeakReference<Context>(applicationContext);
        }

        public void run() {
            super.run();
            Context applicationContext = (Context)this.applicationContextRef.get();
            if (applicationContext != null) {
                TelephonyManager telephonyManager = (TelephonyManager)applicationContext.getSystemService("phone");
                if (telephonyManager != null) {
                    this.phoneStateListener = new PhoneStateListener(){

                        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
                            if (signalStrength.isGsm()) {
                                NetworkOperatorInfo.cellSignalDbm = signalStrength.getGsmSignalStrength() * 2 - 113;
                            } else {
                                NetworkOperatorInfo.cellSignalDbm = signalStrength.getCdmaDbm();
                            }
                        }
                    };
                    telephonyManager.listen(this.phoneStateListener, 256);
                } else {
                    logger.d("Could not register signals strength listener. No telephony service available.");
                }
            } else {
                logger.d("Application context was destroyed. Cannot listen for signals strength.");
            }
        }
    }

    public static class DeviceInfo {
        private static final Logger logger = Logger.getInstance(DeviceInfo.class);
        private static volatile String userAgent = String.format("Android %s", Build.VERSION.RELEASE);
        private final Context context;
        private final ScreenInfo screenInfo;
        private Set<CameraType> cameraTypes;
        public static final String ORIENTATION_LANDSCAPE = "landscape";
        public static final String ORIENTATION_PORTRAIT = "portrait";

        @TargetApi(value=17)
        DeviceInfo(Context context) {
            this.context = context;
            this.screenInfo = new ScreenInfo(context);
            if (!VASAds.isAnonymous()) {
                this.cameraTypes = new HashSet<CameraType>();
                if (Build.VERSION.SDK_INT >= 21) {
                    CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
                    if (cameraManager != null) {
                        try {
                            String[] cameraIds;
                            for (String cameraId : cameraIds = cameraManager.getCameraIdList()) {
                                CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(cameraId);
                                Integer lensFacing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                                if (lensFacing != null) {
                                    if (lensFacing == 0) {
                                        this.cameraTypes.add(CameraType.FRONT);
                                        continue;
                                    }
                                    if (lensFacing != 1) continue;
                                    this.cameraTypes.add(CameraType.BACK);
                                    continue;
                                }
                                logger.d("Camera detected but lens facing characteristic returned null.");
                            }
                        }
                        catch (Throwable e) {
                            logger.e("An error occurred determining camera availability.", e);
                        }
                    } else {
                        logger.d("Could not determine camera availability. Unable to access Camera Service.");
                    }
                } else {
                    Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                    int numCameras = Camera.getNumberOfCameras();
                    for (int i = 0; i < numCameras; ++i) {
                        Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                        if (cameraInfo.facing == 1) {
                            this.cameraTypes.add(CameraType.FRONT);
                            continue;
                        }
                        if (cameraInfo.facing != 0) continue;
                        this.cameraTypes.add(CameraType.BACK);
                    }
                }
            }
            this.loadUserAgent(context);
        }

        private synchronized void loadUserAgent(final Context context) {
            if (Build.VERSION.SDK_INT > 16) {
                try {
                    userAgent = WebSettings.getDefaultUserAgent((Context)context);
                }
                catch (Throwable t) {
                    logger.e("An exception occurred obtaining user agent from WebSettings.", t);
                }
            } else {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        WebView webView = new WebView(context);
                        userAgent = webView.getSettings().getUserAgentString();
                    }
                });
            }
        }

        public String getModel() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return Build.MODEL;
        }

        public String getName() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return Build.DEVICE;
        }

        public String getManufacturer() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return Build.MANUFACTURER;
        }

        public ScreenInfo getScreenInfo() {
            return this.screenInfo;
        }

        public String getCountryCode() {
            return Locale.getDefault().getCountry();
        }

        public String getLanguage() {
            return Locale.getDefault().getLanguage();
        }

        public Float getBatteryLevel() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            Intent intent = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (intent != null) {
                int level = intent.getIntExtra("level", -1);
                int scale = intent.getIntExtra("scale", -1);
                return Float.valueOf((float)level / (float)scale);
            }
            return null;
        }

        public Boolean isCharging() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            Intent intent = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (intent != null) {
                int status = intent.getIntExtra("status", -1);
                return status == 2 || status == 5;
            }
            return null;
        }

        public CameraType[] getCameras() {
            if (this.cameraTypes != null) {
                return this.cameraTypes.toArray(new CameraType[this.cameraTypes.size()]);
            }
            return new CameraType[0];
        }

        public Boolean hasCameraPermission() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") == 0;
        }

        public Boolean hasNFC() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return this.context.getPackageManager().hasSystemFeature("android.hardware.nfc") && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.NFC") == 0;
        }

        private boolean hasExternalStoragePermission() {
            return Build.VERSION.SDK_INT > 18 || ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        }

        public Boolean hasBluetooth() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth") && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.BLUETOOTH") == 0;
        }

        public Boolean hasMicrophone() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return this.context.getPackageManager().hasSystemFeature("android.hardware.microphone") && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.RECORD_AUDIO") == 0;
        }

        public Boolean hasGPS() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return this.context.getPackageManager().hasSystemFeature("android.hardware.location.gps") && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        }

        public Boolean hasHeadphonesPluggedIn() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
            if (audioManager != null) {
                if (Build.VERSION.SDK_INT >= 23) {
                    AudioDeviceInfo[] audioDeviceInfos;
                    for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfos = audioManager.getDevices(2)) {
                        if (audioDeviceInfo.getId() != 4 && audioDeviceInfo.getId() != 3 && audioDeviceInfo.getId() != 22) continue;
                        return true;
                    }
                    return false;
                }
                return audioManager.isWiredHeadsetOn();
            }
            logger.d("Cannot determine headphone status. No Audio Service available.");
            return null;
        }

        public String getNaturalOrientation() {
            WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
            if (windowManager != null) {
                Configuration config = this.context.getResources().getConfiguration();
                int rotation = windowManager.getDefaultDisplay().getRotation();
                if (config.orientation == 2 && (rotation == 0 || rotation == 2)) {
                    return ORIENTATION_LANDSCAPE;
                }
                if (config.orientation == 1 && (rotation == 1 || rotation == 3)) {
                    return ORIENTATION_LANDSCAPE;
                }
                return ORIENTATION_PORTRAIT;
            }
            logger.w("Window Service unavailable. Could not determine orientation.");
            return null;
        }

        public String getConfigurationOrientation() {
            switch (this.context.getResources().getConfiguration().orientation) {
                case 1: {
                    return ORIENTATION_PORTRAIT;
                }
                case 2: {
                    return ORIENTATION_LANDSCAPE;
                }
            }
            return this.getNaturalOrientation();
        }

        public String getOSVersion() {
            return Build.VERSION.RELEASE;
        }

        public String getOSBuildNumber() {
            return Build.ID;
        }

        public Long getAvailableStorage() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            String externalStorageState = Environment.getExternalStorageState();
            boolean readExternalGranted = ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
            long externalAvailableStorage = 0L;
            if (readExternalGranted && ("mounted".equals(externalStorageState) || "mounted_ro".equals(externalStorageState))) {
                externalAvailableStorage = this.getAvailableStorage(Environment.getExternalStorageDirectory());
            }
            return this.getAvailableStorage(Environment.getRootDirectory()) + externalAvailableStorage;
        }

        public boolean isExternalStorageWritable() {
            String storageState = Environment.getExternalStorageState();
            return this.hasExternalStoragePermission() && "mounted".equals(storageState);
        }

        public String getUserAgent() {
            return userAgent;
        }

        public Float getVolume(int streamType) {
            if (VASAds.isAnonymous()) {
                return null;
            }
            AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
            if (audioManager != null) {
                int vol = audioManager.getStreamVolume(streamType);
                int max = audioManager.getStreamMaxVolume(streamType);
                return Float.valueOf((float)vol / (float)max);
            }
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Audio Service unavailable. Could not determine volume for stream type %d", streamType));
            }
            return null;
        }

        public NetworkInfo getNetworkInfo() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return EnvironmentInfo.getNetworkInfo(this.context);
        }

        public String getIP() {
            if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.INTERNET") != 0) {
                logger.e("INTERNET permission is required.");
                return null;
            }
            if (VASAds.isAnonymous()) {
                return null;
            }
            String hostAddress = null;
            try {
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                while (netInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = netInterfaces.nextElement();
                    InetAddress inetAddress = null;
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress nextElement = inetAddresses.nextElement();
                        if (nextElement.isLoopbackAddress()) continue;
                        inetAddress = nextElement;
                        break;
                    }
                    if (inetAddress == null) continue;
                    hostAddress = inetAddress.getHostAddress().toUpperCase();
                    if (!(inetAddress instanceof Inet6Address)) continue;
                    int delimiter = hostAddress.indexOf(37);
                    return delimiter < 0 ? hostAddress : hostAddress.substring(0, delimiter);
                }
            }
            catch (SocketException e) {
                logger.e("An exception occurred while determining device IP.", e);
            }
            return hostAddress;
        }

        private long getAvailableStorage(File file) {
            StatFs pathStats = new StatFs(file.getAbsolutePath());
            long blockSize = pathStats.getBlockSize();
            return (long)pathStats.getAvailableBlocks() * blockSize;
        }
    }

    public static class NetworkOperatorInfo {
        private static final Logger logger = Logger.getInstance(NetworkOperatorInfo.class);
        private static volatile int cellSignalDbm;
        private static PhoneStateListenerThread phoneStateListenerThread;
        private String networkOperatorName;
        private int mcc = 0;
        private int mnc = 0;

        NetworkOperatorInfo(Context context) {
            if (!VASAds.isAnonymous()) {
                String networkOperator;
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    this.networkOperatorName = telephonyManager.getNetworkOperatorName();
                    NetworkOperatorInfo.registerPhoneStateListener(context);
                }
                Configuration config = context.getResources().getConfiguration();
                if (config.mcc == 0 && telephonyManager != null) {
                    networkOperator = telephonyManager.getNetworkOperator();
                    if (networkOperator != null && networkOperator.length() >= 6) {
                        try {
                            this.mcc = Integer.parseInt(networkOperator.substring(0, 3));
                        }
                        catch (NumberFormatException e) {
                            logger.w("Unable to parse mcc from network operator", e);
                        }
                    }
                } else {
                    this.mcc = config.mcc;
                }
                if (config.mnc == 0 && telephonyManager != null) {
                    networkOperator = telephonyManager.getNetworkOperator();
                    if (networkOperator != null && networkOperator.length() >= 6) {
                        try {
                            this.mnc = Integer.parseInt(networkOperator.substring(3));
                        }
                        catch (NumberFormatException e) {
                            logger.w("Unable to parse mnc from network operator", e);
                        }
                    }
                } else {
                    this.mnc = config.mnc;
                }
            }
        }

        private static synchronized void registerPhoneStateListener(Context context) {
            if (phoneStateListenerThread == null) {
                phoneStateListenerThread = new PhoneStateListenerThread(context.getApplicationContext());
                phoneStateListenerThread.start();
            }
        }

        public String getNetworkOperatorName() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return this.networkOperatorName;
        }

        public Integer getCellSignalDbm() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return cellSignalDbm;
        }

        public Integer getMCC() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return this.mcc;
        }

        public Integer getMNC() {
            if (VASAds.isAnonymous()) {
                return null;
            }
            return this.mnc;
        }
    }

    public static class ScreenInfo {
        private static final Logger logger = Logger.getInstance(ScreenInfo.class);
        private final int densityDpi;
        private final float density;
        private int height;
        private int width;

        private ScreenInfo(Context context) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            this.densityDpi = displayMetrics.densityDpi;
            this.density = displayMetrics.density;
            if (Build.VERSION.SDK_INT >= 17) {
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                if (windowManager != null) {
                    Display display = windowManager.getDefaultDisplay();
                    Point size = new Point();
                    display.getRealSize(size);
                    this.width = size.x;
                    this.height = size.y;
                } else {
                    logger.w("Unable to determine display size.");
                }
            } else {
                this.width = displayMetrics.widthPixels;
                this.height = displayMetrics.heightPixels;
            }
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getDensityDpi() {
            return this.densityDpi;
        }

        public float getDensity() {
            return this.density;
        }
    }

    public static interface AdvertisingIdInfo {
        public boolean isLimitAdTrackingEnabled();

        public String getId();
    }

    public static enum CameraType {
        FRONT,
        BACK;

    }
}

