/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.verizon.ads.Logger;
import com.verizon.ads.utils.TextUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DataStore
implements Map<String, Object> {
    private static final Logger logger = Logger.getInstance(DataStore.class);
    private static final String KEY_REQUIRED_MESSAGE = "Key cannot be null";
    private static final String KEY_MUST_BE_STRING_MESSAGE = "Key must be a string";
    private static final int MAX_DEPTH = 10;
    private final Map<String, Object> dataStore = new ConcurrentHashMap<String, Object>();
    private AtomicBoolean traversing = new AtomicBoolean(false);

    public Object getObject(String key, Object defaultValue) {
        return this.get(key, Object.class, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return this.get(key, Integer.class, defaultValue);
    }

    public double getDouble(String key, double defaultValue) {
        return this.get(key, Double.class, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.get(key, Boolean.class, defaultValue);
    }

    public String getString(String key, String defaultValue) {
        return this.get(key, String.class, defaultValue);
    }

    public Map getMap(String key, Map defaultValue) {
        return this.get(key, Map.class, defaultValue);
    }

    public List getList(String key, List defaultValue) {
        return this.get(key, List.class, defaultValue);
    }

    public Object putObject(String key, Object value) {
        return this.put(key, value, Object.class, null);
    }

    public int putInt(String key, int value) {
        return this.put(key, value, Integer.class, 0);
    }

    public double putDouble(String key, double value) {
        return this.put(key, value, Double.class, 0.0);
    }

    public boolean putBoolean(String key, boolean value) {
        return this.put(key, value, Boolean.class, false);
    }

    public String putString(String key, String value) {
        return this.put(key, value, String.class, null);
    }

    public Map putMap(String key, Map value) {
        return this.put(key, value, Map.class, null);
    }

    public List putList(String key, List value) {
        return this.put(key, value, List.class, null);
    }

    public <T> T get(String key, Class<T> clazz, T defaultValue) {
        Object value = this.get(key);
        if (value != null) {
            if (clazz.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            logger.e(String.format("Key: %s expected class: %s but found class: %s", key, clazz.getSimpleName(), value.getClass().getSimpleName()));
        }
        return defaultValue;
    }

    public <T> T put(String key, T value, Class<T> clazz, T defaultValue) {
        Object previousValue = this.put(key, value);
        if (previousValue != null) {
            if (clazz.isAssignableFrom(previousValue.getClass())) {
                return (T)previousValue;
            }
            logger.e(String.format("Key: %s expected previous class: %s but found class: %s", key, clazz.getSimpleName(), previousValue.getClass().getSimpleName()));
        }
        return defaultValue;
    }

    @Override
    public int size() {
        return this.dataStore.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dataStore.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.getObjectInPath(key) != null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            logger.e(KEY_MUST_BE_STRING_MESSAGE);
            return false;
        }
        return this.containsKey((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.dataStore.containsValue(value);
    }

    public Object get(String key) {
        return this.getObjectInPath(key);
    }

    @Override
    @Nullable
    public Object get(Object key) {
        if (!(key instanceof String)) {
            logger.e(KEY_MUST_BE_STRING_MESSAGE);
            return null;
        }
        return this.get((String)key);
    }

    @Override
    @Nullable
    public Object put(String key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        return this.putObjectInPath(key, value);
    }

    public Object remove(String key) {
        return this.removeObjectInPath(key);
    }

    @Override
    @Nullable
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            logger.e(KEY_MUST_BE_STRING_MESSAGE);
            return null;
        }
        return this.remove((String)key);
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ?> map) {
        this.dataStore.putAll(map);
    }

    @Override
    public synchronized void clear() {
        this.dataStore.clear();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.dataStore.keySet();
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        return this.dataStore.values();
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.dataStore.entrySet();
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(DataStore.getInstanceName(this)).append('>');
        if (this.traversing.compareAndSet(false, true)) {
            try {
                this.toStringTraversal(sb, this.dataStore, 0);
            }
            catch (Exception e) {
                logger.e("Error formatting data store contents", e);
            }
            this.traversing.set(false);
        }
        return sb.toString();
    }

    private synchronized Object getObjectInPath(String path) {
        if (TextUtils.isEmpty(path)) {
            logger.e(KEY_REQUIRED_MESSAGE);
            return null;
        }
        try {
            return this.getObjectInMapTraversal(this.dataStore, path);
        }
        catch (Exception e) {
            logger.e(String.format("Error getting value for key: %s", path), e);
            return null;
        }
    }

    private synchronized Object putObjectInPath(String path, Object value) {
        if (TextUtils.isEmpty(path)) {
            logger.e(KEY_REQUIRED_MESSAGE);
            return null;
        }
        try {
            return this.putObjectInMapTraversal(this.dataStore, path, value);
        }
        catch (Exception e) {
            logger.e(String.format("Error setting value for key: %s", path), e);
            return null;
        }
    }

    private synchronized Object removeObjectInPath(String path) {
        if (TextUtils.isEmpty(path)) {
            logger.e(KEY_REQUIRED_MESSAGE);
            return null;
        }
        try {
            return this.removeObjectInMapTraversal(this.dataStore, path);
        }
        catch (Exception e) {
            logger.e(String.format("Error removing value for key: %s", path), e);
            return null;
        }
    }

    private Object getObjectInMapTraversal(Map map, String path) {
        String[] parts = path.split("\\.", 2);
        Object currentValue = map.get(parts[0]);
        if (parts.length == 1) {
            return currentValue;
        }
        if (currentValue instanceof Map) {
            return this.getObjectInMapTraversal((Map)currentValue, parts[1]);
        }
        return null;
    }

    private Object putObjectInMapTraversal(Map map, String path, Object value) {
        String[] parts = path.split("\\.", 2);
        Object currentValue = map.get(parts[0]);
        if (parts.length == 1) {
            return map.put(parts[0], value);
        }
        if (currentValue instanceof Map) {
            return this.putObjectInMapTraversal((Map)currentValue, parts[1], value);
        }
        ConcurrentHashMap childMap = new ConcurrentHashMap();
        map.put(parts[0], childMap);
        return this.putObjectInMapTraversal(childMap, parts[1], value);
    }

    private Object removeObjectInMapTraversal(Map map, String path) {
        String[] parts = path.split("\\.", 2);
        if (!map.containsKey(parts[0])) {
            return null;
        }
        if (parts.length == 1) {
            return map.remove(parts[0]);
        }
        Object currentValue = map.get(parts[0]);
        if (!(currentValue instanceof Map)) {
            return null;
        }
        Object result = this.removeObjectInMapTraversal((Map)currentValue, parts[1]);
        if (((Map)currentValue).isEmpty()) {
            map.remove(parts[0]);
        }
        return result;
    }

    private static String getInstanceName(Object value) {
        return value.getClass().getName() + "@" + Integer.toHexString(value.hashCode());
    }

    private synchronized void toStringTraversal(StringBuilder sb, Map map, int depth) {
        if (depth >= 10) {
            sb.append(" <...> }\n");
            return;
        }
        sb.append(" {");
        String indent = depth > 0 ? String.format("%" + depth + "s", "") : "";
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            sb.append("\n ").append(indent).append(key).append(" : ");
            if (value instanceof DataStore) {
                sb.append('<').append(DataStore.getInstanceName(value)).append('>');
                continue;
            }
            if (value instanceof Map) {
                sb.append('<').append(DataStore.getInstanceName(value)).append('>');
                this.toStringTraversal(sb, (Map)value, depth + 1);
                continue;
            }
            if (value instanceof String) {
                sb.append('\"').append(value).append('\"');
                continue;
            }
            if (value != null) {
                sb.append(value.toString());
                continue;
            }
            sb.append("<null>");
        }
        sb.append('\n').append(indent).append('}');
    }
}

