/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.content.Context;
import com.verizon.ads.Component;
import com.verizon.ads.ComponentFactory;
import com.verizon.ads.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class ComponentRegistry {
    private static final Logger logger = Logger.getInstance(ComponentRegistry.class);
    private static Map<String, ComponentFactory> componentFactoryRegistry = new ConcurrentHashMap<String, ComponentFactory>();

    public static void registerComponent(String type, ComponentFactory componentFactory) {
        if (type == null) {
            logger.e("type cannot be null.");
            return;
        }
        if (componentFactory == null) {
            logger.e("componentFactory cannot be null");
            return;
        }
        String normalizedKey = type.toLowerCase();
        if (!componentFactoryRegistry.containsKey(normalizedKey)) {
            componentFactoryRegistry.put(normalizedKey, componentFactory);
        }
    }

    public static Component getComponent(String type, Context context, JSONObject data, Object ... args) {
        if (type == null) {
            logger.e("type cannot be null.");
            return null;
        }
        String normalizedKey = type.toLowerCase();
        ComponentFactory componentFactory = componentFactoryRegistry.get(normalizedKey);
        if (componentFactory == null) {
            logger.e(String.format("No ComponentFactory class registered for type <%s>", normalizedKey));
            return null;
        }
        return componentFactory.newInstance(context, data, args);
    }
}

