/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.verizon.ads.AdRequest;
import com.verizon.ads.AdSession;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.WaterfallProcessingRunnable;
import com.verizon.ads.WaterfallProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class AdRequestHandler
extends Handler {
    private static final Logger logger = Logger.getInstance(AdRequestHandler.class);
    private static final String WHO = AdRequestHandler.class.getSimpleName();
    private static final int REQUEST_TIMED_OUT = 0;
    private static final int REQUEST_ADS = 1;
    private static final int PROCESS_WATERFALLS = 2;
    private static final int MAX_THREADS = 5;
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    static final int WATERFALL_PROCESSING_COMPLETE = 3;

    AdRequestHandler(Looper looper) {
        super(looper);
    }

    void requestAds(AdRequest adRequest) {
        this.sendMessageDelayed(this.obtainMessage(0, adRequest), adRequest.timeout);
        this.sendMessage(this.obtainMessage(1, adRequest));
    }

    public void handleMessage(@NonNull Message msg) {
        switch (msg.what) {
            case 1: {
                this.performAdRequest((AdRequest)msg.obj);
                break;
            }
            case 0: {
                this.adRequestTimedOut((AdRequest)msg.obj);
                break;
            }
            case 2: {
                this.processWaterfalls((WaterfallResponse)msg.obj);
                break;
            }
            case 3: {
                this.waterfallProcessingComplete((WaterfallProcessingRunnable.WaterfallProcessingResult)msg.obj);
                break;
            }
            default: {
                logger.w(String.format("Received unexpected msg with what = %d", msg.what));
            }
        }
    }

    private void performAdRequest(AdRequest adRequest) {
        LoadWaterfallsRunnable loadWaterfallsRunnable = new LoadWaterfallsRunnable(adRequest, this);
        this.executorService.execute(loadWaterfallsRunnable);
    }

    private void processWaterfalls(WaterfallResponse waterfallResponse) {
        if (waterfallResponse.adRequest.complete) {
            logger.e("Received waterfall response for an ad request that is marked complete.");
            return;
        }
        if (waterfallResponse.adRequest.timedOut) {
            logger.e("Received waterfall response for ad request that has timed out.");
            waterfallResponse.adRequest.complete = true;
            return;
        }
        boolean containsValidAdSessions = true;
        if (waterfallResponse.errorInfo != null) {
            logger.e(String.format("Error occurred while attempting to load waterfalls: %s", waterfallResponse.errorInfo));
        } else if (waterfallResponse.adSessions == null || waterfallResponse.adSessions.length == 0) {
            logger.d("No ad sessions were returned from waterfall provider");
            containsValidAdSessions = false;
        } else {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Received waterfall response: AdSessions[");
            }
            for (AdSession adSession : waterfallResponse.adSessions) {
                if (adSession == null) {
                    logger.w("Null ad session was returned from waterfall provider");
                    containsValidAdSessions = false;
                    continue;
                }
                if (!Logger.isLogLevelEnabled(3)) continue;
                logger.d(adSession.toStringLongDescription());
            }
            logger.d("]");
        }
        if (waterfallResponse.errorInfo != null || !containsValidAdSessions) {
            waterfallResponse.adRequest.complete = true;
            waterfallResponse.adRequest.adRequestListener.onAdReceived(null, waterfallResponse.errorInfo, true);
            return;
        }
        if (waterfallResponse.complete) {
            waterfallResponse.adRequest.waterfallRequestComplete = true;
        }
        for (AdSession adSession : waterfallResponse.adSessions) {
            WaterfallProcessingRunnable runnable = new WaterfallProcessingRunnable(waterfallResponse.adRequest, adSession, this);
            waterfallResponse.adRequest.waterfallProcessingRunnables.add(runnable);
            this.executorService.execute(runnable);
        }
    }

    private void waterfallProcessingComplete(WaterfallProcessingRunnable.WaterfallProcessingResult result) {
        AdRequest adRequest = result.adRequest;
        if (adRequest.complete) {
            logger.e("Received waterfall processing result for an ad request that is marked complete.");
            return;
        }
        if (adRequest.timedOut) {
            logger.e("Received waterfall processing result for ad request that has timed out.");
            return;
        }
        adRequest.waterfallProcessingRunnables.remove(result.waterfallProcessingRunnable);
        boolean bl = adRequest.complete = adRequest.waterfallProcessingRunnables.isEmpty() && adRequest.waterfallRequestComplete;
        if (adRequest.complete) {
            this.removeCallbacksAndMessages(adRequest);
        }
        ErrorInfo errorInfo = result.adSession.getAdAdapter() == null ? new ErrorInfo(AdRequestHandler.class.getName(), "No fill", -1) : null;
        result.waterfallProcessingRunnable.setResult(errorInfo);
        adRequest.adRequestListener.onAdReceived(result.adSession, errorInfo, adRequest.complete);
    }

    private void adRequestTimedOut(AdRequest adRequest) {
        if (adRequest.complete) {
            logger.e("Received an ad request time out for an ad request that is marked complete.");
            return;
        }
        adRequest.timedOut = true;
        adRequest.complete = true;
        this.removeCallbacksAndMessages(adRequest);
        ErrorInfo errorInfo = new ErrorInfo(WHO, "Ad request timed out", -2);
        for (WaterfallProcessingRunnable waterfallProcessingRunnable : adRequest.waterfallProcessingRunnables) {
            waterfallProcessingRunnable.setResult(errorInfo);
        }
        adRequest.adRequestListener.onAdReceived(null, new ErrorInfo(AdRequestHandler.class.getName(), "Ad request timeout", -2), true);
    }

    static class LoadWaterfallsRunnable
    implements Runnable {
        final AdRequest adRequest;
        final Handler handler;

        LoadWaterfallsRunnable(AdRequest adRequest, Handler handler) {
            this.adRequest = adRequest;
            this.handler = handler;
        }

        @Override
        @SuppressLint(value={"DefaultLocale"})
        public void run() {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Requesting %d waterfalls: AdSessions[", this.adRequest.adSessions.length));
                for (AdSession adSession : this.adRequest.adSessions) {
                    logger.d(adSession.toStringLongDescription());
                }
                logger.d("]");
            }
            WaterfallProvider waterfallProvider = this.adRequest.waterfallProvider;
            WaterfallProvider.WaterfallListener waterfallListener = new WaterfallProvider.WaterfallListener(){

                @Override
                public void onWaterfallReceived(AdSession[] adSessions, ErrorInfo errorInfo, boolean complete) {
                    WaterfallResponse waterfallResponse = new WaterfallResponse();
                    waterfallResponse.adRequest = adRequest;
                    waterfallResponse.adSessions = adSessions;
                    waterfallResponse.errorInfo = errorInfo;
                    waterfallResponse.complete = complete;
                    handler.sendMessage(handler.obtainMessage(2, (Object)waterfallResponse));
                }
            };
            if (this.adRequest.bid == null) {
                waterfallProvider.load(this.adRequest.adSessions, this.adRequest.timeout, waterfallListener);
            } else {
                waterfallProvider.load(this.adRequest.bid, this.adRequest.timeout, waterfallListener);
            }
        }
    }

    static class WaterfallResponse {
        AdSession[] adSessions;
        ErrorInfo errorInfo;
        boolean complete;
        AdRequest adRequest;

        WaterfallResponse() {
        }
    }
}

