/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import com.verizon.ads.Logger;
import com.verizon.ads.events.Events;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Configuration
extends HashMap {
    private static final Logger logger = Logger.getInstance(Configuration.class);
    private static final Map<String, Map<String, Object>> domainConfigurations = new ConcurrentHashMap<String, Map<String, Object>>();
    private static final Map<String, String> protectedDomains = new ConcurrentHashMap<String, String>();
    private static final String DOMAIN_REQUIRED_MESSAGE = "Domain cannot be null";
    private static final String KEY_REQUIRED_MESSAGE = "Key cannot be null";
    private static final String SECURITY_KEY_REQUIRED_MESSAGE = "Security key cannot be null";
    public static final String CHANGES_EVENT_ID = "com.verizon.ads.configuration.change";

    private Configuration() {
    }

    public static boolean protectDomain(String domain, String securityKey) throws Exception {
        if (domain == null) {
            logger.e(DOMAIN_REQUIRED_MESSAGE);
            return false;
        }
        if (securityKey == null) {
            logger.e(SECURITY_KEY_REQUIRED_MESSAGE);
            return false;
        }
        if (protectedDomains.containsKey(domain) && !securityKey.equals(protectedDomains.get(domain))) {
            throw new Exception("Domain has already been protected");
        }
        protectedDomains.put(domain, securityKey);
        return true;
    }

    public static boolean isDomainProtected(String domain) {
        if (domain == null) {
            logger.e(DOMAIN_REQUIRED_MESSAGE);
            return false;
        }
        return protectedDomains.containsKey(domain);
    }

    public static boolean exists(String domain, String key) {
        if (domain == null) {
            logger.e(DOMAIN_REQUIRED_MESSAGE);
            return false;
        }
        if (key == null) {
            logger.e(KEY_REQUIRED_MESSAGE);
            return false;
        }
        Map<String, Object> domainValues = domainConfigurations.get(domain);
        return domainValues != null && domainValues.containsKey(key);
    }

    public static Object getObject(String domain, String key, Object defaultValue) {
        return Configuration.get(domain, key, Object.class, defaultValue);
    }

    public static int getInt(String domain, String key, int defaultValue) {
        return Configuration.get(domain, key, Integer.class, defaultValue);
    }

    public static double getDouble(String domain, String key, double defaultValue) {
        return Configuration.get(domain, key, Double.class, defaultValue);
    }

    public static boolean getBoolean(String domain, String key, boolean defaultValue) {
        return Configuration.get(domain, key, Boolean.class, defaultValue);
    }

    public static String getString(String domain, String key, String defaultValue) {
        return Configuration.get(domain, key, String.class, defaultValue);
    }

    public static Map getMap(String domain, String key, Map defaultValue) {
        return Configuration.get(domain, key, Map.class, defaultValue);
    }

    public static List getList(String domain, String key, List defaultValue) {
        return Configuration.get(domain, key, List.class, defaultValue);
    }

    public static void set(Object value, String domain, String key, String securityKey) {
        if (value == null) {
            Configuration.removeValue(domain, key, securityKey);
        } else {
            Configuration.setValue(value, domain, key, securityKey);
        }
    }

    public static void setObject(Object value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setInt(int value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setDouble(double value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setBoolean(boolean value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setString(String value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setMap(Map value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static void setList(List value, String domain, String key, String securityKey) {
        Configuration.set(value, domain, key, securityKey);
    }

    public static <T> T get(String domain, String key, Class<T> clazz, T defaultValue) {
        if (domain == null) {
            logger.e(DOMAIN_REQUIRED_MESSAGE);
            return Configuration.getImmutableValue(defaultValue);
        }
        if (key == null) {
            logger.e(KEY_REQUIRED_MESSAGE);
            return Configuration.getImmutableValue(defaultValue);
        }
        Map<String, Object> domainValues = domainConfigurations.get(domain);
        if (domainValues == null) {
            return Configuration.getImmutableValue(defaultValue);
        }
        Object value = domainValues.get(key);
        if (value != null) {
            if (clazz.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            logger.e(String.format("Value for domain: %s and key: %s is not: %s", domain, key, clazz.getSimpleName()));
        }
        return Configuration.getImmutableValue(defaultValue);
    }

    private static <T> T getImmutableValue(T value) {
        if (value instanceof Map) {
            return (T)Collections.unmodifiableMap((Map)value);
        }
        if (value instanceof List) {
            return (T)Collections.unmodifiableList((List)value);
        }
        return value;
    }

    private static boolean isAllowedToUpdateDomain(String domain, String securityKey) {
        if (domain == null) {
            return false;
        }
        String requiredSecurityKey = protectedDomains.get(domain);
        if (requiredSecurityKey == null || requiredSecurityKey.equals(securityKey)) {
            return true;
        }
        logger.e("Not authorized to set value for a protected domain: " + domain);
        return false;
    }

    private static synchronized void setValue(Object value, String domain, String key, String securityKey) {
        if (domain == null) {
            logger.e(DOMAIN_REQUIRED_MESSAGE);
            return;
        }
        if (key == null) {
            logger.e(KEY_REQUIRED_MESSAGE);
            return;
        }
        if (!Configuration.isAllowedToUpdateDomain(domain, securityKey)) {
            return;
        }
        Map<String, Object> domainValues = domainConfigurations.get(domain);
        if (domainValues == null) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Creating domain: %s", domain));
            }
            domainValues = new ConcurrentHashMap<String, Object>();
            domainConfigurations.put(domain, domainValues);
        } else if (value.equals(domainValues.get(key))) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Value for domain: %s and key: %s is already set to: %s", domain, key, value));
            }
            return;
        }
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Setting value for domain: %s and key: %s to: %s", domain, key, value));
        }
        domainValues.put(key, Configuration.getImmutableValue(value));
        Events.sendEvent(CHANGES_EVENT_ID, new ConfigurationChangeEvent(domain, key, value));
    }

    private static synchronized void removeValue(String domain, String key, String securityKey) {
        if (domain == null) {
            logger.e(DOMAIN_REQUIRED_MESSAGE);
            return;
        }
        if (key == null) {
            logger.e(KEY_REQUIRED_MESSAGE);
            return;
        }
        if (!Configuration.isAllowedToUpdateDomain(domain, securityKey)) {
            return;
        }
        Map<String, Object> domainValues = domainConfigurations.get(domain);
        if (domainValues == null || !domainValues.containsKey(key)) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Value for domain: %s and key: %s does not exist", domain, key));
            }
            return;
        }
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Removing value for domain: %s and key: %s", domain, key));
        }
        domainValues.remove(key);
        if (domainValues.isEmpty()) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Removing domain: %s", domain));
            }
            domainConfigurations.remove(domain);
        }
        Events.sendEvent(CHANGES_EVENT_ID, new ConfigurationChangeEvent(domain, key, null));
    }

    public static final class ConfigurationChangeEvent {
        public final String domain;
        public final String key;
        public final Object value;

        ConfigurationChangeEvent(String domain, String key, Object value) {
            this.domain = domain;
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "ConfigurationChangeEvent{domain: " + this.domain + ", key: " + this.key + ", value: " + this.value + '}';
        }
    }
}

