/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.utils;

import android.graphics.Bitmap;
import com.verizon.ads.Logger;
import com.verizon.ads.utils.IOUtils;
import com.verizon.ads.utils.ThreadUtils;
import com.verizon.ads.utils.VASAdsSSLSocketFactory;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;

public class HttpUtils {
    private static final Logger logger = Logger.getInstance(HttpUtils.class);
    private static final int DEFAULT_TIMEOUT = 15000;
    private static HttpInterceptor httpInterceptor = null;

    static Response sendHttpRequest(String url, String postData, String contentType, Integer connectionTimeout, ResponseStreamer responseStreamer) {
        long requestId = System.currentTimeMillis();
        int timeout = connectionTimeout == null ? 15000 : connectionTimeout;
        HttpRequestRunner httpRequestRunner = new HttpRequestRunner(requestId, url, postData, contentType, timeout, responseStreamer);
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format(Locale.getDefault(), "Sending Http request.\n\t%s", httpRequestRunner.toString()));
        }
        if (httpInterceptor != null) {
            httpInterceptor.onRequest(url, httpRequestRunner);
        }
        ThreadUtils.runOnWorkerThread(httpRequestRunner);
        Response response = httpRequestRunner.waitForResponse(timeout);
        if (httpInterceptor != null) {
            httpInterceptor.onResponse(url, response);
        }
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format(Locale.getDefault(), "Http response.\n\trequestId: %d\n\t%s", requestId, response.toString()));
        }
        return response;
    }

    public static Response getContentFromGetRequest(String url) {
        return HttpUtils.sendHttpRequest(url, null, null, null, new IOUtils.StringStreamer());
    }

    public static Response getContentFromGetRequest(String url, int timeout) {
        return HttpUtils.sendHttpRequest(url, null, null, timeout, new IOUtils.StringStreamer());
    }

    public static Response getContentFromPostRequest(String url, String postData, String contentType) {
        return HttpUtils.sendHttpRequest(url, postData, contentType, null, new IOUtils.StringStreamer());
    }

    public static Response getContentFromPostRequest(String url, String postData, String contentType, int timeout) {
        return HttpUtils.sendHttpRequest(url, postData, contentType, timeout, new IOUtils.StringStreamer());
    }

    public static Response getBitmapFromGetRequest(String url) {
        return HttpUtils.sendHttpRequest(url, null, null, null, new IOUtils.BitmapStreamer());
    }

    public static Response getContentFromPostRequest(String url, int timeout) {
        return HttpUtils.sendHttpRequest(url, null, null, timeout, new IOUtils.StringStreamer());
    }

    public static Response getFileFromGetRequest(String url, File outputFile, int timeout) {
        return HttpUtils.sendHttpRequest(url, null, null, timeout, new IOUtils.FileStreamer(outputFile));
    }

    public static void setInterceptor(HttpInterceptor interceptor) {
        httpInterceptor = interceptor;
    }

    public static void getBitmapFromGetRequestAsync(final String url, final HttpRequestListener httpRequestListener) {
        if (httpRequestListener == null) {
            return;
        }
        ThreadUtils.runOnWorkerThread(new Runnable(){

            @Override
            public void run() {
                Response response = HttpUtils.getBitmapFromGetRequest(url);
                httpRequestListener.onResponse(response);
            }
        });
    }

    public static class HttpRequestRunner
    implements Runnable {
        public String url;
        public Map<String, String> headers;
        public int timeout;
        public String postData;
        public Response response;
        private CountDownLatch latch = new CountDownLatch(1);
        private long requestId;
        private String contentType;
        private ResponseStreamer responseStreamer;

        HttpRequestRunner(long requestId, String url, String postData, String contentType, int timeout, ResponseStreamer responseStreamer) {
            this.requestId = requestId;
            this.url = url;
            this.postData = postData;
            this.contentType = contentType;
            this.timeout = timeout;
            this.responseStreamer = responseStreamer;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(Locale.getDefault(), "requestId: %d\n\turl: %s\n\ttimeout: %d", this.requestId, this.url, this.timeout));
            if (this.contentType != null) {
                sb.append(String.format(Locale.getDefault(), "\n\tcontent type: %s", this.contentType));
            }
            if (this.postData != null) {
                sb.append(String.format(Locale.getDefault(), "\n\tpost data: %s", this.postData));
            }
            return sb.toString();
        }

        Response getResponse() {
            return this.response;
        }

        Response waitForResponse(long waitTime) {
            try {
                if (this.latch.await(waitTime, TimeUnit.MILLISECONDS)) {
                    return this.response;
                }
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d(String.format(Locale.getDefault(), "HTTP request timed out.\n\trequestId: %d\n\twait time: %d", this.requestId, waitTime));
                }
                return new Response(408);
            }
            catch (InterruptedException e) {
                logger.e(String.format(Locale.getDefault(), "Http request was interrupted.\n\trequestId: %d", this.requestId));
                return new Response(400);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block24: {
                this.response = new Response();
                InputStream inputStream = null;
                InputStream errorStream = null;
                OutputStream outputStream = null;
                HttpURLConnection httpURLConnection = null;
                try {
                    int responseCode;
                    Map<String, List<String>> responseHeaders;
                    URL urlObj = new URL(this.url);
                    httpURLConnection = (HttpURLConnection)urlObj.openConnection();
                    httpURLConnection.setReadTimeout(this.timeout);
                    httpURLConnection.setConnectTimeout(this.timeout);
                    httpURLConnection.setInstanceFollowRedirects(true);
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setDoInput(true);
                    if (this.headers != null) {
                        for (Map.Entry<String, String> header : this.headers.entrySet()) {
                            httpURLConnection.setRequestProperty(header.getKey(), header.getValue());
                        }
                    }
                    if (httpURLConnection instanceof HttpsURLConnection) {
                        logger.d("HttpsURLConnection created");
                        VASAdsSSLSocketFactory socketFactory = VASAdsSSLSocketFactory.getInstance();
                        if (socketFactory != null) {
                            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(socketFactory);
                        }
                    }
                    if (this.postData == null) {
                        httpURLConnection.setRequestMethod("GET");
                        httpURLConnection.connect();
                    } else {
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setRequestMethod("POST");
                        httpURLConnection.setRequestProperty("Content-Type", this.contentType);
                        httpURLConnection.setRequestProperty("Content-Length", "" + this.postData.getBytes("UTF-8").length);
                        outputStream = httpURLConnection.getOutputStream();
                        IOUtils.write(outputStream, this.postData);
                        outputStream.flush();
                        IOUtils.closeStream(outputStream);
                        outputStream = null;
                    }
                    if (Logger.isLogLevelEnabled(3) && httpURLConnection instanceof HttpsURLConnection) {
                        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                        logger.d("Negotiated Cipher Suite: " + httpsURLConnection.getCipherSuite());
                    }
                    if ((responseHeaders = httpURLConnection.getHeaderFields()) != null && !responseHeaders.isEmpty()) {
                        HashMap<String, String> adMetadata = new HashMap<String, String>();
                        for (Map.Entry<String, List<String>> header : responseHeaders.entrySet()) {
                            if (header.getKey() == null) continue;
                            String value = null;
                            if (header.getValue() != null && !header.getValue().isEmpty()) {
                                value = header.getValue().get(0);
                            }
                            adMetadata.put(header.getKey(), value);
                        }
                        this.response.adMetadata = adMetadata;
                    }
                    this.response.code = responseCode = httpURLConnection.getResponseCode();
                    if (responseCode == 200) {
                        this.response.contentType = httpURLConnection.getContentType();
                        inputStream = httpURLConnection.getInputStream();
                        this.responseStreamer.streamContent(inputStream, this.response);
                    } else if (responseCode >= 400) {
                        errorStream = httpURLConnection.getErrorStream();
                        this.response.content = IOUtils.convertStreamToString(errorStream);
                        logger.e(String.format(Locale.getDefault(), "HTTP ERROR.\n\trequestId: %d\n\tcode: %d\n\tmessage: %s", this.requestId, responseCode, this.response.content));
                    }
                    IOUtils.closeStream(inputStream);
                }
                catch (SocketTimeoutException e) {
                    this.response.code = 408;
                    if (Logger.isLogLevelEnabled(3)) {
                        logger.d(String.format(Locale.getDefault(), "HTTP request socket timed out.\n\trequestId: %d", this.requestId));
                    }
                    break block24;
                }
                catch (Exception e2) {
                    this.response.code = 400;
                    logger.e(String.format(Locale.getDefault(), "Error occurred when trying to get response content.\n\trequestId: %d\n\texception: %s", this.requestId, e2.toString()));
                    if (Logger.isLogLevelEnabled(3)) {
                        logger.d(String.format(Locale.getDefault(), "Debug info for requestId: %d", this.requestId), e2);
                    }
                    break block24;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeStream(inputStream);
                    IOUtils.closeStream(outputStream);
                    IOUtils.closeStream(errorStream);
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    this.latch.countDown();
                }
                IOUtils.closeStream(outputStream);
                IOUtils.closeStream(errorStream);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                this.latch.countDown();
            }
        }
    }

    public static interface ResponseStreamer {
        public void streamContent(InputStream var1, Response var2);
    }

    public static class Response {
        public int code;
        public String contentType;
        public String content;
        public File file;
        public Bitmap bitmap;
        public Map<String, String> adMetadata;

        public Response() {
        }

        public Response(int code) {
            this.code = code;
        }

        public Response(String content, String contentType, int code) {
            this(code);
            this.content = content;
            this.contentType = contentType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(Locale.getDefault(), "code: %d", this.code));
            if (this.contentType != null) {
                sb.append(String.format(Locale.getDefault(), "\n\tcontent-type: %s", this.contentType));
            }
            if (this.content != null) {
                if (this.contentType == null || this.contentType.contains("text") || this.contentType.contains("json")) {
                    sb.append(String.format(Locale.getDefault(), "\n\tcontent: %s", this.content));
                } else {
                    sb.append("\n\tcontent: <non-text-content>");
                }
            } else if (this.bitmap != null) {
                sb.append(String.format(Locale.getDefault(), "\n\tbitmap: dimensions: %d x %d\n\tbitmap size: %d", this.bitmap.getWidth(), this.bitmap.getHeight(), this.bitmap.getByteCount()));
            } else if (this.file != null) {
                sb.append(String.format(Locale.getDefault(), "\n\tfile: %s", this.file.getAbsolutePath()));
            }
            return sb.toString();
        }
    }

    public static interface HttpRequestListener {
        public void onResponse(Response var1);
    }

    public static interface HttpInterceptor {
        public void onRequest(String var1, HttpRequestRunner var2);

        public void onResponse(String var1, Response var2);
    }
}

