/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import com.verizon.ads.ConfigurationProvider;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.VASAds;

final class ConfigurationProviderRegistration {
    private static final String WHO = ConfigurationProviderRegistration.class.getSimpleName();
    private static final int ERROR_PLUGIN_DISABLED = 1;
    private String pluginId;
    private ConfigurationProvider configurationProvider;

    ConfigurationProviderRegistration(String pluginId, ConfigurationProvider configurationProvider) {
        this.pluginId = pluginId;
        this.configurationProvider = configurationProvider;
    }

    void update(ConfigurationProvider.UpdateListener updateListener) {
        if (VASAds.isPluginEnabled(this.pluginId)) {
            this.configurationProvider.update(updateListener);
        } else if (Logger.isLogLevelEnabled(4)) {
            String description = String.format("Configuration Provider <%s> not updated because plugin with id <%s> is disabled.", this.configurationProvider.getId(), this.pluginId);
            if (updateListener != null) {
                updateListener.onComplete(this.configurationProvider, new ErrorInfo(WHO, description, 1));
            }
        }
    }
}

