/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.events;

import android.os.Handler;
import android.os.HandlerThread;
import com.verizon.ads.Logger;
import com.verizon.ads.events.EventMatcher;
import com.verizon.ads.events.EventReceiver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class Events {
    private static final Logger logger = Logger.getInstance(Events.class);
    private static final HandlerThread handlerThread;
    private static final Handler handler;
    private static final Map<String, Set<Subscription>> subscriptions;

    public static void subscribe(EventReceiver eventReceiver, String topic) {
        Events.subscribe(eventReceiver, topic, null);
    }

    public static void subscribe(final EventReceiver eventReceiver, final String topic, final EventMatcher eventMatcher) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                Events.addSubscriber(eventReceiver, topic, eventMatcher);
            }
        });
    }

    private static void addSubscriber(EventReceiver eventReceiver, String topic, EventMatcher eventMatcher) {
        Subscription subscription;
        if (eventReceiver == null) {
            logger.e("eventReceiver cannot be null");
            return;
        }
        Set<Subscription> subscribers = subscriptions.get(topic);
        if (subscribers == null) {
            subscribers = new HashSet<Subscription>();
            subscriptions.put(topic, subscribers);
        }
        if (!subscribers.add(subscription = new Subscription(eventReceiver, eventMatcher))) {
            logger.w("Already subscribed for topic: " + topic + ", " + subscription);
        } else if (Logger.isLogLevelEnabled(3)) {
            logger.d("Subscribed to topic: " + topic + ", " + subscription);
        }
    }

    public static void unsubscribe(EventReceiver eventReceiver, String topic) {
        Events.unsubscribe(eventReceiver, topic, null);
    }

    public static void unsubscribe(final EventReceiver eventReceiver, final String topic, final EventMatcher eventMatcher) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                Events.removeSubscriber(eventReceiver, topic, eventMatcher);
            }
        });
    }

    private static void removeSubscriber(EventReceiver eventReceiver, String topic, EventMatcher eventMatcher) {
        if (eventReceiver == null) {
            logger.e("eventReceiver cannot be null");
            return;
        }
        Set<Subscription> subscribers = subscriptions.get(topic);
        boolean unsubscribed = false;
        Subscription subscription = new Subscription(eventReceiver, eventMatcher);
        if (subscribers != null) {
            unsubscribed = subscribers.remove(subscription);
            if (subscribers.isEmpty()) {
                subscriptions.remove(topic);
            }
        }
        if (!unsubscribed) {
            logger.w("Not subscribed to topic: " + topic + ", " + subscription);
        } else if (Logger.isLogLevelEnabled(3)) {
            logger.d("Unsubscribed from topic: " + topic + ", " + subscription);
        }
    }

    public static void sendEvent(final String topic, final Object data) {
        if (Logger.isLogLevelEnabled(3)) {
            logger.d("Send event topic: " + topic + " data: " + data);
        }
        if (topic == null) {
            logger.e("Topic cannot be null or empty");
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                Events.sendEventToSubscribers((Set)subscriptions.get(topic), topic, data);
                Events.sendEventToSubscribers((Set)subscriptions.get(null), topic, data);
            }
        });
    }

    private static void sendEventToSubscribers(Set<Subscription> subscribers, String topic, Object data) {
        if (subscribers == null) {
            return;
        }
        for (Subscription subscription : subscribers) {
            subscription.eventReceiver.sendEvent(topic, data, subscription.eventMatcher);
        }
    }

    static void reset() {
        subscriptions.clear();
        handler.removeCallbacksAndMessages(null);
    }

    static Map<String, Set> getSubscriptionsSync() throws InterruptedException {
        final HashMap<String, Set> map = new HashMap<String, Set>();
        final CountDownLatch latch = new CountDownLatch(1);
        handler.post(new Runnable(){

            @Override
            public void run() {
                map.putAll(subscriptions);
                latch.countDown();
            }
        });
        latch.await();
        return map;
    }

    static {
        subscriptions = new HashMap<String, Set<Subscription>>();
        handlerThread = new HandlerThread(Events.class.getName());
        handlerThread.start();
        handler = new Handler(handlerThread.getLooper());
    }

    static final class Subscription {
        final EventReceiver eventReceiver;
        final EventMatcher eventMatcher;

        Subscription(EventReceiver eventReceiver, EventMatcher eventMatcher) {
            this.eventReceiver = eventReceiver;
            this.eventMatcher = eventMatcher;
        }

        public String toString() {
            return "receiver: " + this.eventReceiver + ", matcher: " + this.eventMatcher;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Subscription)) {
                return false;
            }
            Subscription that = (Subscription)other;
            return this.eventReceiver == that.eventReceiver && this.eventMatcher == that.eventMatcher;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.eventReceiver.hashCode();
            if (this.eventMatcher != null) {
                result = 31 * result + this.eventMatcher.hashCode();
            }
            return result;
        }
    }
}

