/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import com.verizon.ads.Logger;
import com.verizon.ads.PEXFactory;
import com.verizon.ads.PEXHandler;
import com.verizon.ads.utils.TextUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PEXRegistry {
    private static final Logger logger = Logger.getInstance(PEXRegistry.class);
    static final Map<String, PEXFactory> registeredFactories = new ConcurrentHashMap<String, PEXFactory>();

    static boolean registerPEX(String contentType, PEXFactory factory) {
        if (TextUtils.isEmpty(contentType)) {
            logger.e("contentType cannot be null or empty.");
            return false;
        }
        if (factory == null) {
            logger.e("PEXFactory instance cannot be null.");
            return false;
        }
        String contentTypeKey = contentType.toLowerCase();
        if (registeredFactories.containsKey(contentTypeKey)) {
            logger.w(String.format("A registration already exists for type <%s>", contentType));
            return false;
        }
        registeredFactories.put(contentTypeKey, factory);
        return true;
    }

    public static PEXHandler getHandler(String contentType) {
        if (TextUtils.isEmpty(contentType)) {
            logger.e("contentType cannot be null or empty.");
            return null;
        }
        String contentTypeKey = contentType.toLowerCase();
        PEXFactory PEXFactory2 = registeredFactories.get(contentTypeKey);
        if (PEXFactory2 == null) {
            logger.w(String.format("No factory is registered for type <%s>", contentType));
            return null;
        }
        return PEXFactory2.getHandler();
    }
}

