/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.verizon.ads.Job;
import com.verizon.ads.Logger;
import com.verizon.ads.VASAds;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class JobScheduler {
    private static final Logger logger = Logger.getInstance(JobScheduler.class);
    private static final Map<Integer, Job> scheduledJobs = new ConcurrentHashMap<Integer, Job>();
    private static final HandlerThread handlerThread = new HandlerThread("JobScheduler");
    private static final Handler jobHandler;

    public static void schedule(Job job) {
        Context applicationContext = (Context)VASAds.applicationWeakReference.get();
        if (applicationContext == null) {
            logger.e("VASAds application context is null.  Cannot schedule job.");
            return;
        }
        JobScheduler.schedule(applicationContext, job);
    }

    @TargetApi(value=21)
    public static void schedule(Context context, Job job) {
        if (context == null) {
            logger.e("context cannot be null.");
            return;
        }
        if (job == null) {
            logger.e("job cannot be null.");
            return;
        }
        JobScheduler.scheduleJobWithHandler(job);
    }

    public static void shutdown() {
        if (handlerThread != null) {
            handlerThread.quit();
        }
    }

    private static void scheduleJobWithHandler(final Job job) {
        Job previousJob;
        if (Logger.isLogLevelEnabled(3)) {
            logger.d(String.format("Scheduling job %d with job handler.", job.getId()));
        }
        if ((previousJob = scheduledJobs.get(job.getId())) != null) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Attempting to cancel previous job with id %d", job.getId()));
            }
            jobHandler.post(new Runnable(){

                @Override
                public void run() {
                    jobHandler.removeCallbacks((Runnable)previousJob);
                }
            });
        }
        job.setJobStateListener(new Job.JobStateListener(){

            @Override
            public void onJobFinished(Job job) {
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d(String.format("Job %d finished.", job.getId()));
                }
            }
        });
        jobHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d(String.format("Starting job %d", job.getId()));
                }
                scheduledJobs.remove(job.getId());
                job.run();
            }
        }, job.getDelay());
    }

    static {
        handlerThread.start();
        jobHandler = new Handler(handlerThread.getLooper());
    }
}

