/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.verizon.ads.AdRequest;
import com.verizon.ads.ErrorInfo;
import com.verizon.ads.Logger;
import com.verizon.ads.Waterfall;
import com.verizon.ads.WaterfallProcessingRunnable;
import com.verizon.ads.WaterfallProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class AdRequestHandler
extends Handler {
    private static final Logger logger = Logger.getInstance(AdRequestHandler.class);
    private static final String WHO = AdRequestHandler.class.getSimpleName();
    private static final int REQUEST_TIMED_OUT = 0;
    private static final int REQUEST_ADS = 1;
    private static final int PROCESS_WATERFALLS = 2;
    private static final int MAX_THREADS = 5;
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    static final int WATERFALL_PROCESSING_COMPLETE = 3;

    AdRequestHandler(Looper looper) {
        super(looper);
    }

    void requestAds(AdRequest adRequest) {
        this.sendMessageDelayed(this.obtainMessage(0, adRequest), adRequest.timeout);
        this.sendMessage(this.obtainMessage(1, adRequest));
    }

    public void handleMessage(Message msg) {
        if (msg == null) {
            return;
        }
        switch (msg.what) {
            case 1: {
                this.performAdRequest((AdRequest)msg.obj);
                break;
            }
            case 0: {
                this.adRequestTimedOut((AdRequest)msg.obj);
                break;
            }
            case 2: {
                this.processWaterfalls((WaterfallResponse)msg.obj);
                break;
            }
            case 3: {
                this.waterfallProcessingComplete((WaterfallProcessingRunnable.WaterfallProcessingResult)msg.obj);
                break;
            }
            default: {
                logger.w(String.format("Received unexpected msg with what = %d", msg.what));
            }
        }
    }

    private void performAdRequest(AdRequest adRequest) {
        LoadWaterfallsRunnable loadWaterfallsRunnable = new LoadWaterfallsRunnable(adRequest, this);
        this.executorService.execute(loadWaterfallsRunnable);
    }

    private void processWaterfalls(WaterfallResponse waterfallResponse) {
        if (waterfallResponse.adRequest.complete) {
            logger.e("Received waterfall response for an ad request that is marked complete.");
            return;
        }
        if (waterfallResponse.adRequest.timedOut) {
            logger.e("Received waterfall response for ad request that has timed out.");
            waterfallResponse.adRequest.complete = true;
            return;
        }
        if (waterfallResponse.errorInfo != null) {
            logger.e(String.format("Error occurred while attempting to load waterfalls: %s", waterfallResponse.errorInfo));
            waterfallResponse.adRequest.complete = true;
            waterfallResponse.adRequest.adRequestListener.onAdReceived(null, waterfallResponse.errorInfo, true);
            return;
        }
        if (waterfallResponse.complete) {
            waterfallResponse.adRequest.waterfallRequestComplete = true;
        }
        if (waterfallResponse.waterfalls == null || waterfallResponse.waterfalls.length == 0) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("No waterfalls were returned from waterfall provider.");
            }
            waterfallResponse.adRequest.complete = true;
            waterfallResponse.adRequest.adRequestListener.onAdReceived(null, null, true);
            return;
        }
        for (Waterfall waterfall : waterfallResponse.waterfalls) {
            WaterfallProcessingRunnable runnable = new WaterfallProcessingRunnable(waterfallResponse.adRequest, waterfall, this);
            waterfallResponse.adRequest.waterfallProcessingRunnables.add(runnable);
            this.executorService.execute(runnable);
        }
    }

    private void waterfallProcessingComplete(WaterfallProcessingRunnable.WaterfallProcessingResult result) {
        AdRequest adRequest = result.adRequest;
        if (adRequest.complete) {
            logger.e("Received waterfall processing result for an ad request that is marked complete.");
            return;
        }
        if (adRequest.timedOut) {
            logger.e("Received waterfall processing result for ad request that has timed out.");
            return;
        }
        adRequest.waterfallProcessingRunnables.remove(result.waterfallProcessingRunnable);
        boolean bl = adRequest.complete = adRequest.waterfallProcessingRunnables.isEmpty() && adRequest.waterfallRequestComplete;
        if (adRequest.complete) {
            this.removeCallbacksAndMessages(adRequest);
        }
        ErrorInfo errorInfo = result.ad == null ? new ErrorInfo(AdRequestHandler.class.getName(), "No fill", -1) : null;
        result.waterfallProcessingRunnable.setResult(errorInfo);
        adRequest.adRequestListener.onAdReceived(result.ad, errorInfo, adRequest.complete);
    }

    private void adRequestTimedOut(AdRequest adRequest) {
        if (adRequest.complete) {
            logger.e("Received an ad request time out for an ad request that is marked complete.");
            return;
        }
        adRequest.timedOut = true;
        adRequest.complete = true;
        this.removeCallbacksAndMessages(adRequest);
        ErrorInfo errorInfo = new ErrorInfo(WHO, "Ad request timed out", -2);
        for (WaterfallProcessingRunnable waterfallProcessingRunnable : adRequest.waterfallProcessingRunnables) {
            waterfallProcessingRunnable.setResult(errorInfo);
        }
        adRequest.adRequestListener.onAdReceived(null, new ErrorInfo(AdRequestHandler.class.getName(), "Ad request timeout", -2), true);
    }

    static class LoadWaterfallsRunnable
    implements Runnable {
        final AdRequest adRequest;
        final Handler handler;

        LoadWaterfallsRunnable(AdRequest adRequest, Handler handler) {
            this.adRequest = adRequest;
            this.handler = handler;
        }

        @Override
        public void run() {
            WaterfallProvider waterfallProvider = this.adRequest.waterfallProvider;
            WaterfallProvider.WaterfallListener waterfallListener = new WaterfallProvider.WaterfallListener(){

                @Override
                public void onWaterfallReceived(Waterfall[] waterfalls, ErrorInfo errorInfo, boolean complete) {
                    WaterfallResponse waterfallResponse = new WaterfallResponse();
                    waterfallResponse.adRequest = LoadWaterfallsRunnable.this.adRequest;
                    waterfallResponse.waterfalls = waterfalls;
                    waterfallResponse.errorInfo = errorInfo;
                    waterfallResponse.complete = complete;
                    LoadWaterfallsRunnable.this.handler.sendMessage(LoadWaterfallsRunnable.this.handler.obtainMessage(2, (Object)waterfallResponse));
                }
            };
            if (this.adRequest.bid == null) {
                waterfallProvider.load(this.adRequest.requestMetadata, this.adRequest.numberOfAds, this.adRequest.timeout, waterfallListener);
            } else {
                waterfallProvider.load(this.adRequest.bid, this.adRequest.timeout, waterfallListener);
            }
        }
    }

    static class WaterfallResponse {
        Waterfall[] waterfalls;
        ErrorInfo errorInfo;
        boolean complete;
        AdRequest adRequest;

        WaterfallResponse() {
        }
    }
}

