/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.verizon.ads.Logger;
import com.verizon.ads.utils.HttpUtils;
import com.verizon.ads.utils.ThreadUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class IOUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final Logger logger = Logger.getInstance(IOUtils.class);

    public static byte[] read(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.read(inputStream, baos);
        return baos.toByteArray();
    }

    public static void read(InputStream inputStream, OutputStream outputStream) throws IOException {
        int i;
        byte[] buffer = new byte[4096];
        while ((i = inputStream.read(buffer, 0, 4096)) != -1) {
            outputStream.write(buffer, 0, i);
        }
    }

    public static String read(InputStream inputStream, String encoding) throws IOException {
        encoding = encoding != null ? encoding : ENCODING_UTF_8;
        return new String(IOUtils.read(inputStream), encoding);
    }

    public static void write(OutputStream outputStream, String content) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, ENCODING_UTF_8);){
            writer.write(content);
        }
    }

    public static boolean closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
                return true;
            }
            catch (IOException e) {
                logger.e("Error closing stream", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream inputStream) {
        BufferedReader reader = null;
        String outputString = null;
        if (inputStream == null) {
            logger.e("Unable to convert to string, input stream is null");
            return null;
        }
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING_UTF_8), 4096);
            StringBuilder outputBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                outputBuilder.append(line);
                outputBuilder.append('\n');
            }
            outputString = outputBuilder.toString();
        }
        catch (IOException e) {
            logger.e("Error occurred when converting stream to string", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.e("Error closing input stream reader", e);
            }
        }
        return outputString;
    }

    static Bitmap convertStreamToBitmap(InputStream inputStream) {
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        if (bitmap == null) {
            logger.e("Unable to create bitmap from input stream");
        }
        return bitmap;
    }

    public static void downloadFile(final String url, final Integer connectionTimeout, final File file, final DownloadListener downloadListener) {
        if (url == null || file == null || downloadListener == null) {
            throw new IllegalArgumentException("url, file, and download listener are required");
        }
        ThreadUtils.runOnWorkerThread(new Runnable(){

            @Override
            public void run() {
                File outputFile = file;
                try {
                    if (file.isDirectory()) {
                        outputFile = File.createTempFile("_vas_", null, file);
                    }
                    HttpUtils.Response response = HttpUtils.sendHttpRequest(url, null, null, connectionTimeout, new FileStreamer(outputFile));
                    if (response.file != null) {
                        downloadListener.onDownloadSucceeded(response.file);
                    } else {
                        downloadListener.onDownloadFailed(new Throwable("Error creating file"));
                    }
                }
                catch (IOException e) {
                    logger.e("An error occurred downloading file from url = " + url, e);
                    downloadListener.onDownloadFailed(e);
                }
            }
        });
    }

    public static File getUniqueFileName(File dir, String name) {
        dir.mkdirs();
        File file = new File(dir, name);
        if (!file.exists()) {
            return file;
        }
        String[] tokens = name.split("\\.(?=[^.]+$)");
        String base = tokens[0];
        String extension = tokens.length > 1 ? tokens[1] : "";
        for (int i = 1; i < 1000; ++i) {
            file = new File(dir, base + "(" + i + ")." + extension);
            if (file.exists()) continue;
            return file;
        }
        return null;
    }

    public static class FileStreamer
    implements HttpUtils.ResponseStreamer {
        private File outputFile;

        public FileStreamer(File outputFile) {
            this.outputFile = outputFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void streamContent(InputStream inputStream, HttpUtils.Response response) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(this.outputFile);
                IOUtils.read(inputStream, outputStream);
                response.file = this.outputFile;
            }
            catch (IOException e) {
                try {
                    logger.e("Unable to create file from input stream", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(outputStream);
                    throw throwable;
                }
                IOUtils.closeStream(outputStream);
            }
            IOUtils.closeStream(outputStream);
        }
    }

    public static class BitmapStreamer
    implements HttpUtils.ResponseStreamer {
        @Override
        public void streamContent(InputStream inputStream, HttpUtils.Response response) {
            response.bitmap = IOUtils.convertStreamToBitmap(inputStream);
        }
    }

    public static class StringStreamer
    implements HttpUtils.ResponseStreamer {
        @Override
        public void streamContent(InputStream inputStream, HttpUtils.Response response) {
            response.content = IOUtils.convertStreamToString(inputStream);
        }
    }

    public static interface DownloadListener {
        public void onDownloadSucceeded(File var1);

        public void onDownloadFailed(Throwable var1);
    }
}

