/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.events;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.verizon.ads.Logger;
import com.verizon.ads.events.EventMatcher;

public abstract class EventReceiver {
    private static final Logger logger = Logger.getInstance(EventReceiver.class);
    private final Handler handler;
    private HandlerThread handlerThread;

    protected abstract void onEvent(String var1, Object var2);

    public EventReceiver() {
        if (Logger.isLogLevelEnabled(3)) {
            logger.d("Creating new handler thread");
        }
        this.handlerThread = new HandlerThread(EventReceiver.class.getName() + System.identityHashCode(this));
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
    }

    public EventReceiver(Looper looper) {
        this.handler = new Handler(looper);
    }

    public void quit() {
        if (this.handlerThread != null) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d("Quitting handler thread");
            }
            if (this.handler != null) {
                this.handler.removeCallbacksAndMessages(null);
            }
            this.handlerThread.quit();
            this.handlerThread = null;
        }
    }

    void sendEvent(final String topic, final Object data, final EventMatcher eventMatcher) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (eventMatcher != null) {
                    try {
                        if (!eventMatcher.matches(topic, data)) {
                            return;
                        }
                    }
                    catch (Throwable t) {
                        logger.e("Event exception", t);
                        return;
                    }
                }
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d("Calling receiver onEvent topic: " + topic + ", data: " + data + " (receiver: " + this + ")");
                }
                try {
                    EventReceiver.this.onEvent(topic, data);
                }
                catch (Throwable e) {
                    logger.e("onEvent error", e);
                }
            }
        });
    }
}

