/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.annotation.SuppressLint;
import android.app.IntentService;
import android.content.Intent;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.provider.Settings;
import com.verizon.ads.Logger;
import com.verizon.ads.VolumeChangeManager;

public class VolumeChangeService
extends IntentService {
    private static final Logger logger = Logger.getInstance(VolumeChangeService.class);
    private VolumeChangeContentObserver contentObserver;
    private int volume;
    private int maxVolume;

    public VolumeChangeService() {
        super("VolumeChangeService");
    }

    @SuppressLint(value={"DefaultLocale"})
    public void onCreate() {
        super.onCreate();
        logger.d("VolumeChangeService created.");
        if (VolumeChangeManager.isStarted()) {
            AudioManager audioManager = (AudioManager)this.getSystemService("audio");
            if (audioManager != null) {
                this.volume = audioManager.getStreamVolume(3);
                this.maxVolume = audioManager.getStreamMaxVolume(3);
            } else {
                logger.w("Unable to get a reference to the AudioManager.");
            }
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("VolumeChangeService created with initial vol = %d, max vol = %d", this.volume, this.maxVolume));
            }
            this.contentObserver = new VolumeChangeContentObserver();
            this.contentObserver.dispatchVolumeChange(true);
            this.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.contentObserver);
        } else {
            logger.d("VolumeChangeManager has not been started; shutting down until needed.");
            this.stopSelf();
        }
    }

    public void onDestroy() {
        logger.d("VolumeChangeService destroyed.");
        if (this.contentObserver != null) {
            this.contentObserver.stopDispatchThread();
            this.getContentResolver().unregisterContentObserver((ContentObserver)this.contentObserver);
        }
        super.onDestroy();
    }

    protected void onHandleIntent(Intent intent) {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    private class VolumeChangeContentObserver
    extends ContentObserver {
        private HandlerThread handlerThread;
        private Handler handler;

        VolumeChangeContentObserver() {
            super(null);
            this.handlerThread = new HandlerThread("VolumeChangeDispatcher");
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
        }

        @SuppressLint(value={"DefaultLocale"})
        public void onChange(boolean selfChange, Uri uri) {
            if (uri == null) {
                return;
            }
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Setting changed for URI = %s", uri));
            }
            if (uri.toString().startsWith("content://settings/system/volume_music_")) {
                this.dispatchVolumeChange(false);
            }
        }

        @SuppressLint(value={"DefaultLocale"})
        void dispatchVolumeChange(boolean force) {
            AudioManager audioManager = (AudioManager)VolumeChangeService.this.getSystemService("audio");
            if (audioManager == null) {
                logger.w("Unable to obtain a reference to the AudioManager.");
                return;
            }
            final int currentVolume = audioManager.getStreamVolume(3);
            if (force) {
                VolumeChangeService.this.volume = -1;
            }
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Current volume vol = %d, last vol = %d", currentVolume, VolumeChangeService.this.volume));
            }
            if (currentVolume != VolumeChangeService.this.volume) {
                final int oldVolume = VolumeChangeService.this.volume;
                VolumeChangeService.this.volume = currentVolume;
                if (Logger.isLogLevelEnabled(3)) {
                    logger.d(String.format("Dispatching volume change old vol = %d, new vol = %d", oldVolume, currentVolume));
                }
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        VolumeChangeManager.updateVolume(oldVolume, currentVolume, VolumeChangeService.this.maxVolume);
                    }
                });
            }
        }

        void stopDispatchThread() {
            if (this.handlerThread != null) {
                this.handlerThread.quit();
                this.handlerThread = null;
            }
        }
    }
}

