/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import com.verizon.ads.ActivityStateManager;
import com.verizon.ads.Logger;
import com.verizon.ads.VolumeChangeService;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class VolumeChangeManager {
    private static final Logger logger = Logger.getInstance(VolumeChangeManager.class);
    private static volatile boolean initialized = false;
    private static volatile boolean started = false;
    private static final List<VolumeChangeListener> listeners = new CopyOnWriteArrayList<VolumeChangeListener>();

    public static synchronized void initialize(Application application, ActivityStateManager activityStateManager) {
        if (initialized) {
            return;
        }
        initialized = true;
        activityStateManager.registerActivityObserver(null, new ActivityStateManager.ActivityObserver(){

            @Override
            protected void onResumed(Activity activity) {
                super.onResumed(activity);
                VolumeChangeManager.start((Context)activity);
            }
        });
    }

    public static synchronized void start(Context context) {
        started = true;
        Intent intent = new Intent(context, VolumeChangeService.class);
        try {
            context.startService(intent);
        }
        catch (IllegalStateException illegalStateException) {
            logger.d("VolumeChangeService failed to start");
        }
    }

    public static synchronized boolean isStarted() {
        return started;
    }

    public static void registerListener(VolumeChangeListener listener) {
        if (listener == null) {
            return;
        }
        listeners.add(listener);
    }

    public static void removeListener(VolumeChangeListener listener) {
        if (listener == null) {
            return;
        }
        listeners.remove(listener);
    }

    public static Float getCurrentVolume(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            logger.w("Unable to get a reference to the AudioManager.");
            return null;
        }
        int volume = audioManager.getStreamVolume(3);
        int maxVolume = audioManager.getStreamMaxVolume(3);
        return Float.valueOf((float)volume / (float)maxVolume * 100.0f);
    }

    static void updateVolume(int oldVolume, int newVolume, int maxVolume) {
        for (VolumeChangeListener listener : listeners) {
            listener.onVolumeChange(oldVolume, newVolume, maxVolume);
        }
    }

    public static interface VolumeChangeListener {
        public void onVolumeChange(int var1, int var2, int var3);
    }
}

