/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RequestMetadata {
    static final String USER_DATA_AGE_KEY = "age";
    static final String USER_DATA_CHILDREN_KEY = "children";
    static final String USER_DATA_INCOME_KEY = "income";
    static final String USER_DATA_KEYWORDS_KEY = "keywords";
    static final String USER_DATA_EDUCATION_KEY = "education";
    static final String USER_DATA_ETHNICITY_KEY = "ethnicity";
    static final String USER_DATA_GENDER_KEY = "gender";
    static final String USER_DATA_MARITAL_STATUS_KEY = "marital";
    static final String USER_DATA_POLITICS_KEY = "politics";
    static final String USER_DATA_DOB_KEY = "dob";
    static final String USER_DATA_STATE_KEY = "state";
    static final String USER_DATA_COUNTRY_KEY = "country";
    static final String USER_DATA_POSTAL_CODE_KEY = "postalCode";
    static final String USER_DATA_DMA_KEY = "dma";
    static final String APP_DATA_MEDIATOR_KEY = "mediator";
    static final String PLACEMENT_DATA_IMP_GROUP_KEY = "impressionGroup";
    private Map<String, Object> userData;
    private Map<String, Object> appData;
    private Map<String, Object> placementData;
    private Map<String, String> customTargeting;
    private Map<String, Object> extras;
    private List<String> keywords;
    private List<String> supportedOrientations;

    private RequestMetadata() {
    }

    private RequestMetadata(Map<String, Object> userData, Map<String, Object> appData, Map<String, Object> placementData, Map<String, String> customTargeting, Map<String, Object> extras, List<String> keywords, List<String> supportedOrientations) {
        this.userData = RequestMetadata.unmodifiableCopy(userData);
        this.appData = RequestMetadata.unmodifiableCopy(appData);
        this.placementData = RequestMetadata.unmodifiableCopy(placementData);
        this.customTargeting = RequestMetadata.unmodifiableCopy(customTargeting);
        this.extras = RequestMetadata.unmodifiableCopy(extras);
        if (keywords != null) {
            this.keywords = Collections.unmodifiableList(keywords);
        }
        if (supportedOrientations != null) {
            this.supportedOrientations = Collections.unmodifiableList(supportedOrientations);
        }
    }

    public Map<String, Object> getUserData() {
        return this.userData;
    }

    public Map<String, Object> getAppData() {
        return this.appData;
    }

    public Map<String, Object> getPlacementData() {
        return this.placementData;
    }

    public Map<String, String> getCustomTargeting() {
        return this.customTargeting;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public List<String> getSupportedOrientations() {
        return this.supportedOrientations;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    private static <T> Map<String, T> unmodifiableCopy(Map<String, T> source) {
        if (source == null) {
            return null;
        }
        return Collections.unmodifiableMap(source);
    }

    public static final class Builder {
        private Map<String, Object> userData;
        private final Map<String, Object> internalUserData = new HashMap<String, Object>();
        private Map<String, Object> appData;
        private final Map<String, Object> internalAppData = new HashMap<String, Object>();
        private Map<String, Object> placementData;
        private final Map<String, Object> internalPlacementData = new HashMap<String, Object>();
        private Map<String, String> customTargeting;
        private Map<String, Object> extras;
        private List<String> keywords;
        private List<String> supportedOrientations;

        public Builder() {
        }

        public Builder(RequestMetadata requestMetadata) {
            if (requestMetadata != null) {
                this.userData = Builder.copy(requestMetadata.userData);
                this.appData = Builder.copy(requestMetadata.appData);
                this.placementData = Builder.copy(requestMetadata.placementData);
                this.customTargeting = Builder.copy(requestMetadata.customTargeting);
                this.extras = Builder.copy(requestMetadata.extras);
                this.keywords = Builder.copy(requestMetadata.keywords);
                this.supportedOrientations = Builder.copy(requestMetadata.supportedOrientations);
            }
        }

        public Map<String, Object> getUserData() {
            return this.userData;
        }

        public Map<String, Object> getAppData() {
            return this.appData;
        }

        public Map<String, Object> getPlacementData() {
            return this.placementData;
        }

        public Map<String, String> getCustomTargeting() {
            return this.customTargeting;
        }

        public Map<String, Object> getExtras() {
            return this.extras;
        }

        public List<String> getKeywords() {
            return this.keywords;
        }

        public List<String> getSupportedOrientations() {
            return this.supportedOrientations;
        }

        public Builder setExtras(Map<String, Object> extras) {
            this.extras = extras;
            return this;
        }

        public Builder setSupportedOrientations(List<String> supportedOrientations) {
            this.supportedOrientations = supportedOrientations;
            return this;
        }

        public Builder setKeywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder setCustomTargeting(Map<String, String> customTargeting) {
            this.customTargeting = customTargeting;
            return this;
        }

        public Builder setAppData(Map<String, Object> appData) {
            this.appData = appData;
            return this;
        }

        public Builder setPlacementData(Map<String, Object> placementData) {
            this.placementData = placementData;
            return this;
        }

        public Builder setUserData(Map<String, Object> userData) {
            this.userData = userData;
            return this;
        }

        public Builder setImpressionGroup(String impressionGroup) {
            this.internalPlacementData.put(RequestMetadata.PLACEMENT_DATA_IMP_GROUP_KEY, impressionGroup);
            return this;
        }

        public Builder setUserAge(Integer age) {
            this.internalUserData.put(RequestMetadata.USER_DATA_AGE_KEY, age);
            return this;
        }

        public Builder setUserChildren(Integer children) {
            this.internalUserData.put(RequestMetadata.USER_DATA_CHILDREN_KEY, children);
            return this;
        }

        public Builder setUserIncome(Integer income) {
            this.internalUserData.put(RequestMetadata.USER_DATA_INCOME_KEY, income);
            return this;
        }

        public Builder setUserKeywords(List<String> keywords) {
            this.internalUserData.put(RequestMetadata.USER_DATA_KEYWORDS_KEY, keywords);
            return this;
        }

        public Builder setUserEducation(Education education) {
            this.internalUserData.put(RequestMetadata.USER_DATA_EDUCATION_KEY, education.value);
            return this;
        }

        public Builder setUserEthnicity(Ethnicity ethnicity) {
            this.internalUserData.put(RequestMetadata.USER_DATA_ETHNICITY_KEY, ethnicity.value);
            return this;
        }

        public Builder setUserGender(Gender gender) {
            this.internalUserData.put(RequestMetadata.USER_DATA_GENDER_KEY, gender.value);
            return this;
        }

        public Builder setUserMaritalStatus(MaritalStatus maritalStatusStatus) {
            this.internalUserData.put(RequestMetadata.USER_DATA_MARITAL_STATUS_KEY, maritalStatusStatus.value);
            return this;
        }

        public Builder setUserPolitics(Politics politics) {
            this.internalUserData.put(RequestMetadata.USER_DATA_POLITICS_KEY, politics.value);
            return this;
        }

        public Builder setUserDob(Date dob) {
            this.internalUserData.put(RequestMetadata.USER_DATA_DOB_KEY, dob);
            return this;
        }

        public Builder setUserState(String state) {
            this.internalUserData.put(RequestMetadata.USER_DATA_STATE_KEY, state);
            return this;
        }

        public Builder setUserCountry(String country) {
            this.internalUserData.put(RequestMetadata.USER_DATA_COUNTRY_KEY, country);
            return this;
        }

        public Builder setUserPostalCode(String postalCode) {
            this.internalUserData.put(RequestMetadata.USER_DATA_POSTAL_CODE_KEY, postalCode);
            return this;
        }

        public Builder setUserDma(String dma) {
            this.internalUserData.put(RequestMetadata.USER_DATA_DMA_KEY, dma);
            return this;
        }

        public Builder setMediator(String mediator) {
            this.internalAppData.put(RequestMetadata.APP_DATA_MEDIATOR_KEY, mediator);
            return this;
        }

        public Builder putExtra(String key, Object extra) {
            if (this.extras == null) {
                this.extras = new HashMap<String, Object>();
            }
            this.extras.put(key, extra);
            return this;
        }

        public RequestMetadata build() {
            if (!this.internalUserData.isEmpty()) {
                if (this.userData == null) {
                    this.userData = new HashMap<String, Object>();
                }
                this.userData.putAll(this.internalUserData);
            }
            if (!this.internalPlacementData.isEmpty()) {
                if (this.placementData == null) {
                    this.placementData = new HashMap<String, Object>();
                }
                this.placementData.putAll(this.internalPlacementData);
            }
            if (!this.internalAppData.isEmpty()) {
                if (this.appData == null) {
                    this.appData = new HashMap<String, Object>();
                }
                this.appData.putAll(this.internalAppData);
            }
            return new RequestMetadata(this.userData, this.appData, this.placementData, this.customTargeting, this.extras, this.keywords, this.supportedOrientations);
        }

        private static <T> Map<String, T> copy(Map<String, T> source) {
            if (source == null) {
                return null;
            }
            return new HashMap<String, T>(source);
        }

        private static <T> List<T> copy(List<T> source) {
            if (source == null) {
                return null;
            }
            return new ArrayList<T>(source);
        }
    }

    public static enum Politics {
        REPUBLICAN("republican"),
        DEMOCRAT("democrat"),
        CONSERVATIVE("conservative"),
        MODERATE("moderate"),
        LIBERAL("liberal"),
        INDEPENDENT("independent"),
        OTHER("other");

        public final String value;

        private Politics(String value) {
            this.value = value;
        }
    }

    public static enum MaritalStatus {
        SINGLE("S"),
        MARRIED("M"),
        DIVORCED("D"),
        RELATIONSHIP("O");

        public final String value;

        private MaritalStatus(String value) {
            this.value = value;
        }
    }

    public static enum Gender {
        MALE("M"),
        FEMALE("F"),
        UNKNOWN("O");

        public final String value;

        private Gender(String value) {
            this.value = value;
        }
    }

    public static enum Ethnicity {
        HISPANIC("hispanic"),
        BLACK("africanamerican"),
        ASIAN("asian"),
        INDIAN("indian"),
        MIDDLE_EASTERN("middleeastern"),
        NATIVE_AMERICAN("nativeamerican"),
        PACIFIC_ISLANDER("pacificislander"),
        WHITE("white"),
        OTHER("other");

        public final String value;

        private Ethnicity(String value) {
            this.value = value;
        }
    }

    public static enum Education {
        HIGH_SCHOOL("highschool"),
        SOME_COLLEGE("somecollege"),
        ASSOCIATE("associate"),
        BACHELOR("bachelor"),
        MASTERS("masters"),
        PHD("phd"),
        PROFESSIONAL("professional");

        public final String value;

        private Education(String value) {
            this.value = value;
        }
    }
}

