/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import com.verizon.ads.Logger;
import java.util.HashSet;
import java.util.Set;

public final class ActivityStateManager
implements Application.ActivityLifecycleCallbacks {
    private static final Logger logger = Logger.getInstance(ActivityStateManager.class);
    private SparseArray<ActivityState> activityStates = new SparseArray();
    private SparseArray<Set<ActivityObserver>> activityObserverRegistrations = new SparseArray();
    private Set<ActivityObserver> unfilteredActivityObservers = new HashSet<ActivityObserver>();

    ActivityStateManager(Application application) {
        if (application == null) {
            logger.e("application cannot be null.");
            return;
        }
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public synchronized void registerActivityObserver(Activity activity, ActivityObserver activityObserver) {
        if (activity == null) {
            this.unfilteredActivityObservers.add(activityObserver);
            return;
        }
        HashSet<ActivityObserver> activityObservers = (HashSet<ActivityObserver>)this.activityObserverRegistrations.get(activity.hashCode());
        if (activityObservers == null) {
            activityObservers = new HashSet<ActivityObserver>();
            this.activityObserverRegistrations.put(activity.hashCode(), activityObservers);
        }
        activityObservers.add(activityObserver);
    }

    public synchronized void unregisterActivityObserver(Activity activity, ActivityObserver activityObserver) {
        if (activity == null) {
            this.unfilteredActivityObservers.remove(activityObserver);
            return;
        }
        Set activityObservers = (Set)this.activityObserverRegistrations.get(activity.hashCode());
        if (activityObservers == null || activityObservers.isEmpty()) {
            this.activityObserverRegistrations.remove(activity.hashCode());
            return;
        }
        activityObservers.remove(activityObserver);
    }

    public synchronized ActivityState getState(Activity activity) {
        if (activity == null) {
            logger.w("activity should not be null.");
            return ActivityState.UNKNOWN;
        }
        ActivityState activityState = (ActivityState)((Object)this.activityStates.get(activity.hashCode()));
        if (activityState == null) {
            return ActivityState.UNKNOWN;
        }
        return activityState;
    }

    synchronized void setState(final Activity activity, final ActivityState activityState) {
        if (activity == null) {
            logger.e("activity must not be null.");
            return;
        }
        if (activityState == null) {
            logger.e("activityState must not be null.");
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ActivityStateManager activityStateManager = ActivityStateManager.this;
                synchronized (activityStateManager) {
                    ActivityStateManager.this.activityStates.put(activity.hashCode(), (Object)activityState);
                }
            }
        });
    }

    public synchronized void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.activityStates.put(activity.hashCode(), (Object)ActivityState.CREATED);
        for (ActivityObserver activityObserver : this.unfilteredActivityObservers) {
            activityObserver.onCreated(activity);
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        this.activityStates.put(activity.hashCode(), (Object)ActivityState.STARTED);
        for (ActivityObserver activityObserver : this.unfilteredActivityObservers) {
            activityObserver.onStarted(activity);
        }
        Set activityObservers = (Set)this.activityObserverRegistrations.get(activity.hashCode());
        if (activityObservers != null) {
            for (ActivityObserver activityObserver : activityObservers) {
                activityObserver.onStarted(activity);
            }
        }
    }

    public synchronized void onActivityResumed(Activity activity) {
        this.activityStates.put(activity.hashCode(), (Object)ActivityState.RESUMED);
        for (ActivityObserver activityObserver : this.unfilteredActivityObservers) {
            activityObserver.onResumed(activity);
        }
        Set activityObservers = (Set)this.activityObserverRegistrations.get(activity.hashCode());
        if (activityObservers != null) {
            for (ActivityObserver activityObserver : activityObservers) {
                activityObserver.onResumed(activity);
            }
        }
    }

    public synchronized void onActivityPaused(Activity activity) {
        this.activityStates.put(activity.hashCode(), (Object)ActivityState.PAUSED);
        for (ActivityObserver activityObserver : this.unfilteredActivityObservers) {
            activityObserver.onPaused(activity);
        }
        Set activityObservers = (Set)this.activityObserverRegistrations.get(activity.hashCode());
        if (activityObservers != null) {
            for (ActivityObserver activityObserver : activityObservers) {
                activityObserver.onPaused(activity);
            }
        }
    }

    public synchronized void onActivityStopped(Activity activity) {
        this.activityStates.put(activity.hashCode(), (Object)ActivityState.STOPPED);
        for (ActivityObserver activityObserver : this.unfilteredActivityObservers) {
            activityObserver.onStopped(activity);
        }
        Set activityObservers = (Set)this.activityObserverRegistrations.get(activity.hashCode());
        if (activityObservers != null) {
            for (ActivityObserver activityObserver : activityObservers) {
                activityObserver.onStopped(activity);
            }
        }
    }

    public synchronized void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        for (ActivityObserver activityObserver : this.unfilteredActivityObservers) {
            activityObserver.onSaveInstanceState(activity);
        }
        Set activityObservers = (Set)this.activityObserverRegistrations.get(activity.hashCode());
        if (activityObservers != null) {
            for (ActivityObserver activityObserver : activityObservers) {
                activityObserver.onSaveInstanceState(activity);
            }
        }
    }

    public synchronized void onActivityDestroyed(Activity activity) {
        this.activityStates.remove(activity.hashCode());
        for (ActivityObserver activityObserver : this.unfilteredActivityObservers) {
            activityObserver.onDestroyed(activity);
        }
        Set activityObservers = (Set)this.activityObserverRegistrations.get(activity.hashCode());
        if (activityObservers != null) {
            for (ActivityObserver activityObserver : activityObservers) {
                activityObserver.onDestroyed(activity);
            }
        }
        this.activityObserverRegistrations.remove(activity.hashCode());
    }

    public static abstract class ActivityObserver {
        protected static final Logger logger = Logger.getInstance(ActivityObserver.class);

        protected void onCreated(Activity activity) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Activity <%d> created.", activity.hashCode()));
            }
        }

        protected void onDestroyed(Activity activity) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Activity <%d> destroyed.", activity.hashCode()));
            }
        }

        protected void onPaused(Activity activity) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Activity <%d> paused.", activity.hashCode()));
            }
        }

        protected void onResumed(Activity activity) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Activity <%d> resumed.", activity.hashCode()));
            }
        }

        protected void onSaveInstanceState(Activity activity) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Activity <%d> instance state saved.", activity.hashCode()));
            }
        }

        protected void onStarted(Activity activity) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Activity <%d> started.", activity.hashCode()));
            }
        }

        protected void onStopped(Activity activity) {
            if (Logger.isLogLevelEnabled(3)) {
                logger.d(String.format("Activity <%d> stopped.", activity.hashCode()));
            }
        }
    }

    public static enum ActivityState {
        CREATED,
        DESTROYED,
        PAUSED,
        RESUMED,
        STARTED,
        STOPPED,
        UNKNOWN;

    }
}

