/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin.utils;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import com.veracode.jenkins.plugin.utils.StringUtil;
import hudson.PluginWrapper;
import hudson.util.VersionNumber;
import jenkins.model.Jenkins;

public class UserAgentUtil {
    private static final String DEFAULT_USER_AGENT = "VeracodeScanJenkins";
    private static final String VERACODE_PLUGIN_CLASS = "veracode-scan";
    private static final String UNKNOWN_VALUE = "Unknown";
    private static final String USERAGENT_HEADER_FORMAT = "%s/%s (Jenkins/%s; Java/%s)";

    public static String getVersionDetails() {
        String pluginVersion = UserAgentUtil.getPluginVersion();
        String jenkinsVersion = UserAgentUtil.getJenkinsVersion();
        String javaVersion = UserAgentUtil.getJavaVersion();
        return String.format(USERAGENT_HEADER_FORMAT, DEFAULT_USER_AGENT, pluginVersion, jenkinsVersion, javaVersion);
    }

    private static String getJavaVersion() {
        try {
            String jreVersion = VeracodeCommand.getJreVersion();
            return StringUtil.isNullOrEmpty(jreVersion) ? UNKNOWN_VALUE : jreVersion;
        }
        catch (Throwable t) {
            return UNKNOWN_VALUE;
        }
    }

    private static String getPluginVersion() {
        try {
            PluginWrapper pluginWrapper = Jenkins.get().getPluginManager().getPlugin(VERACODE_PLUGIN_CLASS);
            if (pluginWrapper == null) {
                throw new RuntimeException("Cannot locate the plugin.");
            }
            String pluginVersion = pluginWrapper.getVersion();
            return StringUtil.isNullOrEmpty(pluginVersion) ? UNKNOWN_VALUE : pluginVersion;
        }
        catch (Throwable t) {
            return UNKNOWN_VALUE;
        }
    }

    private static String getJenkinsVersion() {
        try {
            VersionNumber versionNumber = Jenkins.getVersion();
            if (versionNumber == null) {
                throw new RuntimeException("Cannot retrieve Jenkins version number.");
            }
            String jenkinsVersion = versionNumber.toString();
            return StringUtil.isNullOrEmpty(jenkinsVersion) ? UNKNOWN_VALUE : jenkinsVersion;
        }
        catch (Throwable t) {
            return UNKNOWN_VALUE;
        }
    }
}

