/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin.utils;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import com.veracode.jenkins.plugin.VeracodeNotifier;
import com.veracode.jenkins.plugin.common.Constant;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.Properties;
import jenkins.model.Jenkins;
import org.jenkinsci.remoting.RoleChecker;

public final class FileUtil {
    private static final String VERACODE_PROPERTIES_FILE_NAME = "veracode.properties";

    public static boolean deleteDirectory(File file) {
        File[] list;
        if (file.isDirectory() && (list = file.listFiles()) != null) {
            for (File f : list) {
                FileUtil.deleteDirectory(f);
            }
        }
        return file.delete();
    }

    public static String[] getStringFilePaths(FilePath[] filePaths) throws IOException, InterruptedException {
        String[] stringFilePaths = new String[filePaths.length];
        for (int x = 0; x < filePaths.length; ++x) {
            try {
                stringFilePaths[x] = FileUtil.getStringFilePath(filePaths[x]);
                continue;
            }
            catch (IOException ioe) {
                throw new IOException(String.format("Could not locate the specified file: %s.", filePaths[x]), ioe);
            }
            catch (InterruptedException ie) {
                throw new InterruptedException(String.format("Could not locate the specified file: %s.", filePaths[x]));
            }
        }
        return stringFilePaths;
    }

    public static String getStringFilePath(FilePath filePath) throws IOException, InterruptedException {
        return (String)filePath.act((FilePath.FileCallable)new FileCallableImpl());
    }

    public static boolean copyJarFiles(AbstractBuild<?, ?> build, FilePath local, FilePath remote, PrintStream ps) throws Exception {
        boolean bRet;
        block3: {
            bRet = false;
            try {
                Node node = build.getBuiltOn();
                if (node == null) {
                    throw new RuntimeException("Cannot locate the build node.");
                }
                local.copyRecursiveTo("vosp-api-wrappers-java*.jar", null, remote);
                FilePath[] files = remote.list("vosp-api-wrappers-java*.jar");
                String jarName = files[0].getRemote();
                FilePath oldJar = new FilePath(node.getChannel(), jarName);
                String newJarName = jarName.replaceAll("(vosp-api-wrappers).*?(.jar)", "VeracodeJavaAPI$2");
                FilePath newjarFilePath = new FilePath(node.getChannel(), newJarName);
                oldJar.copyToWithPermission(newjarFilePath);
                bRet = true;
            }
            catch (RuntimeException ex) {
                VeracodeNotifier.VeracodeDescriptor veracodeDescriptor = (VeracodeNotifier.VeracodeDescriptor)Jenkins.get().getDescriptor(VeracodeNotifier.class);
                if (veracodeDescriptor == null || !veracodeDescriptor.getFailbuild()) break block3;
                ps.println("Failed to copy the jarfiles\n");
            }
        }
        return bRet;
    }

    public static FilePath getLocalWorkspaceFilepath() throws URISyntaxException {
        File wrapperFile = new File(VeracodeCommand.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        return new FilePath(wrapperFile.getParentFile());
    }

    public static boolean cleanUpBuildProperties(Run<?, ?> run, TaskListener listener) {
        File file = null;
        try {
            file = new File(run.getRootDir().getParent() + File.separator + VERACODE_PROPERTIES_FILE_NAME);
            if (file.exists()) {
                Files.delete(file.toPath());
            }
            return true;
        }
        catch (IOException e) {
            listener.getLogger().println(Constant.NEWLINE + Constant.NEWLINE + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createBuildPropertiesFile(Run<?, ?> run, Properties properties, TaskListener listener) throws IOException {
        File file = null;
        try (FileOutputStream fileOutputStream = null;){
            file = new File(run.getRootDir().getParent() + File.separator + VERACODE_PROPERTIES_FILE_NAME);
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "Veracode");
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readBuildPropertiesFile(Run<?, ?> run, TaskListener listener) throws IOException {
        File file = null;
        FileInputStream fileInputStream = null;
        Properties properties = null;
        try {
            file = new File(run.getRootDir().getParent() + File.separator + VERACODE_PROPERTIES_FILE_NAME);
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                properties = new Properties();
                properties.load(fileInputStream);
            }
        }
        catch (FileNotFoundException e) {
            listener.getLogger().print(Constant.NEWLINE + Constant.NEWLINE + e.getMessage());
        }
        catch (IOException e) {
            listener.getLogger().print(Constant.NEWLINE + Constant.NEWLINE + e.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            FileUtil.cleanUpBuildProperties(run, listener);
        }
        return properties;
    }

    private FileUtil() {
    }

    public static final class FileCallableImpl
    implements FilePath.FileCallable<String> {
        private static final long serialVersionUID = 1L;

        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return f.getPath();
        }

        public void checkRoles(RoleChecker arg0) throws SecurityException {
        }
    }
}

