/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin.args;

import com.veracode.jenkins.plugin.utils.StringUtil;
import hudson.EnvVars;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractArgs {
    private static final byte MASKED_ARG_LENGTH = 8;
    private static final String API_ID_ENV_VAR = "VERACODE_API_KEY_ID";
    private static final String API_KEY_ENV_VAR = "VERACODE_API_KEY_SECRET";
    private static final String DELIMITER_COLON = ":";
    private static final String DELIMITER_AT = "@";
    private static final String PROTOCOL = "https://";
    private static final String HTTPS_PROXY_ENV_VAR = "https_proxy";
    protected static final String SWITCH = "-";
    protected static final String ACTION = "-action";
    protected static final String PHOST = "-phost";
    protected static final String PPASSWORD = "-ppassword";
    protected static final String PPORT = "-pport";
    protected static final String PUSER = "-puser";
    protected static final String VID = "-vid";
    protected static final String VKEY = "-vkey";
    protected static final String USERAGENT = "-useragent";
    protected final List<String> list = new ArrayList<String>();

    protected AbstractArgs() {
    }

    protected void addProxyConfiguration(String phost, String pport) {
        if (!StringUtil.isNullOrEmpty(phost)) {
            this.list.add(PHOST);
            this.list.add(phost);
        }
        if (!StringUtil.isNullOrEmpty(pport)) {
            this.list.add(PPORT);
            this.list.add(pport);
        }
    }

    protected void addProxyCredentials(String puser, String ppassword) {
        if (!StringUtil.isNullOrEmpty(puser)) {
            this.list.add(PUSER);
            this.list.add(puser);
        }
        if (!StringUtil.isNullOrEmpty(ppassword)) {
            this.list.add(PPASSWORD);
            this.list.add(ppassword);
        }
    }

    protected void addProxyConfiguration(boolean isRemote, EnvVars envVars, String phost, String pport, String puser, String ppassword) {
        if (isRemote && envVars != null) {
            StringBuilder httpsProxy = new StringBuilder();
            httpsProxy.append(PROTOCOL);
            if (!StringUtil.isNullOrEmpty(puser)) {
                httpsProxy.append(AbstractArgs.encodeURLPart(puser));
                if (ppassword != null) {
                    httpsProxy.append(DELIMITER_COLON).append(AbstractArgs.encodeURLPart(ppassword));
                }
                httpsProxy.append(DELIMITER_AT);
            }
            httpsProxy.append(phost).append(DELIMITER_COLON).append(pport);
            envVars.put(HTTPS_PROXY_ENV_VAR, httpsProxy.toString());
            return;
        }
        this.addProxyCredentials(puser, ppassword);
        this.addProxyConfiguration(phost, pport);
    }

    private static String encodeURLPart(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException();
        }
    }

    protected void addApiCredentials(boolean isRemote, EnvVars envVars, String vid, String vkey) {
        if (isRemote && envVars != null) {
            if (!StringUtil.isNullOrEmpty(vid)) {
                envVars.put(API_ID_ENV_VAR, vid);
            }
            if (!StringUtil.isNullOrEmpty(vkey)) {
                envVars.put(API_KEY_ENV_VAR, vkey);
            }
            return;
        }
        if (!StringUtil.isNullOrEmpty(vid)) {
            this.list.add(VID);
            this.list.add(vid);
        }
        if (!StringUtil.isNullOrEmpty(vkey)) {
            this.list.add(VKEY);
            this.list.add(vkey);
        }
    }

    protected void addAction(String action) {
        if (!StringUtil.isNullOrEmpty(action)) {
            this.list.add(ACTION);
            this.list.add(action);
        }
    }

    public String[] getArguments() {
        return this.list.toArray(new String[0]);
    }

    public String[] getMaskedArguments() {
        String[] args = this.getArguments();
        for (int x = 0; x < args.length; ++x) {
            if (!VKEY.equals(args[x]) && !PPASSWORD.equals(args[x]) || x % 2 != 0 || x >= args.length - 1 || args[x + 1] == null) continue;
            args[x + 1] = StringUtil.repeatChar('*', args[x + 1].length() > 0 ? 8 : 0);
        }
        return args;
    }
}

