/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.jenkins.plugin.TrendChart;
import com.veracode.jenkins.plugin.data.BuildHistory;
import com.veracode.jenkins.plugin.data.FindingCounts;
import com.veracode.jenkins.plugin.data.SCAComponent;
import com.veracode.jenkins.plugin.data.SCAScanHistory;
import com.veracode.jenkins.plugin.data.ScanHistory;
import com.veracode.jenkins.plugin.enums.SeverityLevel;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.RunAction2;
import org.apache.commons.lang.StringEscapeUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class VeracodeAction
implements RunAction2 {
    private final ScanHistory scanHistory;
    private transient Run<?, ?> build;
    private final String xmlApiHost;

    public VeracodeAction() {
        this.scanHistory = null;
        this.xmlApiHost = null;
        this.build = null;
    }

    public VeracodeAction(ScanHistory scanHistory, String xmlApiHost) {
        if (null == scanHistory || null == xmlApiHost) {
            throw new IllegalArgumentException("Missing required information to create a VeracodeAction.");
        }
        this.scanHistory = scanHistory;
        this.xmlApiHost = xmlApiHost;
        this.build = null;
    }

    public String getIconFileName() {
        return "/plugin/veracode-scan/icons/veracode-24x24.png";
    }

    public String getDisplayName() {
        return "Veracode Static Scan";
    }

    public String getUrlName() {
        return "veracode";
    }

    public void onAttached(Run<?, ?> r) {
        this.setBuild(r);
    }

    public void onLoad(Run<?, ?> r) {
        this.setBuild(r);
    }

    public String getPolicyName() {
        return this.scanHistory.getPolicyName();
    }

    public String getPolicyNameForHTML() {
        return StringEscapeUtils.escapeHtml((String)this.scanHistory.getPolicyName());
    }

    public String getPolicyComplianceStatus() {
        return this.scanHistory.getPolicyComplianceStatus();
    }

    public String getPolicyComplianceStatusForHTML() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        return StringEscapeUtils.escapeHtml((String)(complianceStatus.equalsIgnoreCase("Pass") ? "Passed" : complianceStatus));
    }

    public String getVeracodeLevel() {
        return this.scanHistory.getVeracodeLevel();
    }

    public String getVeracodeLevelForHTML() {
        return StringEscapeUtils.escapeHtml((String)this.scanHistory.getVeracodeLevel());
    }

    public int getAnalysisScore() {
        return this.scanHistory.getScore();
    }

    public String getScanOverdueStatus() {
        return this.scanHistory.isScanOverdue() ? "Did not pass" : "Passed";
    }

    public String getVeracodeLogo48() {
        return "/plugin/veracode-scan/icons/veracode-48x48.png";
    }

    public String getPolicyComplianceStatusIconUri16() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        String iconName = complianceStatus.equalsIgnoreCase("Pass") ? "shield-green-16x16.png" : (complianceStatus.equalsIgnoreCase("Did not pass") ? "shield-red-16x16.png" : (complianceStatus.equalsIgnoreCase("Conditional pass") ? "shield-yellow-16x16.png" : "shield-gray-16x16.png"));
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public String getPolicyComplianceStatusIconUri24() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        String iconName = complianceStatus.equalsIgnoreCase("Pass") ? "shield-green-24x24.png" : (complianceStatus.equalsIgnoreCase("Did not pass") ? "shield-red-24x24.png" : (complianceStatus.equalsIgnoreCase("Conditional pass") ? "shield-yellow-24x24.png" : "shield-gray-24x24.png"));
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public String getPolicyComplianceStatusIconUri32() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        String iconName = complianceStatus.equalsIgnoreCase("Pass") ? "shield-green-32x32.png" : (complianceStatus.equalsIgnoreCase("Did not pass") ? "shield-red-32x32.png" : (complianceStatus.equalsIgnoreCase("Conditional pass") ? "shield-yellow-32x32.png" : "shield-gray-32x32.png"));
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public String getPolicyComplianceStatusIconUri48() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        String iconName = complianceStatus.equalsIgnoreCase("Pass") ? "shield-green-48x48.png" : (complianceStatus.equalsIgnoreCase("Did not pass") ? "shield-red-48x48.png" : (complianceStatus.equalsIgnoreCase("Conditional pass") ? "shield-yellow-48x48.png" : "shield-gray-48x48.png"));
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public String getOpenNewWindow16() {
        return "/plugin/veracode-scan/icons/open-new-window-16x16.png";
    }

    public boolean isStaticSevLevelMitigated(int severity) {
        boolean result = false;
        try {
            result = this.scanHistory.getMitigateFlag(severity);
        }
        catch (IllegalArgumentException iae) {
            result = false;
        }
        return result;
    }

    public String getFlawsCount(int severity) {
        String displayFlawsCount;
        try {
            int flawsCount = this.scanHistory.getFlawsCount(severity);
            displayFlawsCount = this.isStaticSevLevelMitigated(severity) ? flawsCount + "*" : (flawsCount > 0 ? Integer.toString(flawsCount) : "");
        }
        catch (IllegalArgumentException iae) {
            displayFlawsCount = "";
        }
        return displayFlawsCount;
    }

    public int getTotalFlawsCount() {
        return this.scanHistory.getTotalFlawsCount();
    }

    public int getTotalNewFlawsCount() {
        return this.scanHistory.getTotalNewFlawsCount();
    }

    public int getTotalNetChangeCount() {
        return this.scanHistory.getTotalNetChangeCount();
    }

    public String getNetChange(int severity) {
        int netChange = this.scanHistory.getNetChange(severity);
        String displayNetChange = "";
        if (netChange > 0) {
            displayNetChange = "+" + Integer.toString(netChange);
        } else if (netChange < 0) {
            displayNetChange = Integer.toString(netChange);
        }
        return displayNetChange;
    }

    public String getNewFlaws(int severity) {
        int newFlaw = this.scanHistory.getNewFlaws(severity);
        return newFlaw > 0 ? Integer.toString(newFlaw) : "";
    }

    public List<Map<String, Long>> getFlawsCountHistory() {
        return this.scanHistory.getFlawsCountHistory();
    }

    public void doGraph(StaplerRequest request, StaplerResponse response) {
        try {
            ArrayList<BuildHistory> buildHistoryList = new ArrayList<BuildHistory>();
            BuildHistory staticBuildHistory = new BuildHistory("Static Flaws", this.scanHistory.getFlawsCountHistory());
            buildHistoryList.add(staticBuildHistory);
            if (null != this.getVulCountHistory()) {
                BuildHistory vulnerBuildHistory = new BuildHistory("SCA Vulnerabilities", this.getVulCountHistory());
                buildHistoryList.add(vulnerBuildHistory);
            }
            TrendChart trendChart = new TrendChart(System.currentTimeMillis(), 600, 400, buildHistoryList);
            trendChart.doPng(request, response);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to generate the Flaw trend graph.");
        }
    }

    public String getDetailedReportURLForHTMLAttr() {
        String escapedAcctId = StringEscapeUtils.escapeHtml((String)this.scanHistory.getAccountId());
        String escapedAppId = StringEscapeUtils.escapeHtml((String)this.scanHistory.getAppId());
        String escapedBuildId = StringEscapeUtils.escapeHtml((String)this.scanHistory.getBuildId());
        return String.format("https://%s/auth/index.jsp#ViewReportsDetailedReport", null == this.xmlApiHost ? "analysiscenter.veracode.com" : this.xmlApiHost) + ":" + escapedAcctId + ":" + escapedAppId + ":" + escapedBuildId;
    }

    public boolean isScanHistoryAvailable() {
        return null != this.scanHistory;
    }

    private void setBuild(Run<?, ?> build) {
        this.build = build;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public boolean isSCAHistoryAvailable() {
        return null != this.scanHistory ? this.scanHistory.hasSCAHistory() : false;
    }

    public boolean isSubscribedToSCA() {
        return this.isSCAHistoryAvailable() ? this.scanHistory.getScaHistory().isSubscribed() : false;
    }

    public double getMaxCVSSScore() {
        double score = -2.0;
        if (this.isSCAHistoryAvailable()) {
            score = this.scanHistory.getScaHistory().getMaxCVSSScore();
        }
        return score;
    }

    public String getMaxCVSSScoreForHTML() {
        double score = this.getMaxCVSSScore();
        String result = "";
        if (-1.0 == score) {
            result = "-";
        } else if (-2.0 != score) {
            result = String.valueOf(score);
        }
        return result;
    }

    public int getBlacklistedCompsCount() {
        return this.isSCAHistoryAvailable() ? this.scanHistory.getScaHistory().getBlacklistedComponentsCount() : -1;
    }

    public String getBlacklistedCompsCountForHTML() {
        int count = this.getBlacklistedCompsCount();
        return count == -1 ? "0" : String.valueOf(count);
    }

    private FindingCounts getCountBySeverity(int severity) {
        if (!this.isSCAHistoryAvailable()) {
            return null;
        }
        FindingCounts result = null;
        try {
            result = this.scanHistory.getScaHistory().getCountBySeverity(SeverityLevel.findSevLevel(severity));
        }
        catch (IllegalArgumentException iae) {
            result = null;
        }
        return result;
    }

    public String getVulCountForDisplayBySeverity(int severity) {
        FindingCounts fc = this.getCountBySeverity(severity);
        String result = "";
        result = null != fc ? (fc.isMitigated() ? fc.getCount() + "*" : (fc.getCount() > 0 ? Integer.toString(fc.getCount()) : "")) : null;
        return result;
    }

    public boolean getPolicyAffection(int severity) {
        boolean result = false;
        try {
            result = this.scanHistory.getPolicyAffection(severity);
        }
        catch (IllegalArgumentException | NullPointerException iae) {
            result = false;
        }
        return result;
    }

    public String getNewVulCountForDisplayBySeverity(int severity) {
        FindingCounts fc = this.getCountBySeverity(severity);
        String result = "";
        result = null != fc ? (fc.getNewCount() > 0 ? Integer.toString(fc.getNewCount()) : "") : null;
        return result;
    }

    public String getNetVulCountForDisplayBySeverity(int severity) {
        FindingCounts fc = this.getCountBySeverity(severity);
        String result = "";
        result = null != fc ? (fc.getNetCount() == 0 ? "" : (fc.getNetCount() > 0 ? "+" + fc.getNetCount() : Integer.toString(fc.getNetCount()))) : null;
        return result;
    }

    public boolean isSCASevLevelMitigated(int severity) {
        if (!this.isSCAHistoryAvailable()) {
            return false;
        }
        boolean result = false;
        try {
            FindingCounts fc = this.scanHistory.getScaHistory().getCountBySeverity(SeverityLevel.findSevLevel(severity));
            if (null != fc) {
                result = fc.isMitigated();
            }
        }
        catch (IllegalArgumentException iae) {
            result = false;
        }
        return result;
    }

    public int getTotalVulCount() {
        return this.isSCAHistoryAvailable() ? this.scanHistory.getScaHistory().getTotalVulCount() : -1;
    }

    public String getTotalVulCountForDisplay() {
        int count = this.getTotalVulCount();
        return count > 0 ? String.valueOf(count) : "0";
    }

    public int getTotalNewVulCount() {
        return this.isSCAHistoryAvailable() ? this.scanHistory.getScaHistory().getTotalNewVulCount() : -1;
    }

    public String getTotalNewVulCountForDisplay() {
        int count = this.getTotalNewVulCount();
        return count > 0 ? String.valueOf(count) : "0";
    }

    public Integer getTotalNetVulCount() {
        return this.isSCAHistoryAvailable() ? Integer.valueOf(this.scanHistory.getScaHistory().getTotalNetVulCount()) : null;
    }

    public String getTotalNetVulCountForDisplay() {
        String totalNetVulCount = "0";
        if (null != this.getTotalNetVulCount()) {
            totalNetVulCount = String.valueOf(this.getTotalNetVulCount());
        }
        return totalNetVulCount;
    }

    public boolean isNewSCAComponents() {
        boolean isNewComponents = false;
        if (this.isSCAHistoryAvailable()) {
            for (SCAComponent component : this.scanHistory.getScaHistory().getSCAComponents()) {
                if (!component.isNew()) continue;
                isNewComponents = true;
                break;
            }
        }
        return isNewComponents;
    }

    public ArrayList<String> getNewSCAComponentsByPolicyStatus(boolean isViolatedPolicy) {
        ArrayList<String> componentArray = new ArrayList<String>();
        for (SCAComponent component : this.scanHistory.getScaHistory().getSCAComponents()) {
            if (!component.isNew() || isViolatedPolicy != component.isViolatedPolicy()) continue;
            componentArray.add(component.getName());
        }
        Collections.sort(componentArray);
        return componentArray;
    }

    public String getPolicyComplianceComponentIconUri(boolean isViolatedPolicy) {
        String iconName = "";
        iconName = isViolatedPolicy ? "fail-policy-component.png" : "pass-policy-component.png";
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public List<Map<String, Long>> getVulCountHistory() {
        return this.isSCAHistoryAvailable() ? this.scanHistory.getScaHistory().getVulCountHistory() : null;
    }

    public SCAScanHistory getSCAScanHistory() {
        return this.isSCAHistoryAvailable() ? this.scanHistory.getScaHistory() : null;
    }
}

