/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.jenkins.plugin.data.BuildHistory;
import hudson.util.Graph;
import java.awt.Color;
import java.awt.Paint;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class TrendChart
extends Graph {
    private final CategoryDataset dataset;

    public TrendChart(long timestamp, int defaultW, int defaultH, Collection<BuildHistory> buildHistoryList) {
        super(timestamp, defaultW, defaultH);
        this.dataset = this.createDataset(buildHistoryList);
    }

    private void populateDataset(DefaultCategoryDataset dataset, String dataType, List<Map<String, Long>> buildList) {
        if (null == dataset || null == buildList || buildList.size() == 0) {
            return;
        }
        for (Map<String, Long> currEntry : buildList) {
            Long value = currEntry.get("BUILD_DATE");
            String buildDate = value != null ? this.formatDate(value) : null;
            if (null == buildDate || null == (value = currEntry.get("FLAWS_COUNT"))) continue;
            dataset.addValue((Number)value, (Comparable)((Object)dataType), (Comparable)((Object)buildDate));
        }
    }

    private CategoryDataset createDataset(Collection<BuildHistory> buildHistoryList) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (BuildHistory iter : buildHistoryList) {
            if (iter.getBuildType() == null || iter.getBuildList() == null) continue;
            this.populateDataset(dataset, iter.getBuildType(), iter.getBuildList());
        }
        return dataset;
    }

    private String formatDate(Long value) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(value);
        String buildDate = String.format("%s/%s %02d:%02d", date.getDisplayName(2, 1, Locale.getDefault()), date.get(5), date.get(11), date.get(12));
        return buildDate;
    }

    protected JFreeChart createGraph() {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"", (String)"", (String)"", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        CategoryAxis domainAxis = plot.getDomainAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        StackedBarRenderer renderer = (StackedBarRenderer)plot.getRenderer();
        Color p1 = new Color(117, 205, 235);
        Color p2 = new Color(122, 96, 168);
        renderer.setSeriesPaint(0, (Paint)p1);
        renderer.setSeriesPaint(1, (Paint)p2);
        renderer.setMaximumBarWidth(0.125);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chart;
    }
}

