/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import com.veracode.jenkins.plugin.args.DynamicRescanArgs;
import com.veracode.jenkins.plugin.utils.FileUtil;
import com.veracode.jenkins.plugin.utils.RemoteScanUtil;
import com.veracode.jenkins.plugin.utils.StringUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DynamicRescanPipelineRecorder
extends Recorder
implements SimpleBuildStep {
    @DataBoundSetter
    public final String applicationName;
    @DataBoundSetter
    public final boolean dvrEnabled;
    @DataBoundSetter
    public final boolean canFailJob;
    @DataBoundSetter
    public final boolean debug;
    @DataBoundSetter
    public final String vid;
    @DataBoundSetter
    public final String vkey;
    @DataBoundSetter
    public final boolean useProxy;
    @DataBoundSetter
    public final String pHost;
    @DataBoundSetter
    public final int pPort;
    @DataBoundSetter
    public final String pUser;
    @DataBoundSetter
    public final String pPassword;

    @DataBoundConstructor
    public DynamicRescanPipelineRecorder(String applicationName, boolean dvrEnabled, boolean canFailJob, boolean debug, boolean useProxy, String pHost, int pPort, String pUser, String pPassword, String vid, String vkey) {
        this.canFailJob = canFailJob;
        this.debug = debug;
        this.applicationName = applicationName;
        this.dvrEnabled = dvrEnabled;
        this.vid = vid;
        this.vkey = vkey;
        this.useProxy = useProxy;
        this.pHost = pHost;
        this.pPort = pPort;
        this.pUser = pUser;
        this.pPassword = pPassword;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream ps = listener.getLogger();
        ps.println("------------------------------------------------------------------------");
        ps.println("Dynamic Rescan with Veracode Pipeline");
        ps.println("------------------------------------------------------------------------");
        EnvVars envVars = run.getEnvironment(listener);
        if (this.debug) {
            ps.println("\r\n[Debug mode is on]\r\n");
            ps.println(String.format("Can Fail Job: %s%n", this.canFailJob));
            try {
                Method method = VeracodeCommand.class.getDeclaredMethod("getVersionString", new Class[0]);
                method.setAccessible(true);
                String version = (String)method.invoke(null, new Object[0]);
                if (!StringUtil.isNullOrEmpty(version)) {
                    ps.println(String.format("Version information:%n%s", version));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                ps.println("Could not retrieve API wrapper's version information.");
            }
            try {
                String location = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toString();
                if (!StringUtil.isNullOrEmpty(location)) {
                    ps.println("\r\nHPI location: ");
                    location = location.replace("file:/", "");
                    listener.hyperlink("file://" + location, location);
                }
            }
            catch (Exception e) {
                ps.println("\r\nCould not retrieve hpi file's directory.");
            }
        }
        boolean isRemoteWorkspace = workspace.isRemote();
        if (this.debug) {
            ps.println(String.format("%n%nProcessing files in [%s] workspace: ", isRemoteWorkspace ? "remote" : "local"));
            String workspaceDir = workspace.getRemote();
            workspaceDir = workspaceDir.replace("\\", "/");
            listener.hyperlink("file://" + workspaceDir, workspaceDir);
        }
        File localWorkspaceDir = null;
        try {
            if (isRemoteWorkspace) {
                if (this.copyJarRemoteBuild(workspace, listener)) {
                    if (this.runScanFromRemote(run, workspace, listener, ps) || !this.canFailJob) return;
                    run.setResult(Result.FAILURE);
                    return;
                } else {
                    if (!this.canFailJob) return;
                    ps.println("Could not copy Veracode libs");
                    run.setResult(Result.FAILURE);
                }
                return;
            }
            if (this.debug) {
                ps.print("\r\n\r\nBuilding arguments. ");
            }
            boolean autoApplicationName = false;
            boolean autoScanName = false;
            boolean createAutoApplicationDescription = false;
            DynamicRescanArgs pipelineScanArguments = DynamicRescanArgs.pipelineRescanArgs(autoApplicationName, createAutoApplicationDescription, autoScanName, this.useProxy, this.vid, this.vkey, run.getDisplayName(), run.getParent().getFullDisplayName(), this.applicationName, this.dvrEnabled, this.pHost, Integer.toString(this.pPort), this.pUser, this.pPassword, workspace, envVars, false);
            if (this.debug) {
                ps.println(String.format("Calling wrapper with arguments:%n%s%n", Arrays.toString(pipelineScanArguments.getMaskedArguments())));
            }
            try {
                VeracodeCommand.VeracodeParser parser = new VeracodeCommand.VeracodeParser();
                parser.setOutputWriter(ps);
                parser.setErrorWriter(ps);
                parser.throwExceptions(true);
                int retCode = parser.parse(pipelineScanArguments.getArguments());
                if (retCode == 0 || !this.canFailJob) return;
                ps.print("\r\n\r\nError- Returned code from wrapper:" + retCode + "\r\n\n");
                return;
            }
            catch (Exception e) {
                ps.print("\r\n\r\n" + e.getMessage());
            }
            return;
        }
        finally {
            if (isRemoteWorkspace) {
                try {
                    if (localWorkspaceDir != null && localWorkspaceDir.exists()) {
                        FileUtil.deleteDirectory(localWorkspaceDir);
                    }
                }
                catch (Exception e) {
                    ps.print("\r\n\r\n" + e.getMessage());
                }
            }
        }
    }

    public PipelineDynamicRescanDescriptorImpl getDescriptor() {
        return (PipelineDynamicRescanDescriptorImpl)super.getDescriptor();
    }

    private boolean copyJarFiles(Node node, FilePath local, FilePath remote, PrintStream ps) throws Exception {
        boolean bRet;
        block2: {
            bRet = false;
            try {
                local.copyRecursiveTo("vosp-api-wrappers-java*.jar", null, remote);
                FilePath[] files = remote.list("vosp-api-wrappers-java*.jar");
                String jarName = files[0].getRemote();
                FilePath oldJar = new FilePath(node.getChannel(), jarName);
                String newJarName = jarName.replaceAll("(vosp-api-wrappers).*?(.jar)", "VeracodeJavaAPI$2");
                FilePath newjarFilePath = new FilePath(node.getChannel(), newJarName);
                oldJar.copyToWithPermission(newjarFilePath);
                bRet = true;
            }
            catch (RuntimeException ex) {
                if (!this.canFailJob) break block2;
                ps.print("Failed to copy the veracode java-wrapper libaries\n");
            }
        }
        return bRet;
    }

    private boolean copyJarRemoteBuild(FilePath workspace, TaskListener listener) {
        boolean bRet;
        block15: {
            bRet = false;
            PrintStream ps = listener.getLogger();
            boolean isRemoteWorkspace = workspace.isRemote();
            if (isRemoteWorkspace) {
                Computer comp = workspace.toComputer();
                if (comp == null) {
                    throw new RuntimeException("Cannot locate the remote workspace.");
                }
                Node node = comp.getNode();
                if (node == null) {
                    throw new RuntimeException("Cannot locate the remote node.");
                }
                try {
                    FilePath[] files;
                    FilePath localWorkspaceFilePath = FileUtil.getLocalWorkspaceFilepath();
                    FilePath remoteVeracodeFilePath = RemoteScanUtil.getRemoteVeracodePath(node);
                    if (remoteVeracodeFilePath == null) {
                        throw new RuntimeException("Cannot retrieve the remote file path.");
                    }
                    if (!remoteVeracodeFilePath.exists()) {
                        if (this.debug) {
                            ps.println("Making remote dir");
                        }
                        remoteVeracodeFilePath.mkdirs();
                    }
                    if ((files = remoteVeracodeFilePath.list("vosp-api-wrappers-java*.jar")).length == 0) {
                        bRet = this.copyJarFiles(node, localWorkspaceFilePath, remoteVeracodeFilePath, ps);
                    } else {
                        String oldjarName;
                        int oldVersion;
                        FilePath[] newfiles = localWorkspaceFilePath.list("vosp-api-wrappers-java*.jar");
                        String newjarName = newfiles[0].getRemote();
                        int newVersion = RemoteScanUtil.getJarVersion(newjarName);
                        if (newVersion > (oldVersion = RemoteScanUtil.getJarVersion(oldjarName = files[0].getRemote()))) {
                            if (this.debug) {
                                ps.println("Newer veracode library version, copying it to remote machine");
                            }
                            remoteVeracodeFilePath.deleteContents();
                            bRet = this.copyJarFiles(node, localWorkspaceFilePath, remoteVeracodeFilePath, ps);
                        } else {
                            String jarName = files[0].getRemote();
                            String newJarName = jarName.replaceAll("(vosp-api-wrappers).*?(.jar)", "VeracodeJavaAPI$2");
                            FilePath newjarFilePath = new FilePath(node.getChannel(), newJarName);
                            if (newjarFilePath.exists()) {
                                bRet = true;
                            }
                        }
                    }
                    break block15;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (this.canFailJob) {
                        ps.println(ex.getMessage());
                    }
                    break block15;
                }
            }
            bRet = true;
        }
        return bRet;
    }

    private boolean runScanFromRemote(Run<?, ?> run, FilePath workspace, TaskListener listener, PrintStream ps) {
        boolean bRet;
        block10: {
            bRet = false;
            boolean autoApplicationName = false;
            boolean autoScanName = true;
            boolean createAutoApplicationDescription = false;
            Computer comp = workspace.toComputer();
            if (comp == null) {
                throw new RuntimeException("Cannot locate the remote workspace.");
            }
            Node node = comp.getNode();
            if (node == null) {
                throw new RuntimeException("Cannot locate the remote node.");
            }
            FilePath remoteVeracodeFilePath = RemoteScanUtil.getRemoteVeracodePath(node);
            if (remoteVeracodeFilePath == null) {
                throw new RuntimeException("Cannot retrieve the remote file path.");
            }
            String jarFilePath = remoteVeracodeFilePath.getRemote();
            String remoteworkspace = workspace.getRemote();
            String sep = RemoteScanUtil.getPathSeparator(remoteworkspace);
            try {
                Proc proc;
                int retcode;
                EnvVars envVars = run.getEnvironment(listener);
                DynamicRescanArgs pipelineScanArguments = DynamicRescanArgs.pipelineRescanArgs(autoApplicationName, createAutoApplicationDescription, autoScanName, this.useProxy, this.vid, this.vkey, run.getDisplayName(), run.getParent().getFullDisplayName(), this.applicationName, this.dvrEnabled, this.pHost, Integer.toString(this.pPort), this.pUser, this.pPassword, workspace, envVars, true);
                String jarPath = jarFilePath + sep + "VeracodeJavaAPI" + ".jar";
                Boolean isUnix = comp.isUnix();
                if (isUnix == null) {
                    throw new RuntimeException("Failed to determine the OS.");
                }
                ArgumentListBuilder command = RemoteScanUtil.addArgumentsToCommand(jarPath, pipelineScanArguments.getArguments(), isUnix);
                Launcher launcher = node.createLauncher(listener);
                Launcher.ProcStarter procStart = new Launcher.ProcStarter(launcher);
                procStart = procStart.cmds(command).envs((Map)envVars).stdout(listener).quiet(true);
                if (this.debug) {
                    procStart.quiet(false);
                    ps.print("\nInvoking the following command in remote workspace:\n");
                }
                if ((retcode = (proc = launcher.launch(procStart)).join()) != 0 && this.canFailJob) {
                    ps.print("\r\n\r\nError- Returned code from wrapper:" + retcode + "\r\n\n");
                } else if (retcode == 0) {
                    bRet = true;
                }
            }
            catch (IOException | InterruptedException ex) {
                ex.printStackTrace();
                if (!this.canFailJob) break block10;
                ps.print("\r\n\r\n" + ex.getMessage());
            }
        }
        return bRet;
    }

    @Symbol(value={"veracodeDynamicRescan"})
    @Extension
    public static final class PipelineDynamicRescanDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final String PostBuildActionDisplayText = "Dynamic Rescan with Veracode Pipeline";

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return false;
        }

        public String getDisplayName() {
            return PostBuildActionDisplayText;
        }
    }
}

