/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.apiwrapper.cli.VeracodeCommand;
import com.veracode.jenkins.plugin.VeracodeNotifier;
import com.veracode.jenkins.plugin.args.DynamicRescanArgs;
import com.veracode.jenkins.plugin.utils.EncryptionUtil;
import com.veracode.jenkins.plugin.utils.FileUtil;
import com.veracode.jenkins.plugin.utils.RemoteScanUtil;
import com.veracode.jenkins.plugin.utils.StringUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class DynamicRescanNotifier
extends Notifier {
    private final String _appname;
    private final boolean _dvrenabled;

    public String getAppname() {
        return EncryptionUtil.decrypt(this._appname);
    }

    public boolean getDvrenabled() {
        return this._dvrenabled;
    }

    public DynamicScanDescriptor getDescriptor() {
        return (DynamicScanDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        boolean bRet;
        block14: {
            bRet = false;
            this.getDescriptor().updateFromGlobalConfiguration();
            boolean debug = this.getDescriptor().getDebug();
            PrintStream ps = listener.getLogger();
            FilePath workspace = build.getWorkspace();
            if (workspace == null) {
                ps.print("\r\n\r\nFailed to locate the build workspace.\r\n");
                return !this.getDescriptor().getFailbuild();
            }
            boolean isRemoteWorkspace = workspace.isRemote();
            if (isRemoteWorkspace) {
                try {
                    FilePath[] files;
                    FilePath localWorkspaceFilePath = FileUtil.getLocalWorkspaceFilepath();
                    FilePath remoteVeracodeFilePath = RemoteScanUtil.getRemoteVeracodePath(build);
                    if (!remoteVeracodeFilePath.exists()) {
                        if (debug) {
                            ps.println("Making remote dir");
                        }
                        remoteVeracodeFilePath.mkdirs();
                    }
                    if ((files = remoteVeracodeFilePath.list("vosp-api-wrappers-java*.jar")).length == 0) {
                        bRet = FileUtil.copyJarFiles(build, localWorkspaceFilePath, remoteVeracodeFilePath, ps);
                    } else {
                        String oldjarName;
                        int oldVersion;
                        FilePath[] newfiles = localWorkspaceFilePath.list("vosp-api-wrappers-java*.jar");
                        String newjarName = newfiles[0].getRemote();
                        int newVersion = RemoteScanUtil.getJarVersion(newjarName);
                        if (newVersion > (oldVersion = RemoteScanUtil.getJarVersion(oldjarName = files[0].getRemote()))) {
                            if (debug) {
                                ps.println("Newer veracode library version, copying it to remote machine");
                            }
                            remoteVeracodeFilePath.deleteContents();
                            bRet = FileUtil.copyJarFiles(build, localWorkspaceFilePath, remoteVeracodeFilePath, ps);
                        } else {
                            String jarName = files[0].getRemote();
                            String newJarName = jarName.replaceAll("(vosp-api-wrappers).*?(.jar)", "VeracodeJavaAPI$2");
                            Node node = build.getBuiltOn();
                            if (node == null) {
                                ps.print("\r\n\r\nFailed to locate the build node.\r\n");
                                return !this.getDescriptor().getFailbuild();
                            }
                            FilePath newjarFilePath = new FilePath(node.getChannel(), newJarName);
                            if (newjarFilePath.exists()) {
                                bRet = true;
                            }
                        }
                    }
                    break block14;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (this.getDescriptor().getFailbuild()) {
                        ps.print(ex.getMessage());
                    }
                    break block14;
                }
            }
            bRet = true;
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspace;
        PrintStream ps = listener.getLogger();
        ps.println("------------------------------------------------------------------------");
        ps.println(DynamicScanDescriptor.getPostBuildActionDisplayText());
        ps.println("------------------------------------------------------------------------");
        this.getDescriptor().updateFromGlobalConfiguration();
        boolean debug = this.getDescriptor().getDebug();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        if (debug) {
            ps.println("\r\n[Debug mode is on]\r\n");
            ps.println(String.format("Can Fail Build?%n%s%n", this.getDescriptor().getFailbuild()));
            try {
                Method method = VeracodeCommand.class.getDeclaredMethod("getVersionString", new Class[0]);
                method.setAccessible(true);
                String version = (String)method.invoke(null, new Object[0]);
                if (!StringUtil.isNullOrEmpty(version)) {
                    ps.println(String.format("Version information:%n%s", version));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                ps.println("Could not retrieve API wrapper's version information.");
            }
        }
        if ((workspace = build.getWorkspace()) == null) {
            ps.print("\r\n\r\nFailed to locate the build workspace.\r\n");
            return !this.getDescriptor().getFailbuild();
        }
        boolean isRemoteWorkspace = workspace.isRemote();
        if (debug) {
            ps.println(String.format("%n%nProcessing files in [%s] workspace: ", isRemoteWorkspace ? "remote" : "local"));
            String workspaceDir = workspace.getRemote();
            workspaceDir = workspaceDir.replace("\\", "/");
            listener.hyperlink("file://" + workspaceDir, workspaceDir);
        }
        File localWorkspaceDir = null;
        try {
            block30: {
                if (isRemoteWorkspace) {
                    boolean bl = this.runScanFromRemote(build, listener, ps, debug);
                    return bl;
                }
                if (debug) {
                    ps.print("\r\n\r\nBuilding arguments. ");
                }
                DynamicRescanArgs dynamicScanArguments = DynamicRescanArgs.dynamicScanArgs(this, build, envVars, false);
                if (debug) {
                    ps.println(String.format("Calling wrapper with arguments:%n%s%n", Arrays.toString(dynamicScanArguments.getMaskedArguments())));
                }
                try {
                    VeracodeCommand.VeracodeParser parser = new VeracodeCommand.VeracodeParser();
                    parser.setOutputWriter(ps);
                    parser.setErrorWriter(ps);
                    parser.throwExceptions(true);
                    int retcode = parser.parse(dynamicScanArguments.getArguments());
                    if (retcode != 0 && this.getDescriptor().getFailbuild()) {
                        ps.print("\r\n\r\nError- Returned code from wrapper:" + retcode + "\r\n\n");
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Throwable e) {
                    if (!this.getDescriptor().getFailbuild()) break block30;
                    ps.println();
                    boolean retcode = false;
                    return retcode;
                }
            }
            ps.println();
            boolean bl = true;
            return bl;
        }
        finally {
            if (isRemoteWorkspace) {
                try {
                    if (localWorkspaceDir != null && localWorkspaceDir.exists()) {
                        FileUtil.deleteDirectory(localWorkspaceDir);
                    }
                }
                catch (Throwable e) {
                    ps.println(e.getMessage());
                }
            }
        }
    }

    @DataBoundConstructor
    public DynamicRescanNotifier(String appname, boolean dvrenabled) {
        this._appname = appname;
        this._dvrenabled = dvrenabled;
    }

    private boolean runScanFromRemote(AbstractBuild<?, ?> build, BuildListener listener, PrintStream ps, boolean bDebug) {
        boolean bRet;
        block10: {
            bRet = false;
            Node node = build.getBuiltOn();
            FilePath remoteVeracodeFilePath = RemoteScanUtil.getRemoteVeracodePath(build);
            String jarFilePath = remoteVeracodeFilePath.getRemote();
            FilePath workspace = build.getWorkspace();
            if (workspace == null) {
                ps.print("\r\n\r\nFailed to locate the build workspace.\r\n");
                return !this.getDescriptor().getFailbuild();
            }
            String remoteworkspace = workspace.getRemote();
            String sep = RemoteScanUtil.getPathSeparator(remoteworkspace);
            try {
                Proc proc;
                int retcode;
                EnvVars envVars = build.getEnvironment((TaskListener)listener);
                DynamicRescanArgs dynamicScanArguments = DynamicRescanArgs.dynamicScanArgs(this, build, envVars, true);
                String jarPath = jarFilePath + sep + "VeracodeJavaAPI" + ".jar";
                if (node == null) {
                    ps.print("\r\n\r\nFailed to locate the build node.\r\n");
                    return !this.getDescriptor().getFailbuild();
                }
                Computer computer = node.toComputer();
                if (computer == null) {
                    ps.print("\r\n\r\nFailed to determine the computer.\r\n");
                    return !this.getDescriptor().getFailbuild();
                }
                Boolean isUnix = computer.isUnix();
                if (isUnix == null) {
                    ps.print("\r\n\r\nFailed to determine the OS.\r\n");
                    return !this.getDescriptor().getFailbuild();
                }
                ArgumentListBuilder command = RemoteScanUtil.addArgumentsToCommand(jarPath, dynamicScanArguments.getArguments(), isUnix);
                Launcher launcher = node.createLauncher((TaskListener)listener);
                Launcher.ProcStarter procStart = new Launcher.ProcStarter(launcher);
                procStart = procStart.cmds(command).envs((Map)envVars).stdout((TaskListener)listener).quiet(true);
                if (bDebug) {
                    procStart.quiet(false);
                    ps.print("\nInvoking the following command in remote workspace:\n");
                }
                if ((retcode = (proc = launcher.launch(procStart)).join()) != 0 && this.getDescriptor().getFailbuild()) {
                    ps.print("\r\n\r\nError- Returned code from wrapper:" + retcode + "\r\n\n");
                } else if (retcode == 0) {
                    bRet = true;
                }
            }
            catch (IOException | InterruptedException ex) {
                ex.printStackTrace();
                if (!this.getDescriptor().getFailbuild()) break block10;
                ps.print(ex.getMessage());
            }
        }
        return bRet;
    }

    @Extension
    public static final class DynamicScanDescriptor
    extends BuildStepDescriptor<Publisher> {
        private static final String PostBuildActionDisplayText = "Dynamic Rescan with Veracode";
        private boolean failbuild;
        private boolean autoappname;
        private boolean debug;
        private boolean autoversion;

        public boolean getFailbuild() {
            return this.failbuild;
        }

        public boolean getAutoappname() {
            return this.autoappname;
        }

        public boolean getDebug() {
            return this.debug;
        }

        public boolean getAutoversion() {
            return this.autoversion;
        }

        public String getDisplayName() {
            return DynamicScanDescriptor.getPostBuildActionDisplayText();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public DynamicScanDescriptor() {
            super(DynamicRescanNotifier.class);
            this.load();
        }

        public static String getPostBuildActionDisplayText() {
            return PostBuildActionDisplayText;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.updateFromGlobalConfiguration();
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        private void updateFromGlobalConfiguration() {
            VeracodeNotifier.VeracodeDescriptor globalVeracodeDescriptor = (VeracodeNotifier.VeracodeDescriptor)Jenkins.get().getDescriptor(VeracodeNotifier.class);
            if (globalVeracodeDescriptor != null) {
                this.failbuild = globalVeracodeDescriptor.getFailbuild();
                this.autoappname = globalVeracodeDescriptor.getAutoappname();
                this.debug = globalVeracodeDescriptor.getDebug();
                this.autoversion = globalVeracodeDescriptor.getAutoversion();
            }
        }
    }
}

