/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.jenkins.plugin.common.DAAdapterService;
import com.veracode.jenkins.plugin.data.ProxyBlock;
import com.veracode.jenkins.plugin.utils.FormValidationUtil;
import com.veracode.jenkins.plugin.utils.StringUtil;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DynamicAnalysisResultsPipelineRecorder
extends Recorder
implements SimpleBuildStep {
    @DataBoundSetter
    public final int waitForResultsDuration;
    @DataBoundSetter
    public final boolean failBuildForPolicyViolation;
    @DataBoundSetter
    public final boolean debug;
    @DataBoundSetter
    public final String vid;
    @DataBoundSetter
    public final String vkey;
    @DataBoundSetter
    public final boolean useProxy;
    @DataBoundSetter
    public final String pHost;
    @DataBoundSetter
    public final String pPort;
    @DataBoundSetter
    public final String pUser;
    @DataBoundSetter
    public final String pPassword;

    @DataBoundConstructor
    public DynamicAnalysisResultsPipelineRecorder(int waitForResultsDuration, boolean failBuildForPolicyViolation, boolean debug, boolean useProxy, String pHost, String pPort, String pUser, String pPassword, String vid, String vkey) {
        this.waitForResultsDuration = waitForResultsDuration;
        this.failBuildForPolicyViolation = failBuildForPolicyViolation;
        this.debug = debug;
        this.vid = vid;
        this.vkey = vkey;
        this.useProxy = useProxy;
        this.pHost = useProxy ? pHost : null;
        this.pPort = useProxy ? pPort : null;
        this.pUser = useProxy ? pUser : null;
        this.pPassword = useProxy ? pPassword : null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        DAAdapterService daAdapterService;
        boolean buildSuccess;
        ProxyBlock proxyBlock = null;
        if (this.useProxy) {
            proxyBlock = new ProxyBlock(this.pHost, this.pPort, this.pUser, this.pPassword);
        }
        run.setResult((buildSuccess = (daAdapterService = new DAAdapterService()).reviewDynamicAnalysis(run, workspace, listener, this.waitForResultsDuration, this.failBuildForPolicyViolation, this.vid, this.vkey, this.debug, proxyBlock)) ? Result.SUCCESS : Result.FAILURE);
    }

    public PipelineDynamicAnalysisResultsDescriptorImpl getDescriptor() {
        return (PipelineDynamicAnalysisResultsDescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"veracodeDynamicAnalysisReview"})
    @Extension
    public static final class PipelineDynamicAnalysisResultsDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return false;
        }

        public String getDisplayName() {
            return "Review Veracode Dynamic Analysis Results";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String waitForResultsDuration = formData.getString("waitForResultsDuration");
            formData.put("waitForResultsDuration", StringUtil.isNullOrEmpty(waitForResultsDuration) ? Long.valueOf(TimeUnit.MINUTES.toHours(60L)) : waitForResultsDuration);
            return (Publisher)super.newInstance(req, formData);
        }

        public FormValidation doCheckWaitForResultsDuration(@QueryParameter String waitForResultsDuration) throws IOException, ServletException {
            return FormValidationUtil.checkWaitForResultsDuration(waitForResultsDuration);
        }

        public FormValidation doCheckPHost(@QueryParameter(value="pHost") String pHost, @QueryParameter(value="pPort") String pPort) throws IOException, ServletException {
            return FormValidationUtil.checkFields(pHost, pPort, "Host", "Port", null);
        }

        public FormValidation doCheckPPort(@QueryParameter(value="pHost") String pHost, @QueryParameter(value="pPort") String pPort) throws IOException, ServletException {
            return FormValidationUtil.checkFields(pPort, pHost, "Port", "Host", null);
        }

        public FormValidation doCheckPUser(@QueryParameter(value="pUser") String pUser, @QueryParameter(value="pPassword") String pPassword) throws IOException, ServletException {
            return FormValidationUtil.checkMutuallyInclusiveFields(pUser, pPassword, "User", "Password", null);
        }

        public FormValidation doCheckPPassword(@QueryParameter(value="pUser") String pUser, @QueryParameter(value="pPassword") String pPassword) throws IOException, ServletException {
            return FormValidationUtil.checkMutuallyInclusiveFields(pPassword, pUser, "Password", "User", null);
        }
    }
}

