/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.jenkins.plugin.VeracodeNotifier;
import com.veracode.jenkins.plugin.common.DAAdapterService;
import com.veracode.jenkins.plugin.data.CredentialsBlock;
import com.veracode.jenkins.plugin.data.ProxyBlock;
import com.veracode.jenkins.plugin.utils.EncryptionUtil;
import com.veracode.jenkins.plugin.utils.FormValidationUtil;
import com.veracode.jenkins.plugin.utils.StringUtil;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DynamicAnalysisResultsNotifier
extends Notifier {
    private final int waitForResultsDuration;
    private final boolean failBuildForPolicyViolation;
    private final CredentialsBlock credentials;
    private boolean isGlobalCredentialsEnabled;

    @DataBoundConstructor
    public DynamicAnalysisResultsNotifier(int waitForResultsDuration, boolean failBuildForPolicyViolation, CredentialsBlock credentials) {
        this.waitForResultsDuration = waitForResultsDuration;
        this.failBuildForPolicyViolation = failBuildForPolicyViolation;
        this.credentials = credentials;
        this.isGlobalCredentialsEnabled = credentials == null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        DynamicAnalysisResultsDescriptorImpl descriptor = this.getDescriptor();
        descriptor.updateFromGlobalConfiguration();
        String apiId = this.getCredentials() != null ? this.getVid() : descriptor.getGvid();
        String apiKey = this.getCredentials() != null ? this.getVkey() : descriptor.getGvkey();
        ProxyBlock proxyBlock = null;
        if (descriptor.isProxyEnabled()) {
            proxyBlock = new ProxyBlock(descriptor.getPhost(), descriptor.getPport(), descriptor.getPuser(), descriptor.getPpassword());
        }
        DAAdapterService daAdapterService = new DAAdapterService();
        return daAdapterService.reviewDynamicAnalysis((Run<?, ?>)build, build.getWorkspace(), (TaskListener)listener, this.waitForResultsDuration, this.failBuildForPolicyViolation, apiId, apiKey, descriptor.isDebugEnabled(), proxyBlock);
    }

    public DynamicAnalysisResultsDescriptorImpl getDescriptor() {
        return (DynamicAnalysisResultsDescriptorImpl)super.getDescriptor();
    }

    public int getWaitForResultsDuration() {
        return this.waitForResultsDuration;
    }

    public boolean isFailBuildForPolicyViolation() {
        return this.failBuildForPolicyViolation;
    }

    public boolean isGlobalCredentialsEnabled() {
        return this.isGlobalCredentialsEnabled;
    }

    public CredentialsBlock getCredentials() {
        return this.credentials;
    }

    public String getVid() {
        return EncryptionUtil.decrypt(this.credentials != null ? this.credentials.getVid() : null);
    }

    public String getVkey() {
        return EncryptionUtil.decrypt(this.credentials != null ? this.credentials.getVkey() : null);
    }

    @Extension
    public static class DynamicAnalysisResultsDescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String gvid;
        private String gvkey;
        private boolean debugEnabled;
        private boolean proxyEnabled;
        private String phost;
        private String pport;
        private String puser;
        private String ppassword;

        public DynamicAnalysisResultsDescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Review Veracode Dynamic Analysis Results";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String waitForResultsDuration = formData.getString("waitForResultsDuration");
            formData.put("waitForResultsDuration", StringUtil.isNullOrEmpty(waitForResultsDuration) ? Integer.valueOf(60) : waitForResultsDuration);
            Map credMap = (Map)formData.get("credentials");
            if (credMap != null) {
                credMap.put("vid", EncryptionUtil.encrypt((String)credMap.get("vid")));
                credMap.put("vkey", EncryptionUtil.encrypt((String)credMap.get("vkey")));
                formData.put("credentials", (Object)credMap);
            }
            return (Publisher)super.newInstance(req, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.updateFromGlobalConfiguration();
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckWaitForResultsDuration(@QueryParameter String waitForResultsDuration) throws IOException, ServletException {
            return FormValidationUtil.checkWaitForResultsDuration(waitForResultsDuration);
        }

        public FormValidation doCheckVid(@QueryParameter(value="vid") String vid, @QueryParameter(value="vkey") String vkey) throws IOException, ServletException {
            return FormValidationUtil.checkApiId(vid, vkey, this.hasGlobalApiIdKeyCredentials());
        }

        public FormValidation doCheckVkey(@QueryParameter(value="vid") String vid, @QueryParameter(value="vkey") String vkey) throws IOException, ServletException {
            return FormValidationUtil.checkApiKey(vid, vkey, this.hasGlobalApiIdKeyCredentials());
        }

        private void updateFromGlobalConfiguration() {
            VeracodeNotifier.VeracodeDescriptor globalVeracodeDescriptor = (VeracodeNotifier.VeracodeDescriptor)Jenkins.get().getDescriptor(VeracodeNotifier.class);
            if (globalVeracodeDescriptor != null) {
                this.gvid = globalVeracodeDescriptor.getGvid();
                this.gvkey = globalVeracodeDescriptor.getGvkey();
                this.debugEnabled = globalVeracodeDescriptor.getDebug();
                this.proxyEnabled = globalVeracodeDescriptor.getProxy();
                this.phost = globalVeracodeDescriptor.getPhost();
                this.pport = globalVeracodeDescriptor.getPport();
                this.puser = globalVeracodeDescriptor.getPuser();
                this.ppassword = globalVeracodeDescriptor.getPpassword();
            }
        }

        public String getGvid() {
            return this.gvid;
        }

        public String getGvkey() {
            return this.gvkey;
        }

        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }

        public boolean isProxyEnabled() {
            return this.proxyEnabled;
        }

        public String getPhost() {
            return this.phost;
        }

        public String getPport() {
            return this.pport;
        }

        public String getPuser() {
            return this.puser;
        }

        public String getPpassword() {
            return this.ppassword;
        }

        public boolean hasGlobalApiIdKeyCredentials() {
            return !StringUtil.isNullOrEmpty(this.getGvid()) && !StringUtil.isNullOrEmpty(this.getGvkey());
        }
    }
}

