/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin;

import com.veracode.jenkins.plugin.TrendChart;
import com.veracode.jenkins.plugin.data.BuildHistory;
import com.veracode.jenkins.plugin.data.DAScanHistory;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.RunAction2;
import org.apache.commons.lang.StringEscapeUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DynamicAnalysisResultsAction
implements RunAction2 {
    private final DAScanHistory scanHistory;
    private transient Run<?, ?> build;
    private final String xmlApiHost;

    public DynamicAnalysisResultsAction() {
        this.scanHistory = null;
        this.xmlApiHost = null;
        this.build = null;
    }

    public DynamicAnalysisResultsAction(DAScanHistory scanHistory, String xmlApiHost) {
        if (null == scanHistory || null == xmlApiHost) {
            throw new IllegalArgumentException("Missing required information to create a DynamicAnalysisResultsAction.");
        }
        this.scanHistory = scanHistory;
        this.xmlApiHost = xmlApiHost;
        this.build = null;
    }

    public String getIconFileName() {
        return "/plugin/veracode-scan/icons/veracode-24x24.png";
    }

    public String getDisplayName() {
        return "Veracode Dynamic Analysis";
    }

    public String getUrlName() {
        return "veracodeDA";
    }

    public void onAttached(Run<?, ?> r) {
        this.setBuild(r);
    }

    public void onLoad(Run<?, ?> r) {
        this.setBuild(r);
    }

    public String getPolicyName() {
        return this.scanHistory.getPolicyName();
    }

    public String getPolicyNameForHTML() {
        return StringEscapeUtils.escapeHtml((String)this.scanHistory.getPolicyName());
    }

    public String getPolicyComplianceStatus() {
        return this.scanHistory.getPolicyComplianceStatus();
    }

    public String getPolicyComplianceStatusForHTML() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        return StringEscapeUtils.escapeHtml((String)(complianceStatus.equalsIgnoreCase("Pass") ? "Passed" : complianceStatus));
    }

    public String getVeracodeLevel() {
        return this.scanHistory.getVeracodeLevel();
    }

    public String getVeracodeLevelForHTML() {
        return StringEscapeUtils.escapeHtml((String)this.scanHistory.getVeracodeLevel());
    }

    public int getAnalysisScore() {
        return this.scanHistory.getScore();
    }

    public String getScanOverdueStatus() {
        return this.scanHistory.isScanOverdue() ? "Did not pass" : "Passed";
    }

    public String getVeracodeLogo48() {
        return "/plugin/veracode-scan/icons/veracode-48x48.png";
    }

    public String getPolicyComplianceStatusIconUri16() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        String iconName = complianceStatus.equalsIgnoreCase("Pass") ? "shield-green-16x16.png" : (complianceStatus.equalsIgnoreCase("Did not pass") ? "shield-red-16x16.png" : (complianceStatus.equalsIgnoreCase("Conditional pass") ? "shield-yellow-16x16.png" : "shield-gray-16x16.png"));
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public String getPolicyComplianceStatusIconUri24() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        String iconName = complianceStatus.equalsIgnoreCase("Pass") ? "shield-green-24x24.png" : (complianceStatus.equalsIgnoreCase("Did not pass") ? "shield-red-24x24.png" : (complianceStatus.equalsIgnoreCase("Conditional pass") ? "shield-yellow-24x24.png" : "shield-gray-24x24.png"));
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public String getPolicyComplianceStatusIconUri32() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        String iconName = complianceStatus.equalsIgnoreCase("Pass") ? "shield-green-32x32.png" : (complianceStatus.equalsIgnoreCase("Did not pass") ? "shield-red-32x32.png" : (complianceStatus.equalsIgnoreCase("Conditional pass") ? "shield-yellow-32x32.png" : "shield-gray-32x32.png"));
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public String getPolicyComplianceStatusIconUri48() {
        String complianceStatus = this.scanHistory.getPolicyComplianceStatus();
        String iconName = complianceStatus.equalsIgnoreCase("Pass") ? "shield-green-48x48.png" : (complianceStatus.equalsIgnoreCase("Did not pass") ? "shield-red-48x48.png" : (complianceStatus.equalsIgnoreCase("Conditional pass") ? "shield-yellow-48x48.png" : "shield-gray-48x48.png"));
        return "/plugin/veracode-scan/icons/" + iconName;
    }

    public String getOpenNewWindow16() {
        return "/plugin/veracode-scan/icons/open-new-window-16x16.png";
    }

    public boolean isStaticSevLevelMitigated(int severity) {
        boolean result = false;
        try {
            result = this.scanHistory.getMitigateFlag(severity);
        }
        catch (IllegalArgumentException iae) {
            result = false;
        }
        return result;
    }

    public String getFlawsCount(int severity) {
        String displayFlawsCount;
        try {
            int flawsCount = this.scanHistory.getFlawsCount(severity);
            displayFlawsCount = this.isStaticSevLevelMitigated(severity) ? flawsCount + "*" : (flawsCount > 0 ? Integer.toString(flawsCount) : "");
        }
        catch (IllegalArgumentException iae) {
            displayFlawsCount = "";
        }
        return displayFlawsCount;
    }

    public int getFlawsCountInt(int severity) {
        return this.scanHistory.getFlawsCount(severity);
    }

    public int getTotalFlawsCount() {
        return this.scanHistory.getTotalFlawsCount();
    }

    public int getTotalNewFlawsCount() {
        return this.scanHistory.getTotalNewFlawsCount();
    }

    public int getTotalNetChangeCount() {
        return this.scanHistory.getTotalNetChangeCount();
    }

    public String getNetChange(int severity) {
        int netChange = this.scanHistory.getNetChange(severity);
        String displayNetChange = "";
        if (netChange > 0) {
            displayNetChange = "+" + Integer.toString(netChange);
        } else if (netChange < 0) {
            displayNetChange = Integer.toString(netChange);
        }
        return displayNetChange;
    }

    public String getNewFlaws(int severity) {
        int newFlaw = this.scanHistory.getNewFlaws(severity);
        return newFlaw > 0 ? Integer.toString(newFlaw) : "";
    }

    public List<Map<String, Long>> getFlawsCountHistory() {
        return this.scanHistory.getFlawsCountHistory();
    }

    public void doGraph(StaplerRequest request, StaplerResponse response) {
        try {
            BuildHistory buildHistory = new BuildHistory("Dynamic Vulnerabilities", this.scanHistory.getFlawsCountHistory());
            ArrayList<BuildHistory> buildHistoryList = new ArrayList<BuildHistory>();
            buildHistoryList.add(buildHistory);
            TrendChart trendChart = new TrendChart(System.currentTimeMillis(), 600, 400, buildHistoryList);
            trendChart.doPng(request, response);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to generate the Flaw trend graph.");
        }
    }

    public String getDetailedReportURLForHTMLAttr() {
        String escapedAcctId = StringEscapeUtils.escapeHtml((String)this.scanHistory.getAccountId());
        String escapedAppId = StringEscapeUtils.escapeHtml((String)this.scanHistory.getAppId());
        String escapedBuildId = StringEscapeUtils.escapeHtml((String)this.scanHistory.getBuildId());
        return String.format("https://%s/auth/index.jsp#ViewReportsDetailedReport", null == this.xmlApiHost ? "analysiscenter.veracode.com" : this.xmlApiHost) + ":" + escapedAcctId + ":" + escapedAppId + ":" + escapedBuildId;
    }

    public boolean isScanHistoryAvailable() {
        return null != this.scanHistory;
    }

    private void setBuild(Run<?, ?> build) {
        this.build = build;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public boolean getPolicyAffection(int severity) {
        boolean result = false;
        try {
            result = this.scanHistory.getPolicyAffection(severity);
        }
        catch (IllegalArgumentException | NullPointerException iae) {
            result = false;
        }
        return result;
    }

    public String getPolicyComplianceComponentIconUri(boolean isViolatedPolicy) {
        String iconName = "";
        iconName = isViolatedPolicy ? "fail-policy-component.png" : "pass-policy-component.png";
        return "/plugin/veracode-scan/icons/" + iconName;
    }
}

