/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin.utils;

import com.veracode.apiwrapper.dynamicanalysis.model.client.ScanOccurrenceInfo;
import com.veracode.jenkins.plugin.DynamicAnalysisResultsAction;
import com.veracode.jenkins.plugin.VeracodeAction;
import com.veracode.jenkins.plugin.data.DAScanHistory;
import com.veracode.jenkins.plugin.data.FindingCounts;
import com.veracode.jenkins.plugin.data.SCAComponent;
import com.veracode.jenkins.plugin.data.SCAScanHistory;
import com.veracode.jenkins.plugin.data.ScanHistory;
import com.veracode.jenkins.plugin.enums.SeverityLevel;
import com.veracode.jenkins.plugin.utils.StringUtil;
import hudson.model.Run;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static final String SCA_XPATH = "/detailedreport/*[local-name()='software_composition_analysis']";
    private static final int SEVERITY_LEVEL_NUMBER = 6;
    private static final int MAX_BUILDS_TO_SEARCH = 60;
    private static final String STATIC_ANALYSIS_ELEMENT_NODE = "static-analysis";
    private static final String DYNAMIC_ANALYSIS_ELEMENT_NODE = "dynamic-analysis";
    private static final String STATIC_ANALYSIS_FLAWS_ELEMENT_NODE = "staticflaws";
    private static final String DYNAMIC_ANALYSIS_FLAWS_ELEMENT_NODE = "dynamicflaws";

    public static final ScanHistory newScanHistory(String buildInfoXml, String detailedReportXml, Run<?, ?> build) throws Exception {
        Element buildInfoRoot = XmlUtil.getXmlDocument(buildInfoXml).getDocumentElement();
        String accountId = buildInfoRoot.getAttribute("account_id");
        String appId = buildInfoRoot.getAttribute("app_id");
        String buildId = XmlUtil.parseBuildId(buildInfoXml);
        Document xml = XmlUtil.getXmlDocument(detailedReportXml);
        Element root = xml.getDocumentElement();
        String policyName = root.getAttribute("policy_name");
        String policyComplianceStatus = root.getAttribute("policy_compliance_status");
        String veracodeLevel = root.getAttribute("veracode_level");
        boolean scanOverdue = Boolean.parseBoolean(root.getAttribute("scan_overdue"));
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        int score = XmlUtil.parseAnalysisScore(xPathObj, xml, STATIC_ANALYSIS_ELEMENT_NODE);
        int[] netChange = XmlUtil.getNetChangeCount(xPathObj, xml);
        Object[] realCountObj = XmlUtil.getRealFlawCount(xPathObj, xml, STATIC_ANALYSIS_FLAWS_ELEMENT_NODE);
        int[] realCount = (int[])realCountObj[0];
        boolean[] mtgStatus = (boolean[])realCountObj[1];
        boolean[] policyaffect = XmlUtil.getPolicyAffectedness(xPathObj, xml, STATIC_ANALYSIS_FLAWS_ELEMENT_NODE);
        int totalFlawsCount = 0;
        for (int i = 0; i < realCount.length; ++i) {
            totalFlawsCount += realCount[i];
        }
        long buildDate = build.getTimestamp().getTimeInMillis();
        Map<String, Long> thisScanStats = XmlUtil.createStats(buildDate, Long.valueOf(totalFlawsCount));
        Run lastBuild = build.getPreviousBuild();
        SCAScanHistory lastSCAHistory = null;
        List<Map<String, Long>> lastFlawsCountHistory = null;
        int buildCount = 0;
        lastFlawsCountHistory = null;
        for (buildCount = 0; null == lastFlawsCountHistory && buildCount < 60 && null != lastBuild; lastBuild = lastBuild.getPreviousBuild(), ++buildCount) {
            VeracodeAction lastBuildAction = (VeracodeAction)lastBuild.getAction(VeracodeAction.class);
            if (null == lastBuildAction || !lastBuildAction.isScanHistoryAvailable()) continue;
            lastFlawsCountHistory = lastBuildAction.getFlawsCountHistory();
            lastSCAHistory = lastBuildAction.getSCAScanHistory();
        }
        return new ScanHistory(accountId, appId, buildId, policyName, policyComplianceStatus, score, veracodeLevel, scanOverdue, totalFlawsCount, realCount, mtgStatus, netChange, XmlUtil.createCountHistory(thisScanStats, lastFlawsCountHistory), XmlUtil.newSCAHistory(detailedReportXml, buildDate, lastSCAHistory), policyaffect);
    }

    public static final SCAScanHistory newSCAHistory(String detailedReportXml, long buildDate, SCAScanHistory lastSCAHistory) throws Exception {
        if (StringUtil.isNullOrEmpty(detailedReportXml)) {
            throw new IllegalArgumentException("Cannot process empty detailed report.");
        }
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        Document detailedReportDoc = XmlUtil.getXmlDocument(detailedReportXml);
        SCAScanHistory result = null;
        if (XmlUtil.isSubscribedToSCA(xPathObj, detailedReportDoc)) {
            Set<FindingCounts> findingCounts = XmlUtil.parseFindingCounts(xPathObj, detailedReportDoc, lastSCAHistory);
            int totalVulCount = 0;
            for (FindingCounts vc : findingCounts) {
                if (null == vc) continue;
                totalVulCount += vc.getCount();
            }
            result = new SCAScanHistory(XmlUtil.parseMaxCVSSScore(xPathObj, detailedReportDoc), XmlUtil.parseBlacklistedCompsCount(xPathObj, detailedReportDoc), findingCounts, XmlUtil.parseSCAComponentInfo(xPathObj, detailedReportDoc), XmlUtil.createCountHistory(XmlUtil.createStats(buildDate, Long.valueOf(totalVulCount)), lastSCAHistory == null ? null : lastSCAHistory.getVulCountHistory()));
        } else {
            result = new SCAScanHistory(XmlUtil.createCountHistory(XmlUtil.createStats(buildDate, null), lastSCAHistory == null ? null : lastSCAHistory.getVulCountHistory()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DAScanHistory newDAScanHistory(String detailedReportXml, ScanOccurrenceInfo scanOccurrenceInfo, Run<?, ?> build) throws Exception {
        Element detailedReportRoot = XmlUtil.getXmlDocument(detailedReportXml).getDocumentElement();
        Document xml = XmlUtil.getXmlDocument(detailedReportXml);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        String accountId = detailedReportRoot.getAttribute("account_id");
        String appId = scanOccurrenceInfo.getLinkedPlatformAppId();
        String buildId = scanOccurrenceInfo.getLinkedAppData().getBuildId();
        String policyName = detailedReportRoot.getAttribute("policy_name");
        String policyComplianceStatus = detailedReportRoot.getAttribute("policy_compliance_status");
        String veracodeLevel = detailedReportRoot.getAttribute("veracode_level");
        boolean scanOverdue = Boolean.parseBoolean(detailedReportRoot.getAttribute("scan_overdue"));
        int score = XmlUtil.parseAnalysisScore(xPathObj, xml, DYNAMIC_ANALYSIS_ELEMENT_NODE);
        Object[] actualFlawDataObj = XmlUtil.getRealFlawCount(xPathObj, xml, DYNAMIC_ANALYSIS_FLAWS_ELEMENT_NODE);
        int[] actualFlawCount = (int[])actualFlawDataObj[0];
        boolean[] isMitigated = (boolean[])actualFlawDataObj[1];
        int totalFlawsCount = 0;
        for (int i = 0; i < actualFlawCount.length; ++i) {
            totalFlawsCount += actualFlawCount[i];
        }
        boolean[] policyaffect = XmlUtil.getPolicyAffectedness(xPathObj, xml, DYNAMIC_ANALYSIS_FLAWS_ELEMENT_NODE);
        int[] netChangeList = new int[]{0, 0, 0, 0, 0, 0};
        long buildDate = build.getTimestamp().getTimeInMillis();
        Map<String, Long> thisScanStats = XmlUtil.createStats(buildDate, Long.valueOf(totalFlawsCount));
        Run lastBuild = build.getPreviousBuild();
        List<Map<String, Long>> lastFlawsCountHistory = null;
        int buildCount = 0;
        lastFlawsCountHistory = null;
        for (buildCount = 0; null == lastFlawsCountHistory && buildCount < 60 && null != lastBuild; lastBuild = lastBuild.getPreviousBuild(), ++buildCount) {
            DynamicAnalysisResultsAction lastBuildAction = (DynamicAnalysisResultsAction)lastBuild.getAction(DynamicAnalysisResultsAction.class);
            if (null == lastBuildAction || !lastBuildAction.isScanHistoryAvailable()) continue;
            lastFlawsCountHistory = lastBuildAction.getFlawsCountHistory();
            for (int sevIndex = 0; sevIndex < 6; ++sevIndex) {
                int netChange = 0;
                int prevCount = lastBuildAction.getFlawsCountInt(sevIndex);
                try {
                    netChange = actualFlawCount[sevIndex] - prevCount;
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    netChange = 0;
                    continue;
                }
                finally {
                    netChangeList[sevIndex] = netChange;
                }
            }
        }
        return new DAScanHistory(accountId, appId, buildId, policyName, policyComplianceStatus, score, veracodeLevel, scanOverdue, totalFlawsCount, actualFlawCount, isMitigated, netChangeList, XmlUtil.createCountHistory(thisScanStats, lastFlawsCountHistory), policyaffect);
    }

    private static final int parseAnalysisScore(XPath xPathObj, Document xml, String analysisElementNodeType) throws Exception {
        String ANALYSIS_NODE_XPATH = "/detailedreport/*[local-name()='" + analysisElementNodeType + "']";
        Node node = (Node)xPathObj.evaluate(ANALYSIS_NODE_XPATH, xml.getDocumentElement(), XPathConstants.NODE);
        String score = "";
        if (null != node) {
            score = node.getAttributes().getNamedItem("score").getNodeValue();
        }
        return Integer.parseInt(score);
    }

    public static final String parseAppId(String appName, String xmlAppListResult) throws Exception {
        Document xml = XmlUtil.getXmlDocument(xmlAppListResult);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        NodeList nodeList = (NodeList)xPathObj.evaluate("/*/*[local-name()='app'][@app_id][@app_name]", xml.getDocumentElement(), XPathConstants.NODESET);
        String app_id = null;
        for (int x = 0; x < nodeList.getLength(); ++x) {
            Node node = nodeList.item(x);
            if (StringUtil.compare(node.getAttributes().getNamedItem("app_name").getNodeValue(), appName, true) != 0) continue;
            app_id = node.getAttributes().getNamedItem("app_id").getNodeValue();
            break;
        }
        return app_id;
    }

    public static final String parseSandboxId(String sandboxName, String xmlSandboxListResult) throws Exception {
        if (StringUtil.isNullOrEmpty(xmlSandboxListResult)) {
            throw new IllegalArgumentException("Empty XML document.");
        }
        Document xml = XmlUtil.getXmlDocument(xmlSandboxListResult);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        NodeList nodeList = (NodeList)xPathObj.evaluate("/sandboxlist/sandbox[@sandbox_id][@sandbox_name]", xml.getDocumentElement(), XPathConstants.NODESET);
        String sandboxId = "";
        for (int x = 0; x < nodeList.getLength(); ++x) {
            Node node = nodeList.item(x);
            if (StringUtil.compare(node.getAttributes().getNamedItem("sandbox_name").getNodeValue(), sandboxName, true) != 0) continue;
            sandboxId = node.getAttributes().getNamedItem("sandbox_id").getNodeValue();
            break;
        }
        return sandboxId;
    }

    public static final Document getXmlDocument(String xmlString) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document xml = db.parse(new InputSource(new InputStreamReader((InputStream)inputStream, "UTF-8")));
        return xml;
    }

    public static final String parseBuildId(String xmlBuildInfoResult) throws Exception {
        if (StringUtil.isNullOrEmpty(xmlBuildInfoResult)) {
            throw new IllegalArgumentException("Empty XML document.");
        }
        Document xml = XmlUtil.getXmlDocument(xmlBuildInfoResult);
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPathObj = xpf.newXPath();
        Node node = (Node)xPathObj.evaluate("/*/*[local-name()='build'][@build_id]", xml.getDocumentElement(), XPathConstants.NODE);
        String buildId = "";
        if (null != node) {
            buildId = node.getAttributes().getNamedItem("build_id").getNodeValue();
        }
        return !StringUtil.isNullOrEmpty(buildId) ? buildId : "";
    }

    public static final String getErrorString(String xmlString) {
        if (StringUtil.isNullOrEmpty(xmlString)) {
            return "";
        }
        String errorString = "";
        StringBuilder builder = new StringBuilder();
        Pattern pattern = Pattern.compile("<error>(.*?)</error>");
        Matcher matcher = pattern.matcher(xmlString);
        while (matcher.find()) {
            builder.append(matcher.group(1) + "\r\n");
        }
        errorString = builder.toString();
        if (errorString.contains("\r\n")) {
            errorString = errorString.substring(0, builder.lastIndexOf("\r\n"));
        }
        return errorString;
    }

    private static boolean[] getPolicyAffectedness(XPath xPathObj, Document xml, String flawType) {
        boolean[] policyAffectStatus = new boolean[6];
        try {
            for (int i = 0; i < 6; ++i) {
                String flaws_path = "/detailedreport/severity[@level = '" + i + "']/category/cwe/" + flawType + "/*[local-name()='flaw' and @affects_policy_compliance='true']";
                NodeList flawsNodes = (NodeList)xPathObj.evaluate(flaws_path, xml.getDocumentElement(), XPathConstants.NODESET);
                if (flawsNodes == null || flawsNodes.getLength() <= 0) continue;
                policyAffectStatus[i] = true;
            }
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
        return policyAffectStatus;
    }

    private static Object[] getRealFlawCount(XPath xPathObj, Document xml, String flawType) {
        String FLAW_NODE_XPATH = "/detailedreport/severity/category/cwe/" + flawType + "/*[local-name()='flaw']";
        String MITIGATION_STATUS = "accepted";
        String REMEDIATION_STATUS = "Fixed";
        String SEVERITY_ATTR = "severity";
        String MITIGATION_ATTR = "mitigation_status";
        String REMEDIATION_ATTR = "remediation_status";
        String flawSeverity = "";
        String mitigateStatus = "";
        String remediationStatus = "";
        int[] realCount = new int[6];
        boolean[] mtgStatus = new boolean[6];
        for (int x = 0; x < 6; ++x) {
            mtgStatus[x] = false;
        }
        try {
            NodeList flaws = (NodeList)xPathObj.evaluate(FLAW_NODE_XPATH, xml.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < flaws.getLength(); ++i) {
                Node thisFlaw = flaws.item(i);
                flawSeverity = thisFlaw.getAttributes().getNamedItem("severity").getNodeValue();
                mitigateStatus = thisFlaw.getAttributes().getNamedItem("mitigation_status").getNodeValue();
                remediationStatus = thisFlaw.getAttributes().getNamedItem("remediation_status").getNodeValue();
                for (int j = 0; j < 6; ++j) {
                    if (!flawSeverity.equals(Integer.toString(j)) || remediationStatus.equals("Fixed")) continue;
                    if (mitigateStatus.equals("accepted")) {
                        mtgStatus[j] = true;
                        continue;
                    }
                    int n = j;
                    realCount[n] = realCount[n] + 1;
                }
            }
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        Object[] arrayObjects = new Object[]{realCount, mtgStatus};
        return arrayObjects;
    }

    private static int[] getNetChangeCount(XPath xPathObj, Document xml) {
        int[] netChange;
        block8: {
            String FLAW_STATUS_NODE_XPATH = "/detailedreport/*[local-name()='flaw-status']";
            String[] SEV_ATTRS = new String[]{"sev-0-change", "sev-1-change", "sev-2-change", "sev-3-change", "sev-4-change", "sev-5-change"};
            netChange = new int[SEV_ATTRS.length];
            try {
                Node node = (Node)xPathObj.evaluate("/detailedreport/*[local-name()='flaw-status']", xml.getDocumentElement(), XPathConstants.NODE);
                if (null == node) break block8;
                for (int i = 0; i < SEV_ATTRS.length; ++i) {
                    String count;
                    block9: {
                        count = null;
                        try {
                            Node sevNode = node.getAttributes().getNamedItem(SEV_ATTRS[i]);
                            if (null == sevNode) break block9;
                            count = sevNode.getNodeValue();
                        }
                        catch (DOMException de) {
                            netChange[i] = 0;
                            continue;
                        }
                    }
                    if (!StringUtil.isNullOrEmpty(count)) {
                        try {
                            netChange[i] = Integer.parseInt(count);
                        }
                        catch (NumberFormatException nfe) {
                            netChange[i] = 0;
                        }
                        continue;
                    }
                    netChange[i] = 0;
                }
            }
            catch (XPathExpressionException xpee) {
                throw new RuntimeException(xpee);
            }
        }
        return netChange;
    }

    private static final double parseMaxCVSSScore(XPath xPathObj, Document xml) throws Exception {
        String SCA_COMPONENTS_NODE_XPATH = "/detailedreport/software_composition_analysis/vulnerable_components/*[local-name()='component']";
        String MAX_CVSS_SCORE_ATTR = "max_cvss_score";
        double maxOverallScore = -1.0;
        try {
            NodeList comps = (NodeList)xPathObj.evaluate("/detailedreport/software_composition_analysis/vulnerable_components/*[local-name()='component']", xml.getDocumentElement(), XPathConstants.NODESET);
            String maxCompScoreStr = "";
            for (int i = 0; i < comps.getLength(); ++i) {
                Node thisComp = comps.item(i);
                maxCompScoreStr = thisComp.getAttributes().getNamedItem("max_cvss_score").getNodeValue();
                double maxCompScore = -1.0;
                if (StringUtil.isNullOrEmpty(maxCompScoreStr)) continue;
                try {
                    maxCompScore = Double.parseDouble(maxCompScoreStr);
                }
                catch (NumberFormatException nfe) {
                    maxCompScore = -1.0;
                }
                maxOverallScore = maxCompScore > maxOverallScore ? maxCompScore : maxOverallScore;
            }
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        return maxOverallScore;
    }

    private static final boolean isSubscribedToSCA(XPath xPathObj, Document xml) throws Exception {
        return null != xPathObj.evaluate(SCA_XPATH, xml.getDocumentElement(), XPathConstants.NODE);
    }

    private static final int parseBlacklistedCompsCount(XPath xPathObj, Document xml) throws Exception {
        String countStr;
        String BLACKLISTED_COMPS_ATTR = "blacklisted_components";
        int count = -1;
        Node node = (Node)xPathObj.evaluate(SCA_XPATH, xml.getDocumentElement(), XPathConstants.NODE);
        if (null != node && null != node.getAttributes().getNamedItem("blacklisted_components") && !StringUtil.isNullOrEmpty(countStr = node.getAttributes().getNamedItem("blacklisted_components").getNodeValue())) {
            count = Integer.parseInt(countStr);
        }
        return count;
    }

    private static final Set<FindingCounts> parseFindingCounts(XPath xPathObj, Document xml, SCAScanHistory lastSCAHistory) {
        int i;
        String SCA_VUL_NODE_XPATH = "/detailedreport/software_composition_analysis/vulnerable_components/component/vulnerabilities/*[local-name()='vulnerability']";
        String MITIGATED_ATTR = "mitigation";
        String SEVERITY_ATTR = "severity";
        int maxSevLevel = SeverityLevel.values().length;
        int[] counts = new int[maxSevLevel];
        boolean[] mitigated = new boolean[maxSevLevel];
        try {
            NodeList vuls = (NodeList)xPathObj.evaluate("/detailedreport/software_composition_analysis/vulnerable_components/component/vulnerabilities/*[local-name()='vulnerability']", xml.getDocumentElement(), XPathConstants.NODESET);
            for (i = 0; i < vuls.getLength(); ++i) {
                Node thisVul = vuls.item(i);
                try {
                    int sev = Integer.parseInt(thisVul.getAttributes().getNamedItem("severity").getNodeValue());
                    if (sev >= maxSevLevel) continue;
                    boolean thisVulIsMitigated = Boolean.parseBoolean(thisVul.getAttributes().getNamedItem("mitigation").getNodeValue());
                    if (!thisVulIsMitigated) {
                        int n = sev;
                        counts[n] = counts[n] + 1;
                    }
                    if (mitigated[sev] || !thisVulIsMitigated) continue;
                    mitigated[sev] = true;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                catch (DOMException domex) {
                    // empty catch block
                }
            }
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        LinkedHashSet<FindingCounts> results = new LinkedHashSet<FindingCounts>();
        for (i = 0; i < maxSevLevel; ++i) {
            int newCount = 0;
            int netCount = 0;
            if (null != lastSCAHistory && lastSCAHistory.isSubscribed()) {
                try {
                    netCount = counts[i] - lastSCAHistory.getCountBySeverity(SeverityLevel.findSevLevel(i)).getCount();
                    newCount = Math.max(netCount, 0);
                }
                catch (IllegalArgumentException iae) {
                    netCount = 0;
                    newCount = 0;
                }
            } else {
                netCount = counts[i];
                newCount = counts[i];
            }
            results.add(new FindingCounts(SeverityLevel.findSevLevel(i), counts[i], newCount, netCount, mitigated[i]));
        }
        return results;
    }

    private static final Set<SCAComponent> parseSCAComponentInfo(XPath xPathObj, Document xml) throws Exception {
        String SCA_COMPONENTS_NODE_XPATH = "/detailedreport/software_composition_analysis/vulnerable_components/*[local-name()='component']";
        String COMPONENT_NAME_ATTR = "file_name";
        String IS_BLACKLISTED_ATTR = "blacklisted";
        String IS_NEW_ATTR = "new";
        String IS_VIOLATED_POLICY_ATTR = "component_affects_policy_compliance";
        HashSet<SCAComponent> newSCAComponentInfo = new HashSet<SCAComponent>();
        try {
            NodeList comps = (NodeList)xPathObj.evaluate("/detailedreport/software_composition_analysis/vulnerable_components/*[local-name()='component']", xml.getDocumentElement(), XPathConstants.NODESET);
            String componentName = "";
            boolean isBlacklisted = false;
            boolean isNew = false;
            boolean isViolatedPolicy = false;
            for (int i = 0; i < comps.getLength(); ++i) {
                Node thisComp = comps.item(i);
                try {
                    if (thisComp.getAttributes().getNamedItem("file_name") != null) {
                        componentName = thisComp.getAttributes().getNamedItem("file_name").getNodeValue();
                    }
                    if (thisComp.getAttributes().getNamedItem("blacklisted") != null) {
                        isBlacklisted = Boolean.parseBoolean(thisComp.getAttributes().getNamedItem("blacklisted").getNodeValue());
                    }
                    if (thisComp.getAttributes().getNamedItem("new") != null) {
                        isNew = Boolean.parseBoolean(thisComp.getAttributes().getNamedItem("new").getNodeValue());
                    }
                    if (thisComp.getAttributes().getNamedItem("component_affects_policy_compliance") != null) {
                        isViolatedPolicy = Boolean.parseBoolean(thisComp.getAttributes().getNamedItem("component_affects_policy_compliance").getNodeValue());
                    }
                    newSCAComponentInfo.add(new SCAComponent(componentName, isBlacklisted, isNew, isViolatedPolicy));
                    continue;
                }
                catch (DOMException domex) {
                    // empty catch block
                }
            }
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        return newSCAComponentInfo;
    }

    private static final Map<String, Long> createStats(long buildDate, Long count) {
        HashMap<String, Long> thisScanStats = new HashMap<String, Long>();
        thisScanStats.put("BUILD_DATE", buildDate);
        thisScanStats.put("FLAWS_COUNT", count);
        return thisScanStats;
    }

    private static final List<Map<String, Long>> createCountHistory(Map<String, Long> countInThisBuild, List<Map<String, Long>> lastCountHistory) {
        int MAX_PREV_BUILDS = 8;
        ArrayList<Object> countHistory = null;
        if (null == lastCountHistory || lastCountHistory.size() == 0) {
            countHistory = new ArrayList<Map<String, Long>>();
            countHistory.add(countInThisBuild);
        } else {
            countHistory = new ArrayList<Map<String, Long>>(lastCountHistory);
            while (countHistory.size() >= 8) {
                countHistory.remove(0);
            }
            countHistory.add(countInThisBuild);
        }
        return countHistory;
    }
}

