/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.jenkins.plugin.data;

import com.veracode.jenkins.plugin.data.SCAScanHistory;
import com.veracode.jenkins.plugin.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScanHistory {
    public static final String BUILD_DATE = "BUILD_DATE";
    public static final String FLAWS_COUNT = "FLAWS_COUNT";
    private String accountId;
    private String appId;
    private String buildId;
    private String policyName;
    private String policyComplianceStatus;
    private int score;
    private String veracodeLevel;
    private boolean scanOverdue;
    private int[] flawsCount;
    private boolean[] mitigateFlag;
    private boolean[] policyaffect;
    private final int totalFlawsCount;
    private final int totalNewFlawsCount;
    private final int totalNetChangeCount;
    private int[] netChange;
    private final List<Map<String, Long>> flawsCountHistory;
    private final SCAScanHistory scaHistory;

    public ScanHistory(String accountId, String appId, String buildId, String policyName, String policyComplianceStatus, int score, String veracodeLevel, boolean scanOverdue, int totalFlawsCount, int[] flawsCount, boolean[] mitigateFlag, int[] netChange, List<Map<String, Long>> flawsCountHistory, SCAScanHistory scaHistory, boolean[] policyaffect) {
        if (StringUtil.isNullOrEmpty(policyName) || StringUtil.isNullOrEmpty(policyComplianceStatus) || StringUtil.isNullOrEmpty(veracodeLevel)) {
            throw new IllegalArgumentException("Missing required information to create a scan history.");
        }
        this.accountId = accountId;
        this.appId = appId;
        this.buildId = buildId;
        this.policyName = policyName;
        this.policyComplianceStatus = policyComplianceStatus;
        this.score = score;
        this.veracodeLevel = veracodeLevel;
        this.scanOverdue = scanOverdue;
        this.flawsCount = (int[])flawsCount.clone();
        this.mitigateFlag = (boolean[])mitigateFlag.clone();
        this.totalFlawsCount = totalFlawsCount;
        this.netChange = (int[])netChange.clone();
        int totalNetChangeCount = 0;
        int totalNewFlawsCount = 0;
        for (int thisCount : netChange) {
            totalNetChangeCount += thisCount;
            if (thisCount <= 0) continue;
            totalNewFlawsCount += thisCount;
        }
        this.totalNetChangeCount = totalNetChangeCount;
        this.totalNewFlawsCount = totalNewFlawsCount;
        this.flawsCountHistory = new ArrayList<Map<String, Long>>(flawsCountHistory);
        this.scaHistory = scaHistory;
        this.policyaffect = (boolean[])policyaffect.clone();
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyComplianceStatus() {
        return this.policyComplianceStatus;
    }

    public int getScore() {
        return this.score;
    }

    public String getVeracodeLevel() {
        return this.veracodeLevel;
    }

    public boolean isScanOverdue() {
        return this.scanOverdue;
    }

    public int getFlawsCount(int severity) {
        if (severity < 0 || severity > 5) {
            throw new IllegalArgumentException("Invalid severity. Severity must be between 0 and 5");
        }
        return this.flawsCount[severity];
    }

    public boolean getMitigateFlag(int severity) {
        if (severity < 0 || severity > 5) {
            throw new IllegalArgumentException("Invalid severity. Severity must be between 0 and 5");
        }
        return this.mitigateFlag[severity];
    }

    public boolean getPolicyAffection(int severity) {
        if (severity < 0 || severity > 5) {
            throw new IllegalArgumentException("Invalid severity. Severity must be between 0 and 5");
        }
        return this.policyaffect[severity];
    }

    public int getTotalFlawsCount() {
        return this.totalFlawsCount;
    }

    public int getTotalNewFlawsCount() {
        return this.totalNewFlawsCount;
    }

    public int getTotalNetChangeCount() {
        return this.totalNetChangeCount;
    }

    public int getNewFlaws(int severity) {
        if (severity < 0 || severity > 5) {
            throw new IllegalArgumentException("Invalid severity. Severity must be between 0 and 5");
        }
        int netChange = this.getNetChange(severity);
        return netChange > 0 ? netChange : 0;
    }

    public int getNetChange(int severity) {
        if (severity < 0 || severity > 5) {
            throw new IllegalArgumentException("Invalid severity. Severity must be between 0 and 5");
        }
        return this.netChange[severity];
    }

    public List<Map<String, Long>> getFlawsCountHistory() {
        return this.flawsCountHistory;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public boolean hasSCAHistory() {
        return null != this.scaHistory;
    }

    public SCAScanHistory getScaHistory() {
        return this.scaHistory;
    }
}

